/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.index.IndexTerm;
import org.dita.dost.index.IndexTermCollection;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.DitamapIndexTermReader;
import org.dita.dost.reader.IndexTermReader;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class IndexTermExtractModule
implements AbstractPipelineModule {
    private String inputMap = null;
    private String targetExt = null;
    private String baseInputDir = null;
    private List<String> topicList = null;
    private List<String> ditamapList = null;
    private DITAOTJavaLogger javaLogger = new DITAOTJavaLogger();

    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        try {
            IndexTermCollection.getInstantce().clear();
            this.parseAndValidateInput(input);
            this.extractIndexTerm();
            IndexTermCollection.getInstantce().sort();
            IndexTermCollection.getInstantce().outputTerms();
        }
        catch (Exception e) {
            this.javaLogger.logException(e);
        }
        return null;
    }

    private void parseAndValidateInput(AbstractPipelineInput input) throws DITAOTException {
        String t;
        StringTokenizer tokenizer = null;
        Properties prop = new Properties();
        String outputRoot = null;
        Properties params = new Properties();
        PipelineHashIO hashIO = (PipelineHashIO)input;
        String baseDir = hashIO.getAttribute("basedir");
        String tempDir = ((PipelineHashIO)input).getAttribute("tempDir");
        String output = hashIO.getAttribute("output");
        String encoding = hashIO.getAttribute("encoding");
        String indextype = hashIO.getAttribute("indextype");
        String indexclass = hashIO.getAttribute("indexclass");
        this.inputMap = hashIO.getAttribute("inputmap");
        this.targetExt = hashIO.getAttribute("targetext");
        if (!new File(tempDir).isAbsolute()) {
            tempDir = new File(baseDir, tempDir).getAbsolutePath();
        }
        if (!new File(output).isAbsolute()) {
            output = new File(baseDir, output).getAbsolutePath();
        }
        this.baseInputDir = tempDir;
        String ditalist = new File(tempDir, "dita.list").getAbsolutePath();
        try {
            prop.load(new FileInputStream(ditalist));
        }
        catch (Exception e) {
            String msg = null;
            params.put("%1", ditalist);
            msg = MessageUtils.getMessage("DOTJ011E", params).toString();
            msg = new StringBuffer(msg).append(Constants.LINE_SEPARATOR).append(e.toString()).toString();
            throw new DITAOTException(msg, e);
        }
        tokenizer = new StringTokenizer(prop.getProperty("fullditatopiclist"), ",");
        String resource_only_list = prop.getProperty("resourceonlylist", "");
        this.topicList = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            t = tokenizer.nextToken();
            if (resource_only_list.contains(t)) continue;
            this.topicList.add(t);
        }
        tokenizer = new StringTokenizer(prop.getProperty("fullditamaplist"), ",");
        this.ditamapList = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            t = tokenizer.nextToken();
            if (resource_only_list.contains(t)) continue;
            this.ditamapList.add(t);
        }
        int lastIndexOfDot = output.lastIndexOf(".");
        outputRoot = lastIndexOfDot == -1 ? output : output.substring(0, lastIndexOfDot);
        IndexTermCollection.getInstantce().setOutputFileRoot(outputRoot);
        IndexTermCollection.getInstantce().setIndexType(indextype);
        IndexTermCollection.getInstantce().setIndexClass(indexclass);
        if (encoding != null && encoding.trim().length() > 0) {
            IndexTerm.setTermLocale(StringUtils.getLocale(encoding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractIndexTerm() throws SAXException {
        int topicNum = this.topicList.size();
        int ditamapNum = this.ditamapList.size();
        FileInputStream inputStream = null;
        XMLReader xmlReader = null;
        IndexTermReader handler = new IndexTermReader();
        DitamapIndexTermReader ditamapIndexTermReader = new DitamapIndexTermReader();
        if (System.getProperty("org.xml.sax.driver") == null) {
            StringUtils.initSaxDriver();
        }
        xmlReader = XMLReaderFactory.createXMLReader();
        try {
            Properties params;
            xmlReader.setContentHandler(handler);
            for (int i = 0; i < topicNum; ++i) {
                handler.reset();
                String target = this.topicList.get(i);
                String targetPathFromMap = FileUtils.getRelativePathFromMap(this.inputMap, target);
                String targetPathFromMapWithoutExt = targetPathFromMap.substring(0, targetPathFromMap.lastIndexOf("."));
                handler.setTargetFile(new StringBuffer(targetPathFromMapWithoutExt).append(this.targetExt).toString());
                try {
                    inputStream = new FileInputStream(new File(this.baseInputDir, target));
                    xmlReader.parse(new InputSource(inputStream));
                    inputStream.close();
                    continue;
                }
                catch (Exception e) {
                    params = new Properties();
                    StringBuffer buff = new StringBuffer();
                    String msg = null;
                    params.put("%1", target);
                    msg = MessageUtils.getMessage("DOTJ013E", params).toString();
                    this.javaLogger.logError(buff.append(msg).append(e.getMessage()).toString());
                }
            }
            xmlReader.setContentHandler(ditamapIndexTermReader);
            for (int j = 0; j < ditamapNum; ++j) {
                String ditamap = this.ditamapList.get(j);
                String currentMapPathName = FileUtils.getRelativePathFromMap(this.inputMap, ditamap);
                String mapPathFromInputMap = "";
                if (currentMapPathName.lastIndexOf("/") != -1) {
                    mapPathFromInputMap = currentMapPathName.substring(0, currentMapPathName.lastIndexOf("/"));
                }
                ditamapIndexTermReader.setMapPath(mapPathFromInputMap);
                try {
                    inputStream = new FileInputStream(new File(this.baseInputDir, ditamap));
                    xmlReader.parse(new InputSource(inputStream));
                    inputStream.close();
                    continue;
                }
                catch (Exception e) {
                    params = new Properties();
                    String msg = null;
                    params.put("%1", ditamap);
                    msg = MessageUtils.getMessage("DOTJ013E", params).toString();
                    this.javaLogger.logError(msg);
                    this.javaLogger.logException(e);
                }
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    this.javaLogger.logException(e);
                }
            }
        }
    }
}

