/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.AbstractPipelineModule;
import org.dita.dost.pipeline.AbstractPipelineInput;
import org.dita.dost.pipeline.AbstractPipelineOutput;
import org.dita.dost.pipeline.PipelineHashIO;
import org.dita.dost.reader.MergeMapParser;

public class TopicMergeModule
implements AbstractPipelineModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractPipelineOutput execute(AbstractPipelineInput input) throws DITAOTException {
        String ditaInput = ((PipelineHashIO)input).getAttribute("inputmap");
        String style = ((PipelineHashIO)input).getAttribute("style");
        String out = ((PipelineHashIO)input).getAttribute("output");
        String tempdir = ((PipelineHashIO)input).getAttribute("tempDir");
        OutputStreamWriter output = null;
        DITAOTJavaLogger logger = new DITAOTJavaLogger();
        MergeMapParser mapParser = new MergeMapParser();
        String midResult = null;
        StringReader midStream = null;
        File outputDir = null;
        if (ditaInput == null || !new File(ditaInput).exists()) {
            logger.logError(MessageUtils.getMessage("DOTJ025E").toString());
            return null;
        }
        if (out == null) {
            logger.logError(MessageUtils.getMessage("DOTJ026E").toString());
            return null;
        }
        mapParser.read(ditaInput + "|" + tempdir);
        midResult = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>").append("<dita-merge xmlns:ditaarch=\"http://dita.oasis-open.org/architecture/2005/\">").append((StringBuffer)mapParser.getContent().getValue()).append("</dita-merge>").toString();
        midStream = new StringReader(midResult);
        try {
            outputDir = new File(out).getParentFile();
            if (!outputDir.exists()) {
                outputDir.mkdirs();
            }
            if (style != null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(new StreamSource(new FileInputStream(style)));
                transformer.transform(new StreamSource(midStream), new StreamResult(new FileOutputStream(new File(out))));
            } else {
                output = new OutputStreamWriter((OutputStream)new FileOutputStream(out), "UTF-8");
                output.write(midResult);
                output.flush();
            }
        }
        catch (Exception e) {
            logger.logException(e);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
                midStream.close();
            }
            catch (Exception e) {
                logger.logException(e);
            }
        }
        return null;
    }
}

