/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.platform.IAction;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGenerator
extends DefaultHandler {
    private XMLReader reader = null;
    private DITAOTJavaLogger logger = null;
    private OutputStreamWriter output = null;
    private Hashtable<String, String> featureTable = null;
    private String templateFileName = null;

    public FileGenerator() {
        this(null);
    }

    public FileGenerator(Hashtable<String, String> featureTbl) {
        this.featureTable = featureTbl;
        this.output = null;
        this.templateFileName = null;
        this.logger = new DITAOTJavaLogger();
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String fileName) {
        FileOutputStream fileOutput = null;
        File outputFile = new File(fileName.substring(0, fileName.lastIndexOf("_template")) + fileName.substring(fileName.lastIndexOf(46)));
        this.templateFileName = fileName;
        try {
            fileOutput = new FileOutputStream(outputFile);
            this.output = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.parse(fileName);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        finally {
            try {
                fileOutput.close();
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(StringUtils.escapeXML(ch, start, length));
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (!"http://dita-ot.sourceforge.net".equals(uri) || !"extension".equals(localName)) {
                this.output.write("</" + qName + ">");
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        IAction action = null;
        String input = null;
        try {
            if ("http://dita-ot.sourceforge.net".equals(uri) && "extension".equals(localName)) {
                action = (IAction)Class.forName(attributes.getValue("behavior")).newInstance();
                action.setParam("template=" + this.templateFileName + ";extension=" + attributes.getValue("id"));
                input = this.featureTable.get(attributes.getValue("id"));
                if (input != null) {
                    action.setFeatures(this.featureTable);
                    action.setInput(input);
                    this.output.write(action.getResult());
                }
            } else {
                int attLen = attributes.getLength();
                this.output.write("<" + qName);
                for (int i = 0; i < attLen; ++i) {
                    if ("http://dita-ot.sourceforge.net".equals(attributes.getURI(i))) {
                        if ("extension".equals(attributes.getLocalName(i))) continue;
                        String extensions = attributes.getValue("http://dita-ot.sourceforge.net", "extension");
                        StringTokenizer extensionTokenizer = new StringTokenizer(extensions);
                        while (extensionTokenizer.hasMoreTokens()) {
                            String thisExtension = extensionTokenizer.nextToken();
                            String thisExtensionClass = extensionTokenizer.nextToken();
                            if (!thisExtension.equals(attributes.getLocalName(i))) continue;
                            action = (IAction)Class.forName(thisExtensionClass).newInstance();
                            break;
                        }
                        action.setFeatures(this.featureTable);
                        action.setParam("template=" + this.templateFileName + ";localname=" + attributes.getLocalName(i));
                        action.setInput(attributes.getValue(i));
                        this.output.write(action.getResult());
                        continue;
                    }
                    if (attributes.getQName(i).startsWith("xmlns:") && "http://dita-ot.sourceforge.net".equals(attributes.getValue(i))) continue;
                    this.output.write(" ");
                    this.output.write(new StringBuffer(attributes.getQName(i)).append("=\"").append(attributes.getValue(i)).append("\"").toString());
                }
                this.output.write(">");
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
            this.output.close();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }
}

