/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.platform.DescParser;
import org.dita.dost.platform.Features;
import org.dita.dost.platform.FileGenerator;
import org.dita.dost.platform.PluginRequirement;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Integrator {
    public static Hashtable<String, Features> pluginTable = null;
    private Set<String> templateSet = null;
    private String ditaDir;
    private String basedir;
    private Set<File> descSet;
    private XMLReader reader;
    private DITAOTJavaLogger logger;
    private Set<String> loadedPlugin = null;
    private Hashtable<String, String> featureTable = null;
    private File propertiesFile = null;

    private void initTemplateSet() {
        this.templateSet = new HashSet<String>(16);
        this.templateSet.add("catalog-dita_template.xml");
        this.templateSet.add("build_template.xml");
        this.templateSet.add("build_general_template.xml");
        this.templateSet.add("build_dita2eclipsehelp_template.xml");
        this.templateSet.add("build_preprocess_template.xml");
        this.templateSet.add("resource/messages_template.xml");
        this.templateSet.add("xsl/common/allstrings_template.xml");
        this.templateSet.add("xsl/dita2xhtml_template.xsl");
        this.templateSet.add("xsl/dita2rtf_template.xsl");
        this.templateSet.add("xsl/dita2fo-shell_template.xsl");
        this.templateSet.add("xsl/dita2docbook_template.xsl");
        this.templateSet.add("xsl/preprocess/maplink_template.xsl");
        this.templateSet.add("xsl/preprocess/mapref_template.xsl");
        this.templateSet.add("xsl/preprocess/mappull_template.xsl");
        this.templateSet.add("xsl/map2plugin_template.xsl");
        this.templateSet.add("xsl/preprocess/conref_template.xsl");
        this.templateSet.add("xsl/preprocess/topicpull_template.xsl");
    }

    public void execute() {
        if (!new File(this.ditaDir).isAbsolute()) {
            this.ditaDir = new File(this.basedir, this.ditaDir).getAbsolutePath();
        }
        Properties properties = new Properties();
        if (this.propertiesFile != null) {
            try {
                FileInputStream propertiesStream = new FileInputStream(this.propertiesFile);
                properties.load(propertiesStream);
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        } else {
            properties.setProperty("plugindirs", "plugins;demo");
        }
        String[] pluginDirs = properties.getProperty("plugindirs").split(";");
        for (int j = 0; j < pluginDirs.length; ++j) {
            File pluginDir = null;
            File[] pluginFiles = null;
            pluginDir = new File(this.ditaDir + File.separatorChar + pluginDirs[j]);
            pluginFiles = pluginDir.listFiles();
            for (int i = 0; pluginFiles != null && i < pluginFiles.length; ++i) {
                File descFile = new File(pluginFiles[i], "plugin.xml");
                if (!pluginFiles[i].isDirectory() || !descFile.exists()) continue;
                this.descSet.add(descFile);
            }
        }
        this.parsePlugin();
        this.integrate();
    }

    private void integrate() {
        Iterator<String> iter = pluginTable.keySet().iterator();
        Iterator<String> setIter = null;
        File templateFile = null;
        String currentPlugin = null;
        FileGenerator fileGen = new FileGenerator(this.featureTable);
        while (iter.hasNext()) {
            currentPlugin = iter.next();
            this.loadPlugin(currentPlugin);
        }
        setIter = this.templateSet.iterator();
        while (setIter.hasNext()) {
            templateFile = new File(this.ditaDir, setIter.next());
            fileGen.generate(templateFile.getAbsolutePath());
        }
    }

    private boolean loadPlugin(String plugin) {
        Set<Map.Entry<String, String>> featureSet = null;
        Iterator<Map.Entry<String, String>> setIter = null;
        Iterator<String> templateIter = null;
        Map.Entry<String, String> currentFeature2 = null;
        Features pluginFeatures = pluginTable.get(plugin);
        if (this.checkPlugin(plugin)) {
            featureSet = pluginFeatures.getAllFeatures();
            for (Map.Entry<String, String> currentFeature2 : featureSet) {
                if (this.featureTable.containsKey(currentFeature2.getKey())) {
                    String value = this.featureTable.remove(currentFeature2.getKey());
                    this.featureTable.put(currentFeature2.getKey(), new StringBuffer(value).append(",").append(currentFeature2.getValue()).toString());
                    continue;
                }
                this.featureTable.put(currentFeature2.getKey(), currentFeature2.getValue());
            }
            for (String templateName : pluginFeatures.getAllTemplates()) {
                this.templateSet.add(FileUtils.getRelativePathFromMap(this.getDitaDir() + File.separator + "dummy", pluginFeatures.getLocation() + File.separator + templateName));
            }
            this.loadedPlugin.add(plugin);
            return true;
        }
        return false;
    }

    private boolean checkPlugin(String currentPlugin) {
        PluginRequirement requirement = null;
        Properties prop = new Properties();
        Features pluginFeatures = pluginTable.get(currentPlugin);
        Iterator<PluginRequirement> iter = pluginFeatures.getRequireListIter();
        while (iter.hasNext()) {
            boolean anyPluginFound = false;
            requirement = iter.next();
            Iterator<String> requiredPluginIter = requirement.getPlugins();
            while (requiredPluginIter.hasNext()) {
                String requiredPlugin = requiredPluginIter.next();
                if (!pluginTable.containsKey(requiredPlugin)) continue;
                if (!this.loadedPlugin.contains(requiredPlugin)) {
                    this.loadPlugin(requiredPlugin);
                }
                anyPluginFound = true;
            }
            if (anyPluginFound || !requirement.getRequired()) continue;
            prop.put("%1", requirement.toString());
            prop.put("%2", currentPlugin);
            this.logger.logWarn(MessageUtils.getMessage("DOTJ020W", prop).toString());
            return false;
        }
        return true;
    }

    private void parsePlugin() {
        if (!this.descSet.isEmpty()) {
            Iterator<File> iter = this.descSet.iterator();
            File descFile = null;
            while (iter.hasNext()) {
                descFile = iter.next();
                this.parseDesc(descFile);
            }
        }
    }

    private void parseDesc(File descFile) {
        try {
            this.reader.setContentHandler(new DescParser(descFile.getParent()));
            this.reader.parse(descFile.getAbsolutePath());
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public Integrator() {
        this.initTemplateSet();
        pluginTable = new Hashtable(16);
        this.descSet = new HashSet<File>(16);
        this.loadedPlugin = new HashSet<String>(16);
        this.featureTable = new Hashtable(16);
        this.logger = new DITAOTJavaLogger();
        this.basedir = null;
        this.ditaDir = null;
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public String getBasedir() {
        return this.basedir;
    }

    public void setBasedir(String baseDir) {
        this.basedir = baseDir;
    }

    public String getDitaDir() {
        return this.ditaDir;
    }

    public void setDitaDir(String ditadir) {
        this.ditaDir = ditadir;
    }

    public File getProperties() {
        return this.propertiesFile;
    }

    public void setProperties(File propertiesfile) {
        this.propertiesFile = propertiesfile;
    }

    public static void main(String[] args) {
        Integrator abc = new Integrator();
        File currentDir = new File(".");
        String currentPath = currentDir.getAbsolutePath();
        abc.setDitaDir(currentPath.substring(0, currentPath.lastIndexOf(Constants.FILE_SEPARATOR)));
        abc.setProperties(new File("integrator.properties"));
        abc.execute();
    }
}

