/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DitaValReader
extends AbstractXMLReader {
    private HashMap<String, String> filterMap = new HashMap();
    private HashMap<String, String> schemeFilterMap = new HashMap();
    private ContentImpl content = null;
    private XMLReader reader;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private List<String> imageList = new ArrayList<String>(256);
    private String ditaVal = null;
    private List<String> relFlagImageList = new ArrayList<String>(256);
    private HashMap<String, HashMap<String, HashSet<Element>>> bindingMap = null;
    private HashMap<String, HashMap<String, HashSet<String>>> validValuesMap = new HashMap();
    private HashMap<String, HashMap<String, String>> defaultValueMap = new HashMap();
    private Element schemeRoot = null;

    public DitaValReader() {
        this.bindingMap = new HashMap();
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void read(String input) {
        this.ditaVal = input;
        try {
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(this.ditaVal));
            this.reader.parse(new InputSource(new FileInputStream(input)));
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public Content getContent() {
        this.content = new ContentImpl();
        this.content.setCollection(this.filterMap.entrySet());
        return this.content;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String flagImage = null;
        if (atts.getValue("img") != null) {
            flagImage = atts.getValue("img");
        } else if (atts.getValue("imageref") != null) {
            flagImage = atts.getValue("imageref");
        }
        if ("prop".equals(qName)) {
            HashMap<String, HashSet<Element>> schemeMap;
            String action = atts.getValue("action");
            String attName = atts.getValue("att");
            String attValue = atts.getValue("val");
            String key = null;
            key = attName == null ? "default" : (attValue == null ? attName : attName + "=" + attValue);
            if (action != null) {
                this.insertAction(action, key);
            }
            if (attName != null && attValue != null && this.bindingMap != null && !this.bindingMap.isEmpty() && (schemeMap = this.bindingMap.get(attName)) != null && !schemeMap.isEmpty()) {
                Iterator<HashSet<Element>> subTreeIter = schemeMap.values().iterator();
                while (subTreeIter.hasNext()) {
                    Iterator<Element> subTreeSet = subTreeIter.next().iterator();
                    while (subTreeSet.hasNext()) {
                        Element subRoot = this.searchForKey(subTreeSet.next(), attValue);
                        if (subRoot == null || action == null) continue;
                        this.insertAction(subRoot, attName, action);
                    }
                }
            }
        }
        if (flagImage != null && !"".equals(flagImage.trim())) {
            if (new File(flagImage).isAbsolute()) {
                this.imageList.add(flagImage);
                this.relFlagImageList.add(FileUtils.getRelativePathFromMap(this.ditaVal, flagImage));
                return;
            }
            String filterDir = new File(new File(this.ditaVal).getAbsolutePath()).getParent();
            this.imageList.add(new File(filterDir, flagImage).getAbsolutePath());
            this.relFlagImageList.add(flagImage);
        }
    }

    private void insertAction(String action, String key) {
        if (this.filterMap.get(key) == null) {
            this.filterMap.put(key, action);
        } else {
            Properties prop = new Properties();
            prop.put("%1", key);
            this.logger.logError(MessageUtils.getMessage("DOTJ007E", prop).toString());
        }
    }

    private void insertAction(Element subTree, String attName, String action) {
        if (subTree == null || action == null) {
            return;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        NodeList children = subTree.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            queue.offer((Element)children.item(i));
        }
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.poll();
            children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.offer((Element)children.item(i));
            }
            String attrValue = node.getAttribute("class");
            if (attrValue == null || !attrValue.contains(" subjectScheme/subjectdef ") || StringUtils.isEmptyString(key = node.getAttribute("keys")) || this.schemeFilterMap.get(key = attName + "=" + key) != null) continue;
            this.schemeFilterMap.put(key, action);
        }
    }

    public List<String> getImageList() {
        return this.imageList;
    }

    public HashMap<String, String> getFilterMap() {
        this.schemeFilterMap.putAll(this.filterMap);
        return this.schemeFilterMap;
    }

    public void reset() {
        this.schemeFilterMap.clear();
        this.validValuesMap.clear();
        this.defaultValueMap.clear();
    }

    public void filterReset() {
        this.filterMap.clear();
    }

    public List<String> getRelFlagImageList() {
        return this.relFlagImageList;
    }

    public void loadSubjectScheme(String scheme) {
        if (!FileUtils.fileExists(scheme)) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new FileInputStream(new File(scheme))));
            this.schemeRoot = doc.getDocumentElement();
            if (this.schemeRoot == null) {
                return;
            }
            NodeList rootChildren = this.schemeRoot.getChildNodes();
            for (int i = 0; i < rootChildren.getLength(); ++i) {
                Element node;
                String attrValue;
                if (rootChildren.item(i).getNodeType() != 1 || (attrValue = (node = (Element)rootChildren.item(i)).getAttribute("class")) == null || !attrValue.contains(" subjectScheme/enumerationdef ")) continue;
                NodeList enumChildren = node.getChildNodes();
                String elementName = "*";
                String attributeName = null;
                for (int j = 0; j < enumChildren.getLength(); ++j) {
                    HashSet<Element> A;
                    Element subTree;
                    String keyValue;
                    if (enumChildren.item(j).getNodeType() != 1) continue;
                    node = (Element)enumChildren.item(j);
                    attrValue = node.getAttribute("class");
                    if (attrValue != null && attrValue.contains(" subjectScheme/elementdef ")) {
                        elementName = node.getAttribute("name");
                        continue;
                    }
                    if (attrValue != null && attrValue.contains(" subjectScheme/attributedef ")) {
                        attributeName = node.getAttribute("name");
                        HashMap<String, HashSet<Element>> S = this.bindingMap.get(attributeName);
                        if (S != null) continue;
                        S = new HashMap();
                        this.bindingMap.put(attributeName, S);
                        continue;
                    }
                    if (attrValue != null && attrValue.contains(" subjectScheme/defaultSubject ")) {
                        keyValue = node.getAttribute("keyref");
                        if (keyValue == null) continue;
                        HashMap<String, String> S = this.defaultValueMap.get(attributeName);
                        if (S == null) {
                            S = new HashMap();
                        }
                        S.put(elementName, keyValue);
                        this.defaultValueMap.put(attributeName, S);
                        continue;
                    }
                    if (attrValue == null || !attrValue.contains(" subjectScheme/subjectdef ")) continue;
                    keyValue = node.getAttribute("keyref");
                    if (StringUtils.isEmptyString(keyValue)) {
                        keyValue = node.getAttribute("keys");
                    }
                    if ((subTree = this.searchForKey(this.schemeRoot, keyValue)) == null) continue;
                    HashMap<String, HashSet<Element>> S = this.bindingMap.get(attributeName);
                    if (S == null) {
                        S = new HashMap();
                    }
                    if ((A = S.get(elementName)) == null) {
                        A = new HashSet();
                    }
                    if (!A.contains(subTree)) {
                        this.putValuePairsIntoMap(subTree, elementName, attributeName);
                    }
                    A.add(subTree);
                    S.put(elementName, A);
                    this.bindingMap.put(attributeName, S);
                }
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private void putValuePairsIntoMap(Element subtree, String elementName, String attName) {
        HashSet<String> valueSet;
        if (subtree == null || attName == null) {
            return;
        }
        HashMap<String, HashSet<String>> valueMap = this.validValuesMap.get(attName);
        if (valueMap == null) {
            valueMap = new HashMap();
        }
        if ((valueSet = valueMap.get(elementName)) == null) {
            valueSet = new HashSet();
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.offer(subtree);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.poll();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.offer((Element)children.item(i));
            }
            String attrValue = node.getAttribute("class");
            if (attrValue == null || !attrValue.contains(" subjectScheme/subjectdef ") || StringUtils.isEmptyString(key = node.getAttribute("keys"))) continue;
            valueSet.add(key);
        }
        valueMap.put(elementName, valueSet);
        this.validValuesMap.put(attName, valueMap);
    }

    private Element searchForKey(Element root, String keyValue) {
        if (root == null || keyValue == null) {
            return null;
        }
        LinkedList<Element> queue = new LinkedList<Element>();
        queue.add(root);
        while (!queue.isEmpty()) {
            String key;
            Element node = (Element)queue.removeFirst();
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                if (children.item(i).getNodeType() != 1) continue;
                queue.add((Element)children.item(i));
            }
            String attrValue = node.getAttribute("class");
            if (attrValue == null || !attrValue.contains(" subjectScheme/subjectdef ") || !keyValue.equals(key = node.getAttribute("keys"))) continue;
            return node;
        }
        return null;
    }

    public HashMap<String, HashMap<String, HashSet<String>>> getValidValuesMap() {
        return this.validValuesMap;
    }

    public HashMap<String, HashMap<String, String>> getDefaultValueMap() {
        return this.defaultValueMap;
    }
}

