/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.io.File;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.module.Content;
import org.dita.dost.module.ContentImpl;
import org.dita.dost.reader.AbstractXMLReader;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.MergeUtils;
import org.dita.dost.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class MergeTopicParser
extends AbstractXMLReader {
    private static StringBuffer topicInfo = null;
    private ContentImpl content;
    private String dirPath = null;
    private String filePath = null;
    private boolean isFirstTopicId = false;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private XMLReader reader = null;
    private String retId = null;
    private MergeUtils util;

    public MergeTopicParser() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            if (this.reader == null) {
                this.reader = XMLReaderFactory.createXMLReader();
                this.reader.setContentHandler(this);
                this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            if (topicInfo == null) {
                topicInfo = new StringBuffer(1024);
            }
            this.content = new ContentImpl();
            this.util = MergeUtils.getInstance();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void reset() {
        topicInfo.delete(0, topicInfo.length());
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        topicInfo.append(StringUtils.escapeXML(ch, start, length));
    }

    public void endDocument() throws SAXException {
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("dita".equalsIgnoreCase(qName)) {
            return;
        }
        topicInfo.append("<").append("/").append(qName).append(">");
    }

    public Content getContent() {
        this.content.setValue(topicInfo);
        return this.content;
    }

    private String handleID(String classValue, String attValue) {
        String retAttValue = attValue;
        if (classValue != null && classValue.indexOf(" topic/topic ") != -1) {
            String value = this.filePath + "#" + attValue;
            if (this.util.findId(value)) {
                topicInfo.append(" ").append("oid").append("=").append("\"").append(StringUtils.escapeXML(attValue)).append("\"");
                retAttValue = this.util.getIdValue(value);
            } else {
                topicInfo.append(" ").append("oid").append("=").append("\"").append(StringUtils.escapeXML(attValue)).append("\"");
                retAttValue = this.util.addId(value);
            }
            if (this.isFirstTopicId) {
                this.isFirstTopicId = false;
                this.retId = retAttValue;
                this.util.addId(this.filePath, retAttValue);
            }
        }
        return retAttValue;
    }

    private String handleLocalDita(int sharpIndex, String attValue) {
        String retAttValue = attValue;
        if (sharpIndex != -1) {
            String pathFromMap = sharpIndex == 0 ? this.filePath.replaceAll("\\\\", "/") : FileUtils.resolveTopic(new File(this.filePath).getParent(), attValue.substring(0, sharpIndex)).replaceAll("\\\\", "/");
            topicInfo.append(" ").append("ohref").append("=").append("\"").append(pathFromMap).append(attValue.substring(sharpIndex)).append("\"");
            String topicId = attValue.substring(sharpIndex);
            int slashIndex = topicId.indexOf("/");
            int index = attValue.indexOf("/", sharpIndex);
            String string = topicId = slashIndex != -1 ? pathFromMap + topicId.substring(0, slashIndex) : pathFromMap + topicId;
            if (this.util.findId(topicId)) {
                String prefix = "#" + this.util.getIdValue(topicId);
                retAttValue = index != -1 ? prefix + attValue.substring(index) : prefix;
            } else {
                String prefix = "#" + this.util.addId(topicId);
                retAttValue = index != -1 ? prefix + attValue.substring(index) : prefix;
            }
        } else {
            String pathFromMap = FileUtils.resolveTopic(new File(this.filePath).getParent(), attValue);
            topicInfo.append(" ").append("ohref").append("=").append("\"").append(pathFromMap).append("\"");
            if (this.util.findId(pathFromMap)) {
                retAttValue = "#" + this.util.getIdValue(pathFromMap);
            } else {
                String fileId = this.util.getFirstTopicId(pathFromMap, this.dirPath, false);
                if (this.util.findId(pathFromMap + "#" + fileId)) {
                    this.util.addId(pathFromMap, this.util.getIdValue(pathFromMap + "#" + fileId));
                    retAttValue = "#" + this.util.getIdValue(pathFromMap + "#" + fileId);
                } else {
                    retAttValue = "#" + this.util.addId(pathFromMap);
                    this.util.addId(pathFromMap + "#" + fileId, this.util.getIdValue(pathFromMap));
                }
            }
        }
        return retAttValue;
    }

    public String parse(String filename, String dir) {
        int index = filename.indexOf("#");
        this.dirPath = dir;
        try {
            this.filePath = index != -1 ? filename.substring(0, index) : filename;
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(dir + File.separator + this.filePath));
            this.reader.parse(dir + File.separator + this.filePath);
            return this.retId;
        }
        catch (Exception e) {
            this.logger.logException(e);
            return null;
        }
    }

    public void startDocument() throws SAXException {
        this.isFirstTopicId = true;
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classValue = null;
        String scopeValue = null;
        String formatValue = null;
        int attsLen = atts.getLength();
        if ("dita".equalsIgnoreCase(qName)) {
            return;
        }
        topicInfo.append("<").append(qName);
        classValue = atts.getValue("class");
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = atts.getValue(i);
            if ("id".equals(attQName)) {
                attValue = this.handleID(classValue, attValue);
            }
            if (classValue != null && "href".equals(attQName) && attValue != null && !"".equalsIgnoreCase(attValue)) {
                scopeValue = atts.getValue("scope");
                formatValue = atts.getValue("format");
                int sharpIndex = attValue.indexOf("#");
                if ((scopeValue == null || "local".equalsIgnoreCase(scopeValue)) && attValue.indexOf("://") == -1) {
                    attValue = !(classValue.indexOf(" topic/xref ") == -1 && classValue.indexOf(" topic/link ") == -1 || formatValue != null && !"dita".equalsIgnoreCase(formatValue)) ? this.handleLocalDita(sharpIndex, attValue) : this.handleLocalHref(attValue);
                }
            }
            topicInfo.append(" ").append(attQName).append("=").append("\"").append(StringUtils.escapeXML(attValue)).append("\"");
        }
        topicInfo.append(">");
    }

    private String handleLocalHref(String attValue) {
        String pathFromMap = FileUtils.resolveTopic(new File(this.filePath).getParent(), attValue);
        return pathFromMap;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        String pi = data != null ? target + " " + data : target;
        topicInfo.append("<?" + pi + "?" + ">");
    }
}

