/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.util.HashMap;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.util.CatalogParser;
import org.dita.dost.util.StringUtils;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogUtils {
    private static HashMap<String, String> map = null;
    private static DITAOTJavaLogger logger = new DITAOTJavaLogger();
    public static CatalogResolver catalogResolver = null;
    private static String ditaDir;

    private CatalogUtils() {
    }

    public static HashMap<String, String> getCatalog(String ditaDir) {
        if (map != null) {
            return map;
        }
        String catalogFilePath = ditaDir == null ? "catalog-dita.xml" : ditaDir + File.separator + "catalog-dita.xml";
        map = new HashMap();
        CatalogParser parser = new CatalogParser(map, ditaDir);
        if (System.getProperty("org.xml.sax.driver") == null) {
            StringUtils.initSaxDriver();
        }
        try {
            XMLReader reader = XMLReaderFactory.createXMLReader();
            reader.setContentHandler(parser);
            reader.parse(catalogFilePath);
        }
        catch (Exception e) {
            logger.logException(e);
        }
        return map;
    }

    public static void setDitaDir(String ditaDir) {
        catalogResolver = null;
        CatalogUtils.ditaDir = ditaDir;
    }

    public static String getDitaDir() {
        if (StringUtils.isEmptyString(ditaDir)) {
            return "";
        }
        return ditaDir + File.separator;
    }

    public static CatalogResolver getCatalogResolver() {
        if (catalogResolver == null) {
            CatalogManager manager = new CatalogManager();
            manager.setIgnoreMissingProperties(true);
            manager.setUseStaticCatalog(false);
            manager.setPreferPublic(true);
            catalogResolver = new CatalogResolver(manager);
            String catalogFilePath = CatalogUtils.getDitaDir() + "catalog-dita.xml";
            Catalog catalog = catalogResolver.getCatalog();
            try {
                catalog.parseCatalog(catalogFilePath);
            }
            catch (Exception e) {
                logger.logException(e);
            }
        }
        return catalogResolver;
    }
}

