/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.util.Constants;
import org.dita.dost.util.StringUtils;

public class FileUtils {
    private FileUtils() {
    }

    public static boolean isHTMLFile(String lcasefn) {
        return lcasefn.endsWith(".html") || lcasefn.endsWith(".htm");
    }

    public static boolean isPDFFile(String lcasefn) {
        return lcasefn.endsWith(".pdf");
    }

    public static boolean isSWFile(String lcasefn) {
        return lcasefn.endsWith(".swf");
    }

    public static boolean isDITAFile(String lcasefn) {
        if (lcasefn == null) {
            return false;
        }
        if (lcasefn.contains("#")) {
            lcasefn = lcasefn.substring(0, lcasefn.indexOf("#"));
        }
        return FileUtils.isDITATopicFile(lcasefn) || FileUtils.isDITAMapFile(lcasefn);
    }

    public static boolean isDITATopicFile(String lcasefn) {
        return lcasefn.endsWith(".dita") || lcasefn.endsWith(".xml");
    }

    public static boolean isDITAMapFile(String lcasefn) {
        return lcasefn.endsWith(".ditamap");
    }

    public static boolean isSupportedImageFile(String lcasefn) {
        return lcasefn.endsWith(".jpg") || lcasefn.endsWith(".gif") || lcasefn.endsWith(".eps") || lcasefn.endsWith(".jpeg") || lcasefn.endsWith(".png") || lcasefn.endsWith(".svg") || lcasefn.endsWith(".tiff") || lcasefn.endsWith(".tif");
    }

    public static boolean isTopicFile(String lcasefn) {
        if (StringUtils.isEmptyString(lcasefn)) {
            return false;
        }
        return lcasefn.endsWith(".dita") || lcasefn.endsWith(".xml");
    }

    public static boolean isValidTarget(String lcasefn) {
        return lcasefn.endsWith(".dita") || lcasefn.endsWith(".ditamap") || lcasefn.endsWith(".xml") || lcasefn.endsWith(".jpg") || lcasefn.endsWith(".gif") || lcasefn.endsWith(".eps") || lcasefn.endsWith(".html") || lcasefn.endsWith(".jpeg") || lcasefn.endsWith(".png") || lcasefn.endsWith(".svg") || lcasefn.endsWith(".tiff") || lcasefn.endsWith(".tif") || lcasefn.endsWith(".pdf") || lcasefn.endsWith(".swf");
    }

    public static String getRelativePathFromMap(String mapFilePathName, String topicFilePathName) {
        StringBuffer upPathBuffer = new StringBuffer(128);
        StringBuffer downPathBuffer = new StringBuffer(128);
        StringTokenizer mapTokenizer = new StringTokenizer(FileUtils.removeRedundantNames(mapFilePathName.replaceAll("\\\\", "/"), "/"), "/");
        StringTokenizer topicTokenizer = new StringTokenizer(FileUtils.removeRedundantNames(topicFilePathName.replaceAll("\\\\", "/"), "/"), "/");
        while (mapTokenizer.countTokens() > 1 && topicTokenizer.countTokens() > 1) {
            String mapToken = mapTokenizer.nextToken();
            String topicToken = topicTokenizer.nextToken();
            boolean equals = false;
            equals = Constants.OS_NAME.toLowerCase().indexOf("windows") != -1 ? mapToken.equalsIgnoreCase(topicToken) : mapToken.equals(topicToken);
            if (equals) continue;
            if (mapToken.endsWith(":") || topicToken.endsWith(":")) {
                return topicFilePathName;
            }
            upPathBuffer.append("..");
            upPathBuffer.append("/");
            downPathBuffer.append(topicToken);
            downPathBuffer.append("/");
            break;
        }
        while (mapTokenizer.countTokens() > 1) {
            mapTokenizer.nextToken();
            upPathBuffer.append("..");
            upPathBuffer.append("/");
        }
        while (topicTokenizer.hasMoreTokens()) {
            downPathBuffer.append(topicTokenizer.nextToken());
            if (!topicTokenizer.hasMoreTokens()) continue;
            downPathBuffer.append("/");
        }
        return upPathBuffer.append(downPathBuffer).toString();
    }

    public static String getPathtoProject(String relativePath) {
        StringTokenizer tokenizer = new StringTokenizer(relativePath, "/");
        StringBuffer buffer = new StringBuffer();
        if (tokenizer.countTokens() == 1) {
            return null;
        }
        while (tokenizer.countTokens() > 1) {
            tokenizer.nextToken();
            buffer.append("..");
            buffer.append("/");
        }
        return buffer.toString();
    }

    public static String resolveTopic(String rootPath, String relativePath) {
        String begin = relativePath;
        String end = "";
        if (relativePath.indexOf("#") != -1) {
            begin = relativePath.substring(0, relativePath.indexOf(35));
            end = relativePath.substring(relativePath.indexOf(35));
        }
        return FileUtils.normalizeDirectory(rootPath, begin) + end;
    }

    public static String resolveFile(String rootPath, String relativePath) {
        String begin = relativePath;
        if (relativePath.indexOf("#") != -1) {
            begin = relativePath.substring(0, relativePath.indexOf(35));
        }
        return FileUtils.normalizeDirectory(rootPath, begin);
    }

    public static String normalizeDirectory(String basedir, String filepath) {
        String normilizedPath = null;
        int index = filepath.indexOf("#");
        String pathname = index == -1 ? filepath : filepath.substring(0, index);
        normilizedPath = new File(basedir, pathname).getPath();
        if (basedir == null || basedir.length() == 0) {
            return normilizedPath;
        }
        return FileUtils.removeRedundantNames(normilizedPath);
    }

    public static String removeRedundantNames(String path) {
        return FileUtils.removeRedundantNames(path, File.separator);
    }

    public static String removeRedundantNames(String path, String separator) {
        StringTokenizer tokenizer = null;
        StringBuffer buff = new StringBuffer(path.length());
        LinkedList<String> dirs = new LinkedList<String>();
        Iterator iter = null;
        int dirNum = 0;
        int i = 0;
        tokenizer = new StringTokenizer(path, separator);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (".".equals(token)) continue;
            dirs.add(token);
        }
        dirNum = dirs.size();
        while (i < dirNum) {
            if (i > 0) {
                String lastDir = (String)dirs.get(i - 1);
                String dir = (String)dirs.get(i);
                if ("..".equals(dir) && !"..".equals(lastDir)) {
                    dirs.remove(i);
                    dirs.remove(i - 1);
                    dirNum = dirs.size();
                    --i;
                    continue;
                }
            }
            ++i;
        }
        if (path.startsWith(separator)) {
            buff.append(separator);
        }
        iter = dirs.iterator();
        while (iter.hasNext()) {
            buff.append((String)iter.next());
            if (!iter.hasNext()) continue;
            buff.append(separator);
        }
        return buff.toString();
    }

    public static boolean isAbsolutePath(String path) {
        if (path == null || "".equals(path.trim())) {
            return false;
        }
        if (Constants.FILE_SEPARATOR.equals("/")) {
            return path.startsWith("/");
        }
        if (Constants.FILE_SEPARATOR.equals("\\") && path.length() > 2) {
            return path.matches("[a-zA-Z]:\\\\.*");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File target) {
        DITAOTJavaLogger logger;
        FileInputStream fis = null;
        FileOutputStream fos = null;
        byte[] buffer = new byte[4096];
        try {
            int len;
            fis = new FileInputStream(src);
            fos = new FileOutputStream(target);
            while ((len = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, len);
            }
            fos.flush();
        }
        catch (IOException ex) {
            logger = new DITAOTJavaLogger();
            logger.logException(ex);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                logger = new DITAOTJavaLogger();
                logger.logException(e);
            }
        }
    }

    public static String replaceExtName(String attValue, String extName) {
        int index = attValue.indexOf("#");
        if (attValue.startsWith("#")) {
            return attValue;
        }
        if (index != -1) {
            String fileName = attValue.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(0, fileExtIndex) + extName + attValue.substring(index) : attValue;
        }
        int fileExtIndex = attValue.lastIndexOf(".");
        return fileExtIndex != -1 ? attValue.substring(0, fileExtIndex) + extName : attValue;
    }

    public static boolean fileExists(String filename) {
        String string = filename = filename.indexOf("#") != -1 ? filename.substring(0, filename.indexOf("#")) : filename;
        return new File(filename).exists();
    }
}

