/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.util;

public class LogUtils {
    private static int numOfFatals = 0;
    private static int numOfErrors = 0;
    private static int numOfWarnings = 0;
    private static int numOfInfo = 0;
    private static final String FATAL = "FATAL";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final String INFO = "INFO";
    private static final String LINE_SEP = System.getProperty("line.separator");

    private LogUtils() {
    }

    public static void increaseNumOfFatals() {
        ++numOfFatals;
    }

    public static void increaseNumOfErrors() {
        ++numOfErrors;
    }

    public static void increaseNumOfWarnings() {
        ++numOfWarnings;
    }

    public static void increaseNumOfInfo() {
        ++numOfInfo;
    }

    public static int getNumOfFatals() {
        return numOfFatals;
    }

    public static int getNumOfErrors() {
        return numOfErrors;
    }

    public static int getNumOfWarnings() {
        return numOfWarnings;
    }

    public static int getNumOfInfo() {
        return numOfInfo;
    }

    public static void clear() {
        numOfFatals = 0;
        numOfErrors = 0;
        numOfWarnings = 0;
        numOfInfo = 0;
    }

    public static boolean haveFatalOrError() {
        return numOfFatals > 0 || numOfErrors > 0;
    }

    public static void print() {
        System.out.println("Number of Fatals : " + numOfFatals);
        System.out.println("Number of Errors : " + numOfErrors);
        System.out.println("Number of Warnings : " + numOfWarnings);
        System.out.println("Number of Info : " + numOfInfo);
    }

    public static String getLogStatisticInfo() {
        String logStaticticInfo = "Number of Fatals : " + LogUtils.getNumOfFatals() + LINE_SEP;
        logStaticticInfo = logStaticticInfo + "Number of Errors : " + LogUtils.getNumOfErrors() + LINE_SEP;
        logStaticticInfo = logStaticticInfo + "Number of Warnings : " + LogUtils.getNumOfWarnings() + LINE_SEP;
        return logStaticticInfo;
    }

    public static void increaseNumOfExceptionByType(String msgType) {
        if (msgType == null) {
            LogUtils.increaseNumOfErrors();
            return;
        }
        String type = msgType.toUpperCase();
        if (FATAL.equals(type)) {
            LogUtils.increaseNumOfFatals();
            return;
        }
        if (ERROR.equals(type)) {
            LogUtils.increaseNumOfErrors();
            return;
        }
        if (WARN.equals(type)) {
            LogUtils.increaseNumOfWarnings();
            return;
        }
        if (INFO.equals(type)) {
            LogUtils.increaseNumOfInfo();
            return;
        }
        LogUtils.increaseNumOfErrors();
    }
}

