/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DitaMetaWriter
extends AbstractXMLWriter {
    private String firstMatchTopic;
    private String lastMatchTopic;
    private Hashtable metaTable = null;
    private DITAOTJavaLogger logger;
    private List matchList = null;
    private boolean needResolveEntity = false;
    private Writer output = null;
    private OutputStreamWriter ditaFileOutput;
    private StringWriter strOutput;
    private XMLReader reader;
    private boolean startTopic = false;
    private boolean startDOM;
    private boolean hasWritten;
    private List topicIdList = new ArrayList(16);
    private boolean insideCDATA = false;
    private ArrayList topicSpecList = new ArrayList(16);
    private static Hashtable moveTable = new Hashtable(32);
    private static HashSet uniqueSet;
    private static Hashtable compareTable;

    public DitaMetaWriter() {
        this.logger = new DITAOTJavaLogger();
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    private boolean checkMatch() {
        int matchSize = this.matchList.size();
        int ancestorSize = this.topicIdList.size();
        ListIterator matchIterator = this.matchList.listIterator();
        ListIterator ancestorIterator = this.topicIdList.listIterator(ancestorSize - matchSize);
        if (this.matchList == null) {
            return true;
        }
        while (matchIterator.hasNext()) {
            String ancestor;
            String match = (String)matchIterator.next();
            if (match.equals(ancestor = (String)ancestorIterator.next())) continue;
            return false;
        }
        return true;
    }

    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.startTopic) {
            this.topicIdList.remove(this.topicIdList.size() - 1);
        }
        try {
            if (this.startTopic && this.topicSpecList.contains(qName)) {
                if (this.startDOM) {
                    this.startDOM = false;
                    this.output.write("</topic>");
                    this.output = this.ditaFileOutput;
                    this.processDOM();
                } else if (!this.hasWritten) {
                    this.output = this.ditaFileOutput;
                    this.processDOM();
                }
            }
            this.output.write("</" + qName + ">");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private void processDOM() {
        try {
            Document doc;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (this.strOutput.getBuffer().length() > 0) {
                builder.setErrorHandler(new DITAOTXMLErrorHandler(this.strOutput.toString()));
                doc = builder.parse(new InputSource(new StringReader(this.strOutput.toString())));
            } else {
                doc = builder.newDocument();
                doc.appendChild(doc.createElement("topic"));
            }
            Element root = doc.getDocumentElement();
            for (Map.Entry entry : this.metaTable.entrySet()) {
                this.moveMeta(entry, root);
            }
            this.outputMeta(root);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        this.hasWritten = true;
    }

    private void outputMeta(Node root) throws IOException {
        NodeList children = root.getChildNodes();
        Node child = null;
        block5: for (int i = 0; i < children.getLength(); ++i) {
            child = children.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    this.output((Text)child);
                    continue block5;
                }
                case 7: {
                    this.output((ProcessingInstruction)child);
                    continue block5;
                }
                case 1: {
                    this.output((Element)child);
                }
            }
        }
    }

    private void output(ProcessingInstruction instruction) throws IOException {
        this.output.write("<?" + instruction.getTarget() + " " + instruction.getData() + "?>");
    }

    private void output(Text text) throws IOException {
        this.output.write(StringUtils.escapeXML(text.getData()));
    }

    private void output(Element elem) throws IOException {
        this.output.write("<" + elem.getNodeName());
        NamedNodeMap attrMap = elem.getAttributes();
        for (int i = 0; i < attrMap.getLength(); ++i) {
            this.output.write(" " + attrMap.item(i).getNodeName() + "=\"" + attrMap.item(i).getNodeValue() + "\"");
        }
        this.output.write(">");
        NodeList children = elem.getChildNodes();
        block6: for (int j = 0; j < children.getLength(); ++j) {
            Node child = children.item(j);
            switch (child.getNodeType()) {
                case 3: {
                    this.output((Text)child);
                    continue block6;
                }
                case 7: {
                    this.output((ProcessingInstruction)child);
                    continue block6;
                }
                case 1: {
                    this.output((Element)child);
                }
            }
        }
        this.output.write("</" + elem.getNodeName() + ">");
    }

    private void moveMeta(Map.Entry entry, Node root) {
        String metaPath = (String)moveTable.get(entry.getKey());
        if (metaPath == null) {
            return;
        }
        StringTokenizer token = new StringTokenizer(metaPath, "/");
        Node parent = null;
        Node child = root;
        Node current = null;
        Node item = null;
        boolean createChild = false;
        while (token.hasMoreElements()) {
            parent = child;
            String next = (String)token.nextElement();
            Integer nextIndex = (Integer)compareTable.get(next);
            Integer currentIndex = null;
            NodeList childElements = parent.getChildNodes();
            for (int i = 0; i < childElements.getLength(); ++i) {
                String name = null;
                current = childElements.item(i);
                if (current.getNodeType() == 1) {
                    name = current.getNodeName();
                }
                if (name != null && current.getNodeName().equals(next)) {
                    child = current;
                    break;
                }
                if (name == null) continue;
                currentIndex = (Integer)compareTable.get(name);
                if (currentIndex == null) {
                    String classValue = ((Element)current).getAttribute("class");
                    String generalizedName = classValue.substring(classValue.indexOf("/") + 1);
                    generalizedName = generalizedName.substring(0, generalizedName.indexOf(" "));
                    currentIndex = (Integer)compareTable.get(generalizedName);
                }
                if (currentIndex == null) {
                    Properties prop = new Properties();
                    prop.put("%1", name);
                    this.logger.logFatal(MessageUtils.getMessage("DOTJ038W", prop).toString());
                    break;
                }
                if (currentIndex.compareTo(nextIndex) > 0) break;
            }
            if (child != parent) continue;
            child = parent.getOwnerDocument().createElement(next);
            ((Element)child).setAttribute("class", "- topic/" + next + " ");
            if (current == null || currentIndex == null || nextIndex.compareTo(currentIndex) >= 0) {
                parent.appendChild(child);
                current = null;
            } else {
                parent.insertBefore(child, current);
                current = null;
            }
            createChild = true;
        }
        NodeList list = ((Node)entry.getValue()).getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            item = list.item(i);
            if (i == 0 && createChild || uniqueSet.contains(entry.getKey())) {
                item = parent.getOwnerDocument().importNode(item, true);
                parent.replaceChild(item, child);
                child = item;
                continue;
            }
            item = parent.getOwnerDocument().importNode(item, true);
            ((Element)parent).insertBefore(item, child);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void setContent(Content content) {
        this.metaTable = (Hashtable)content.getValue();
    }

    private void setMatch(String match) {
        int index = 0;
        this.matchList = new ArrayList(16);
        String string = this.firstMatchTopic = match.indexOf("/") != -1 ? match.substring(0, match.indexOf(47)) : match;
        while (index != -1) {
            int end = match.indexOf("/", index);
            if (end == -1) {
                this.matchList.add(match.substring(index));
                this.lastMatchTopic = match.substring(index);
                index = end;
                continue;
            }
            this.matchList.add(match.substring(index, end));
            index = end + 1;
        }
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            this.output.write(StringUtils.getEntity(name));
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void startCDATA() throws SAXException {
        this.insideCDATA = true;
        try {
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String classAttrValue = atts.getValue("class");
        try {
            if (classAttrValue != null && classAttrValue.contains(" topic/topic ") && !this.topicSpecList.contains(qName)) {
                this.topicSpecList.add(qName);
            }
            if (!(!this.startTopic || this.startDOM || classAttrValue == null || this.hasWritten || classAttrValue.indexOf(" topic/prolog ") == -1 && classAttrValue.indexOf(" topic/abstract ") == -1 && classAttrValue.indexOf(" topic/shortdesc ") == -1 && classAttrValue.indexOf(" topic/titlealts ") == -1)) {
                this.startDOM = true;
                this.output = this.strOutput;
                this.output.write("<topic>");
            }
            if (this.startTopic && classAttrValue != null && !this.hasWritten && (classAttrValue.indexOf(" topic/topic ") != -1 || classAttrValue.indexOf(" topic/related-links ") != -1 || classAttrValue.indexOf(" topic/body ") != -1)) {
                if (this.startDOM) {
                    this.startDOM = false;
                    this.output.write("</topic>");
                    this.output = this.ditaFileOutput;
                    this.processDOM();
                } else {
                    this.processDOM();
                }
            }
            if (!this.startTopic && !"dita".equalsIgnoreCase(qName)) {
                if (atts.getValue("id") != null) {
                    this.topicIdList.add(atts.getValue("id"));
                } else {
                    this.topicIdList.add("null");
                }
                if (this.matchList == null) {
                    this.startTopic = true;
                } else if (this.topicIdList.size() >= this.matchList.size()) {
                    this.startTopic = this.checkMatch();
                }
            }
            this.outputElement(qName, atts);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private void outputElement(String qName, Attributes atts) throws IOException {
        int attsLen = atts.getLength();
        this.output.write("<" + qName);
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = atts.getValue(i);
            attValue = StringUtils.escapeXML(attValue);
            this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append("\"").append(attValue).append("\"").toString());
        }
        this.output.write(">");
    }

    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String outputFilename) {
        String filename = outputFilename;
        String file = null;
        String topic = null;
        File inputFile = null;
        File outputFile = null;
        FileOutputStream fileOutput = null;
        try {
            Properties prop;
            if (filename.endsWith("#")) {
                filename = filename.substring(0, filename.length() - 1);
            }
            if (filename.lastIndexOf("#") != -1) {
                file = filename.substring(0, filename.lastIndexOf("#"));
                topic = filename.substring(filename.lastIndexOf("#") + 1);
                this.setMatch(topic);
                this.startTopic = false;
            } else {
                file = filename;
                this.matchList = null;
                this.startTopic = false;
            }
            this.needResolveEntity = true;
            this.hasWritten = false;
            this.startDOM = false;
            inputFile = new File(file);
            outputFile = new File(file + ".temp");
            fileOutput = new FileOutputStream(outputFile);
            this.ditaFileOutput = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.strOutput = new StringWriter();
            this.output = this.ditaFileOutput;
            this.topicIdList.clear();
            this.reader.parse(file);
            this.output.close();
            if (!inputFile.delete()) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        finally {
            try {
                fileOutput.close();
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    static {
        moveTable.put(" map/searchtitle ", "titlealts/searchtitle");
        moveTable.put(" topic/audience ", "prolog/metadata/audience");
        moveTable.put(" topic/author ", "prolog/author");
        moveTable.put(" topic/category ", "prolog/metadata/category");
        moveTable.put(" topic/copyright ", "prolog/copyright");
        moveTable.put(" topic/critdates ", "prolog/critdates");
        moveTable.put(" topic/data ", "prolog/data");
        moveTable.put(" topic/data-about ", "prolog/data-about");
        moveTable.put(" topic/foreign ", "prolog/foreign");
        moveTable.put(" topic/keywords ", "prolog/metadata/keywords");
        moveTable.put(" topic/othermeta ", "prolog/metadata/othermeta");
        moveTable.put(" topic/permissions ", "prolog/permissions");
        moveTable.put(" topic/prodinfo ", "prolog/metadata/prodinfo");
        moveTable.put(" topic/publisher ", "prolog/publisher");
        moveTable.put(" topic/resourceid ", "prolog/resourceid");
        moveTable.put(" map/map ", "titlealts/searchtitle");
        moveTable.put(" topic/source ", "prolog/source");
        moveTable.put(" topic/unknown ", "prolog/unknown");
        uniqueSet = new HashSet(16);
        uniqueSet.add(" topic/critdates ");
        uniqueSet.add(" topic/permissions ");
        uniqueSet.add(" topic/publisher ");
        uniqueSet.add(" topic/source ");
        uniqueSet.add(" map/searchtitle ");
        compareTable = new Hashtable(32);
        compareTable.put("titlealts", new Integer(1));
        compareTable.put("navtitle", new Integer(2));
        compareTable.put("searchtitle", new Integer(3));
        compareTable.put("abstract", new Integer(4));
        compareTable.put("shortdesc", new Integer(5));
        compareTable.put("prolog", new Integer(6));
        compareTable.put("author", new Integer(7));
        compareTable.put("source", new Integer(8));
        compareTable.put("publisher", new Integer(9));
        compareTable.put("copyright", new Integer(10));
        compareTable.put("critdates", new Integer(11));
        compareTable.put("permissions", new Integer(12));
        compareTable.put("metadata", new Integer(13));
        compareTable.put("audience", new Integer(14));
        compareTable.put("category", new Integer(15));
        compareTable.put("keywords", new Integer(16));
        compareTable.put("prodinfo", new Integer(17));
        compareTable.put("othermeta", new Integer(18));
        compareTable.put("resourceid", new Integer(19));
        compareTable.put("data", new Integer(20));
        compareTable.put("data-about", new Integer(21));
        compareTable.put("foreign", new Integer(22));
        compareTable.put("unknown", new Integer(23));
    }
}

