/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.dita.dost.exception.DITAOTException;
import org.dita.dost.exception.DITAOTXMLErrorHandler;
import org.dita.dost.log.DITAOTJavaLogger;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.module.Content;
import org.dita.dost.util.Constants;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.StringUtils;
import org.dita.dost.writer.AbstractXMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopicRefWriter
extends AbstractXMLWriter {
    private static final String NOT_LOCAL_URL = "://";
    private LinkedHashMap<String, String> changeTable = null;
    private Hashtable<String, String> conflictTable = null;
    private DITAOTJavaLogger logger = new DITAOTJavaLogger();
    private OutputStreamWriter output = null;
    private OutputStreamWriter ditaFileOutput;
    private boolean needResolveEntity;
    private boolean insideCDATA = false;
    private String currentFilePath = null;
    private String currentFilePathName = null;
    private XMLReader reader = null;

    public TopicRefWriter() {
        try {
            if (System.getProperty("org.xml.sax.driver") == null) {
                StringUtils.initSaxDriver();
            }
            this.reader = XMLReaderFactory.createXMLReader();
            this.reader.setContentHandler(this);
            this.reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            this.reader.setFeature("http://apache.org/xml/features/scanner/notify-builtin-refs", true);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    public void setup(Hashtable<String, String> conflictTable) {
        this.conflictTable = conflictTable;
    }

    @Override
    public void startEntity(String name) throws SAXException {
        try {
            this.needResolveEntity = StringUtils.checkEntity(name);
            if (!this.needResolveEntity) {
                this.output.write(StringUtils.getEntity(name));
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        try {
            String pi = data != null ? target + " " + data : target;
            this.output.write("<?" + pi + "?" + ">");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.output.write(ch, start, length);
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.needResolveEntity) {
            try {
                if (this.insideCDATA) {
                    this.output.write(ch, start, length);
                } else {
                    this.output.write(StringUtils.escapeXML(ch, start, length));
                }
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.needResolveEntity) {
            this.needResolveEntity = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.insideCDATA = false;
        try {
            this.output.write("]]>");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.output.flush();
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.output.write("</" + qName + ">");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void setContent(Content content) {
        this.changeTable = (LinkedHashMap)content.getValue();
    }

    @Override
    public void startCDATA() throws SAXException {
        try {
            this.insideCDATA = true;
            this.output.write("<![CDATA[");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        try {
            this.output.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
            this.output.write(Constants.LINE_SEPARATOR);
        }
        catch (IOException io) {
            this.logger.logException(io);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.copyElementName(qName, atts);
            this.copyElementAttribute(atts);
            this.output.write(">");
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
    }

    private void copyAttribute(String attQName, String attValue) throws IOException {
        this.output.write(new StringBuffer().append(" ").append(attQName).append("=").append("\"").append(attValue).append("\"").toString());
    }

    private void copyElementAttribute(Attributes atts) throws IOException {
        int attsLen = atts.getLength();
        for (int i = 0; i < attsLen; ++i) {
            String attQName = atts.getQName(i);
            String attValue = "href".equals(attQName) ? this.updateHref(attQName, atts) : atts.getValue(i);
            attValue = StringUtils.escapeXML(attValue);
            this.copyAttribute(attQName, attValue);
        }
    }

    private boolean checkDITAHREF(Attributes atts) {
        String classValue = atts.getValue("class");
        String scopeValue = atts.getValue("scope");
        String formatValue = atts.getValue("format");
        if (classValue == null || classValue.indexOf(" topic/xref ") == -1 && classValue.indexOf(" topic/link ") == -1 && classValue.indexOf(" map/topicref ") == -1) {
            return false;
        }
        if (scopeValue == null) {
            scopeValue = "local";
        }
        if (formatValue == null) {
            formatValue = "dita";
        }
        return scopeValue.equalsIgnoreCase("local") && formatValue.equalsIgnoreCase("dita");
    }

    private String updateHref(String attQName, Attributes atts) {
        String attValue = null;
        if (attQName == null) {
            return null;
        }
        attValue = atts.getValue(attQName);
        if (attValue == null) {
            return null;
        }
        attValue = attValue.replaceAll("\\\\", "/");
        if (this.changeTable == null) {
            return attValue;
        }
        if (this.checkDITAHREF(atts)) {
            String pathtoElem;
            String rootPathName = this.currentFilePathName;
            String changeTarget = this.changeTable.get(FileUtils.resolveFile(this.currentFilePath, attValue));
            String elementID = this.getElementID(attValue);
            String string = pathtoElem = attValue.contains("#") ? attValue.substring(attValue.indexOf("#") + 1) : "";
            if (StringUtils.isEmptyString(changeTarget)) {
                String absolutePath = FileUtils.resolveTopic(this.currentFilePath, attValue);
                if (absolutePath.contains("#") && absolutePath.substring(absolutePath.indexOf("#")).contains("/")) {
                    absolutePath = absolutePath.substring(0, absolutePath.indexOf("/", absolutePath.indexOf("#")));
                }
                changeTarget = this.changeTable.get(absolutePath);
            }
            if (!this.notTopicFormat(atts, attValue)) {
                if (changeTarget == null) {
                    return attValue;
                }
                String conTarget = this.conflictTable.get(this.removeAnchor(changeTarget));
                if (!StringUtils.isEmptyString(conTarget)) {
                    if (elementID == null) {
                        String idpath = this.getElementID(changeTarget);
                        return FileUtils.getRelativePathFromMap(rootPathName, conTarget) + (idpath != null ? "#" + idpath : "");
                    }
                    if (conTarget.contains("#")) {
                        if (!pathtoElem.contains("/")) {
                            return FileUtils.getRelativePathFromMap(rootPathName, conTarget);
                        }
                        return FileUtils.getRelativePathFromMap(rootPathName, conTarget) + "/" + elementID;
                    }
                    return FileUtils.getRelativePathFromMap(rootPathName, conTarget) + "#" + pathtoElem;
                }
                if (elementID == null) {
                    return FileUtils.getRelativePathFromMap(rootPathName, changeTarget);
                }
                if (changeTarget.contains("#")) {
                    if (!pathtoElem.contains("/")) {
                        return FileUtils.getRelativePathFromMap(rootPathName, changeTarget);
                    }
                    return FileUtils.getRelativePathFromMap(rootPathName, changeTarget) + "/" + elementID;
                }
                return FileUtils.getRelativePathFromMap(rootPathName, changeTarget) + "#" + pathtoElem;
            }
        }
        return attValue;
    }

    private String removeAnchor(String s) {
        if (s.lastIndexOf("#") != -1) {
            return s.substring(0, s.lastIndexOf("#"));
        }
        return s;
    }

    private String getElementID(String relativePath) {
        String elementID = null;
        String topicWithelement = null;
        if (relativePath.indexOf("#") != -1) {
            topicWithelement = relativePath.substring(relativePath.lastIndexOf("#") + 1);
            elementID = topicWithelement.lastIndexOf("/") != -1 ? topicWithelement.substring(topicWithelement.lastIndexOf("/") + 1) : topicWithelement;
        }
        return elementID;
    }

    private boolean notLocalURL(String valueOfURL) {
        return valueOfURL.indexOf(NOT_LOCAL_URL) != -1;
    }

    public String getExtName(String attValue) {
        int index = attValue.indexOf("#");
        if (attValue.startsWith("#")) {
            return null;
        }
        if (index != -1) {
            String fileName = attValue.substring(0, index);
            int fileExtIndex = fileName.lastIndexOf(".");
            return fileExtIndex != -1 ? fileName.substring(fileExtIndex + 1, fileName.length()) : null;
        }
        int fileExtIndex = attValue.lastIndexOf(".");
        return fileExtIndex != -1 ? attValue.substring(fileExtIndex + 1, attValue.length()) : null;
    }

    private boolean notTopicFormat(Attributes attrs, String valueOfHref) {
        String hrefValue = valueOfHref;
        String formatValue = attrs.getValue("format");
        String extOfHref = this.getExtName(valueOfHref);
        if (this.notLocalURL(hrefValue)) {
            return true;
        }
        return formatValue == null && extOfHref != null && !extOfHref.equalsIgnoreCase("DITA") && !extOfHref.equalsIgnoreCase("XML");
    }

    private void copyElementName(String qName, Attributes atts) throws IOException {
        this.output.write("<" + qName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String outputFilename) throws DITAOTException {
        String filename = outputFilename;
        String file = null;
        this.currentFilePathName = new File(outputFilename).getAbsolutePath();
        this.currentFilePath = new File(outputFilename).getParent();
        File inputFile = null;
        File outputFile = null;
        FileOutputStream fileOutput = null;
        this.needResolveEntity = true;
        try {
            Properties prop;
            if (filename.endsWith("#")) {
                filename = filename.substring(0, filename.length() - 1);
            }
            file = filename.lastIndexOf("#") != -1 ? filename.substring(0, filename.lastIndexOf("#")) : filename;
            inputFile = new File(file);
            outputFile = new File(file + ".temp");
            fileOutput = new FileOutputStream(outputFile);
            this.output = this.ditaFileOutput = new OutputStreamWriter((OutputStream)fileOutput, "UTF-8");
            this.reader.setErrorHandler(new DITAOTXMLErrorHandler(file));
            this.reader.parse(file);
            this.output.close();
            if (!inputFile.delete()) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
            if (!outputFile.renameTo(inputFile)) {
                prop = new Properties();
                prop.put("%1", inputFile.getPath());
                prop.put("%2", outputFile.getPath());
                this.logger.logError(MessageUtils.getMessage("DOTJ009E", prop).toString());
            }
        }
        catch (Exception e) {
            this.logger.logException(e);
        }
        finally {
            try {
                fileOutput.close();
            }
            catch (Exception e) {
                this.logger.logException(e);
            }
        }
    }
}

