/*
 * Decompiled with CFR 0.152.
 */
package xpages.jeimage;

import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxe.JaxeDocument;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomJTree
extends JPanel {
    private static final Logger LOG = Logger.getLogger(DomJTree.class);
    private static final int ELEMENT_TYPE = 1;
    private static int taillemax = 300;
    private static String cheminFichierXML = "";
    private JaxeDocument doc;
    private Document document;
    private URL urlimg = null;
    JTree tree;
    TreePath arbreSelection;
    AdaptateurNoeud adpNoeud;

    public DomJTree(final JaxeDocument jaxeDocument, Document document, String string, boolean bl, final JLabel jLabel) {
        this.doc = jaxeDocument;
        this.document = document;
        cheminFichierXML = jaxeDocument.furl.getFile();
        this.tree = new JTree(new AdaptateurModele());
        this.tree.setShowsRootHandles(true);
        this.tree.setRootVisible(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DomJTree.this.arbreSelection = treeSelectionEvent.getNewLeadSelectionPath();
                if (DomJTree.this.arbreSelection != null) {
                    DomJTree.this.adpNoeud = (AdaptateurNoeud)DomJTree.this.arbreSelection.getLastPathComponent();
                    if (!DomJTree.this.adpNoeud.estUnDossier()) {
                        try {
                            DomJTree.this.urlimg = new URL(jaxeDocument.furl, DomJTree.cheminNoeud(DomJTree.this.arbreSelection));
                        }
                        catch (MalformedURLException malformedURLException) {
                            LOG.error((Object)"urlimg", (Throwable)malformedURLException);
                        }
                        Image image = Toolkit.getDefaultToolkit().createImage(DomJTree.this.urlimg);
                        if (image != null && DomJTree.this.chargerImage(image)) {
                            image = DomJTree.reduireImage(image);
                        }
                        ImageIcon imageIcon = new ImageIcon(image);
                        if (jLabel != null) {
                            jLabel.setIcon(imageIcon);
                        }
                    } else {
                        jLabel.setIcon(null);
                    }
                }
            }
        });
        if (bl && string != "") {
            String[] stringArray = string.split("\\/");
            Object[] objectArray = new AdaptateurNoeud[stringArray.length + 1];
            objectArray[0] = (AdaptateurNoeud)this.tree.getModel().getRoot();
            boolean bl2 = false;
            block0: for (int i = 0; i < stringArray.length && objectArray[i] != null; ++i) {
                for (int j = 0; j < ((AdaptateurNoeud)objectArray[i]).nombreEnfant(); ++j) {
                    if (!stringArray[i].equals(((AdaptateurNoeud)objectArray[i]).enfant(j).toString())) continue;
                    objectArray[i + 1] = ((AdaptateurNoeud)objectArray[i]).enfant(j);
                    if (i != stringArray.length - 1) continue block0;
                    bl2 = true;
                    continue block0;
                }
            }
            if (bl2) {
                TreePath treePath = new TreePath(objectArray);
                this.tree.setExpandsSelectedPaths(true);
                if (treePath != null) {
                    this.tree.setSelectionPath(treePath);
                }
            }
        }
    }

    public static String cheminNoeud(TreePath treePath) {
        String string = "";
        if (treePath != null) {
            string = treePath.toString();
            string = string.replace(", ", "/");
            string = string.substring(DomJTree.nomContribution().length() + 2, string.length() - 1);
        }
        return string;
    }

    private static String nomContribution() {
        String[] stringArray = cheminFichierXML.split("\\/");
        String string = stringArray[stringArray.length - 1];
        String[] stringArray2 = string.split("\\.xml");
        String string2 = stringArray2[0];
        return string2;
    }

    private boolean chargerImage(Image image) {
        if (image == null) {
            return false;
        }
        MediaTracker mediaTracker = new MediaTracker(this.doc.jframe);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return !mediaTracker.isErrorAny();
    }

    private static Image reduireImage(Image image) {
        if (image == null) {
            return null;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == -1 || n2 == -1) {
            return null;
        }
        if (n > taillemax || n2 > taillemax) {
            double d;
            if (n > n2) {
                d = (double)taillemax * 1.0 / (double)n;
                n = taillemax;
                n2 = (int)((double)n2 * d);
            } else {
                d = (double)taillemax * 1.0 / (double)n2;
                n2 = taillemax;
                n = (int)((double)n * d);
            }
            Image image2 = image.getScaledInstance(n, n2, 2);
            image.flush();
            return image2;
        }
        return image;
    }

    public class AdaptateurModele
    implements TreeModel {
        AdaptateurNoeud racine;
        private Vector<TreeModelListener> listenerList = new Vector();

        public AdaptateurModele() {
            this.racine = new AdaptateurNoeud(DomJTree.this.document.getDocumentElement());
        }

        public Object getRoot() {
            return this.racine;
        }

        public boolean isLeaf(Object object) {
            AdaptateurNoeud adaptateurNoeud = (AdaptateurNoeud)object;
            return !adaptateurNoeud.estUnDossier();
        }

        public int getChildCount(Object object) {
            AdaptateurNoeud adaptateurNoeud = (AdaptateurNoeud)object;
            return adaptateurNoeud.nombreEnfant();
        }

        public Object getChild(Object object, int n) {
            AdaptateurNoeud adaptateurNoeud = (AdaptateurNoeud)object;
            return adaptateurNoeud.enfant(n);
        }

        public int getIndexOfChild(Object object, Object object2) {
            AdaptateurNoeud adaptateurNoeud = (AdaptateurNoeud)object;
            return adaptateurNoeud.index((AdaptateurNoeud)object2);
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (treeModelListener != null && !this.listenerList.contains(treeModelListener)) {
                this.listenerList.addElement(treeModelListener);
            }
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (treeModelListener != null) {
                this.listenerList.removeElement(treeModelListener);
            }
        }

        public void fireTreeNodesChanged(TreeModelEvent treeModelEvent) {
            Enumeration<TreeModelListener> enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = enumeration.nextElement();
                treeModelListener.treeNodesChanged(treeModelEvent);
            }
        }

        public void fireTreeNodesInserted(TreeModelEvent treeModelEvent) {
            Enumeration<TreeModelListener> enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = enumeration.nextElement();
                treeModelListener.treeNodesInserted(treeModelEvent);
            }
        }

        public void fireTreeNodesRemoved(TreeModelEvent treeModelEvent) {
            Enumeration<TreeModelListener> enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = enumeration.nextElement();
                treeModelListener.treeNodesRemoved(treeModelEvent);
            }
        }

        public void fireTreeStructureChanged(TreeModelEvent treeModelEvent) {
            Enumeration<TreeModelListener> enumeration = this.listenerList.elements();
            while (enumeration.hasMoreElements()) {
                TreeModelListener treeModelListener = enumeration.nextElement();
                treeModelListener.treeStructureChanged(treeModelEvent);
            }
        }
    }

    public class AdaptateurNoeud {
        Node domNode;
        AdaptateurNoeud[] enfants;

        public AdaptateurNoeud(Node node) {
            this.domNode = node;
            ArrayList<AdaptateurNoeud> arrayList = new ArrayList<AdaptateurNoeud>();
            for (int i = 0; i < this.domNode.getChildNodes().getLength(); ++i) {
                node = this.domNode.getChildNodes().item(i);
                if (node.getNodeType() != 1) continue;
                arrayList.add(new AdaptateurNoeud(node));
            }
            if (arrayList.size() == 0) {
                this.enfants = null;
            } else {
                this.enfants = new AdaptateurNoeud[arrayList.size()];
                arrayList.toArray(this.enfants);
            }
        }

        public String toString() {
            if (this.domNode instanceof Element) {
                return ((Element)this.domNode).getAttribute("nom");
            }
            return "";
        }

        public int index(AdaptateurNoeud adaptateurNoeud) {
            if (this.enfants == null) {
                return -1;
            }
            for (int i = 0; i < this.enfants.length; ++i) {
                if (adaptateurNoeud != this.enfants[i]) continue;
                return i;
            }
            return -1;
        }

        public AdaptateurNoeud enfant(int n) {
            if (this.enfants == null) {
                return null;
            }
            return this.enfants[n];
        }

        public int nombreEnfant() {
            if (this.enfants == null) {
                return 0;
            }
            return this.enfants.length;
        }

        public boolean estUnDossier() {
            return "DOSSIER".equals(this.domNode.getNodeName());
        }
    }
}

