/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jst;

import com.fluendo.jst.Buffer;
import com.fluendo.jst.Caps;
import com.fluendo.jst.CapsListener;
import com.fluendo.jst.Event;
import com.fluendo.jst.Object;
import com.fluendo.jst.Query;
import com.fluendo.utils.Debug;
import java.util.Enumeration;
import java.util.Vector;

public class Pad
extends Object
implements Runnable {
    public static final int UNKNOWN = 0;
    public static final int SRC = 1;
    public static final int SINK = 2;
    public static final int OK = 0;
    public static final int NOT_LINKED = -1;
    public static final int WRONG_STATE = -2;
    public static final int UNEXPECTED = -3;
    public static final int NOT_NEGOTIATED = -4;
    public static final int ERROR = -5;
    public static final int NOT_SUPPORTED = -6;
    public static final int MODE_NONE = 0;
    public static final int MODE_PUSH = 1;
    public static final int MODE_PULL = 2;
    protected Pad peer;
    protected int direction = 0;
    protected boolean flushing;
    protected java.lang.Object streamLock = new java.lang.Object();
    int mode;
    private Vector capsListeners = new Vector();
    protected Caps caps;
    private static final int T_STOP = 0;
    private static final int T_PAUSE = 1;
    private static final int T_START = 2;
    private Thread thread;
    private int taskState;

    public static final boolean isFlowFatal(int n) {
        return n <= -3;
    }

    public static final boolean isFlowSuccess(int n) {
        return n >= 0;
    }

    public static final String getFlowName(int n) {
        switch (n) {
            case 0: {
                return "ok";
            }
            case -1: {
                return "not-linked";
            }
            case -2: {
                return "wrong-state";
            }
            case -3: {
                return "unexpected";
            }
            case -4: {
                return "not-negotiated";
            }
            case -5: {
                return "error";
            }
            case -6: {
                return "not-supported";
            }
        }
        return "unknown";
    }

    public Pad(int n) {
        this(n, null);
    }

    public Pad(int n, String string) {
        super(string);
        this.direction = n;
    }

    public String toString() {
        String string = this.parent != null ? this.parent.getName() : "";
        String string2 = this.getName();
        if (string2 == null) {
            string2 = "";
        }
        return "Pad: " + string + ":" + string2;
    }

    public synchronized void addCapsListener(CapsListener capsListener) {
        this.capsListeners.addElement(capsListener);
    }

    public synchronized void removeCapsListener(CapsListener capsListener) {
        this.capsListeners.removeElement(capsListener);
    }

    private synchronized void doCapsListeners(Caps caps) {
        Enumeration enumeration = this.capsListeners.elements();
        while (enumeration.hasMoreElements()) {
            CapsListener capsListener = (CapsListener)enumeration.nextElement();
            capsListener.capsChanged(caps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean link(Pad pad) {
        if (this.peer != null) {
            return false;
        }
        if (this.direction != 1) {
            return false;
        }
        Pad pad2 = pad;
        synchronized (pad2) {
            if (pad.direction != 2) {
                return false;
            }
            if (pad.peer != null) {
                return false;
            }
            this.peer = pad;
            this.peer.peer = this;
        }
        return true;
    }

    public synchronized void unlink() {
        if (this.peer == null) {
            return;
        }
        if (this.direction == 1) {
            this.peer.unlink();
        }
        this.peer = null;
    }

    public synchronized Pad getPeer() {
        return this.peer;
    }

    protected boolean eventFunc(Event event) {
        switch (event.getType()) {
            default: 
        }
        boolean bl = false;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sendEvent(Event event) {
        boolean bl;
        Debug.debug(this + " got event " + event);
        switch (event.getType()) {
            case 1: {
                this.setFlushing(true);
                bl = this.eventFunc(event);
                break;
            }
            case 2: {
                java.lang.Object object = this.streamLock;
                synchronized (object) {
                    this.setFlushing(false);
                    bl = this.eventFunc(event);
                    break;
                }
            }
            case 3: 
            case 4: {
                java.lang.Object object = this.streamLock;
                synchronized (object) {
                    bl = this.eventFunc(event);
                    break;
                }
            }
            case 5: {
                bl = this.eventFunc(event);
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean query(Query query) {
        return false;
    }

    public synchronized Caps getCaps() {
        return this.caps;
    }

    protected boolean setCapsFunc(Caps caps) {
        return true;
    }

    public boolean setCaps(Caps caps) {
        boolean bl = true;
        if (caps != null) {
            bl = this.setCapsFunc(caps);
        }
        if (bl) {
            this.caps = caps;
            if (caps != null) {
                this.doCapsListeners(caps);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int chain(Buffer buffer) {
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            Pad pad = this;
            synchronized (pad) {
                if (this.flushing) {
                    return -2;
                }
                if (buffer.caps != null && buffer.caps != this.caps && !this.setCaps(buffer.caps)) {
                    buffer.free();
                    return -4;
                }
            }
            int n = this.chainFunc(buffer);
            return n;
        }
    }

    protected int chainFunc(Buffer buffer) {
        return -5;
    }

    public final int push(Buffer buffer) {
        if (this.peer == null) {
            return -1;
        }
        return this.peer.chain(buffer);
    }

    public final boolean pushEvent(Event event) {
        if (this.peer == null) {
            return false;
        }
        return this.peer.sendEvent(event);
    }

    public synchronized void setFlushing(boolean bl) {
        this.flushing = bl;
    }

    public synchronized boolean isFlushing() {
        return this.flushing;
    }

    protected boolean activateFunc(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean activate(int n) {
        boolean bl;
        Debug.debug(this + " activate mode = " + (n == 0 ? "none" : "push"));
        if (this.mode == n) {
            return true;
        }
        if (n == 0) {
            this.setFlushing(true);
        }
        if (!(bl = this.activateFunc(n))) {
            return false;
        }
        if (n != 0) {
            this.setFlushing(false);
        } else {
            java.lang.Object object = this.streamLock;
            synchronized (object) {
                this.setCaps(null);
            }
        }
        this.mode = n;
        return bl;
    }

    protected void taskFunc() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            while (this.taskState != 0) {
                while (this.taskState == 1) {
                    Debug.debug(this.parent.getName() + ":" + this.getName() + " paused, waiting...");
                    try {
                        this.streamLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.taskState == 0) break;
                try {
                    this.taskFunc();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startTask(String string) {
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            this.taskState = 2;
            if (this.thread == null) {
                this.thread = new Thread((Runnable)this, string);
                this.thread.start();
            }
            this.streamLock.notifyAll();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseTask() {
        this.taskState = 1;
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            this.taskState = 1;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTask() {
        Thread thread;
        this.taskState = 0;
        java.lang.Object object = this.streamLock;
        synchronized (object) {
            this.taskState = 0;
            this.streamLock.notifyAll();
            thread = this.thread;
            this.thread = null;
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }
}

