/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class BufferedConnection {
    public static final int CONNECTION_SERVER_TYPE = 1;
    public static final int CONNECTION_CLIENT_TYPE = 2;
    public static final int SO_TIMEOUT = 100;
    public static final int BUFFER_SIZE = 65536;
    private int m_type = 0;
    private Socket m_socket = null;
    private ServerSocket m_serversocket = null;
    private String m_host = null;
    private int m_port = -1;
    private byte[] m_buffer = new byte[65536];
    private InputStream m_inputstream = null;
    private OutputStream m_outputstream = null;
    private BufferedInputStream m_bufferedinputstream = null;
    private BufferedOutputStream m_bufferedoutputstream = null;
    private boolean connected = false;

    public BufferedConnection(int type) {
        this.m_type = type;
    }

    public BufferedConnection(Socket socket) {
        this.m_type = 1;
        this.m_socket = socket;
        try {
            this.m_outputstream = this.m_socket.getOutputStream();
            this.m_inputstream = this.m_socket.getInputStream();
            this.m_bufferedoutputstream = new BufferedOutputStream(this.m_outputstream);
            this.m_bufferedinputstream = new BufferedInputStream(this.m_inputstream);
        }
        catch (IOException e) {
            return;
        }
        try {
            this.m_socket.setSoTimeout(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = true;
    }

    public int connect(String host, int port) {
        if (this.connected) {
            return 0;
        }
        this.m_host = host;
        this.m_port = port;
        if (this.m_type == 1) {
            try {
                this.m_serversocket = new ServerSocket(this.m_port);
                this.m_port = this.m_serversocket.getLocalPort();
                this.m_socket = this.m_serversocket.accept();
            }
            catch (IOException e) {
                int n = -1;
                return n;
            }
        }
        try {
            this.m_socket = new Socket(this.m_host, this.m_port);
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        try {
            this.m_outputstream = this.m_socket.getOutputStream();
            this.m_inputstream = this.m_socket.getInputStream();
            this.m_bufferedoutputstream = new BufferedOutputStream(this.m_outputstream);
            this.m_bufferedinputstream = new BufferedInputStream(this.m_inputstream);
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        try {
            this.m_socket.setSoTimeout(100);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connected = true;
        return 0;
    }

    public synchronized int disconnect() {
        if (!this.connected) {
            return 0;
        }
        try {
            this.m_bufferedinputstream.close();
            this.m_bufferedoutputstream.flush();
            this.m_bufferedoutputstream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.m_socket.close();
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        this.connected = false;
        return 0;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public byte[] read() {
        if (!this.connected) {
            return null;
        }
        int len = -1;
        try {
            len = this.m_bufferedinputstream.read(this.m_buffer, 0, 65536);
        }
        catch (InterruptedIOException e) {
            len = 0;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (len == -1) {
            return null;
        }
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = this.m_buffer[i];
        }
        return ret;
    }

    public int write(byte[] toWrite) {
        if (toWrite == null) {
            return 0;
        }
        return this.write(toWrite, 0, toWrite.length);
    }

    public int write(byte[] toWrite, int start, int end) {
        if (toWrite == null) {
            return 0;
        }
        if (toWrite.length == 0) {
            return 0;
        }
        if (!this.connected) {
            return 0;
        }
        try {
            this.m_bufferedoutputstream.write(toWrite, start, end);
            this.m_bufferedoutputstream.flush();
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        return 0;
    }

    public int getLocalPort() {
        return this.m_port;
    }

    static {
        CONNECTION_SERVER_TYPE = 1;
        CONNECTION_CLIENT_TYPE = 2;
        SO_TIMEOUT = 100;
        BUFFER_SIZE = 65536;
    }
}

