/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import com.cqs.ftp.Connection;
import com.cqs.ftp.FileAccess;
import com.cqs.ftp.RemoteFile;
import com.cqs.ftp.ThreadDownloadPasv;
import com.cqs.ftp.ThreadDownloadPort;
import com.cqs.ftp.ThreadListPasv;
import com.cqs.ftp.ThreadListPort;
import com.cqs.ftp.ThreadUploadPasv;
import com.cqs.ftp.ThreadUploadPort;
import com.cqs.ftp.TransferMonitor;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class FTP {
    public static final String CARRIAGE_RETURN = "\r\n";
    public static final int CODE_CONNECT_OK = 220;
    public static final int CODE_DISCONNECT_OK = 221;
    public static final int CODE_LOGGEDIN = 230;
    public static final int CODE_TRANSFER_OK = 226;
    public static final int CODE_CD_OK = 250;
    public static final int CODE_PWD_OK = 257;
    protected static final int CODE_DL_FILE_OK = 150;
    protected static final int CODE_UL_FILE_OK = 150;
    public static final int CODE_DELETE_FILE_OK = 250;
    public static final int CODE_MKDIR_OK = 257;
    public static final int CODE_RMDIR_OK = 250;
    public static final int CODE_RNFR_OK = 350;
    public static final int CODE_RNTO_OK = 250;
    public static final String[] ASCII_EXT;
    public static final int TRANSFER_PORT = 0;
    public static final int TRANSFER_PASV = 1;
    private static final int MODE_UNDEFINED = -1;
    public static final int MODE_AUTO = 0;
    public static final int MODE_BINARY = 1;
    public static final int MODE_ASCII = 2;
    private String host;
    private int port;
    private String proxyHost;
    private int proxyPort;
    private boolean useProxy = false;
    private String login;
    private String password;
    private int transfer = 0;
    private int mode = 0;
    private int _mode = -1;
    private String lastRequest = "";
    private String lastReply = "";
    private RemoteFile[] directoryList = null;
    private int lastCode = -1;
    private boolean connected = false;
    private boolean log = false;
    private String logFileName = "";
    private FileAccess fileAccess = null;
    private String workingDirectory = "";
    private String stringDirectoryList = "";
    private long fileSize = 0L;
    private String passive_host = "";
    private int passive_port = -1;
    private Connection comm = null;

    public FTP(String host) {
        this.host = host;
        this.port = 21;
        this.useProxy = false;
        this.comm = new Connection(2);
    }

    public FTP(String host, int port) {
        this.host = host;
        this.port = port;
        this.useProxy = false;
        this.comm = new Connection(2);
    }

    public FTP(String host, int port, String proxyHost, int proxyPort) {
        this.host = host;
        this.port = port;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.useProxy = true;
        this.comm = new Connection(2);
    }

    public void setLogFile(String fileName) {
        if (fileName == null) {
            return;
        }
        if (fileName.length() == 0) {
            return;
        }
        this.log = true;
        this.logFileName = fileName;
        this.fileAccess = new FileAccess(this.logFileName);
        this.fileAccess.open();
    }

    public void closeLogFile() {
        if (this.fileAccess != null) {
            this.fileAccess.close();
        }
        this.fileAccess = null;
    }

    public int writeLog(String chaine) {
        if (chaine == null) {
            return 0;
        }
        if (!this.log) {
            return 0;
        }
        if (this.fileAccess != null) {
            this.fileAccess.write(chaine);
        }
        return 0;
    }

    public int writelnLog(String chaine) {
        if (chaine == null) {
            return 0;
        }
        return this.writeLog(String.valueOf(String.valueOf(chaine)).concat(CARRIAGE_RETURN));
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setTransfer(int transfer) {
        this.transfer = transfer;
    }

    public int reconnect() {
        this.disconnect();
        return this.connect();
    }

    public int connect() {
        int code = -1;
        if (this.useProxy) {
            this.writeLog(String.valueOf(String.valueOf(new StringBuffer("Connection to proxy ").append(this.proxyHost).append(":").append(this.proxyPort).append(CARRIAGE_RETURN))));
            code = this.comm.connect(this.proxyHost, this.proxyPort);
        } else {
            this.writeLog(String.valueOf(String.valueOf(new StringBuffer("Connection to host ").append(this.host).append(":").append(this.port).append(CARRIAGE_RETURN))));
            code = this.comm.connect(this.host, this.port);
        }
        if (code != 0) {
            this.lastCode = -1;
            return -1;
        }
        if (!this.read(this.comm)) {
            return -1;
        }
        this.connected = true;
        this._mode = -1;
        return 0;
    }

    public int disconnect() {
        this._mode = -1;
        if (!this.connected) {
            this.lastCode = -1;
            return 0;
        }
        this.write(this.comm, "QUIT");
        this.read(this.comm);
        this.comm.disconnect();
        this.connected = false;
        return 0;
    }

    public int login(String login, String password) {
        this.login = login;
        this.password = password;
        if (this.useProxy) {
            this.write(this.comm, String.valueOf(String.valueOf(new StringBuffer("USER ").append(login).append("@").append(this.host).append(":").append(this.port))));
        } else {
            this.write(this.comm, "USER ".concat(String.valueOf(String.valueOf(login))));
        }
        if (!this.read(this.comm)) {
            return -1;
        }
        this.write(this.comm, "PASS ".concat(String.valueOf(String.valueOf(password))));
        if (!this.read(this.comm)) {
            return -1;
        }
        this._mode = -1;
        return 0;
    }

    public int relogin() {
        return this.login(this.login, this.password);
    }

    public int cd(String directory) {
        this.write(this.comm, "CWD ".concat(String.valueOf(String.valueOf(directory))));
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int size(String fileName) {
        this.write(this.comm, "SIZE ".concat(String.valueOf(String.valueOf(fileName))));
        if (!this.read(this.comm)) {
            return -1;
        }
        this.fileSize = Long.parseLong(this.lastReply.substring(1 + this.lastReply.indexOf(" "), this.lastReply.lastIndexOf(CARRIAGE_RETURN)));
        return 0;
    }

    public int noop() {
        this.write(this.comm, "NOOP");
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int pwd() {
        this.write(this.comm, "PWD");
        if (!this.read(this.comm)) {
            return -1;
        }
        int start = 1 + this.lastReply.indexOf("\"");
        int end = this.lastReply.indexOf("\"", start);
        this.workingDirectory = this.lastReply.substring(start, end);
        return 0;
    }

    public int delete(String fileName) {
        this.write(this.comm, "DELE ".concat(String.valueOf(String.valueOf(fileName))));
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int restart(long restartByte) {
        this.write(this.comm, "REST ".concat(String.valueOf(String.valueOf(restartByte))));
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int makedir(String directory) {
        this.write(this.comm, "MKD ".concat(String.valueOf(String.valueOf(directory))));
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int removedir(String directory) {
        this.write(this.comm, "RMD ".concat(String.valueOf(String.valueOf(directory))));
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int parentdir(String directory) {
        this.write(this.comm, "CDUP");
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int rename(String oldFileName, String newFileName) {
        this.write(this.comm, "RNFR ".concat(String.valueOf(String.valueOf(oldFileName))));
        if (!this.read(this.comm)) {
            return -1;
        }
        if (this.lastCode != 350) {
            return -1;
        }
        this.write(this.comm, "RNTO ".concat(String.valueOf(String.valueOf(newFileName))));
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public String lastRequest() {
        return this.lastRequest;
    }

    public String lastReply() {
        return this.lastReply;
    }

    public int lastCode() {
        return this.lastCode;
    }

    public int pasv() {
        this.write(this.comm, "PASV");
        if (!this.read(this.comm)) {
            return -1;
        }
        int c1 = this.lastReply.indexOf(40);
        int c2 = this.lastReply.indexOf(41, c1);
        String pasv = this.lastReply.substring(1 + c1, c2);
        String[] ch = FTP.chaineSplit(pasv, ",", false);
        this.passive_host = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(ch[0]))).append(".").append(ch[1]).append(".").append(ch[2]).append(".").append(ch[3])));
        this.passive_port = Integer.parseInt(ch[4]) * 256 + Integer.parseInt(ch[5]);
        return 0;
    }

    public int ascii() {
        this.write(this.comm, "TYPE A");
        this._mode = 2;
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int binary() {
        this.write(this.comm, "TYPE I");
        this._mode = 1;
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int list() {
        return this.list(null);
    }

    public int list(TransferMonitor transferMonitor) {
        if (this.transfer == 1) {
            this.pasv();
            this.write(this.comm, "LIST");
            ThreadListPasv tl = new ThreadListPasv(this.passive_host, this.passive_port);
            tl.start();
            if (!this.read(this.comm)) {
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(tl);
                transferMonitor.start();
            }
            try {
                tl.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.read(this.comm)) {
                return -1;
            }
            this.stringDirectoryList = tl.getList();
        } else if (this.transfer == 0) {
            String localIp = "";
            try {
                localIp = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
            }
            catch (Exception exception) {
                // empty catch block
            }
            ThreadListPort tl = new ThreadListPort();
            int dataPort = tl.getLocalPort();
            int low = dataPort % 256;
            int high = dataPort / 256;
            this.write(this.comm, String.valueOf(String.valueOf(new StringBuffer("PORT ").append(localIp).append(",").append(high).append(",").append(low))));
            if (!this.read(this.comm)) {
                return -1;
            }
            tl.start();
            this.write(this.comm, "LIST");
            if (!this.read(this.comm)) {
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(tl);
                transferMonitor.start();
            }
            try {
                tl.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.read(this.comm)) {
                return -1;
            }
            this.stringDirectoryList = tl.getList();
        }
        this.directoryList = RemoteFile.createFromList(this.stringDirectoryList);
        return 0;
    }

    public int raw(String command) {
        this.write(this.comm, command);
        if (!this.read(this.comm)) {
            return -1;
        }
        return 0;
    }

    public int download(String remote, String local) {
        return this.download(null, remote, local, 0L);
    }

    public int download(TransferMonitor transferMonitor, String remote, String local) {
        return this.download(transferMonitor, remote, local, 0L);
    }

    public int download(String remote, String local, long restartByte) {
        return this.download(null, remote, local, 0L);
    }

    public int download(TransferMonitor transferMonitor, String remote, String local, long restartByte) {
        switch (this.mode) {
            case 0: {
                if (FTP.hasAsciiExtension(remote)) {
                    if (this._mode == 2) break;
                    this.ascii();
                    break;
                }
                if (this._mode == 1) break;
                this.binary();
                break;
            }
            case 1: {
                if (this._mode == 1) break;
                this.binary();
                break;
            }
            case 2: {
                if (this._mode == 2) break;
                this.ascii();
            }
        }
        if (this.transfer == 1) {
            this.pasv();
            if (restartByte > (long)0) {
                this.restart(restartByte);
            }
            this.write(this.comm, "RETR ".concat(String.valueOf(String.valueOf(remote))));
            ThreadDownloadPasv td = new ThreadDownloadPasv(this.passive_host, this.passive_port, local, restartByte);
            td.start();
            if (!this.read(this.comm)) {
                return -1;
            }
            if (this.lastCode != 150) {
                td.interrupt();
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(td);
                transferMonitor.start();
            }
            try {
                td.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.read(this.comm)) {
                return -1;
            }
        } else if (this.transfer == 0) {
            String localIp = "";
            try {
                localIp = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
            }
            catch (Exception exception) {
                // empty catch block
            }
            ThreadDownloadPort td = new ThreadDownloadPort(local, restartByte);
            int dataPort = td.getLocalPort();
            int low = dataPort % 256;
            int high = dataPort / 256;
            this.write(this.comm, String.valueOf(String.valueOf(new StringBuffer("PORT ").append(localIp).append(",").append(high).append(",").append(low))));
            if (!this.read(this.comm)) {
                return -1;
            }
            if (restartByte > (long)0) {
                this.restart(restartByte);
            }
            td.start();
            this.write(this.comm, "RETR ".concat(String.valueOf(String.valueOf(remote))));
            if (!this.read(this.comm)) {
                return -1;
            }
            if (this.lastCode != 150) {
                td.interrupt();
                td.closeServerSocket();
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(td);
                transferMonitor.start();
            }
            try {
                td.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            td.closeServerSocket();
            if (!this.read(this.comm)) {
                return -1;
            }
        }
        return 0;
    }

    public int download(TransferMonitor transferMonitor, RemoteFile remoteFile, String local, long restartByte) {
        switch (this.mode) {
            case 0: {
                if (FTP.hasAsciiExtension(remoteFile.name)) {
                    if (this._mode == 2) break;
                    this.ascii();
                    break;
                }
                if (this._mode == 1) break;
                this.binary();
                break;
            }
            case 1: {
                if (this._mode == 1) break;
                this.binary();
                break;
            }
            case 2: {
                if (this._mode == 2) break;
                this.ascii();
            }
        }
        if (this.transfer == 1) {
            this.pasv();
            if (restartByte > (long)0) {
                this.restart(restartByte);
            }
            this.write(this.comm, "RETR ".concat(String.valueOf(String.valueOf(remoteFile.name))));
            ThreadDownloadPasv td = new ThreadDownloadPasv(this.passive_host, this.passive_port, local, restartByte);
            td.setFinalSize(remoteFile.size);
            td.start();
            if (!this.read(this.comm)) {
                return -1;
            }
            if (this.lastCode != 150) {
                td.interrupt();
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(td);
                transferMonitor.start();
            }
            try {
                td.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.read(this.comm)) {
                return -1;
            }
        } else if (this.transfer == 0) {
            String localIp = "";
            try {
                localIp = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
            }
            catch (Exception exception) {
                // empty catch block
            }
            ThreadDownloadPort td = new ThreadDownloadPort(local, restartByte);
            int dataPort = td.getLocalPort();
            int low = dataPort % 256;
            int high = dataPort / 256;
            this.write(this.comm, String.valueOf(String.valueOf(new StringBuffer("PORT ").append(localIp).append(",").append(high).append(",").append(low))));
            if (!this.read(this.comm)) {
                return -1;
            }
            if (restartByte > (long)0) {
                this.restart(restartByte);
            }
            td.setFinalSize(remoteFile.size);
            td.start();
            this.write(this.comm, "RETR ".concat(String.valueOf(String.valueOf(remoteFile.name))));
            if (!this.read(this.comm)) {
                return -1;
            }
            if (this.lastCode != 150) {
                td.interrupt();
                td.closeServerSocket();
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(td);
                transferMonitor.start();
            }
            try {
                td.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            td.closeServerSocket();
            if (!this.read(this.comm)) {
                return -1;
            }
        }
        return 0;
    }

    public int upload(String local, String remote) {
        return this.upload(null, local, remote, 0L);
    }

    public int upload(TransferMonitor transferMonitor, String local, String remote) {
        return this.upload(transferMonitor, local, remote, 0L);
    }

    public int upload(String local, String remote, long restartByte) {
        return this.upload(null, local, remote, restartByte);
    }

    public int upload(TransferMonitor transferMonitor, String local, String remote, long restartByte) {
        switch (this.mode) {
            case 0: {
                if (FTP.hasAsciiExtension(local)) {
                    if (this._mode == 2) break;
                    this.ascii();
                    break;
                }
                if (this._mode == 1) break;
                this.binary();
                break;
            }
            case 1: {
                if (this._mode == 1) break;
                this.binary();
                break;
            }
            case 2: {
                if (this._mode == 2) break;
                this.ascii();
            }
        }
        if (this.transfer == 1) {
            this.pasv();
            if (restartByte > (long)0) {
                this.restart(restartByte);
            }
            this.write(this.comm, "STOR ".concat(String.valueOf(String.valueOf(remote))));
            ThreadUploadPasv tu = new ThreadUploadPasv(this.passive_host, this.passive_port, local, restartByte);
            tu.start();
            if (!this.read(this.comm)) {
                return -1;
            }
            if (this.lastCode != 150) {
                tu.interrupt();
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(tu);
                transferMonitor.start();
            }
            try {
                tu.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.read(this.comm)) {
                return -1;
            }
        } else if (this.transfer == 0) {
            String localIp = "";
            try {
                localIp = InetAddress.getLocalHost().getHostAddress().replace('.', ',');
            }
            catch (Exception exception) {
                // empty catch block
            }
            ThreadUploadPort tu = new ThreadUploadPort(local, restartByte);
            int dataPort = tu.getLocalPort();
            int low = dataPort % 256;
            int high = dataPort / 256;
            this.write(this.comm, String.valueOf(String.valueOf(new StringBuffer("PORT ").append(localIp).append(",").append(high).append(",").append(low))));
            if (!this.read(this.comm)) {
                return -1;
            }
            if (restartByte > (long)0) {
                this.restart(restartByte);
            }
            tu.start();
            this.write(this.comm, "STOR ".concat(String.valueOf(String.valueOf(remote))));
            if (!this.read(this.comm)) {
                return -1;
            }
            if (this.lastCode != 150) {
                tu.interrupt();
                tu.closeServerSocket();
                return -1;
            }
            if (transferMonitor != null) {
                transferMonitor.setTransferThread(tu);
                transferMonitor.start();
            }
            try {
                tu.join();
                if (transferMonitor != null) {
                    transferMonitor.join();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            tu.closeServerSocket();
            if (!this.read(this.comm)) {
                return -1;
            }
        }
        return 0;
    }

    public boolean read(Connection comm) {
        boolean cont = true;
        String ret = "";
        int cptBlankLines = 0;
        while (cont) {
            String line = null;
            try {
                line = comm.read();
            }
            catch (IOException ioe) {
                this.lastReply = String.valueOf(String.valueOf(ioe.toString())).concat(CARRIAGE_RETURN);
                this.lastCode = -1;
                comm.disconnect();
                this.connected = false;
                this.writeLog(this.lastReply);
                boolean bl = false;
                return bl;
            }
            if (line == null) {
                this.lastReply = "Disconnected by server\r\n";
                this.lastCode = -1;
                comm.disconnect();
                this.connected = false;
                this.writeLog(this.lastReply);
                return false;
            }
            ret = String.valueOf(String.valueOf(ret)).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(line)).concat(CARRIAGE_RETURN))));
            if (line.length() < 4) {
                ++cptBlankLines;
                continue;
            }
            if (line.charAt(3) != ' ') continue;
            cont = false;
        }
        this.writeLog(ret);
        this.lastReply = ret;
        int pos = 0;
        for (int i = 0; i < cptBlankLines; ++i) {
            pos = CARRIAGE_RETURN.length() + this.lastReply.indexOf(CARRIAGE_RETURN, pos);
        }
        this.lastCode = Integer.parseInt(this.lastReply.substring(pos, 3 + pos));
        return true;
    }

    public void write(Connection comm, String chaine) {
        String toSend = String.valueOf(String.valueOf(chaine)).concat(CARRIAGE_RETURN);
        comm.write(toSend.getBytes());
        this.lastRequest = toSend;
        if (toSend.indexOf("PASS ") == 0) {
            toSend = "PASS ***\r\n";
        }
        this.writeLog(toSend);
    }

    public static String[] chaineSplit(String chaine, String delims, boolean trimStrings) {
        if (chaine == null) {
            return null;
        }
        if (chaine.length() == 0) {
            return new String[0];
        }
        Vector<String> res = new Vector<String>();
        StringTokenizer stk = new StringTokenizer(chaine, delims, false);
        while (stk.hasMoreTokens()) {
            res.addElement(stk.nextToken());
        }
        String[] res2 = new String[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            res2[i] = (String)res.elementAt(i);
            if (!trimStrings) continue;
            res2[i] = res2[i].trim();
        }
        return res2;
    }

    public static boolean hasAsciiExtension(String name) {
        if (name == null) {
            return false;
        }
        for (int i = 0; i < ASCII_EXT.length; ++i) {
            String extension;
            if (name.length() < ASCII_EXT[i].length() || !ASCII_EXT[i].equalsIgnoreCase(extension = name.substring(name.length() - ASCII_EXT[i].length(), name.length()))) continue;
            return true;
        }
        return false;
    }

    public RemoteFile[] getDirectoryList() {
        return this.directoryList;
    }

    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void finalize() {
        this.closeLogFile();
    }

    static {
        CARRIAGE_RETURN = CARRIAGE_RETURN;
        CODE_CONNECT_OK = 220;
        CODE_DISCONNECT_OK = 221;
        CODE_LOGGEDIN = 230;
        CODE_TRANSFER_OK = 226;
        CODE_CD_OK = 250;
        CODE_PWD_OK = 257;
        CODE_DL_FILE_OK = 150;
        CODE_UL_FILE_OK = 150;
        CODE_DELETE_FILE_OK = 250;
        CODE_MKDIR_OK = 257;
        CODE_RMDIR_OK = 250;
        CODE_RNFR_OK = 350;
        CODE_RNTO_OK = 250;
        ASCII_EXT = new String[]{".TXT", ".XML", ".HTM", ".BAT", ".CSS", ".HTML", ".ASP", ".C", ".H", ".CPP", ".PHP", ".SHTML", ".DHTML"};
        TRANSFER_PORT = 0;
        TRANSFER_PASV = 1;
        MODE_UNDEFINED = -1;
        MODE_AUTO = 0;
        MODE_BINARY = 1;
        MODE_ASCII = 2;
    }
}

