/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import com.cqs.ftp.FTP;
import com.cqs.ftp.RemoteFile;
import com.cqs.ftp.StdoutPercentTransferMonitor;
import com.cqs.ftp.StdoutSizeTransferMonitor;
import com.cqs.ftp.TransferMonitor;
import java.io.File;

public class Main {
    public static void main(String[] args) {
        Main.ftp();
    }

    public static void ftp() {
        String host = "ftp.lip6.fr";
        String login = "anonymous";
        String password = "fcueto@javawork.net";
        FTP ftp = new FTP(host);
        ftp.setLogFile("C:\\TEMP\\ftp.log");
        ftp.connect();
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 220) {
            System.out.println("Connection failed.");
            return;
        }
        ftp.login(login, password);
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 230) {
            System.out.println("incorrect login.");
            ftp.disconnect();
            return;
        }
        ftp.setTransfer(1);
        ftp.setMode(0);
        ftp.cd("binary");
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 250) {
            System.out.println("the directory does not exist.");
            ftp.disconnect();
            return;
        }
        ftp.cd("pdf");
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 250) {
            System.out.println("the directory does not exist.");
            ftp.disconnect();
            return;
        }
        ftp.pwd();
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 257) {
            System.out.println("unknown error.");
            ftp.disconnect();
            return;
        }
        System.out.println("Working directory is : ".concat(String.valueOf(String.valueOf(ftp.getWorkingDirectory()))));
        ftp.list();
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 226) {
            System.out.println("error while listing the directory.");
            ftp.disconnect();
            return;
        }
        RemoteFile[] files = ftp.getDirectoryList();
        System.out.println("Directory listing :");
        for (int i = 0; i < files.length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(files[i].name))).append(" (").append(files[i].size).append(" bytes)"))));
        }
        ftp.download("test.pdf", "C:\\TEMP\\local.pdf");
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 226) {
            System.out.println("error while downloading");
            ftp.disconnect();
            File f = new File("C:\\TEMP\\local.pdf");
            long taille = f.length();
            ftp.connect();
            ftp.relogin();
            ftp.cd("/binary/pdf");
            long rollback = 512L;
            ftp.download("test.pdf", "C:\\TEMP\\local.pdf", taille - rollback);
        }
        ftp.upload("C:\\TEMP\\local.pdf", "remote.pdf");
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 226) {
            System.out.println("error while uploading.");
            ftp.disconnect();
            ftp.connect();
            ftp.relogin();
            ftp.cd("/binary/pdf");
            ftp.size("remote.pdf");
            long taille = ftp.getFileSize();
            System.out.println("Size of the file on the server : ".concat(String.valueOf(String.valueOf(taille))));
            long rollback = 512L;
            ftp.upload("C:\\TEMP\\local.pdf", "remote.pdf", taille - rollback);
        }
        TransferMonitor tm = new StdoutSizeTransferMonitor();
        ftp.list(tm);
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 226) {
            System.out.println("error while listing the directory.");
            ftp.disconnect();
            return;
        }
        files = ftp.getDirectoryList();
        System.out.println("Directory listing :");
        for (int i = 0; i < files.length; ++i) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(files[i].name))).append(" (").append(files[i].size).append(" bytes)"))));
        }
        tm = new StdoutPercentTransferMonitor();
        RemoteFile toDownload = RemoteFile.findRemoteFile(files, "new-this-week");
        if (toDownload != null) {
            ftp.download(tm, toDownload, "C:\\TEMP\\new-this-week", 0L);
            System.out.print(ftp.lastReply());
            if (ftp.lastCode() != 226) {
                System.out.println("error while downloading");
                ftp.disconnect();
                return;
            }
        } else {
            System.out.println("File not found.");
        }
        ftp.disconnect();
        System.out.print(ftp.lastReply());
        if (ftp.lastCode() != 221) {
            System.out.println("disconnection failed.");
            return;
        }
        ftp.closeLogFile();
        System.out.println("OK.");
    }
}

