/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import com.cqs.ftp.BufferedConnection;
import com.cqs.ftp.TransferThread;
import java.io.RandomAccessFile;
import java.net.ServerSocket;

public class ThreadDownloadPort
extends TransferThread {
    private int port = this.port;
    private String fileName;
    private ServerSocket serverSocket = null;
    private long restartByte;

    public ThreadDownloadPort(String fileName, long restartByte) {
        this.fileName = fileName;
        this.restartByte = restartByte;
        this.offsetSize = restartByte;
        try {
            this.serverSocket = new ServerSocket(0);
            this.port = this.serverSocket.getLocalPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performTransfer() {
        boolean cont = true;
        try {
            BufferedConnection data = new BufferedConnection(this.serverSocket.accept());
            RandomAccessFile fos = new RandomAccessFile(this.fileName, "rw");
            fos.setLength(this.restartByte);
            if (this.restartByte > (long)0) {
                fos.seek(this.restartByte);
            }
            while (cont) {
                byte[] tab = data.read();
                if (tab == null) {
                    cont = false;
                    continue;
                }
                this.transferredSize += (long)tab.length;
                fos.write(tab);
            }
            fos.close();
            data.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeServerSocket() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLocalPort() {
        return this.port;
    }

    public int getTransferType() {
        return 0;
    }
}

