/*
 * Decompiled with CFR 0.152.
 */
package com.cqs.ftp;

import com.cqs.ftp.BufferedConnection;
import com.cqs.ftp.TransferThread;
import java.io.RandomAccessFile;
import java.net.ServerSocket;

public class ThreadUploadPort
extends TransferThread {
    public static final int BUFFER_SIZE = 65536;
    private int port = this.port;
    private String fileName;
    private ServerSocket serverSocket = null;
    private long restartByte = 0L;

    public ThreadUploadPort(String fileName, long restartByte) {
        this.fileName = fileName;
        this.restartByte = restartByte;
        this.offsetSize = restartByte;
        try {
            this.serverSocket = new ServerSocket(0);
            this.port = this.serverSocket.getLocalPort();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void performTransfer() {
        boolean cont = true;
        try {
            BufferedConnection data = new BufferedConnection(this.serverSocket.accept());
            RandomAccessFile fis = new RandomAccessFile(this.fileName, "r");
            if (this.restartByte > (long)0) {
                fis.seek(this.restartByte);
            }
            byte[] buffer = new byte[65536];
            while (cont) {
                int lu = fis.read(buffer, 0, 65536);
                if (lu == -1) {
                    cont = false;
                    continue;
                }
                this.transferredSize += (long)lu;
                data.write(buffer, 0, lu);
            }
            fis.close();
            data.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeServerSocket() {
        try {
            this.serverSocket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getLocalPort() {
        return this.port;
    }

    public int getTransferType() {
        return 1;
    }

    static {
        BUFFER_SIZE = 65536;
    }
}

