/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.player;

import com.fluendo.player.StatusListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.util.Enumeration;
import java.util.Vector;

public class Status
extends Component
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private int bufferPercent;
    private boolean buffering;
    private String message;
    private String error;
    private Rectangle r;
    private Component component;
    private Font font = new Font("SansSerif", 0, 10);
    private boolean haveAudio;
    private boolean havePercent;
    private boolean seekable;
    private boolean live;
    private boolean showSpeaker;
    private static final int NONE = 0;
    private static final int BUTTON1 = 1;
    private static final int BUTTON2 = 2;
    private static final int SEEKER = 3;
    private static final int SEEKBAR = 4;
    private int clicked = 0;
    private Color button1Color;
    private Color button2Color;
    private Color seekColor;
    private static final int SPEAKER_WIDTH = 12;
    private static final int SPEAKER_HEIGHT = 10;
    private static final int TIME_WIDTH = 38;
    private static final int SEEK_TIME_GAP = 10;
    private static final int THUMB_WIDTH = 9;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_PAUSED = 1;
    public static final int STATE_PLAYING = 2;
    private int state = 0;
    private double position = 0.0;
    private long time;
    private double duration;
    private long byteDuration;
    private long bytePosition;
    private String speaker = "\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00efU\u0017\u001e\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00efU\u0018\u0000\u0000\u0000\u00ef\u0000\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0013\u00ef\u00ef\u00ef\u0000\u001c\u00ef\u0000Z\u00ef\u0000\u00ef\\\u00ef\u0000)+F\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00efIbz\u0091\u00ef\u0000\u0000\u00ef\u0000\u00efr\u00ef\u00ef\u00ef\u00be\u00d3\u00ef\u0000Z\u00ef\u0000\u00ef\\\u0000\u0000\u0000\u00ef\u00ef\u00ef\u0000\u00ef\u0000\u0000\u00ef\u0000\u0000\u0000\u0000\u0000\u00ef\u00ef\u0000\u0000\u0000\u00ef\\\u0000\u0000\u0000\u0000\u0000\u0000\u00ef\u0000\u0000\u00ef\\\u0000\u0000";
    private Image speakerImg;
    private int speakerWidth;
    private Vector listeners = new Vector();

    public Status(Component component) {
        int[] nArray = new int[120];
        this.component = component;
        for (int i = 0; i < 120; ++i) {
            nArray[i] = 0xFF000000 | this.speaker.charAt(i) << 16 | this.speaker.charAt(i) << 8 | this.speaker.charAt(i);
        }
        this.speakerImg = component.getToolkit().createImage(new MemoryImageSource(12, 10, nArray, 0, 12));
        this.button1Color = Color.black;
        this.button2Color = Color.black;
        this.seekColor = Color.black;
    }

    public void addStatusListener(StatusListener statusListener) {
        this.listeners.addElement(statusListener);
    }

    public void removeStatusListener(StatusListener statusListener) {
        this.listeners.remove(statusListener);
    }

    public void notifyNewState(int n) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((StatusListener)enumeration.nextElement()).newState(n);
        }
    }

    public void notifySeek(double d) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((StatusListener)enumeration.nextElement()).newSeek(d);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void paintBox(Graphics graphics) {
        graphics.setColor(Color.darkGray);
        graphics.drawRect(0, 0, this.r.width - 1, this.r.height - 1);
        graphics.setColor(Color.black);
        graphics.fillRect(1, 1, this.r.width - 2, this.r.height - 2);
    }

    private void paintPercent(Graphics graphics) {
        if (this.havePercent) {
            graphics.setColor(Color.white);
            graphics.drawString("" + this.bufferPercent + "%", this.r.width - 26 - this.speakerWidth, this.r.height - 2);
        }
    }

    private void paintButton1(Graphics graphics) {
        int n = 1;
        int n2 = 1;
        int n3 = this.r.height - 2;
        int n4 = this.r.height - 2;
        graphics.setColor(Color.darkGray);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(this.button1Color);
        graphics.fillRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        if (this.state == 2) {
            graphics.setColor(Color.white);
            if (this.live) {
                graphics.fillRect((int)((double)n3 * 0.4), (int)((double)n3 * 0.4), (int)((double)n3 * 0.5), (int)((double)n3 * 0.5));
            } else {
                graphics.fillRect((int)((double)n3 * 0.4), (int)((double)n4 * 0.4), (int)((double)n3 * 0.2), (int)((double)n4 * 0.5));
                graphics.fillRect((int)((double)n3 * 0.7), (int)((double)n4 * 0.4), (int)((double)n3 * 0.2), (int)((double)n4 * 0.5));
            }
        } else {
            int[] nArray = new int[]{(int)((double)n3 * 0.4), (int)((double)n3 * 0.4), (int)((double)n3 * 0.9)};
            int[] nArray2 = new int[]{(int)((double)n3 * 0.3), (int)((double)n3 * 0.9), (int)((double)n3 * 0.6)};
            graphics.setColor(Color.white);
            graphics.fillPolygon(nArray, nArray2, 3);
        }
    }

    private void paintButton2(Graphics graphics) {
        int n = this.r.height + 1;
        int n2 = 1;
        int n3 = this.r.height - 2;
        int n4 = this.r.height - 2;
        graphics.setColor(Color.darkGray);
        graphics.drawRect(n, n2, n3, n4);
        graphics.setColor(this.button2Color);
        graphics.fillRect(n + 1, n2 + 1, n3 - 1, n4 - 1);
        graphics.setColor(Color.white);
        graphics.fillRect(this.r.height + (int)((double)n3 * 0.4), (int)((double)n3 * 0.4), (int)((double)n3 * 0.5), (int)((double)n3 * 0.5));
    }

    private void paintMessage(Graphics graphics, int n) {
        if (this.message != null) {
            graphics.setColor(Color.white);
            graphics.drawString(this.message, n, this.r.height - 2);
        }
    }

    private void paintBuffering(Graphics graphics, int n) {
        graphics.setColor(Color.white);
        graphics.drawString("Buffering", n, this.r.height - 2);
    }

    private Rectangle getSeekBarRect() {
        return new Rectangle(this.r.height * 2 + 1, 2, this.r.width - 10 - 38 - this.speakerWidth - this.r.height * 2, this.r.height - 4);
    }

    private Rectangle getThumbRect() {
        Rectangle rectangle = this.getSeekBarRect();
        int n = rectangle.width - 9;
        int n2 = (int)((double)n * this.position);
        return new Rectangle(n2 + rectangle.x, 1, 9, this.r.height - 2);
    }

    private void paintSeekBar(Graphics graphics) {
        Rectangle rectangle = this.getSeekBarRect();
        Rectangle rectangle2 = this.getThumbRect();
        graphics.setColor(Color.darkGray);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.gray);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 3, rectangle2.x - (rectangle.x + 2), rectangle.height - 6);
        graphics.setColor(Color.white);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y, rectangle2.x + rectangle2.width - 1, rectangle2.y);
        graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width - 1, rectangle2.y + rectangle2.height);
        graphics.drawLine(rectangle2.x, rectangle2.y + 1, rectangle2.x, rectangle2.y + rectangle2.height - 1);
        graphics.drawLine(rectangle2.x + rectangle2.width, rectangle2.y + 1, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height - 1);
        graphics.setColor(this.seekColor);
        graphics.fillRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 1, rectangle2.height - 1);
    }

    private void paintTime(Graphics graphics) {
        if (this.time < 0L) {
            return;
        }
        long l = this.time % 60L;
        long l2 = this.time / 60L;
        long l3 = l2 / 60L;
        this.r = this.getBounds();
        int n = this.r.width - this.speakerWidth - 38;
        graphics.setColor(Color.white);
        graphics.drawString("" + l3 + ":" + ((l2 %= 60L) < 10L ? "0" + l2 : "" + l2) + ":" + (l < 10L ? "0" + l : "" + l), n, this.r.height - 2);
    }

    private void paintSpeaker(Graphics graphics) {
        if (this.haveAudio) {
            graphics.drawImage(this.speakerImg, this.r.width - 12, this.r.height - 10 - 1, null);
        }
    }

    public void paint(Graphics graphics) {
        int n = 0;
        if (!this.isVisible()) {
            return;
        }
        this.r = this.getBounds();
        Image image = this.component.createImage(this.r.width, this.r.height);
        if (image == null) {
            return;
        }
        Graphics graphics2 = image.getGraphics();
        if (graphics2 == null) {
            return;
        }
        graphics2.setFont(this.font);
        this.paintBox(graphics2);
        if (!this.buffering) {
            this.paintButton1(graphics2);
        }
        if (!this.live) {
            this.paintButton2(graphics2);
            n = this.r.height * 2;
        } else {
            n = this.r.height;
        }
        if (this.buffering) {
            this.paintPercent(graphics2);
            this.paintBuffering(graphics2, n + 3);
        } else if (this.state == 0 || !this.seekable) {
            this.paintMessage(graphics2, n + 3);
            this.paintTime(graphics2);
        } else if (this.seekable) {
            this.paintSeekBar(graphics2);
            this.paintTime(graphics2);
        }
        if (this.showSpeaker) {
            this.paintSpeaker(graphics2);
        }
        graphics.drawImage(image, this.r.x, this.r.y, null);
        image.flush();
    }

    public void setBufferPercent(boolean bl, int n) {
        boolean bl2 = this.buffering != bl;
        if (bl2 |= this.bufferPercent != n) {
            this.buffering = bl;
            this.bufferPercent = n;
            this.component.repaint();
        }
    }

    public void setTime(double d) {
        if (this.clicked == 0) {
            this.time = d < this.duration || this.seekable ? (long)d : (long)this.duration;
            if (this.duration > -1.0) {
                double d2 = (double)this.time / this.duration;
                if (d2 != this.position) {
                    this.position = d2;
                    this.component.repaint();
                }
            } else {
                double d3;
                this.position = d3 = (double)this.bytePosition / (double)this.byteDuration;
                this.component.repaint();
            }
        }
    }

    public void setDuration(double d) {
        this.duration = d;
        this.component.repaint();
    }

    public void setByteDuration(long l) {
        this.byteDuration = l;
        if (this.duration == -1.0) {
            this.position = (double)this.bytePosition / (double)this.byteDuration;
            this.component.repaint();
        }
    }

    public void setBytePosition(long l) {
        this.bytePosition = l;
        if (this.duration == -1.0) {
            this.position = (double)this.bytePosition / (double)this.byteDuration;
            this.component.repaint();
        }
    }

    public void setMessage(String string) {
        this.message = string;
        this.component.repaint();
    }

    public void setHaveAudio(boolean bl) {
        this.haveAudio = bl;
        this.component.repaint();
    }

    public void setHavePercent(boolean bl) {
        this.havePercent = bl;
        this.component.repaint();
    }

    public void setSeekable(boolean bl) {
        this.seekable = bl;
        this.component.repaint();
    }

    public void setLive(boolean bl) {
        this.live = bl;
        this.component.repaint();
    }

    public void setShowSpeaker(boolean bl) {
        this.showSpeaker = bl;
        this.speakerWidth = bl ? 12 : 0;
        this.component.repaint();
    }

    public void setState(int n) {
        if (this.state != n) {
            this.state = n;
            this.component.repaint();
        }
    }

    private boolean intersectButton1(MouseEvent mouseEvent) {
        if (this.r == null) {
            return false;
        }
        return mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.r.height - 2 && mouseEvent.getY() > 0 && mouseEvent.getY() <= this.r.height - 2;
    }

    private boolean intersectButton2(MouseEvent mouseEvent) {
        if (this.r == null) {
            return false;
        }
        return mouseEvent.getX() >= this.r.height && mouseEvent.getX() <= this.r.height + this.r.height - 2 && mouseEvent.getY() > 0 && mouseEvent.getY() <= this.r.height - 2;
    }

    private boolean intersectSeeker(MouseEvent mouseEvent) {
        this.r = this.getBounds();
        Rectangle rectangle = this.getThumbRect();
        return rectangle.contains(mouseEvent.getPoint());
    }

    private boolean intersectSeekbar(MouseEvent mouseEvent) {
        this.r = this.getBounds();
        Rectangle rectangle = this.getSeekBarRect();
        return rectangle.contains(mouseEvent.getPoint());
    }

    private int findComponent(MouseEvent mouseEvent) {
        if (!this.buffering && this.intersectButton1(mouseEvent)) {
            return 1;
        }
        if (this.intersectButton2(mouseEvent)) {
            return 2;
        }
        if (this.seekable && this.intersectSeeker(mouseEvent)) {
            return 3;
        }
        if (this.seekable && this.intersectSeekbar(mouseEvent)) {
            return 4;
        }
        return 0;
    }

    public void cancelMouseOperation() {
        this.button1Color = Color.black;
        this.button2Color = Color.black;
        this.seekColor = Color.black;
        this.clicked = 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(-1, -1);
        this.clicked = this.findComponent(mouseEvent);
        if (this.clicked == 4 && this.state != 0) {
            this.clicked = 3;
            this.seekColor = Color.gray;
            this.mouseDragged(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        mouseEvent.translatePoint(-1, -1);
        int n = this.findComponent(mouseEvent);
        if (this.clicked != n) {
            if (this.clicked == 3) {
                n = this.clicked;
            } else {
                return;
            }
        }
        switch (n) {
            case 1: {
                if (this.state == 2) {
                    this.state = this.live ? 0 : 1;
                    this.notifyNewState(this.state);
                    break;
                }
                this.state = 2;
                this.notifyNewState(this.state);
                break;
            }
            case 2: {
                this.state = 0;
                this.notifyNewState(this.state);
                break;
            }
            case 3: {
                if (this.state == 0) break;
                this.notifySeek(this.position);
                break;
            }
            case 4: {
                break;
            }
        }
        this.clicked = 0;
        this.component.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.seekable) {
            mouseEvent.translatePoint(-1, -1);
            if (this.clicked == 3) {
                Rectangle rectangle = this.getSeekBarRect();
                int n = rectangle.width - 9;
                int n2 = mouseEvent.getX() - rectangle.x - 4;
                double d = (double)n2 / (double)n;
                if (d < 0.0) {
                    d = 0.0;
                } else if (d > 1.0) {
                    d = 1.0;
                }
                if (d != this.position) {
                    this.position = d;
                    this.time = (long)(this.duration * this.position);
                    this.component.repaint();
                }
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        mouseEvent.translatePoint(-1, -1);
        if (!this.buffering) {
            if (this.intersectButton1(mouseEvent)) {
                if (this.button1Color != Color.gray) {
                    this.button1Color = Color.gray;
                    bl = true;
                }
            } else if (this.button1Color != Color.black) {
                this.button1Color = Color.black;
                bl = true;
            }
        }
        if (this.intersectButton2(mouseEvent)) {
            if (this.button2Color != Color.gray) {
                this.button2Color = Color.gray;
                bl = true;
            }
        } else if (this.button2Color != Color.black) {
            this.button2Color = Color.black;
            bl = true;
        }
        if (this.seekable) {
            if (this.intersectSeeker(mouseEvent)) {
                if (this.seekColor != Color.gray) {
                    this.seekColor = Color.gray;
                    bl = true;
                }
            } else if (this.seekColor != Color.black) {
                this.seekColor = Color.black;
                bl = true;
            }
        }
        if (bl) {
            this.component.repaint();
        }
    }
}

