/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.FenetreEdition;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AutreConfig
extends JFrame {
    private FenetreEdition fe;
    private org.w3c.dom.Document doc;
    private Element racine;
    private Element langage;
    private Element autre_config;
    private File fichierXML;
    JTextField nomFichier_t;
    private JPanel listePanelAutreConfig;

    public AutreConfig(FenetreEdition fenetreEdition, org.w3c.dom.Document document, Element element, File file) {
        super(Strings.get("titre.AutreConfig"));
        this.fe = fenetreEdition;
        this.doc = document;
        this.racine = element;
        this.fichierXML = file;
        this.langage = Outils.premierEnfantDeNom(element, "LANGAGE");
        this.autre_config = Outils.premierEnfantDeNom(this.langage, "AUTRE_CONFIG");
        if (this.autre_config == null) {
            this.autre_config = document.createElement("AUTRE_CONFIG");
            this.langage.appendChild(this.autre_config);
        }
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        this.setLayout(new BorderLayout());
        this.listePanelAutreConfig = new JPanel();
        this.listePanelAutreConfig.setLayout(new BoxLayout(this.listePanelAutreConfig, 1));
        JScrollPane jScrollPane = new JScrollPane(this.listePanelAutreConfig);
        jScrollPane.setPreferredSize(new Dimension(800, 400));
        this.add((Component)jScrollPane, "North");
        this.recupererAutreConfig();
        JPanel jPanel = new JPanel(new FlowLayout());
        this.add((Component)jPanel, "South");
        JButton jButton = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(AutreConfig.this.doc);
            }
        });
        JButton jButton2 = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                AutreConfig.this.nettoyerDOM();
                AutreConfig.this.setVisible(false);
                AutreConfig.this.fe.afficher();
            }
        });
        jPanel.add(jButton2);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelAutreConfig(final Element element, final int n) {
        final JPanel jPanel = new JPanel(new FlowLayout(0));
        this.listePanelAutreConfig.add(jPanel);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel.add(jPanel2);
        JLabel jLabel = new JLabel(Strings.get("label.AutreConfig"));
        this.nomFichier_t = new JTextField(15);
        this.nomFichier_t.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AutreConfig.this.parcourir(element);
            }

            public void mousePressed(MouseEvent mouseEvent) {
            }

            public void mouseReleased(MouseEvent mouseEvent) {
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Parcourir")){

            public void actionPerformed(ActionEvent actionEvent) {
                AutreConfig.this.parcourir(element);
            }
        });
        jPanel2.add(jLabel);
        jPanel2.add(this.nomFichier_t);
        jPanel2.add(jButton);
        if (element != null) {
            this.nomFichier_t.setText(element.getAttribute("nom"));
        }
        this.nomFichier_t.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                AutreConfig.this.ecouteurAutreConfig(documentEvent, n);
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                AutreConfig.this.ecouteurAutreConfig(documentEvent, n);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                AutreConfig.this.ecouteurAutreConfig(documentEvent, n);
            }
        });
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel.add(jPanel3);
        JButton jButton2 = new JButton(new AbstractAction("+"){

            public void actionPerformed(ActionEvent actionEvent) {
                Element element = AutreConfig.this.enregistrerAutreConfig(AutreConfig.this.listePanelAutreConfig.getComponentCount(), null);
                AutreConfig.this.creerPanelAutreConfig(element, AutreConfig.this.listePanelAutreConfig.getComponentCount());
                AutreConfig.this.listePanelAutreConfig.revalidate();
            }
        });
        jPanel3.add(jButton2);
        JButton jButton3 = new JButton(new AbstractAction("-"){

            public void actionPerformed(ActionEvent actionEvent) {
                if (AutreConfig.this.listePanelAutreConfig.getComponentCount() > 1) {
                    AutreConfig.this.listePanelAutreConfig.remove(jPanel);
                    AutreConfig.this.listePanelAutreConfig.revalidate();
                    Element element = AutreConfig.this.trouverAutreConfig(n);
                    if (element != null) {
                        element.getParentNode().removeChild(element);
                        EditeurFichierConfig.setModif(true);
                    }
                }
                if (AutreConfig.this.listePanelAutreConfig.getComponentCount() == 1) {
                    AutreConfig.this.nomFichier_t.setText(null);
                }
            }
        });
        jPanel3.add(jButton3);
    }

    private void parcourir(Element element) {
        File file;
        File file2 = null;
        file2 = !"".equals(element.getAttribute("nom")) ? new File(this.fichierXML.getParentFile(), element.getAttribute("nom")) : this.fichierXML;
        JFileChooser jFileChooser = new JFileChooser(file2);
        jFileChooser.setApproveButtonText("OK");
        if (!"".equals(element.getAttribute("nom"))) {
            jFileChooser.setSelectedFile(file2);
        }
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                int n = string.lastIndexOf(46);
                return n > 0 && n < string.length() - 1 && string.substring(n + 1).toLowerCase().equals("xml");
            }

            public String getDescription() {
                return Strings.get("texte.FichiersXML");
            }
        });
        if (jFileChooser.showOpenDialog(null) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            URI uRI = null;
            URI uRI2 = null;
            try {
                uRI = new URI(file.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.out.println(uRISyntaxException);
            }
            try {
                uRI2 = new URI(this.fichierXML.getParentFile().toString());
            }
            catch (URISyntaxException uRISyntaxException) {
                System.out.println(uRISyntaxException);
            }
            try {
                URI uRI3 = uRI2.relativize(uRI);
                this.nomFichier_t.setText(uRI3.toString());
            }
            catch (NullPointerException nullPointerException) {
                System.out.println(nullPointerException);
            }
        }
    }

    private void ecouteurAutreConfig(DocumentEvent documentEvent, int n) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerAutreConfig(n, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private Element enregistrerAutreConfig(int n, String string) {
        Element element = this.trouverAutreConfig(n);
        if (element == null) {
            element = this.doc.createElement("AUTRE_CONFIG");
            this.langage.appendChild(element);
        }
        if (string != null) {
            element.setAttribute("nom", string);
        }
        return element;
    }

    private Element trouverAutreConfig(int n) {
        if (n == -1) {
            return null;
        }
        if (this.langage == null) {
            return null;
        }
        int n2 = 0;
        for (Node node = this.langage.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"AUTRE_CONFIG".equals(node.getNodeName())) continue;
            if (n2 == n) {
                return (Element)node;
            }
            ++n2;
        }
        return null;
    }

    private void recupererAutreConfig() {
        this.listePanelAutreConfig.removeAll();
        Element element = null;
        if (this.langage != null) {
            element = Outils.premierEnfantDeNom(this.langage, "AUTRE_CONFIG");
            if (element == null) {
                element = this.enregistrerAutreConfig(0, null);
            }
            this.creerPanelAutreConfig(element, 0);
            int n = this.langage.getChildNodes().getLength();
            for (int i = 1; i < n; ++i) {
                if ((element = Outils.enfantSuivantDeMemeNom(element)) == null) continue;
                this.creerPanelAutreConfig(element, i);
            }
        }
    }

    private void nettoyerDOM() {
        for (Node node = this.langage.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !"AUTRE_CONFIG".equals(node.getNodeName()) || ((Element)node).hasAttribute("nom") && !"".equals(((Element)node).getAttribute("nom"))) continue;
            this.langage.removeChild(node);
        }
    }
}

