/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.DefinirLaLangue;
import editeurconfig.EditeurFichierConfig;
import editeurconfig.ParcourirSchema;
import editeurconfig.Strings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ChoixDuSchema
extends JDialog {
    private String schemaSelectionne = "";
    private EditeurFichierConfig appl;
    private Document doc;
    private Element racine;
    private JList listeSchemas;
    private JButton bOK;

    public ChoixDuSchema(EditeurFichierConfig editeurFichierConfig, Document document, Element element) {
        super((Frame)new JFrame(), Strings.get("titre.ChoixDuSchema"));
        this.appl = editeurFichierConfig;
        this.doc = document;
        this.racine = element;
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        JLabel jLabel = new JLabel(Strings.get("label.choixSchema"));
        this.add((Component)jLabel, "North");
        JPanel jPanel = new JPanel();
        this.choisir();
        this.add((Component)new JScrollPane(this.listeSchemas), "Center");
        this.listeSchemas.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (ChoixDuSchema.this.listeSchemas.getSelectedValue() != null) {
                    ChoixDuSchema.this.schemaSelectionne = ChoixDuSchema.this.listeSchemas.getSelectedValue().toString();
                    ChoixDuSchema.this.bOK.setEnabled(true);
                }
            }
        });
        this.listeSchemas.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ChoixDuSchema.this.setVisible(false);
                    if (ChoixDuSchema.this.schemaSelectionne == Strings.get("texte.XMLSchema")) {
                        new ParcourirSchema(ChoixDuSchema.this.appl, ChoixDuSchema.this.doc, ChoixDuSchema.this.racine, "xsd");
                    }
                    if (ChoixDuSchema.this.schemaSelectionne == Strings.get("texte.RelaxNG")) {
                        new ParcourirSchema(ChoixDuSchema.this.appl, ChoixDuSchema.this.doc, ChoixDuSchema.this.racine, "rng");
                    }
                    if (ChoixDuSchema.this.schemaSelectionne == Strings.get("texte.SchemaXMLSimplifie")) {
                        ChoixDuSchema.this.setVisible(true);
                        JOptionPane.showMessageDialog(ChoixDuSchema.this, Strings.get("message.SchemaPasPrisEnCharge"));
                    }
                }
            }
        });
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Annuler")){

            public void actionPerformed(ActionEvent actionEvent) {
                ChoixDuSchema.this.setVisible(false);
                new DefinirLaLangue(ChoixDuSchema.this.appl, ChoixDuSchema.this.doc, ChoixDuSchema.this.racine);
            }
        });
        jPanel.add(jButton);
        this.bOK = new JButton(new AbstractAction(Strings.get("bouton.OK")){

            public void actionPerformed(ActionEvent actionEvent) {
                ChoixDuSchema.this.setVisible(false);
                if (ChoixDuSchema.this.schemaSelectionne == Strings.get("texte.XMLSchema")) {
                    new ParcourirSchema(ChoixDuSchema.this.appl, ChoixDuSchema.this.doc, ChoixDuSchema.this.racine, "xsd");
                }
                if (ChoixDuSchema.this.schemaSelectionne == Strings.get("texte.RelaxNG")) {
                    new ParcourirSchema(ChoixDuSchema.this.appl, ChoixDuSchema.this.doc, ChoixDuSchema.this.racine, "rng");
                }
                if (ChoixDuSchema.this.schemaSelectionne == Strings.get("texte.SchemaXMLSimplifie")) {
                    ChoixDuSchema.this.setVisible(true);
                    JOptionPane.showMessageDialog(ChoixDuSchema.this, Strings.get("message.SchemaPasPrisEnCharge"));
                }
            }
        });
        jPanel.add(this.bOK);
        this.bOK.setEnabled(false);
        this.add((Component)jPanel, "South");
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void choisir() {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        this.listeSchemas = new JList(defaultListModel);
        this.listeSchemas.setSelectionMode(0);
        defaultListModel.addElement(Strings.get("texte.XMLSchema"));
        defaultListModel.addElement(Strings.get("texte.RelaxNG"));
        defaultListModel.addElement(Strings.get("texte.SchemaXMLSimplifie"));
    }
}

