/*
 * Decompiled with CFR 0.152.
 */
package editeurconfig;

import editeurconfig.EditeurFichierConfig;
import editeurconfig.Outils;
import editeurconfig.Strings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextesMenu
extends JFrame {
    private org.w3c.dom.Document doc;
    private Element racine;
    private JPanel panelAffichage;
    private Node monNoeud;
    private String menuSelectionne;
    private ArrayList<Node> listeNodeParents = new ArrayList();
    private JTextField titre_t;
    private JTextArea documentation_t;

    public TextesMenu(org.w3c.dom.Document document, Node node) {
        super(Strings.get("titre.TextePourUnMenu"));
        this.doc = document;
        this.monNoeud = node;
        this.menuSelectionne = ((Element)node).getAttribute("nom");
        this.setDefaultCloseOperation(0);
        this.afficher();
    }

    private void afficher() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(Strings.get("label.TextePourLeMenu") + " " + this.menuSelectionne), "North");
        this.panelAffichage = new JPanel();
        this.panelAffichage.setLayout(new BoxLayout(this.panelAffichage, 1));
        JScrollPane jScrollPane = new JScrollPane(this.panelAffichage);
        jScrollPane.setPreferredSize(new Dimension(400, 700));
        jPanel.add((Component)jScrollPane, "Center");
        this.creerPanelLangues();
        JPanel jPanel2 = new JPanel(new FlowLayout());
        JButton jButton = new JButton(new AbstractAction(Strings.get("bouton.Fermer")){

            public void actionPerformed(ActionEvent actionEvent) {
                TextesMenu.this.nettoyerDOM();
                TextesMenu.this.setVisible(false);
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(new AbstractAction("Tester"){

            public void actionPerformed(ActionEvent actionEvent) {
                EditeurFichierConfig.convertToString(TextesMenu.this.doc);
            }
        });
        jPanel.add((Component)jPanel2, "South");
        this.add(jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.setVisible(true);
    }

    private void creerPanelLangues() {
        this.racine = this.doc.getDocumentElement();
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS");
        int n = nodeList.getLength();
        JPanel[] jPanelArray = new JPanel[n];
        for (int i = 0; i < n; ++i) {
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            Node node = this.monNoeud;
            while (!"MENUS".equals(node.getNodeName())) {
                this.listeNodeParents.add(node);
                node = node.getParentNode();
            }
            final Element element2 = this.remplirStringMenu(element);
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setLayout(new BoxLayout(jPanelArray[i], 1));
            this.panelAffichage.add(jPanelArray[i]);
            jPanelArray[i].setBorder(new TitledBorder(element.getAttribute("langue").toUpperCase()));
            JPanel jPanel = new JPanel(new FlowLayout(0));
            jPanelArray[i].add(jPanel);
            JLabel jLabel = new JLabel(Strings.get("label.Titre") + ": ");
            this.titre_t = new JTextField(25);
            Element element3 = null;
            if (this.doc != null) {
                element3 = Outils.premierEnfantDeNom(element2, "TITRE");
            }
            if (element3 != null) {
                this.titre_t.setText(Outils.getValeurElement(element3));
            }
            this.titre_t.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    TextesMenu.this.ecouteurTitre(documentEvent, element2);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    TextesMenu.this.ecouteurTitre(documentEvent, element2);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    TextesMenu.this.ecouteurTitre(documentEvent, element2);
                }
            });
            jPanel.add(jLabel);
            jPanel.add(this.titre_t);
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
            jPanelArray[i].add(jPanel2);
            JLabel jLabel2 = new JLabel(Strings.get("label.Documentation") + ": ");
            this.documentation_t = new JTextArea(4, 12);
            this.documentation_t.setLineWrap(true);
            this.documentation_t.setWrapStyleWord(true);
            JScrollPane jScrollPane = new JScrollPane(this.documentation_t);
            Element element4 = null;
            if (this.doc != null) {
                element4 = Outils.premierEnfantDeNom(element2, "DOCUMENTATION");
            }
            if (element4 != null) {
                this.documentation_t.setText(Outils.getValeurElement(element4));
            }
            this.documentation_t.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent documentEvent) {
                    TextesMenu.this.ecouteurDocumentation(documentEvent, element2);
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    TextesMenu.this.ecouteurDocumentation(documentEvent, element2);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    TextesMenu.this.ecouteurDocumentation(documentEvent, element2);
                }
            });
            jPanel2.add(jLabel2);
            jPanel2.add(jScrollPane);
        }
    }

    private void ecouteurTitre(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerTitre(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            System.out.println(badLocationException);
        }
    }

    private void ecouteurDocumentation(DocumentEvent documentEvent, Element element) {
        Document document = documentEvent.getDocument();
        try {
            String string = document.getText(0, document.getLength());
            this.enregistrerDocumentation(element, string);
            EditeurFichierConfig.setModif(true);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private Element remplirStringMenu(Element element) {
        Element element2 = element;
        for (int i = this.listeNodeParents.size() - 1; i >= 0; --i) {
            Element element3 = (Element)this.listeNodeParents.get(i);
            element2 = this.enregistrerStringsMenu(element2, element3.getAttribute("nom"));
        }
        return element2;
    }

    private Element enregistrerStringsMenu(Element element, String string) {
        Element element2 = Outils.getElementSelectionne(element, "STRINGS_MENU", string, "menu");
        if (element2 == null) {
            element2 = this.doc.createElement("STRINGS_MENU");
            element.appendChild(element2);
            element2.setAttribute("menu", string);
            EditeurFichierConfig.setModif(true);
        }
        return element2;
    }

    private void enregistrerTitre(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "TITRE");
        if (element2 == null) {
            element2 = this.doc.createElement("TITRE");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private void enregistrerDocumentation(Element element, String string) {
        Element element2 = Outils.premierEnfantDeNom(element, "DOCUMENTATION");
        if (element2 == null) {
            element2 = this.doc.createElement("DOCUMENTATION");
            element.appendChild(element2);
        }
        Outils.setValeurElement(this.doc, element2, string);
    }

    private void nettoyerDOM() {
        this.nettoyer_STRINGS_MENU();
    }

    private void nettoyer_STRINGS_MENU() {
        NodeList nodeList = this.racine.getElementsByTagName("STRINGS_MENU");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node;
            if (!(nodeList.item(i) instanceof Element)) continue;
            Element element = (Element)nodeList.item(i);
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"TITRE".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!"DOCUMENTATION".equals(node.getNodeName()) || node.hasChildNodes() && !"".equals(Outils.getValeurElement((Element)node))) continue;
                element.removeChild(node);
            }
        }
    }
}

