/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class ImageKeeper {
    protected Map<String, Image> _images = new HashMap<String, Image>();
    private static final BufferedImage DUMMY_IMAGE = new BufferedImage(1, 1, 2);
    private static final Logger LOG = Logger.getLogger(ImageKeeper.class);
    private static ImageKeeper _instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ImageKeeper getInstance() {
        if (_instance != null) return _instance;
        Class<ImageKeeper> clazz = ImageKeeper.class;
        synchronized (ImageKeeper.class) {
            if (_instance != null) return _instance;
            _instance = new ImageKeeper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public static Image loadImage(String string) {
        return ImageKeeper.getInstance().load(string, false);
    }

    public static Image loadImage(String string, boolean bl) {
        return ImageKeeper.getInstance().load(string, bl);
    }

    public static Image loadImage(Class clazz, String string) {
        return ImageKeeper.getInstance().load(clazz, string, false);
    }

    public static Image loadImage(Class clazz, String string, boolean bl) {
        return ImageKeeper.getInstance().load(clazz, string, bl);
    }

    public static void removeImage(String string) {
        ImageKeeper.getInstance().remove(string);
    }

    public static void flushImages() {
        for (Image image : ImageKeeper.getInstance()._images.values()) {
            if (image == null) continue;
            image.flush();
        }
    }

    private ImageKeeper() {
    }

    protected Image load(String string, boolean bl) {
        return this.load(this.getClass(), string, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Image load(Class clazz, String string, boolean bl) {
        if (string == null) {
            return null;
        }
        Image image = null;
        if (this._images.containsKey(string)) {
            return this._images.get(string);
        }
        Class<ImageKeeper> clazz2 = ImageKeeper.class;
        synchronized (ImageKeeper.class) {
            block11: {
                try {
                    boolean bl2;
                    File file = new File(string);
                    try {
                        bl2 = file.exists();
                    }
                    catch (AccessControlException accessControlException) {
                        bl2 = false;
                    }
                    URL uRL = bl2 ? file.toURI().toURL() : clazz.getResource(string);
                    if (uRL == null) {
                        uRL = clazz.getClassLoader().getResource(string);
                    }
                    if (uRL != null) {
                        BufferedImage bufferedImage = ImageIO.read(uRL);
                        image = bufferedImage;
                        this._images.put(string, bufferedImage);
                        break block11;
                    }
                    if (!bl) return image;
                    LOG.error("Image not found: " + string);
                    return DUMMY_IMAGE;
                }
                catch (IOException iOException) {
                    LOG.error("Error loading image: " + string, iOException);
                    if (!bl) return image;
                    return DUMMY_IMAGE;
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return image;
        }
    }

    protected void remove(String string) {
        this._images.remove(string);
    }
}

