/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.ParagraphView;
import javax.swing.text.TableView;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;
import org.apache.log4j.Logger;

public class JaxeTableView
extends TableView
implements ViewFactory {
    private static final Logger LOG = Logger.getLogger(JaxeTableView.class);
    String TRtag = "tr";
    String TDtag = "td";
    String THtag = "th";
    String CaptionTag = "caption";

    public JaxeTableView(Element element) {
        super(element);
        this.setInsets((short)2, (short)2, (short)2, (short)2);
    }

    public void paint(Graphics graphics, Shape shape) {
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            View view = this.getView(i);
            view.paint(graphics, this.getChildAllocation(i, shape));
        }
        Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
        graphics.setColor(Color.gray);
        graphics.draw3DRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, true);
        graphics.setColor(Color.black);
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        int n3 = this.getViewCount();
        View view = null;
        Rectangle rectangle2 = new Rectangle();
        for (int i = 0; i < n3; ++i) {
            rectangle2.setBounds(rectangle);
            this.childAllocation(i, rectangle2);
            view = this.getView(i);
            if (!(view instanceof JaxeTableRow) || (view = ((JaxeTableRow)view).findViewAtPoint(n, n2, rectangle2)) == null) continue;
            rectangle.setBounds(rectangle2);
            return view;
        }
        return super.getViewAtPoint(n, n2, rectangle);
    }

    public View create(Element element) {
        ViewFactory viewFactory;
        View view;
        String string = element.getName();
        if (string != null) {
            if (string.equals(this.TRtag)) {
                return new JaxeTableRow(element);
            }
            if (string.equals(this.TDtag) || string.equals(this.THtag)) {
                return new JaxeTableCell(element);
            }
            if (string.equals(this.CaptionTag)) {
                return new ParagraphView(element);
            }
        }
        if ((view = this.getParent()) != null && (viewFactory = view.getViewFactory()) != null) {
            return viewFactory.create(element);
        }
        return null;
    }

    private int getColsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
        if (string != null) {
            try {
                return Math.max(Integer.parseInt(string), 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    private int getRowsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
        if (string != null) {
            try {
                return Math.max(Integer.parseInt(string), 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    float calculateAllCells() {
        int n;
        JaxeTableCell jaxeTableCell;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5 = this.getViewCount();
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            object = this.getView(i);
            if (!(object instanceof JaxeTableRow)) continue;
            JaxeTableRow jaxeTableRow = (JaxeTableRow)object;
            int n8 = 0;
            int n9 = jaxeTableRow.getViewCount();
            for (n4 = 0; n4 < n9; ++n4) {
                n8 += this.getColsOccupied(jaxeTableRow.getView(n4));
            }
            n6 = Math.max(n8, n6);
        }
        n7 = n5;
        float[][] fArray = new float[n7][n6];
        object = new float[n7];
        for (n3 = 0; n3 < n7; ++n3) {
            View view = this.getView(n3);
            object[n3] = 0.0f;
            if (!(view instanceof JaxeTableRow)) continue;
            JaxeTableRow jaxeTableRow = (JaxeTableRow)view;
            n2 = jaxeTableRow.getViewCount();
            for (n4 = 0; n4 < n2; ++n4) {
                jaxeTableCell = (JaxeTableCell)jaxeTableRow.getView(n4);
                n = this.getRowsOccupied(jaxeTableCell);
                if (n == 1) {
                    fArray[n3][n4] = jaxeTableCell.getRealSpan(1);
                    object[n3] = Math.max((float)object[n3], fArray[n3][n4]);
                    continue;
                }
                fArray[n3][n4] = -1.0f;
            }
        }
        for (n3 = 0; n3 < n7; ++n3) {
            float f = 0.0f;
            for (int i = 0; i < n6; ++i) {
                f = Math.max(f, fArray[n3][i]);
            }
            JaxeTableRow jaxeTableRow = (JaxeTableRow)this.getView(n3);
            jaxeTableRow.setPreferredSize((int)f);
            n2 = jaxeTableRow.getViewCount();
            for (n4 = 0; n4 < n2; ++n4) {
                jaxeTableCell = (JaxeTableCell)jaxeTableRow.getView(n4);
                n = this.getRowsOccupied(jaxeTableCell);
                if (n != 1) continue;
                jaxeTableCell.setPreferredHeight(f);
            }
        }
        n3 = 0;
        do {
            n3 = 0;
            for (int i = 0; i < n7 && n3 == 0; ++i) {
                View view = this.getView(i);
                if (!(view instanceof JaxeTableRow) || n3 != 0) continue;
                JaxeTableRow jaxeTableRow = (JaxeTableRow)view;
                int n10 = jaxeTableRow.getViewCount();
                for (n2 = 0; n2 < n10 && n3 == 0; ++n2) {
                    JaxeTableCell jaxeTableCell2 = (JaxeTableCell)jaxeTableRow.getView(n2);
                    int n11 = this.getRowsOccupied(jaxeTableCell2);
                    if (n11 <= 1 || n3 != 0) continue;
                    float f = 0.0f;
                    for (int j = 0; j < n11; ++j) {
                        if (i + j >= ((Object)object).length) continue;
                        f += object[i + j];
                    }
                    if (f > jaxeTableCell2.getRealSpan(1)) {
                        jaxeTableCell2.setPreferredHeight(f);
                        continue;
                    }
                    if (!(f < jaxeTableCell2.getRealSpan(1))) continue;
                    jaxeTableCell2.setPreferredHeight(jaxeTableCell2.getRealSpan(1));
                    float f2 = (jaxeTableCell2.getRealSpan(1) - f) / (float)n11;
                    for (int j = 0; j < n11; ++j) {
                        if (i + j >= ((Object)object).length) continue;
                        JaxeTableRow jaxeTableRow2 = (JaxeTableRow)this.getView(i + j);
                        jaxeTableRow2.setPreferredSize((int)(jaxeTableRow2.getPreferredSpan(1) + f2));
                        object[i + j] = object[i + j] + f2;
                    }
                    n3 = 1;
                }
            }
        } while (n3 != 0);
        float f = 0.0f;
        for (int i = 0; i < n7; ++i) {
            JaxeTableRow jaxeTableRow = (JaxeTableRow)this.getView(i);
            for (n2 = 0; n2 < jaxeTableRow.getViewCount(); ++n2) {
                JaxeTableCell jaxeTableCell3 = (JaxeTableCell)jaxeTableRow.getView(n2);
                if (this.getRowsOccupied(jaxeTableCell3) != 1) continue;
                jaxeTableCell3.setPreferredHeight((int)object[i]);
            }
            f += object[i];
        }
        return f;
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        if (n == 1) {
            super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements = new SizeRequirements();
            sizeRequirements.maximum = sizeRequirements.minimum = (int)this.calculateAllCells();
            sizeRequirements.preferred = sizeRequirements.minimum;
        } else {
            sizeRequirements = super.calculateMajorAxisRequirements(n, sizeRequirements);
            sizeRequirements.maximum = sizeRequirements.preferred;
        }
        return sizeRequirements;
    }

    public void setParent(View view) {
        if (view != null) {
            super.setParent(view);
        }
    }

    class JaxeTableCell
    extends BoxView {
        float _height;

        public JaxeTableCell(Element element) {
            super(element, 1);
            this._height = -1.0f;
            this.setInsets((short)3, (short)3, (short)3, (short)3);
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
            if (sizeRequirements2.maximum == Integer.MAX_VALUE) {
                sizeRequirements2.maximum = Short.MAX_VALUE;
            }
            return sizeRequirements2;
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            rectangle.height = (int)this.getPreferredHeight();
            Rectangle rectangle2 = new Rectangle();
            int n = this.getViewCount();
            int n2 = rectangle.x + this.getLeftInset();
            int n3 = rectangle.y + this.getTopInset();
            for (int i = 0; i < n; ++i) {
                rectangle2.x = n2 + this.getOffset(0, i);
                rectangle2.y = n3 + this.getOffset(1, i);
                rectangle2.width = this.getSpan(0, i);
                rectangle2.height = (int)this.getPreferredHeight();
                this.paintChild(graphics, rectangle2, i);
            }
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }

        public void setPreferredHeight(float f) {
            this._height = f;
        }

        public float getPreferredHeight() {
            return this._height;
        }

        public float getMinimumSpan(int n) {
            if (n == 1) {
                return this._height;
            }
            return super.getMinimumSpan(n);
        }

        public float getPreferredSpan(int n) {
            if (n == 1) {
                return this._height;
            }
            return super.getPreferredSpan(n);
        }

        public float getMaximumSpan(int n) {
            if (n == 1) {
                return this._height;
            }
            return super.getMaximumSpan(n);
        }

        public float getRealSpan(int n) {
            return super.getPreferredSpan(n);
        }
    }

    class JaxeTableRow
    extends TableView.TableRow {
        int pref;

        public JaxeTableRow(Element element) {
            super(JaxeTableView.this, element);
            this.pref = 0;
        }

        View findViewAtPoint(int n, int n2, Rectangle rectangle) {
            int n3 = this.getViewCount();
            for (int i = 0; i < n3; ++i) {
                Rectangle rectangle2 = this.getChildAllocation(i, rectangle).getBounds();
                JaxeTableCell jaxeTableCell = (JaxeTableCell)this.getView(i);
                rectangle2.height = (int)jaxeTableCell.getPreferredHeight();
                if (!rectangle2.contains(n, n2)) continue;
                this.childAllocation(i, rectangle);
                return this.getView(i);
            }
            return null;
        }

        protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
            JaxeTableView.this.calculateAllCells();
            int n3 = 0;
            int n4 = this.getViewCount();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                View view = this.getView(n6);
                nArray2[n6] = (int)view.getPreferredSpan(1);
                if (nArray2[n6] > n5) {
                    n5 = nArray2[n6];
                }
                ++n6;
                ++n3;
            }
            super.layoutMinorAxis(n, n2, nArray, nArray2);
        }

        public void paint(Graphics graphics, Shape shape) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            Rectangle rectangle2 = new Rectangle();
            int n = this.getViewCount();
            int n2 = rectangle.x + this.getLeftInset();
            int n3 = rectangle.y + this.getTopInset();
            for (int i = 0; i < n; ++i) {
                rectangle2.x = n2 + this.getOffset(0, i);
                rectangle2.y = n3 + this.getOffset(1, i);
                rectangle2.width = this.getSpan(0, i);
                rectangle2.height = this.getSpan(1, i);
                this.paintChild(graphics, rectangle2, i);
            }
        }

        public float getPreferredSpan(int n) {
            float f = super.getPreferredSpan(n);
            if (n == 1) {
                return this.pref;
            }
            return f;
        }

        public float getMinimumSpan(int n) {
            float f = super.getMinimumSpan(n);
            if (n == 1) {
                return this.pref;
            }
            return f;
        }

        public float getMaximumSpan(int n) {
            float f = super.getMaximumSpan(n);
            if (n == 1) {
                return this.pref;
            }
            return f;
        }

        public void setPreferredSize(int n) {
            this.pref = n;
        }

        protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
            if (n == 1) {
                super.calculateMinorAxisRequirements(n, sizeRequirements);
                sizeRequirements = new SizeRequirements();
                sizeRequirements.alignment = 0.0f;
                sizeRequirements.preferred = this.pref;
                sizeRequirements.minimum = this.pref;
                sizeRequirements.maximum = this.pref;
            } else {
                sizeRequirements = super.calculateMinorAxisRequirements(n, sizeRequirements);
            }
            return sizeRequirements;
        }
    }
}

