/*
 * Decompiled with CFR 0.152.
 */
package jaxe.wxs;

import jaxe.wxs.WXSAnnotated;
import jaxe.wxs.WXSSimpleType;
import org.w3c.dom.Element;

public class WXSFacet
extends WXSAnnotated {
    protected String facet;
    protected String value = null;
    protected boolean fixed = false;
    protected int iparam = 0;

    public WXSFacet(Element element) {
        this.parseAnnotation(element);
        this.facet = element.getLocalName();
        if (element.getAttributeNode("value") != null) {
            this.value = element.getAttribute("value");
            try {
                this.iparam = Integer.parseInt(this.value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if ("pattern".equals(this.facet)) {
                this.value = this.value.replace("\\i", "[^<>&#!/?'\",0-9.\\-\\s]");
                this.value = this.value.replace("\\I", "[^a-zA-Z]");
                this.value = this.value.replace("\\c", "[^<>&#!/?'\",\\s]");
                this.value = this.value.replace("\\C", "\\W");
            }
        }
        if (element.getAttributeNode("fixed") != null) {
            this.fixed = "true".equals(element.getAttribute("fixed")) || "1".equals(element.getAttribute("fixed"));
        }
    }

    public String getFacet() {
        return this.facet;
    }

    public String getValue() {
        return this.value;
    }

    public boolean validerValeur(String string) {
        if ("minExclusive".equals(this.facet)) {
            try {
                double d = Double.parseDouble(string);
                return d > (double)this.iparam;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if ("minInclusive".equals(this.facet)) {
            try {
                double d = Double.parseDouble(string);
                return d >= (double)this.iparam;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if ("maxExclusive".equals(this.facet)) {
            try {
                double d = Double.parseDouble(string);
                return d < (double)this.iparam;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if ("maxInclusive".equals(this.facet)) {
            try {
                double d = Double.parseDouble(string);
                return d <= (double)this.iparam;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        if ("totalDigits".equals(this.facet)) {
            int n = 0;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) < '0' || string.charAt(i) > '9') continue;
                ++n;
            }
            return n <= this.iparam;
        }
        if ("fractionDigits".equals(this.facet)) {
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (!bl) {
                    if (string.charAt(i) != '.') continue;
                    bl = true;
                    continue;
                }
                if (string.charAt(i) < '0' || string.charAt(i) > '9') continue;
                ++n;
            }
            return n <= this.iparam;
        }
        if ("length".equals(this.facet)) {
            return string.length() == this.iparam;
        }
        if ("minLength".equals(this.facet)) {
            return string.length() >= this.iparam;
        }
        if ("maxLength".equals(this.facet)) {
            return string.length() <= this.iparam;
        }
        if ("enumeration".equals(this.facet)) {
            return this.value != null && this.value.equals(string);
        }
        if ("whiteSpace".equals(this.facet)) {
            return true;
        }
        if ("pattern".equals(this.facet)) {
            return WXSSimpleType.verifExpr(string, this.value);
        }
        return true;
    }
}

