/*
Jaxe - Editeur XML en Java

Copyright (C) 2005 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package pluginsjaxe;

import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;

import org.w3c.dom.*;

import jaxe.JaxeDocument;
import jaxe.Fonction;


/**
 * Fonction affichant un dialogue avec des statistiques sur le document.
 * Les attributs sont ignors.
 * compilation:
 * javac -encoding ISO-8859-1 -classpath .:Jaxe.jar pluginsjaxe/FonctionStatistiques.java
 */
public class FonctionStatistiques implements Fonction {

    int nbmots, nbcar;

    public boolean appliquer(JaxeDocument doc, int start, int end) {
        nbmots = 0;
        nbcar = 0;
        String infosel;
        try {
            if (start == end) {
                infosel = "Ensemble du document";
                calculer(doc.getText(0, doc.getLength()));
            } else {
                infosel = "Slection";
                calculer(doc.getText(start, end - start));
            }
            
            JOptionPane.showMessageDialog(doc.jframe,
                infosel + " :\n" +
                " nombre de mots : " + nbmots + "\n" +
                " nombre de caractres (espaces compris) : " + nbcar,
                "Statistiques", JOptionPane.INFORMATION_MESSAGE);
            return(true);
        } catch (BadLocationException ex) {
            // une exception peut tre lance par doc.getText
            ex.printStackTrace();
            return(false);
        }
    }
    
    private void calculer(String s) {
        char c;
        int ind1 = -1; // index dernier espace
        for (int i=0; i<s.length(); i++) {
            c = s.charAt(i);
            if (" \n'\",;:.!?()*".indexOf(c) != -1) {
                if (i - ind1 > 1)
                    nbmots++;
                ind1 = i;
            }
            if (c != '*') // le caractre * correspond  une balise, on ne le compte pas
                nbcar++;
        }
        if (s.length() - ind1 > 1)
            nbmots++;
    }
}
