/*
    Exemple de cration d'un nouvel lment Jaxe: lment boolen affich avec une bote  cocher
    compilation: javac -classpath .:Jaxe.jar -encoding ISO-8859-1 JEBooleen.java
*/

import jaxe.JaxeDocument;
import jaxe.JaxeElement;

import java.awt.event.*;
import javax.swing.JCheckBox;
import javax.swing.text.Position;

import org.w3c.dom.*;

/**
 * Elment boolen.
 * Valeurs possibles: "true" | "false" | "1" | "0"
 */
public class JEBooleen extends JaxeElement implements ItemListener {

    protected static final boolean defaut = false;
    
    protected JCheckBox coche;

    // initialisation de l'affichage pour un lment DOM
    public void init(Position pos, Node noeud) {
        Element el = (Element)noeud;
        
        // lecture de la valeur de l'lment
        String titre = el.getTagName();
        Node child = noeud.getFirstChild();
        String texte = null;
        if (child != null)
            texte = child.getNodeValue();
        
        // cration du composant Swing
        coche = new JCheckBox(titre, stringVersBooleen(texte));
        coche.addItemListener(this);
        
        // insertion du composant dans le texte (insertComponent est une mthode de JaxeElement)
        insertComponent(pos, coche);
    }
    
    protected static boolean stringVersBooleen(String s) {
        if (s != null)
            s = s.trim();
        if ("true".equals(s) || "1".equals(s))
            return(true);
        else if ("false".equals(s) || "0".equals(s))
            return(false);
        else
            return(defaut);
    }
    
    protected static String booleenVersString(boolean b) {
        if (b)
            return("true");
        else
            return("false");
    }
    
    // cration d'un nouvel lment DOM
    public Node nouvelElement(Element refElement) {
        Element newel = nouvelElementDOM(doc, refElement);
        Node textnode = doc.DOMdoc.createTextNode(booleenVersString(defaut));
        newel.appendChild(textnode);
        return(newel);
    }
    
    // mise  jour de l'affichage des attributs en fonction du DOM: rien  faire pour JEBooleen
    //public void majAffichage() { }
    
    public void itemStateChanged(ItemEvent e) {
        setValeur(coche.isSelected());
    }
    
    public void setValeur(boolean valeur) {
        Element el = (Element)noeud;
        Node child = noeud.getFirstChild();
        if (child != null)
            child.setNodeValue(booleenVersString(valeur));
        else {
            Node textnode = doc.DOMdoc.createTextNode(booleenVersString(valeur));
            el.appendChild(textnode);
        }
    }
}
