/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.wfxml;

import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.components.wfxml.DefInfo;
import org.enhydra.jawe.components.wfxml.DefInfoEditor;
import org.enhydra.jawe.components.wfxml.WfXML;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;

public class WfXMLTablePanel
extends XMLBasicPanel
implements XMLElementChangeListener {
    protected JTable allItems;
    protected Vector columnNames;
    protected DefInfo dummy;
    protected WfXML wfxml;

    public WfXMLTablePanel(WfXML wfXML) {
        super(null, (XMLElement)wfXML.getDefInfos(), wfXML.getSettings().getLanguageDependentString("ProcessDefinitionListKey"), true, true, false);
        this.wfxml = wfXML;
        this.myOwner.addListener((XMLElementChangeListener)this);
        this.myOwner.setNotifyListeners(true);
        this.dummy = (DefInfo)wfXML.getDefInfos().generateNewElement();
        this.setLayout(new BorderLayout());
        this.columnNames = this.getColumnNames(wfXML);
        this.allItems = this.createTable();
        this.setupTable();
        this.add(this.createScrollPane());
    }

    public JTable getTable() {
        return this.allItems;
    }

    public DefInfo getSelectedElement() {
        int n = this.allItems.getSelectedRow();
        if (n >= 0) {
            return (DefInfo)((Object)this.allItems.getValueAt(n, 0));
        }
        return null;
    }

    public boolean setSelectedElement(Object object) {
        try {
            int n = this.allItems.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (object != this.allItems.getValueAt(i, 0)) continue;
                    this.allItems.setRowSelectionInterval(i, i);
                    JViewport jViewport = (JViewport)this.allItems.getParent();
                    Rectangle rectangle = this.allItems.getCellRect(i, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
                    jViewport.scrollRectToVisible(rectangle);
                    this.scrollRectToVisible(rectangle);
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setSelectedRow(int n) {
        try {
            this.allItems.setRowSelectionInterval(n, n);
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)this.getSelectedElement(), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addRow(DefInfo defInfo) {
        int n = this.allItems.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        Vector vector = this.getRow(defInfo);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        defaultTableModel.removeRow(n);
    }

    public void updateRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        DefInfo defInfo = (DefInfo)((Object)defaultTableModel.getValueAt(n, 0));
        for (int i = 0; i < defInfo.toElements().size(); ++i) {
            defaultTableModel.setValueAt(defInfo.get(i).toValue(), n, i + 1);
        }
    }

    protected JTable createTable() {
        return new JTable(new Vector(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
                String string = null;
                try {
                    string = defaultTableModel.getValueAt(n, n3).toString();
                }
                catch (Exception exception) {
                    string = super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
    }

    protected void setupTable() {
        TableColumn tableColumn = this.allItems.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        tableColumn = this.allItems.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(375);
        tableColumn = this.allItems.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(150);
        tableColumn = this.allItems.getColumnModel().getColumn(3);
        tableColumn.setPreferredWidth(275);
        this.allItems.setAutoResizeMode(0);
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(0);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        this.allItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DefInfo defInfo;
                if (mouseEvent.getClickCount() > 1 && (defInfo = WfXMLTablePanel.this.getSelectedElement()) != null) {
                    new DefInfoEditor(defInfo);
                    WfXMLTablePanel.this.updateRow(WfXMLTablePanel.this.allItems.getSelectedRow());
                }
            }
        });
    }

    protected Vector getColumnNames(WfXML wfXML) {
        Vector<String> vector = new Vector<String>();
        vector.add("Object");
        for (XMLElement xMLElement : this.dummy.toElements()) {
            vector.add(wfXML.getSettings().getLanguageDependentString(xMLElement.toName() + "Key"));
        }
        return vector;
    }

    public void fillTableContent(List list) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (DefInfo defInfo : list) {
            Vector vector = this.getRow(defInfo);
            defaultTableModel.addRow(vector);
        }
    }

    protected Vector getRow(DefInfo defInfo) {
        Vector<Object> vector = new Vector<Object>();
        for (XMLElement xMLElement : defInfo.toElements()) {
            vector.add(xMLElement.toValue());
        }
        vector.add(0, (Object)defInfo);
        return vector;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(this.allItems);
        return jScrollPane;
    }

    protected int getElementRow(XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            XMLElement xMLElement2 = (XMLElement)this.allItems.getValueAt(i, 0);
            if (xMLElement != xMLElement2) continue;
            n = i;
            break;
        }
        return n;
    }

    public void cleanup() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
    }

    public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
        block3: {
            block2: {
                if (xMLElementChangeInfo.getAction() != 5) break block2;
                for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                    int n = this.getElementRow(xMLElement);
                    if (n == -1) continue;
                    this.removeRow(n);
                }
                break block3;
            }
            if (xMLElementChangeInfo.getAction() != 3) break block3;
            for (DefInfo defInfo : xMLElementChangeInfo.getChangedSubElements()) {
                this.addRow(defInfo);
            }
        }
    }
}

