/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.packagenavigator;

import java.util.Iterator;
import javax.swing.tree.MutableTreeNode;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.components.XPDLTreeModel;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class PackageNavigatorTreeModel
extends XPDLTreeModel {
    public PackageNavigatorTreeModel(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    public XPDLTreeNode insertNode(XMLElement xMLElement) {
        if (xMLElement instanceof Package || xMLElement instanceof WorkflowProcess || xMLElement instanceof ActivitySet || xMLElement instanceof Activity) {
            Object object;
            if (xMLElement instanceof Package) {
                return super.insertNode(xMLElement);
            }
            XPDLTreeNode xPDLTreeNode = null;
            if (xMLElement instanceof WorkflowProcess) {
                xPDLTreeNode = this.findNode((XMLElement)XMLUtil.getPackage((XMLElement)xMLElement));
            } else if (xMLElement instanceof ActivitySet) {
                xPDLTreeNode = this.findNode((XMLElement)XMLUtil.getWorkflowProcess((XMLElement)xMLElement));
            } else if (xMLElement instanceof Activity) {
                object = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)xMLElement);
                xPDLTreeNode = this.findNode((XMLElement)object);
            }
            if (xPDLTreeNode != null) {
                object = this.findNode(xPDLTreeNode, xMLElement);
                object = object == null ? this.insertNode(xPDLTreeNode, xMLElement) : null;
                return object;
            }
        }
        return null;
    }

    protected XPDLTreeNode insertNode(XPDLTreeNode xPDLTreeNode, XMLElement xMLElement) {
        if (xMLElement instanceof Package || xMLElement instanceof WorkflowProcess || xMLElement instanceof ActivitySet || xMLElement instanceof Activity) {
            XPDLTreeNode xPDLTreeNode2 = this.createNode(xMLElement);
            this.insertNodeInto((MutableTreeNode)xPDLTreeNode2, (MutableTreeNode)xPDLTreeNode, xPDLTreeNode.getChildCount());
            if (xMLElement instanceof Package || xMLElement instanceof WorkflowProcess || xMLElement instanceof ActivitySet) {
                if (xMLElement instanceof Package) {
                    Iterator iterator = ((Package)xMLElement).getWorkflowProcesses().toElements().iterator();
                    while (iterator.hasNext()) {
                        this.insertNode(xPDLTreeNode2, (XMLElement)((WorkflowProcess)iterator.next()));
                    }
                } else if (xMLElement instanceof WorkflowProcess) {
                    Iterator iterator = ((WorkflowProcess)xMLElement).getActivitySets().toElements().iterator();
                    while (iterator.hasNext()) {
                        this.insertNode(xPDLTreeNode2, (XMLElement)((ActivitySet)iterator.next()));
                    }
                    iterator = ((WorkflowProcess)xMLElement).getActivities().toElements().iterator();
                    while (iterator.hasNext()) {
                        this.insertNode(xPDLTreeNode2, (XMLElement)((Activity)iterator.next()));
                    }
                } else if (xMLElement instanceof ActivitySet) {
                    Iterator iterator = ((ActivitySet)xMLElement).getActivities().toElements().iterator();
                    while (iterator.hasNext()) {
                        this.insertNode(xPDLTreeNode2, (XMLElement)((Activity)iterator.next()));
                    }
                }
            }
            return xPDLTreeNode2;
        }
        return null;
    }

    protected XPDLTreeNode createNode(XMLElement xMLElement) {
        return new XPDLTreeNode(xMLElement){

            public String toString() {
                if (this.userObject instanceof XMLElement) {
                    return JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName((XMLElement)this.userObject);
                }
                return this.userObject.toString();
            }
        };
    }

    public boolean isLeaf(Object object) {
        Object object2 = ((XPDLTreeNode)object).getUserObject();
        if (object2 instanceof XMLElement) {
            if (object2 instanceof Package) {
                return ((Package)object2).getWorkflowProcesses().size() == 0;
            }
            if (object2 instanceof WorkflowProcess) {
                WorkflowProcess workflowProcess = (WorkflowProcess)object2;
                return workflowProcess.getActivitySets().size() == 0 && workflowProcess.getActivities().size() == 0;
            }
            if (object2 instanceof ActivitySet) {
                return ((ActivitySet)object2).getActivities().size() == 0;
            }
            if (object2 instanceof Activity) {
                return true;
            }
        }
        return false;
    }
}

