/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.languageswitcher;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.List;
import java.util.Locale;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.languageswitcher.LanguageSwitcherManager;
import org.enhydra.jawe.misc.PFLocale;

public class LanguageSwitcherMenu
extends JMenu
implements JaWEComponentView,
ActionListener {
    protected LanguageSwitcherManager controller;

    public void configure() {
    }

    public LanguageSwitcherMenu(LanguageSwitcherManager languageSwitcherManager) {
        this.controller = languageSwitcherManager;
    }

    public void init() {
        this.setText(this.controller.getSettings().getLanguageDependentString(this.controller.getName() + "Label"));
        List list = Utils.findPropertyFiles();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = list.size() - 1; i >= 0; --i) {
            PFLocale pFLocale = (PFLocale)list.get(i);
            SMItem sMItem = new SMItem(pFLocale.toString(), pFLocale);
            if (pFLocale.getLocale().equals(ResourceManager.getChoosenLocale())) {
                sMItem.setSelected(true);
            }
            sMItem.addActionListener(this);
            buttonGroup.add(sMItem);
            this.insert(sMItem, 0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = new File(System.getProperty("JaWE_CURRENT_CONFIG_HOME") + "/" + "togwebasic.properties");
        if (!file.exists()) {
            file = new File(System.getProperty("JaWE_CURRENT_CONFIG_HOME") + "/" + "jaweconfiguration.properties");
        }
        if (!file.exists()) {
            return;
        }
        File file2 = new File(System.getProperty("JaWE_CURRENT_CONFIG_HOME") + "/temp");
        Locale locale = ((SMItem)actionEvent.getSource()).getMyLocale().getLocale();
        try {
            file2.createNewFile();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2));
            String string = null;
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                if (!bl && (string.startsWith("#StartingLocale") || string.startsWith("StartingLocale"))) {
                    string = locale.getLanguage() == "" ? "StartingLocale = default" : "StartingLocale = " + locale.getLanguage();
                    if (!locale.getCountry().equals("")) {
                        string = string + "_" + locale.getCountry();
                    }
                    if (!locale.getVariant().equals("")) {
                        string = string + "_" + locale.getVariant();
                    }
                    bl = true;
                }
                bufferedWriter.write(string + "\n");
            }
            bufferedReader.close();
            bufferedWriter.close();
            file.delete();
            file2.renameTo(file);
            try {
                JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
                Utils.reconfigure((String)jaWEController.getConfigId(jaWEController.getCurrentConfig()));
            }
            catch (Exception exception) {
                JaWEManager.getInstance().getJaWEController().message(this.controller.getSettings().getLanguageDependentString("InformationEffectAfterRestart"), 1);
            }
        }
        catch (Exception exception) {
            JaWEManager.getInstance().getJaWEController().message(this.controller.getSettings().getLanguageDependentString("ErrorErrorWhileSaveFile"), 0);
        }
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    private class SMItem
    extends JRadioButtonMenuItem {
        PFLocale myLocale;

        public SMItem(String string, PFLocale pFLocale) {
            super(string);
            this.myLocale = pFLocale;
        }

        public void setMyLocale(PFLocale pFLocale) {
            this.myLocale = pFLocale;
        }

        public PFLocale getMyLocale() {
            return this.myLocale;
        }
    }
}

