/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.naming.NamingException;
import javax.swing.JComponent;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.ldap.LDAPConfiguration;
import org.enhydra.jawe.components.ldap.LDAPPanel;
import org.enhydra.jawe.components.ldap.LDAPSettings;
import org.enhydra.jawe.components.ldap.LDAPUtils;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class LDAPController
implements JaWEComponent,
Observer {
    protected String type = "OTHER";
    protected LDAPPanel panel;
    protected boolean updateInProgress = false;
    protected LDAPSettings settings;
    protected LDAPConfiguration ldapConfig;

    public LDAPController(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (LDAPSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
        this.ldapConfig = new LDAPConfiguration(this.settings);
    }

    public LDAPConfiguration getLDAPConfig() {
        return this.ldapConfig;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 5 && n != 3 && n != 8) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("LDAP -> update for event " + xPDLElementChangeInfo + " started ...");
        this.update(xPDLElementChangeInfo);
        JaWEManager.getInstance().getLoggingManager().info("LDAP -> update ended...");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF LDAP COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.updateInProgress) {
            return;
        }
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        this.updateInProgress = true;
        try {
            if (xPDLElementChangeInfo.getChangedElement() instanceof Package && !xPDLElementChangeInfo.getChangedElement().isReadOnly() && xPDLElementChangeInfo.getAction() == 5) {
                boolean bl = false;
                if (xPDLElementChangeInfo.getChangedSubElements().size() == 0) {
                    bl = true;
                }
                for (int i = 0; i < xPDLElementChangeInfo.getChangedSubElements().size(); ++i) {
                    if (!(xPDLElementChangeInfo.getChangedSubElements().get(i) instanceof Package) || ((Package)xPDLElementChangeInfo.getChangedSubElements().get(i)).isReadOnly()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    this.panel.refreshPanel(new ArrayList());
                }
            }
            this.settings.adjustActions();
        }
        finally {
            this.updateInProgress = false;
        }
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public LDAPSettings getLDAPSettings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listEntries() {
        ArrayList arrayList = new ArrayList();
        try {
            LDAPUtils.getEntries(this.getLDAPConfig(), Arrays.asList(this.settings.getLDAPObjectClassFilterChoices()), this.panel.getSelectedObjectClass(), this.panel.getSearchCriteria(), arrayList);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            if (namingException.getMessage().indexOf("Sizelimit Exceeded") != -1) {
                JaWEManager.getInstance().getJaWEController().message(ResourceManager.getLanguageDependentString((String)"ErrorLDAPSearchPartiallyFailedSizelimitExceeded"), 0);
            } else if (namingException.getMessage().indexOf("Timelimit Exceeded") != -1) {
                JaWEManager.getInstance().getJaWEController().message(ResourceManager.getLanguageDependentString((String)"ErrorLDAPSearchPartiallyFailedTimelimitExceeded"), 0);
            } else {
                JaWEManager.getInstance().getJaWEController().message(ResourceManager.getLanguageDependentString((String)"ErrorLDAPSearchFailed") + "\n" + namingException.getClass() + ":" + namingException.getMessage(), 0);
            }
            System.err.println("Search failed: " + namingException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JaWEManager.getInstance().getJaWEController().message(ResourceManager.getLanguageDependentString((String)"ErrorLDAPSearchFailed") + "\n" + exception.getClass() + ":" + exception.getMessage(), 0);
            System.err.println("Non-naming error: " + exception.getMessage());
        }
        finally {
            this.panel.refreshPanel(arrayList);
        }
    }

    public boolean hasSelectedEntries() {
        return this.panel.hasSelectedEntries();
    }

    public int howManyEntries() {
        return this.panel.howManyEntries();
    }

    public void importSelectedEntries() {
        List list = this.panel.getSelectedEntries();
        LDAPUtils.createParticipants(list);
    }

    public void importAllEntries() {
        List list = this.panel.getAllEntries();
        LDAPUtils.createParticipants(list);
    }

    protected void init() {
        this.panel = new LDAPPanel(this);
        this.panel.configure();
        this.settings.adjustActions();
    }

    public JaWEComponentView getView() {
        return this.panel;
    }

    public JComponent getDisplay() {
        return this.panel.getDisplay();
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "LDAPComponent";
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public void setUpdateInProgress(boolean bl) {
    }

    public boolean isUpdateInProgress() {
        return false;
    }
}

