/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.enhydra.jawe.HistoryManager;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;

public class HistoryMgr
implements HistoryManager {
    protected Stack backHistory = new Stack();
    protected Stack forwardHistory = new Stack();
    protected int maxHistory = -1;

    public void init(int n) {
        this.maxHistory = n >= 0 ? n : Integer.MAX_VALUE;
    }

    public void addToHistory(XMLElement xMLElement, XMLElement xMLElement2) {
        if (this.maxHistory <= 0) {
            return;
        }
        if (xMLElement2 == null && xMLElement == null) {
            return;
        }
        if (xMLElement2 != xMLElement && xMLElement != null) {
            if (!this.backHistory.isEmpty() && this.backHistory.lastElement() == xMLElement) {
                return;
            }
            if (this.backHistory.size() >= this.maxHistory) {
                this.backHistory.remove(0);
            }
            this.backHistory.push(xMLElement);
            this.forwardHistory.clear();
        }
    }

    public void removeFromHistory(XMLElement xMLElement) {
        XMLElement xMLElement2;
        int n;
        if (xMLElement == null) {
            return;
        }
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        for (n = 0; n < this.backHistory.size(); ++n) {
            xMLElement2 = (XMLElement)this.backHistory.get(n);
            if (xMLElement2 != xMLElement && !XMLUtil.isParentsChild((XMLElement)xMLElement, (XMLElement)xMLElement2)) continue;
            arrayList.add(xMLElement2);
        }
        if (arrayList.size() > 0) {
            this.forwardHistory.clear();
            this.backHistory.removeAll(arrayList);
            Iterator iterator = this.backHistory.iterator();
            xMLElement2 = null;
            while (iterator.hasNext()) {
                XMLElement xMLElement3 = (XMLElement)iterator.next();
                if (xMLElement2 == null) {
                    xMLElement2 = xMLElement3;
                    continue;
                }
                if (xMLElement3 == xMLElement2) {
                    iterator.remove();
                    continue;
                }
                xMLElement2 = xMLElement3;
            }
        } else {
            n = 0;
            for (int i = 0; i < this.forwardHistory.size(); ++i) {
                XMLElement xMLElement4 = (XMLElement)this.forwardHistory.get(i);
                if (xMLElement4 != xMLElement && !XMLUtil.isParentsChild((XMLElement)xMLElement, (XMLElement)xMLElement4)) continue;
                n = 1;
                break;
            }
            if (n != 0) {
                this.forwardHistory.clear();
            }
        }
    }

    public XMLElement getNext(XMLElement xMLElement) {
        if (this.maxHistory <= 0) {
            return null;
        }
        XMLElement xMLElement2 = null;
        if (!this.forwardHistory.empty()) {
            xMLElement2 = (XMLElement)this.forwardHistory.pop();
            if (xMLElement != null) {
                if (this.backHistory.size() >= this.maxHistory) {
                    this.backHistory.remove(0);
                }
                this.backHistory.push(xMLElement);
            }
        }
        return xMLElement2;
    }

    public XMLElement getPrevious(XMLElement xMLElement) {
        if (this.maxHistory <= 0) {
            return null;
        }
        XMLElement xMLElement2 = null;
        if (!this.backHistory.empty()) {
            xMLElement2 = (XMLElement)this.backHistory.pop();
            if (xMLElement != null) {
                if (this.forwardHistory.size() >= this.maxHistory) {
                    this.forwardHistory.remove(0);
                }
                this.forwardHistory.push(xMLElement);
            }
        }
        return xMLElement2;
    }

    public boolean canGoBack() {
        return !this.backHistory.isEmpty();
    }

    public boolean canGoForward() {
        return !this.forwardHistory.isEmpty();
    }

    public void cleanHistory() {
        this.backHistory.clear();
        this.forwardHistory.clear();
    }
}

