/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.infobar;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XMLElementChoiceButton;
import org.enhydra.jawe.base.display.DisplayNameGenerator;
import org.enhydra.jawe.base.recentfiles.RecentFilesManager;
import org.enhydra.jawe.base.recentfiles.RecentFilesSettings;
import org.enhydra.jawe.components.infobar.InfoBarController;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class InfoBar
extends JPanel
implements JaWEComponentView {
    protected InfoBarController controller;
    protected JLabel fileNameLabel = new JLabel(" - ");
    protected JLabel packageNameLabel = new JLabel(" - ");
    protected JLabel processNameLabel = new JLabel(" - ");
    protected XMLElementChoiceButton pkgChoiceButton;
    protected XMLElementChoiceButton wpChoiceButton;
    protected JButton fileButton;
    protected RecentFilesManager recentF;

    public InfoBar(InfoBarController infoBarController) {
        this.controller = infoBarController;
    }

    public void configure() {
    }

    public void init() {
        try {
            this.recentF = new RecentFilesManager((JaWEComponentSettings)new RecentFilesSettings());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ImageIcon imageIcon = this.controller.getInfoBarSettings().getPackageSelectionIcon();
        this.pkgChoiceButton = new XMLElementChoiceButton(Package.class, (ChoiceButtonListener)this.controller, imageIcon, false, new String[]{"Id", "Name"});
        this.pkgChoiceButton.setContentAreaFilled(false);
        this.pkgChoiceButton.setBorder(BorderFactory.createEmptyBorder());
        imageIcon = this.controller.getInfoBarSettings().getProcessSelectionIcon();
        this.wpChoiceButton = new XMLElementChoiceButton(WorkflowProcess.class, (ChoiceButtonListener)this.controller, imageIcon, false, new String[]{"Id", "Name"});
        this.wpChoiceButton.setContentAreaFilled(false);
        this.wpChoiceButton.setBorder(BorderFactory.createEmptyBorder());
        imageIcon = this.controller.getInfoBarSettings().getFileIcon();
        this.fileButton = new JButton(imageIcon);
        this.fileButton.setContentAreaFilled(false);
        this.fileButton.setBorder(BorderFactory.createEmptyBorder());
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenu jMenu = (JMenu)InfoBar.this.recentF.getView().getDisplay();
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                jPopupMenu.show(InfoBar.this.fileButton.getParent(), InfoBar.this.fileButton.getX(), InfoBar.this.fileButton.getY() + InfoBar.this.fileButton.getHeight());
            }
        });
        this.setLayout(new BoxLayout(this, 0));
        Color color = this.controller.getInfoBarSettings().getBackgroundColor();
        this.setBackground(color);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.add((Component)this.pkgChoiceButton);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.packageNameLabel);
        this.add(Box.createHorizontalStrut(10));
        this.add((Component)this.wpChoiceButton);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.processNameLabel);
        this.add(Box.createHorizontalStrut(10));
        this.add(Box.createHorizontalGlue());
        this.add(this.fileButton);
        this.add(Box.createHorizontalStrut(3));
        this.add(this.fileNameLabel);
        this.add(Box.createHorizontalStrut(10));
    }

    public JaWEComponent getJaWEComponent() {
        return this.controller;
    }

    public JComponent getDisplay() {
        return this;
    }

    public void setFileName(String string) {
        if (string == null || string.trim().equals("")) {
            string = " - ";
        }
        this.fileNameLabel.setText(string);
    }

    public void setPackageName(Package package_) {
        String string = " - ";
        if (package_ != null) {
            DisplayNameGenerator displayNameGenerator = JaWEManager.getInstance().getDisplayNameGenerator();
            string = displayNameGenerator.getDisplayName((XMLElement)package_);
        }
        this.packageNameLabel.setText(string);
        this.pkgChoiceButton.setObjectIcon((Object)package_);
    }

    public void setProcessName(WorkflowProcess workflowProcess) {
        String string = " - ";
        if (workflowProcess != null) {
            DisplayNameGenerator displayNameGenerator = JaWEManager.getInstance().getDisplayNameGenerator();
            string = displayNameGenerator.getDisplayName((XMLElement)workflowProcess);
        }
        this.processNameLabel.setText(string);
        this.wpChoiceButton.setObjectIcon((Object)workflowProcess);
    }
}

