/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe;

import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.lang.reflect.Constructor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.ButtonPropertyChangedListener;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEAction;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.NewActionBase;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.controller.JaWETypeChoiceButton;
import org.enhydra.jxpdl.XMLUtil;

public class BarFactory {
    public static final String CLASSNAME_POSTFIX = "ClassName";
    public static final String SETTINGSNAME_POSTFIX = "SettingsName";
    public static final String ACCELERATION_POSTFIX = "Accel";
    public static final String MNEMONIC_POSTFIX = "Mnemonic";
    public static final String LABEL_POSTFIX = "Label";
    public static final String TOOLTIP_POSTFIX = "Tooltip";
    public static final String LANGUAGEDEPENDENTNAME_POSTFIX = "LangName";
    public static final String JAWE_STANDARD_MENU_PREFIX = "jawe_";
    public static final String JAWE_STANDARD_ACTION_PREFIX = "jaweAction_";
    public static final String JAWECOMPONENT_AS_MENU_PREFIX = "@";
    public static final String SUBMENU_PREFIX = "*";
    public static final String ACTION_DELIMITER = " ";
    public static final String ACTION_SEPARATOR = "-";
    public static final String CTRL_PREFIX = "CTRL";
    public static final String SHIFT_PREFIX = "SHIFT";
    public static final String ALT_PREFIX = "ALT";

    public static JMenuBar createMainMenu(JaWEComponent jaWEComponent) {
        JMenuBar jMenuBar = new JMenuBar();
        String string = jaWEComponent.getSettings().getMainMenuActionOrder();
        String[] stringArray = XMLUtil.tokenize((String)string, (String)ACTION_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].startsWith(JAWECOMPONENT_AS_MENU_PREFIX)) {
                String string2;
                object = (String)jaWEComponent.getSettings().getSetting(stringArray[i].substring(1) + CLASSNAME_POSTFIX);
                JMenu jMenu = BarFactory.getExternalMenu((String)object, string2 = (String)jaWEComponent.getSettings().getSetting(stringArray[i].substring(1) + SETTINGSNAME_POSTFIX));
                if (jMenu == null) continue;
                BarFactory.setAccelerator(jMenu, jaWEComponent.getSettings().getLanguageDependentString(stringArray[i].substring(1) + ACCELERATION_POSTFIX));
                BarFactory.setMnemonic(jMenu, jaWEComponent.getSettings().getLanguageDependentString(stringArray[i].substring(1) + MNEMONIC_POSTFIX));
                jMenuBar.add(jMenu);
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_MENU_PREFIX)) {
                jMenuBar.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionMenu(stringArray[i], true));
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_ACTION_PREFIX)) {
                jMenuBar.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionMenuItem(stringArray[i].substring(11), true));
                continue;
            }
            if (stringArray[i].startsWith(SUBMENU_PREFIX)) {
                object = BarFactory.createSubMenu(stringArray[i].substring(1), jaWEComponent, true);
                if (object == null) continue;
                jMenuBar.add((JMenu)object);
                continue;
            }
            object = jaWEComponent.getSettings().getAction(stringArray[i]);
            if (object == null) continue;
            jMenuBar.add(BarFactory.createMenuItem((JaWEAction)object, jaWEComponent, true));
        }
        return jMenuBar;
    }

    public static JPopupMenu createPopupMenu(String string, JaWEComponent jaWEComponent) {
        String string2 = jaWEComponent.getSettings().getMenuActionOrder(string);
        return BarFactory.createMenu(string2, jaWEComponent, false).getPopupMenu();
    }

    public static JToolBar createToolbar(String string, JaWEComponent jaWEComponent) {
        String string2 = jaWEComponent.getSettings().getToolbarActionOrder(string);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setRollover(true);
        String[] stringArray = XMLUtil.tokenize((String)string2, (String)ACTION_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(ACTION_SEPARATOR)) {
                jToolBar.addSeparator();
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_MENU_PREFIX)) {
                jToolBar.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionToolbar(stringArray[i]));
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_ACTION_PREFIX)) {
                jToolBar.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionButton(stringArray[i].substring(11)));
                continue;
            }
            if (stringArray[i].startsWith(SUBMENU_PREFIX)) {
                jToolBar.add(BarFactory.createToolbar(stringArray[i].substring(1), jaWEComponent));
                continue;
            }
            JaWEAction jaWEAction = jaWEComponent.getSettings().getAction(stringArray[i]);
            if (jaWEAction == null) continue;
            jToolBar.add(BarFactory.createToolbarButton(jaWEAction, jaWEComponent));
        }
        jToolBar.setName(jaWEComponent.getSettings().getLanguageDependentString(string + LABEL_POSTFIX));
        return jToolBar;
    }

    public static JButton createToolbarButton(JaWEAction jaWEAction, JaWEComponent jaWEComponent) {
        ActionBase actionBase = jaWEAction.getAction();
        String string = null;
        if (actionBase != null) {
            string = (String)actionBase.getValue("Name");
        }
        String string2 = jaWEAction.getLangDepName();
        String string3 = jaWEComponent.getSettings().getLanguageDependentString(string2 + LABEL_POSTFIX);
        if (string == null) {
            string = string2;
        }
        if (string3 == null) {
            string3 = string;
        }
        JButton jButton = null;
        ImageIcon imageIcon = jaWEAction.getIcon();
        jButton = imageIcon != null ? (actionBase instanceof NewActionBase && jaWEComponent instanceof ChoiceButtonListener ? new JaWETypeChoiceButton(JaWEType.class, ((NewActionBase)actionBase).getXPDLTypeClass(), ((NewActionBase)actionBase).getXPDLTypeClassParentForEA(), (ChoiceButtonListener)((Object)jaWEComponent), imageIcon) : new JButton(imageIcon){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        }) : (actionBase instanceof NewActionBase && jaWEComponent instanceof ChoiceButtonListener ? new JaWETypeChoiceButton(JaWEType.class, ((NewActionBase)actionBase).getXPDLTypeClass(), ((NewActionBase)actionBase).getXPDLTypeClassParentForEA(), (ChoiceButtonListener)((Object)jaWEComponent), imageIcon) : new JButton(string3){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        });
        jButton.setName(string);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setRequestFocusEnabled(false);
        jButton.setActionCommand(string);
        if (actionBase != null) {
            jButton.addActionListener(actionBase);
            jButton.setEnabled(actionBase.isEnabled());
            actionBase.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton));
        } else {
            jButton.setEnabled(false);
        }
        String string4 = jaWEComponent.getSettings().getLanguageDependentString(string2 + TOOLTIP_POSTFIX);
        if (string4 != null) {
            jButton.setToolTipText(string4);
        }
        return jButton;
    }

    protected static JMenu createMenu(String string, JaWEComponent jaWEComponent, boolean bl) {
        JMenu jMenu = new JMenu();
        String[] stringArray = XMLUtil.tokenize((String)string, (String)ACTION_DELIMITER);
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equals(ACTION_SEPARATOR)) {
                jMenu.addSeparator();
                continue;
            }
            if (stringArray[i].startsWith(JAWECOMPONENT_AS_MENU_PREFIX)) {
                object = (String)jaWEComponent.getSettings().getSetting(stringArray[i].substring(1) + CLASSNAME_POSTFIX);
                String string2 = (String)jaWEComponent.getSettings().getSetting(stringArray[i].substring(1) + SETTINGSNAME_POSTFIX);
                JMenu jMenu2 = BarFactory.getExternalMenu((String)object, string2);
                BarFactory.setAccelerator(jMenu2, jaWEComponent.getSettings().getLanguageDependentString(stringArray[i].substring(1) + ACCELERATION_POSTFIX));
                BarFactory.setMnemonic(jMenu2, jaWEComponent.getSettings().getLanguageDependentString(stringArray[i].substring(1) + MNEMONIC_POSTFIX));
                jMenu.add(jMenu2);
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_MENU_PREFIX)) {
                jMenu.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionMenu(stringArray[i], bl));
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_ACTION_PREFIX)) {
                jMenu.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionMenuItem(stringArray[i].substring(11), bl));
                continue;
            }
            if (stringArray[i].startsWith(SUBMENU_PREFIX)) {
                jMenu.add(BarFactory.createSubMenu(stringArray[i].substring(1), jaWEComponent, bl));
                continue;
            }
            object = jaWEComponent.getSettings().getAction(stringArray[i]);
            if (object == null) continue;
            jMenu.add(BarFactory.createMenuItem((JaWEAction)object, jaWEComponent, bl));
        }
        return jMenu;
    }

    protected static JMenu createSubMenu(String string, JaWEComponent jaWEComponent, boolean bl) {
        JMenu jMenu = new JMenu();
        String string2 = (String)jaWEComponent.getSettings().getSetting(string + LANGUAGEDEPENDENTNAME_POSTFIX);
        String string3 = jaWEComponent.getSettings().getLanguageDependentString(string2 + LABEL_POSTFIX);
        if (string3 == null) {
            string3 = string;
        }
        BarFactory.setAccelerator(jMenu, jaWEComponent.getSettings().getLanguageDependentString(string2 + ACCELERATION_POSTFIX));
        BarFactory.setMnemonic(jMenu, jaWEComponent.getSettings().getLanguageDependentString(string2 + MNEMONIC_POSTFIX));
        jMenu.setText(string3);
        String string4 = jaWEComponent.getSettings().getMenuActionOrder(string);
        String[] stringArray = XMLUtil.tokenize((String)string4, (String)ACTION_DELIMITER);
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equals(ACTION_SEPARATOR)) {
                jMenu.addSeparator();
                ++n;
                continue;
            }
            if (stringArray[i].startsWith(JAWECOMPONENT_AS_MENU_PREFIX)) {
                String string5;
                object = (String)jaWEComponent.getSettings().getSetting(stringArray[i].substring(1) + CLASSNAME_POSTFIX);
                JMenu jMenu2 = BarFactory.getExternalMenu((String)object, string5 = (String)jaWEComponent.getSettings().getSetting(stringArray[i].substring(1) + SETTINGSNAME_POSTFIX));
                if (jMenu2 != null) {
                    BarFactory.setAccelerator(jMenu2, jaWEComponent.getSettings().getLanguageDependentString(stringArray[i].substring(1) + ACCELERATION_POSTFIX));
                    BarFactory.setMnemonic(jMenu2, jaWEComponent.getSettings().getLanguageDependentString(stringArray[i].substring(1) + MNEMONIC_POSTFIX));
                    jMenu.add(jMenu2);
                    ++n;
                    continue;
                }
                System.out.println("Can't create ext meny " + string5 + " for cn " + (String)object);
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_MENU_PREFIX)) {
                jMenu.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionMenu(stringArray[i], bl));
                ++n;
                continue;
            }
            if (stringArray[i].startsWith(JAWE_STANDARD_ACTION_PREFIX)) {
                jMenu.add(JaWEManager.getInstance().getJaWEController().getJaWEActions().getActionMenuItem(stringArray[i].substring(11), bl));
                ++n;
                continue;
            }
            if (stringArray[i].startsWith(SUBMENU_PREFIX)) {
                object = BarFactory.createSubMenu(stringArray[i], jaWEComponent, bl);
                if (object == null) continue;
                jMenu.add((JMenuItem)object);
                ++n;
                continue;
            }
            object = jaWEComponent.getSettings().getAction(stringArray[i]);
            if (object == null) continue;
            jMenu.add(BarFactory.createMenuItem((JaWEAction)object, jaWEComponent, bl));
            ++n;
        }
        if (n > 0) {
            return jMenu;
        }
        return null;
    }

    protected static JMenu getExternalMenu(String string, String string2) {
        try {
            Constructor<?> constructor = Class.forName(string2).getConstructor(new Class[0]);
            JaWEComponentSettings jaWEComponentSettings = (JaWEComponentSettings)constructor.newInstance(new Object[0]);
            Constructor<?> constructor2 = Class.forName(string).getConstructor(JaWEComponentSettings.class);
            JaWEComponent jaWEComponent = (JaWEComponent)constructor2.newInstance(jaWEComponentSettings);
            return (JMenu)((Object)jaWEComponent.getView());
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static JMenuItem createMenuItem(JaWEAction jaWEAction, JaWEComponent jaWEComponent, boolean bl) {
        String string;
        ActionBase actionBase = jaWEAction.getAction();
        String string2 = null;
        if (actionBase != null) {
            string2 = (String)actionBase.getValue("Name");
        }
        String string3 = jaWEAction.getLangDepName();
        if (string2 == null) {
            string2 = string3;
        }
        if (string3 == null) {
            string3 = string2;
        }
        if ((string = jaWEComponent.getSettings().getLanguageDependentString(string3 + LABEL_POSTFIX)) == null) {
            string = string2;
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setName(string2);
        ImageIcon imageIcon = jaWEAction.getIcon();
        if (imageIcon != null) {
            jMenuItem.setHorizontalTextPosition(4);
            jMenuItem.setIcon(imageIcon);
        }
        BarFactory.setAccelerator(jMenuItem, jaWEComponent.getSettings().getLanguageDependentString(string3 + ACCELERATION_POSTFIX));
        BarFactory.setMnemonic(jMenuItem, jaWEComponent.getSettings().getLanguageDependentString(string3 + MNEMONIC_POSTFIX));
        jMenuItem.setActionCommand(string2);
        if (actionBase != null) {
            jMenuItem.addActionListener(actionBase);
            if (bl) {
                actionBase.addPropertyChangeListener(new ButtonPropertyChangedListener(jMenuItem));
            }
            jMenuItem.setEnabled(actionBase.isEnabled());
        } else {
            jMenuItem.setEnabled(false);
        }
        return jMenuItem;
    }

    public static void setMnemonic(JMenuItem jMenuItem, String string) {
        if (string != null && string.length() > 0) {
            jMenuItem.setMnemonic(string.toCharArray()[0]);
        }
    }

    public static void setAccelerator(JMenuItem jMenuItem, String string) {
        if (string != null) {
            try {
                int n = 0;
                if (string.startsWith(CTRL_PREFIX)) {
                    n += 2;
                    string = string.substring(CTRL_PREFIX.length() + 1);
                }
                if (string.startsWith(SHIFT_PREFIX)) {
                    ++n;
                    string = string.substring(SHIFT_PREFIX.length() + 1);
                }
                if (string.startsWith(ALT_PREFIX)) {
                    n += 8;
                    string = string.substring(ALT_PREFIX.length() + 1);
                }
                int n2 = KeyEvent.class.getField("VK_" + string).getInt(null);
                jMenuItem.setAccelerator(KeyStroke.getKeyStroke(n2, n));
            }
            catch (Exception exception) {
                System.err.println("Error while assigning accelerator !!!");
            }
        }
    }
}

