/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.display;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.base.display.DisplayNameGenerator;
import org.enhydra.jawe.base.display.DisplayNameGeneratorSettings;
import org.enhydra.jawe.base.label.LabelGenerator;
import org.enhydra.jawe.base.xpdlhandler.XPDLHandler;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLEmptyChoiceElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActualParameter;
import org.enhydra.jxpdl.elements.BasicType;
import org.enhydra.jxpdl.elements.Condition;
import org.enhydra.jxpdl.elements.DataType;
import org.enhydra.jxpdl.elements.DataTypes;
import org.enhydra.jxpdl.elements.Deadline;
import org.enhydra.jxpdl.elements.DeclaredType;
import org.enhydra.jxpdl.elements.EnumerationType;
import org.enhydra.jxpdl.elements.ExpressionType;
import org.enhydra.jxpdl.elements.ExternalPackage;
import org.enhydra.jxpdl.elements.ExternalReference;
import org.enhydra.jxpdl.elements.FormalParameters;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.Member;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.ParticipantType;
import org.enhydra.jxpdl.elements.RecordType;
import org.enhydra.jxpdl.elements.Responsible;
import org.enhydra.jxpdl.elements.Route;
import org.enhydra.jxpdl.elements.Split;
import org.enhydra.jxpdl.elements.SubFlow;
import org.enhydra.jxpdl.elements.TaskApplication;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.TransitionRef;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.TypeDeclaration;
import org.enhydra.jxpdl.elements.UnionType;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class StandardDisplayNameGenerator
implements DisplayNameGenerator {
    protected DisplayNameGeneratorSettings settings;

    public StandardDisplayNameGenerator() {
        this.settings = new DisplayNameGeneratorSettings();
        this.settings.init(null);
    }

    public StandardDisplayNameGenerator(DisplayNameGeneratorSettings displayNameGeneratorSettings) {
        this.settings = displayNameGeneratorSettings;
        this.settings.init(null);
    }

    public String getDisplayName(ActualParameter actualParameter) {
        XMLCollectionElement xMLCollectionElement;
        SequencedHashMap sequencedHashMap = XMLUtil.getPossibleVariables((XMLElement)actualParameter);
        String string = actualParameter.toValue();
        if (!string.equals("") && (xMLCollectionElement = (XMLCollectionElement)sequencedHashMap.get(string)) != null) {
            return this.getDisplayName(xMLCollectionElement);
        }
        return string;
    }

    public String getDisplayName(BasicType basicType) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)basicType);
    }

    public String getDisplayName(Condition condition) {
        return condition.toValue();
    }

    public String getDisplayName(DataType dataType) {
        return this.getDisplayName(dataType.getDataTypes());
    }

    public String getDisplayName(DataTypes dataTypes) {
        XMLBaseForCollectionAndComplex xMLBaseForCollectionAndComplex = (XMLBaseForCollectionAndComplex)dataTypes.getChoosen();
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        String string = labelGenerator.getLabel((XMLElement)xMLBaseForCollectionAndComplex);
        if (xMLBaseForCollectionAndComplex instanceof BasicType) {
            string = string + " -> " + this.settings.getLanguageDependentString(((BasicType)xMLBaseForCollectionAndComplex).getType() + "Key");
        } else if (xMLBaseForCollectionAndComplex instanceof DeclaredType) {
            String string2 = ((DeclaredType)xMLBaseForCollectionAndComplex).getId();
            TypeDeclaration typeDeclaration = XMLUtil.getTypeDeclaration((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (Package)XMLUtil.getPackage((XMLElement)dataTypes), (String)string2);
            string = string + " -> " + this.getDisplayName((XMLCollectionElement)typeDeclaration);
        }
        return string;
    }

    public String getDisplayName(Deadline deadline) {
        return deadline.getDeadlineDuration();
    }

    public String getDisplayName(DeclaredType declaredType) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        return labelGenerator.getLabel((XMLElement)declaredType);
    }

    public String getDisplayName(EnumerationType enumerationType) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)enumerationType);
    }

    public String getDisplayName(ExternalPackage externalPackage) {
        return externalPackage.getHref();
    }

    public String getDisplayName(ExternalReference externalReference) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)externalReference);
    }

    public String getDisplayName(FormalParameters formalParameters) {
        if (formalParameters.getParent() instanceof XMLComplexChoice) {
            return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)formalParameters);
        }
        return String.valueOf(formalParameters.size());
    }

    public String getDisplayName(Join join) {
        return this.generateStandardDisplayName((XMLElement)join.getTypeAttribute());
    }

    public String getDisplayName(Member member) {
        return this.getDisplayName(member.getDataTypes());
    }

    public String getDisplayName(ParticipantType participantType) {
        return this.generateStandardDisplayName((XMLElement)participantType.getTypeAttribute());
    }

    public String getDisplayName(RecordType recordType) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)recordType);
    }

    public String getDisplayName(Responsible responsible) {
        Participant participant;
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)responsible);
        Package package_ = XMLUtil.getPackage((XMLElement)responsible);
        XPDLHandler xPDLHandler = JaWEManager.getInstance().getXPDLHandler();
        SequencedHashMap sequencedHashMap = null;
        if (workflowProcess != null) {
            sequencedHashMap = XMLUtil.getPossibleParticipants((WorkflowProcess)workflowProcess, (XMLInterface)xPDLHandler);
        } else if (package_ != null) {
            sequencedHashMap = XMLUtil.getPossibleParticipants((Package)package_, (XMLInterface)xPDLHandler);
        }
        String string = responsible.toValue();
        if (sequencedHashMap != null && !string.equals("") && (participant = (Participant)sequencedHashMap.get(string)) != null) {
            return this.getDisplayName((XMLCollectionElement)participant);
        }
        return string;
    }

    public String getDisplayName(Route route) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)route);
    }

    public String getDisplayName(Split split) {
        return this.generateStandardDisplayName((XMLElement)split.getTypeAttribute());
    }

    public String getDisplayName(SubFlow subFlow) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)subFlow);
    }

    public String getDisplayName(TaskApplication taskApplication) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)taskApplication);
    }

    public String getDisplayName(TransitionRef transitionRef) {
        return this.getDisplayName(transitionRef.get("Id"));
    }

    public String getDisplayName(UnionType unionType) {
        return JaWEManager.getInstance().getLabelGenerator().getLabel((XMLElement)unionType);
    }

    public String getDisplayName(XMLAttribute xMLAttribute) {
        SequencedHashMap sequencedHashMap;
        Activity activity;
        XMLCollectionElement xMLCollectionElement;
        Transitions transitions;
        Transition transition;
        if (xMLAttribute.getParent() instanceof Transition && (xMLAttribute.toName().equals("From") || xMLAttribute.toName().equals("To"))) {
            XMLCollectionElement xMLCollectionElement2 = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)xMLAttribute);
            SequencedHashMap sequencedHashMap2 = this.getPossibleActivities(xMLCollectionElement2);
            Activity activity2 = (Activity)sequencedHashMap2.get((Object)xMLAttribute.toValue());
            if (activity2 != null) {
                return this.generateStandardDisplayName((XMLElement)activity2);
            }
        } else if (xMLAttribute.getParent() instanceof TransitionRef && (transition = (transitions = (Transitions)(xMLCollectionElement = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)xMLAttribute)).get("Transitions")).getTransition(xMLAttribute.toValue())) != null && (activity = (Activity)(sequencedHashMap = this.getPossibleActivities(xMLCollectionElement)).get((Object)transition.getTo())) != null) {
            return this.generateStandardDisplayName((XMLElement)activity);
        }
        return this.generateStandardDisplayName((XMLElement)xMLAttribute);
    }

    public String getDisplayName(XMLEmptyChoiceElement xMLEmptyChoiceElement) {
        String string = xMLEmptyChoiceElement.toValue();
        return string;
    }

    public String getDisplayName(XMLComplexChoice xMLComplexChoice) {
        return this.generateStandardDisplayName((XMLElement)xMLComplexChoice);
    }

    public String getDisplayName(XMLCollection xMLCollection) {
        return this.generateStandardDisplayName((XMLElement)xMLCollection);
    }

    public String getDisplayName(XMLCollectionElement xMLCollectionElement) {
        return this.generateStandardDisplayName((XMLElement)xMLCollectionElement);
    }

    public String getDisplayName(XMLComplexElement xMLComplexElement) {
        return this.generateStandardDisplayName((XMLElement)xMLComplexElement);
    }

    public String getDisplayName(XMLSimpleElement xMLSimpleElement) {
        return this.generateStandardDisplayName((XMLElement)xMLSimpleElement);
    }

    @Override
    public String getDisplayName(XMLElement xMLElement) {
        try {
            Method method;
            Class<Object> clazz;
            block8: {
                clazz = xMLElement.getClass();
                method = null;
                try {
                    method = this.getClass().getMethod("getDisplayName", clazz);
                }
                catch (Exception exception) {
                    if (clazz == XMLSimpleElement.class || clazz == XMLAttribute.class || clazz == XMLComplexChoice.class || clazz == XMLComplexElement.class || clazz == XMLCollectionElement.class || clazz == XMLCollection.class) break block8;
                    if (XMLComplexChoice.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexChoice.class;
                    }
                    if (XMLAttribute.class.isAssignableFrom(clazz)) {
                        clazz = XMLAttribute.class;
                    }
                    if (XMLSimpleElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLSimpleElement.class;
                    }
                    if (XMLComplexElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexElement.class;
                    }
                    if (!XMLCollection.class.isAssignableFrom(clazz)) break block8;
                    clazz = XMLCollection.class;
                }
            }
            method = this.getClass().getMethod("getDisplayName", clazz);
            return (String)method.invoke((Object)this, xMLElement);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.generateStandardDisplayName(xMLElement);
        }
    }

    public String generateStandardDisplayName(XMLElement xMLElement) {
        String string = "";
        if (xMLElement instanceof XMLCollection) {
            string = String.valueOf(((XMLCollection)xMLElement).size());
        } else if (xMLElement instanceof XMLComplexElement) {
            XMLElement xMLElement2;
            XMLElement xMLElement3 = ((XMLComplexElement)xMLElement).get("Name");
            if (xMLElement3 != null) {
                string = xMLElement3.toValue();
            }
            if (string.equals("") && (xMLElement2 = ((XMLComplexElement)xMLElement).get("Id")) != null) {
                string = xMLElement2.toValue();
            }
            if (string.equals("")) {
                string = xMLElement instanceof ExpressionType ? xMLElement.toValue() : JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement);
            }
        } else if (xMLElement instanceof XMLComplexChoice) {
            string = this.getDisplayName(((XMLComplexChoice)xMLElement).getChoosen());
        } else if (xMLElement instanceof XMLAttribute && ((XMLAttribute)xMLElement).getChoices() != null) {
            string = this.settings.getLanguageDependentString(xMLElement.toValue() + "Key");
            if (string == null || string.equals("")) {
                string = xMLElement.toValue();
            }
        } else {
            string = xMLElement.toValue();
        }
        return string;
    }

    public DisplayNameGeneratorSettings getSetting() {
        return this.settings;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public SequencedHashMap getPossibleActivities(XMLCollectionElement xMLCollectionElement) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        ArrayList arrayList = ((Activities)xMLCollectionElement.get("Activities")).toElements();
        for (Activity activity : arrayList) {
            sequencedHashMap.put((Object)activity.getId(), (Object)activity);
        }
        return sequencedHashMap;
    }
}

