/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Properties;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.base.panel.PanelValidator;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLGroupPanel;
import org.enhydra.jawe.base.panel.panels.XMLPanel;
import org.enhydra.jawe.base.panel.panels.XMLTabbedPanel;
import org.enhydra.jawe.base.transitionhandler.TransitionHandler;
import org.enhydra.jawe.components.graph.SizeObject;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLEmptyChoiceElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Condition;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Transition;

public class StandardPanelValidator
implements PanelValidator {
    protected Properties properties;

    public void configure(Properties properties) throws Exception {
        this.properties = properties;
    }

    public boolean validatePanel(SizeObject sizeObject, XMLPanel xMLPanel) {
        XMLPanel xMLPanel2 = StandardPanelValidator.findPanel(xMLPanel, sizeObject.get("Width"));
        XMLPanel xMLPanel3 = StandardPanelValidator.findPanel(xMLPanel, sizeObject.get("Height"));
        String string = (String)xMLPanel2.getValue();
        String string2 = (String)xMLPanel3.getValue();
        try {
            double d = Double.parseDouble(string);
            double d2 = Double.parseDouble(string2);
            if (d <= 10.0 || d2 < 10.0) {
                XMLBasicPanel.errorMessage(xMLPanel.getWindow(), ResourceManager.getLanguageDependentString("ErrorMessageKey"), "", ResourceManager.getLanguageDependentString("MessageInvalidDimension"));
                return false;
            }
        }
        catch (Exception exception) {
            XMLBasicPanel.errorMessage(xMLPanel.getWindow(), ResourceManager.getLanguageDependentString("ErrorMessageKey"), "", ResourceManager.getLanguageDependentString("MessageInvalidValue"));
            return false;
        }
        return true;
    }

    public boolean validatePanel(XMLAttribute xMLAttribute, XMLPanel xMLPanel) {
        return this.standardPanelValidation((XMLElement)xMLAttribute, xMLPanel);
    }

    public boolean validatePanel(XMLEmptyChoiceElement xMLEmptyChoiceElement, XMLPanel xMLPanel) {
        return this.standardPanelValidation((XMLElement)xMLEmptyChoiceElement, xMLPanel);
    }

    public boolean validatePanel(XMLComplexChoice xMLComplexChoice, XMLPanel xMLPanel) {
        return this.standardPanelValidation((XMLElement)xMLComplexChoice, xMLPanel);
    }

    public boolean validatePanel(XMLCollection xMLCollection, XMLPanel xMLPanel) {
        return this.standardPanelValidation((XMLElement)xMLCollection, xMLPanel);
    }

    public boolean validatePanel(XMLComplexElement xMLComplexElement, XMLPanel xMLPanel) {
        return this.standardPanelValidation((XMLElement)xMLComplexElement, xMLPanel);
    }

    public boolean validatePanel(XMLSimpleElement xMLSimpleElement, XMLPanel xMLPanel) {
        return this.standardPanelValidation((XMLElement)xMLSimpleElement, xMLPanel);
    }

    @Override
    public boolean validatePanel(XMLElement xMLElement, XMLPanel xMLPanel) {
        try {
            Method method;
            Class<Object> clazz;
            block8: {
                clazz = xMLElement.getClass();
                method = null;
                try {
                    method = this.getClass().getMethod("validatePanel", clazz, XMLPanel.class);
                }
                catch (Exception exception) {
                    if (clazz == XMLSimpleElement.class || clazz == XMLAttribute.class || clazz == XMLComplexChoice.class || clazz == XMLComplexElement.class || clazz == XMLCollectionElement.class || clazz == XMLCollection.class) break block8;
                    if (XMLComplexChoice.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexChoice.class;
                    }
                    if (XMLAttribute.class.isAssignableFrom(clazz)) {
                        clazz = XMLAttribute.class;
                    }
                    if (XMLSimpleElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLSimpleElement.class;
                    }
                    if (XMLComplexElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexElement.class;
                    }
                    if (!XMLCollection.class.isAssignableFrom(clazz)) break block8;
                    clazz = XMLCollection.class;
                }
            }
            method = this.getClass().getMethod("validatePanel", clazz, XMLPanel.class);
            return (Boolean)method.invoke((Object)this, xMLElement, xMLPanel);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.standardPanelValidation(xMLElement, xMLPanel);
        }
    }

    public boolean standardPanelValidation(XMLElement xMLElement, XMLPanel xMLPanel) {
        boolean bl = false;
        if (xMLElement instanceof XMLCollectionElement || xMLElement instanceof Package) {
            bl = true;
        } else if (xMLElement instanceof XMLAttribute && xMLElement.toName().equals("Id") && (xMLElement.getParent() instanceof XMLCollectionElement || xMLElement.getParent() instanceof Package)) {
            bl = true;
        }
        if (bl && !this.validateId(xMLPanel, xMLElement)) {
            return false;
        }
        if ((xMLElement instanceof Transition || xMLElement instanceof Condition || xMLElement.getParent() instanceof Transition || xMLElement.getParent() instanceof Condition) && !this.validateTransition(xMLPanel, xMLElement)) {
            return false;
        }
        return !(xMLElement instanceof Association) && !(xMLElement.getParent() instanceof Association) || this.validateAssociation(xMLPanel, xMLElement);
    }

    protected boolean validateId(XMLPanel xMLPanel, XMLElement xMLElement) {
        XMLComplexElement xMLComplexElement = null;
        String string = null;
        XMLPanel xMLPanel2 = null;
        if (xMLElement instanceof XMLAttribute) {
            XMLElement xMLElement2 = xMLElement.getParent();
            if (xMLElement2 instanceof XMLCollectionElement) {
                xMLComplexElement = (XMLCollectionElement)xMLElement2;
                string = xMLComplexElement.get("Id").toValue();
                if (xMLPanel.getValue() instanceof String) {
                    string = ((String)xMLPanel.getValue()).trim();
                    xMLPanel2 = xMLPanel;
                }
            } else if (xMLElement2 instanceof Package) {
                xMLComplexElement = (Package)xMLElement2;
                string = xMLComplexElement.get("Id").toValue();
                if (xMLPanel.getValue() instanceof String) {
                    string = ((String)xMLPanel.getValue()).trim();
                    xMLPanel2 = xMLPanel;
                }
            }
        } else if (xMLElement instanceof XMLComplexElement) {
            xMLComplexElement = (XMLComplexElement)xMLElement;
            string = xMLComplexElement.get("Id").toValue();
            xMLPanel2 = StandardPanelValidator.findPanel(xMLPanel, xMLComplexElement.get("Id"));
            if (xMLPanel2 == null) {
                xMLPanel2 = xMLPanel;
            }
            if (xMLPanel2 != null) {
                if (xMLPanel2.getValue() instanceof String) {
                    string = ((String)xMLPanel2.getValue()).trim();
                }
                if (xMLPanel2.getValue() instanceof XMLCollectionElement) {
                    string = ((XMLCollectionElement)xMLPanel2.getValue()).getId().trim();
                }
            }
        }
        System.err.println("Valid for " + xMLElement + ", par=" + xMLElement.getParent() + ", newid=" + string + ", idp=" + xMLPanel2);
        boolean bl = XMLUtil.isIdValid((String)string);
        if (!bl) {
            XMLBasicPanel.errorMessage(xMLPanel.getWindow(), ResourceManager.getLanguageDependentString("ErrorMessageKey"), "", ResourceManager.getLanguageDependentString("ERROR_INVALID_ID"));
            xMLPanel2.requestFocus();
            return false;
        }
        if (xMLComplexElement != null) {
            boolean bl2 = true;
            if (xMLComplexElement instanceof XMLCollectionElement) {
                bl2 = JaWEManager.getInstance().getIdFactory().isIdUnique((XMLCollectionElement)xMLComplexElement, string);
            } else {
                Package package_ = JaWEManager.getInstance().getXPDLHandler().getPackageById(string);
                if (package_ != null && package_ != xMLComplexElement && package_.getId().equals(string)) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                XMLBasicPanel.errorMessage(xMLPanel.getWindow(), ResourceManager.getLanguageDependentString("ErrorMessageKey"), "", ResourceManager.getLanguageDependentString("ERROR_NON_UNIQUE_ID"));
                xMLPanel2.requestFocus();
                return false;
            }
        }
        return true;
    }

    protected boolean validateTransition(XMLPanel xMLPanel, XMLElement xMLElement) {
        boolean bl;
        Object object;
        Object object2;
        Transition transition = XMLUtil.getTransition((XMLElement)xMLElement);
        String string = transition.getFrom();
        String string2 = transition.getTo();
        Object object3 = string;
        Object object4 = string2;
        String string3 = transition.getCondition().getType();
        if (xMLElement instanceof Transition) {
            object2 = StandardPanelValidator.findPanel(xMLPanel, transition.get("From"));
            if (object2 != null) {
                object = ((XMLPanel)object2).getValue();
                if (object instanceof XMLElement) {
                    if (object instanceof Activity) {
                        object3 = ((Activity)object).getId();
                    }
                } else if (object instanceof String) {
                    object3 = ((String)object).trim();
                }
            }
            if ((object2 = StandardPanelValidator.findPanel(xMLPanel, transition.get("To"))) != null) {
                object = ((XMLPanel)object2).getValue();
                if (object instanceof XMLElement) {
                    if (object instanceof Activity) {
                        object4 = ((Activity)object).getId();
                    }
                } else if (object instanceof String) {
                    object4 = ((String)object).trim();
                }
            }
            if ((object2 = StandardPanelValidator.findPanel(xMLPanel, (XMLElement)((Condition)transition.get("Condition")).getTypeAttribute())) != null && (object = ((XMLPanel)object2).getValue()) instanceof String) {
                string3 = ((String)object).trim();
            }
        } else if (xMLElement instanceof XMLAttribute && (xMLElement.toName().equals("From") || xMLElement.toName().equals("To"))) {
            object2 = xMLPanel.getValue();
            object = null;
            if (object2 instanceof XMLElement) {
                if (object2 instanceof Activity) {
                    object = ((Activity)object2).getId();
                }
            } else if (object2 instanceof String) {
                object = ((String)object2).trim();
            }
            if (object != null) {
                if (xMLElement.toName().equals("From")) {
                    object3 = object;
                } else {
                    object4 = object;
                }
            }
        } else if (xMLElement instanceof Condition) {
            object2 = StandardPanelValidator.findPanel(xMLPanel, (XMLElement)((Condition)transition.get("Condition")).getTypeAttribute());
            if (object2 != null && (object = ((XMLPanel)object2).getValue()) instanceof String) {
                string3 = ((String)object).trim();
            }
        } else if (xMLElement instanceof XMLAttribute && xMLElement.getParent() instanceof Condition && xMLElement.toName().equals("Type") && (object2 = xMLPanel.getValue()) instanceof String) {
            string3 = ((String)object2).trim();
        }
        object2 = (Activities)((XMLCollectionElement)transition.getParent().getParent()).get("Activities");
        object = object2.getActivity((String)object3);
        Activity activity = object2.getActivity((String)object4);
        if (object == null || activity == null) {
            return false;
        }
        TransitionHandler transitionHandler = JaWEManager.getInstance().getTransitionHandler();
        ArrayList arrayList = new ArrayList();
        boolean bl2 = false;
        if (string3.equals("EXCEPTION") || string3.equals("DEFAULTEXCEPTION")) {
            bl2 = true;
        }
        if (!(bl = transitionHandler.allowsConnection((Activity)object, activity, transition, bl2, arrayList))) {
            String string4 = "WarningSourceActivityCannotHaveMoreOutgoingTransitions";
            if ((Integer)arrayList.get(0) == 2) {
                string4 = "WarningTargetActivityCannotHaveMoreIncomingTransitions";
            } else if ((Integer)arrayList.get(0) == 3) {
                string4 = "ErrorActivityCannotHaveMoreThenOneIncomingOutgoingTransitionFromToTheSameActivity";
            }
            XMLBasicPanel.errorMessage(xMLPanel.getWindow(), ResourceManager.getLanguageDependentString("ErrorMessageKey"), "", ResourceManager.getLanguageDependentString(string4));
        }
        return bl;
    }

    protected boolean validateAssociation(XMLPanel xMLPanel, XMLElement xMLElement) {
        Activity activity;
        Object object;
        Object object2;
        Association association = XMLUtil.getAssociation((XMLElement)xMLElement);
        String string = association.getSource();
        String string2 = association.getTarget();
        String string3 = string;
        String string4 = string2;
        if (xMLElement instanceof Association) {
            object2 = StandardPanelValidator.findPanel(xMLPanel, association.get("Source"));
            if (object2 != null) {
                object = ((XMLPanel)object2).getValue();
                if (object instanceof XMLCollectionElement) {
                    string3 = ((XMLCollectionElement)object).getId();
                } else if (object instanceof String) {
                    string3 = ((String)object).trim();
                }
            }
            if ((object2 = StandardPanelValidator.findPanel(xMLPanel, association.get("Target"))) != null) {
                object = ((XMLPanel)object2).getValue();
                if (object instanceof XMLCollectionElement) {
                    string4 = ((XMLCollectionElement)object).getId();
                } else if (object instanceof String) {
                    string4 = ((String)object).trim();
                }
            }
        } else if (xMLElement instanceof XMLAttribute && (xMLElement.toName().equals("Source") || xMLElement.toName().equals("Target"))) {
            object2 = xMLPanel.getValue();
            object = null;
            if (object2 instanceof XMLCollectionElement) {
                object = ((XMLCollectionElement)object2).getId();
            } else if (object2 instanceof String) {
                object = ((String)object2).trim();
            }
            if (object != null) {
                if (xMLElement.toName().equals("Source")) {
                    string3 = object;
                } else {
                    string4 = object;
                }
            }
        }
        object2 = XMLUtil.getPackage((XMLElement)xMLElement);
        object = object2.getActivity(string3);
        if (object == null) {
            object = object2.getArtifact(string3);
        }
        if ((activity = object2.getActivity(string4)) == null) {
            activity = object2.getArtifact(string4);
        }
        if (object == null || activity == null || object instanceof Activity && activity instanceof Activity || object instanceof Artifact && activity instanceof Artifact) {
            XMLBasicPanel.errorMessage(xMLPanel.getWindow(), ResourceManager.getLanguageDependentString("ErrorMessageKey"), "", ResourceManager.getLanguageDependentString("ErrorImproperAssociationConnection"));
            return false;
        }
        return true;
    }

    public static XMLPanel findPanel(XMLPanel xMLPanel, XMLElement xMLElement) {
        if (xMLPanel instanceof XMLTabbedPanel) {
            return ((XMLTabbedPanel)xMLPanel).getPanelForElement(xMLElement);
        }
        if (xMLPanel instanceof XMLGroupPanel) {
            return ((XMLGroupPanel)xMLPanel).getPanelForElement(xMLElement);
        }
        return null;
    }

    @Override
    public Settings getSettings() {
        return null;
    }
}

