/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels;

import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.enhydra.jawe.ButtonPropertyChangedListener;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.NewActionBase;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.controller.JaWETypeChoiceButton;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.panels.XMLElementView;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.elements.Member;

public class PanelUtilities {
    public static List toXMLElementViewList(PanelContainer panelContainer, Collection collection, boolean bl) {
        ArrayList<XMLElementView> arrayList = new ArrayList<XMLElementView>();
        for (Object e : collection) {
            if (e instanceof XMLElement) {
                XMLElement xMLElement = (XMLElement)e;
                arrayList.add(new XMLElementView(panelContainer, xMLElement, 1));
                continue;
            }
            arrayList.add(new XMLElementView(panelContainer, (String)e, bl));
        }
        return arrayList;
    }

    public static JButton createToolbarButton(Settings settings, Action action) {
        return PanelUtilities.createToolbarButton(settings, action, null);
    }

    public static JButton createToolbarButton(Settings settings, Action action, ChoiceButtonListener choiceButtonListener) {
        if (action == null) {
            return null;
        }
        String string = (String)action.getValue("Name");
        JButton jButton = null;
        ImageIcon imageIcon = (ImageIcon)settings.getSetting("DefaultAction.Icon." + string);
        jButton = action instanceof NewActionBase && choiceButtonListener != null ? new JaWETypeChoiceButton(JaWEType.class, ((NewActionBase)action).getXPDLTypeClass(), ((NewActionBase)action).getXPDLTypeClassParentForEA(), choiceButtonListener, imageIcon) : new JButton(imageIcon){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        jButton.setName(string);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        jButton.setRequestFocusEnabled(false);
        jButton.addActionListener(action);
        action.addPropertyChangeListener(new ButtonPropertyChangedListener(jButton));
        String string2 = settings.getLanguageDependentString(string + "Tooltip");
        if (string2 != null) {
            jButton.setToolTipText(string2);
        }
        return jButton;
    }

    public static boolean isForModalDialog(XMLElement xMLElement) {
        boolean bl = true;
        if (xMLElement instanceof XMLSimpleElement) {
            return true;
        }
        if (xMLElement instanceof XMLComplexElement && !(xMLElement instanceof Member)) {
            ArrayList arrayList = ((XMLComplexElement)xMLElement).toElements();
            for (int i = 0; i < arrayList.size(); ++i) {
                Object e = arrayList.get(i);
                if (e instanceof XMLSimpleElement || e instanceof XMLAttribute) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static boolean isModifyingEvent(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown() && (keyEvent.getKeyCode() == 16 || keyEvent.getKeyCode() == 36)) {
            return false;
        }
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 88) {
            return true;
        }
        if (!keyEvent.isAltDown() && !keyEvent.isControlDown() && !keyEvent.isAltGraphDown() || keyEvent.isControlDown() && keyEvent.getKeyCode() == 86) {
            int n = keyEvent.getKeyCode();
            return n != 27 && n != 37 && n != 39 && n != 38 && n != 40;
        }
        return false;
    }
}

