/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.enhydra.jawe.ChoiceButton;
import org.enhydra.jawe.ChoiceButtonListener;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.NewActionBase;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.base.controller.JaWESelectionManager;
import org.enhydra.jawe.base.controller.JaWEType;
import org.enhydra.jawe.base.editor.StandardXPDLElementEditor;
import org.enhydra.jawe.base.panel.InlinePanel;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.panels.PanelUtilities;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLElementView;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;
import org.enhydra.jxpdl.elements.ExtendedAttributes;

public class XMLListPanel
extends XMLBasicPanel
implements XMLElementChangeListener,
FocusListener,
ChoiceButtonListener {
    protected static Dimension minimalDimension = new Dimension(250, 60);
    protected static Dimension listDimension = new Dimension(450, 150);
    protected XMLElementView movingElement;
    protected int movingElementPosition;
    protected int newMovingElementPosition;
    protected boolean dragging = false;
    protected boolean changing = false;
    protected boolean lostFocusHandle = true;
    protected JList allParam;
    protected JPanel toolbox;
    protected InlinePanel ipc;
    protected NewActionBase newElementAction = null;
    protected boolean notifyPanel;
    protected Action duplicateElementAction = new AbstractAction("Duplicate"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLListPanel.this.getSelectedElement();
            if (xMLElement != null) {
                JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
                XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                XMLListPanel.this.allParam.clearSelection();
                jaWESelectionManager.setSelection(xMLElement, false);
                JaWEManager.getInstance().getJaWEController().getEdit().duplicate();
                if (!XMLListPanel.this.setSelectedElement(jaWESelectionManager.getSelectedElement())) {
                    jaWESelectionManager.setSelection(XMLListPanel.this.ipc.getActiveElement(), false);
                }
                XMLListPanel.this.adjustActions();
                XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
            }
        }
    };
    protected Action editElementAction = new AbstractAction("EditProperties"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLListPanel.this.getSelectedElement();
            if (xMLElement != null) {
                if (XMLListPanel.this.ipc.isModified()) {
                    XMLListPanel.this.lostFocusHandle = false;
                    int n = XMLListPanel.this.ipc.showModifiedWarning();
                    if (n == 2 || n == 0 && XMLListPanel.this.ipc.isModified()) {
                        XMLListPanel.this.lostFocusHandle = true;
                        return;
                    }
                }
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
            }
        }
    };
    protected Action deleteElementAction = new AbstractAction("Delete"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLElement xMLElement = XMLListPanel.this.getSelectedElement();
            if (xMLElement != null) {
                XMLElement xMLElement2 = xMLElement.getParent();
                XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                XMLListPanel.this.lostFocusHandle = false;
                JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
                jaWESelectionManager.setSelection(xMLElement, false);
                JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("Delete").actionPerformed(null);
                XMLListPanel.this.ipc.getHistoryManager().removeFromHistory(xMLElement);
                XMLListPanel.this.ipc.getPanelSettings().adjustActions();
                XMLElement xMLElement3 = jaWESelectionManager.getSelectedElement();
                if (xMLElement3 != xMLElement2 && !XMLListPanel.this.setSelectedElement(xMLElement3)) {
                    jaWESelectionManager.setSelection(XMLListPanel.this.ipc.getActiveElement(), true);
                }
                XMLListPanel.this.lostFocusHandle = true;
                XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
                XMLListPanel.this.adjustActions();
            }
        }
    };
    protected Action referencesElementAction = new AbstractAction("References"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("References").actionPerformed(null);
        }
    };
    protected Action moveUpAction = new AbstractAction("MoveUp"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
            XMLListPanel.this.lostFocusHandle = false;
            XMLListPanel.this.moveItem(0);
            XMLListPanel.this.lostFocusHandle = true;
            XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
            XMLListPanel.this.adjustActions();
        }
    };
    protected Action moveDownAction = new AbstractAction("MoveDown"){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
            XMLListPanel.this.lostFocusHandle = false;
            XMLListPanel.this.moveItem(1);
            XMLListPanel.this.lostFocusHandle = true;
            XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
            XMLListPanel.this.adjustActions();
        }
    };

    public XMLListPanel(final InlinePanel inlinePanel, final XMLCollection xMLCollection, List list, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super(inlinePanel, (XMLElement)xMLCollection, string, true, bl, bl2);
        this.ipc = inlinePanel;
        this.notifyPanel = bl6;
        Class<?> clazz = null;
        if (xMLCollection instanceof ExtendedAttributes) {
            clazz = xMLCollection.getParent().getClass();
        }
        this.newElementAction = new NewActionBase(inlinePanel.getJaWEComponent(), "New", xMLCollection.getClass(), clazz){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                inlinePanel.getJaWEComponent().setUpdateInProgress(true);
                XMLListPanel.this.lostFocusHandle = false;
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection((XMLElement)xMLCollection, false);
                XMLListPanel.this.allParam.clearSelection();
                XMLListPanel.this.adjustActions();
            }

            @Override
            public void enableDisableAction() {
                this.setEnabled(JaWEManager.getInstance().getJaWEController().canCreateElement((XMLCollection)XMLListPanel.this.getOwner()));
            }
        };
        xMLCollection.addListener((XMLElementChangeListener)this);
        xMLCollection.setNotifyListeners(true);
        this.allParam = this.createList();
        this.setupList(bl3);
        this.fillListContent(list);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setAlignmentX(0.0f);
        jScrollPane.setViewportView(this.allParam);
        if (!bl4) {
            jScrollPane.setPreferredSize(new Dimension(listDimension));
        } else {
            jScrollPane.setPreferredSize(new Dimension(minimalDimension));
        }
        this.toolbox = this.createToolbar(bl5);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(jScrollPane);
        this.add(this.toolbox);
        this.add(Box.createVerticalStrut(3));
        this.add(jPanel);
        this.allParam.addFocusListener(this);
        this.adjustActions();
    }

    public boolean isItemChangingPosition() {
        return this.changing || this.dragging;
    }

    public JList getList() {
        return this.allParam;
    }

    public XMLElement getSelectedElement() {
        if (this.allParam.getSelectedIndex() == -1) {
            return null;
        }
        return ((XMLElementView)this.allParam.getSelectedValue()).getElement();
    }

    public boolean setSelectedElement(XMLElement xMLElement) {
        int n = -1;
        XMLElementView xMLElementView = this.getRow(xMLElement);
        for (int i = 0; i < this.allParam.getModel().getSize(); ++i) {
            XMLElementView xMLElementView2 = (XMLElementView)this.allParam.getModel().getElementAt(i);
            if (!xMLElementView.equals(xMLElementView2)) continue;
            n = i;
            break;
        }
        if (n != -1) {
            this.allParam.setSelectedIndex(n);
        }
        return n != -1;
    }

    protected void moveItem(int n) {
        this.newMovingElementPosition = this.movingElementPosition;
        if (this.newMovingElementPosition == -1) {
            return;
        }
        this.newMovingElementPosition = n == 0 ? --this.newMovingElementPosition : ++this.newMovingElementPosition;
        this.moveItem();
    }

    protected void moveItem() {
        this.changing = true;
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        int n = defaultListModel.getSize();
        if (this.movingElement == null || this.movingElementPosition == -1 || this.newMovingElementPosition == -1 || this.newMovingElementPosition == this.movingElementPosition || n - 1 < this.movingElementPosition || n - 1 < this.newMovingElementPosition || !xMLCollection.contains(this.movingElement.getElement())) {
            this.changing = false;
            return;
        }
        XMLCollection xMLCollection2 = (XMLCollection)this.getOwner();
        if (JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection2, this.movingElement.getElement())) {
            this.ipc.getJaWEComponent().setUpdateInProgress(true);
            XMLElement xMLElement = ((XMLElementView)defaultListModel.getElementAt(this.newMovingElementPosition)).getElement();
            int n2 = xMLCollection.indexOf(xMLElement);
            defaultListModel.remove(this.movingElementPosition);
            defaultListModel.add(this.newMovingElementPosition, this.movingElement);
            JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
            jaWEController.startUndouableChange();
            xMLCollection.reposition(this.movingElement.getElement(), n2);
            ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
            arrayList.add(this.movingElement.getElement());
            jaWEController.endUndouableChange(arrayList);
            try {
                this.allParam.setSelectedIndex(this.newMovingElementPosition);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.movingElementPosition = this.newMovingElementPosition;
            this.ipc.getJaWEComponent().setUpdateInProgress(false);
        }
        this.changing = false;
    }

    protected JList createList() {
        DefaultListModel defaultListModel = new DefaultListModel();
        JList jList = new JList(defaultListModel);
        Color color = new Color(245, 245, 245);
        if (this.ipc.getSettings() instanceof PanelSettings) {
            color = ((PanelSettings)this.ipc.getSettings()).getBackgroundColor();
        }
        jList.setBackground(color);
        return jList;
    }

    protected void setupList(final boolean bl) {
        this.allParam.setSelectionMode(0);
        this.allParam.setAlignmentX(0.0f);
        this.allParam.setAlignmentY(0.0f);
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        final boolean bl2 = JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, null);
        this.allParam.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (bl && mouseEvent.getClickCount() > 1) {
                    XMLListPanel.this.editElementAction.actionPerformed(null);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (!XMLListPanel.this.getOwner().isReadOnly() && bl2) {
                    XMLListPanel.this.dragging = true;
                }
                XMLListPanel.this.movingElement = null;
                XMLListPanel.this.movingElementPosition = -1;
                try {
                    XMLListPanel.this.movingElementPosition = XMLListPanel.this.allParam.getSelectedIndex();
                    if (XMLListPanel.this.movingElementPosition >= 0) {
                        XMLListPanel.this.movingElement = (XMLElementView)XMLListPanel.this.allParam.getSelectedValue();
                        XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(XMLListPanel.this.getSelectedElement(), false);
                        XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
                        XMLListPanel.this.adjustActions();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (XMLListPanel.this.changing) {
                    XMLListPanel.this.changing = false;
                    return;
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                XMLListPanel.this.dragging = false;
            }
        });
        if (!this.myOwner.isReadOnly() && bl2) {
            this.allParam.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (XMLListPanel.this.dragging) {
                        if (!XMLListPanel.this.changing) {
                            XMLListPanel.this.newMovingElementPosition = -1;
                            try {
                                XMLListPanel.this.newMovingElementPosition = XMLListPanel.this.allParam.getSelectedIndex();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            XMLListPanel.this.moveItem();
                        }
                        return;
                    }
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    try {
                        XMLElement xMLElement = XMLListPanel.this.getSelectedElement();
                        if (xMLElement != null) {
                            XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(true);
                            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
                            XMLListPanel.this.ipc.getJaWEComponent().setUpdateInProgress(false);
                            XMLListPanel.this.adjustActions();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        if (bl) {
            this.allParam.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0, false), "edit");
            this.allParam.getActionMap().put("edit", this.editElementAction);
            this.allParam.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0, false), "delete");
            this.allParam.getActionMap().put("delete", this.deleteElementAction);
        }
        if (!this.getOwner().isReadOnly() && bl2) {
            this.allParam.setToolTipText(this.pc.getLanguageDependentString("MessageDragItemToChangeItsPosition"));
        }
    }

    protected void fillListContent(List list) {
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        for (XMLElement xMLElement : list) {
            XMLElementView xMLElementView = this.getRow(xMLElement);
            defaultListModel.addElement(xMLElementView);
        }
    }

    protected XMLElementView getRow(XMLElement xMLElement) {
        return new XMLElementView((PanelContainer)this.ipc, xMLElement, 1);
    }

    protected JPanel createToolbar(boolean bl) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        JButton jButton = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.newElementAction, this);
        jButton.setRolloverEnabled(true);
        JButton jButton2 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.editElementAction);
        jButton2.setRolloverEnabled(true);
        JButton jButton3 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.referencesElementAction);
        jButton3.setRolloverEnabled(true);
        JButton jButton4 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.deleteElementAction);
        jButton4.setRolloverEnabled(true);
        JButton jButton5 = PanelUtilities.createToolbarButton(this.ipc.getSettings(), this.duplicateElementAction);
        jButton5.setRolloverEnabled(true);
        jPanel.add(jButton);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton2);
        jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
        jPanel.add(jButton4);
        jPanel.add(Box.createRigidArea(new Dimension(5, 3)));
        if (!bl) {
            jPanel.add(jButton5);
            jPanel.add(Box.createRigidArea(new Dimension(3, 3)));
            jPanel.add(jButton3);
        }
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    protected JPanel createArrowPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        XMLCollection xMLCollection = (XMLCollection)this.getOwner();
        boolean bl = JaWEManager.getInstance().getJaWEController().canRepositionElement(xMLCollection, null);
        JButton jButton = new JButton();
        jButton.setIcon(this.ipc.getPanelSettings().getArrowUpImageIcon());
        jButton.setPreferredSize(new Dimension(16, 16));
        jButton.setEnabled(!this.myOwner.isReadOnly() && bl);
        jButton.addActionListener(this.moveUpAction);
        JButton jButton2 = new JButton();
        jButton2.setIcon(this.ipc.getPanelSettings().getArrowDownImageIcon());
        jButton2.setPreferredSize(new Dimension(16, 16));
        jButton2.setEnabled(!this.myOwner.isReadOnly() && bl);
        jButton2.addActionListener(this.moveDownAction);
        jPanel.add(jButton);
        jPanel.add(Box.createVerticalGlue());
        jPanel.add(jButton2);
        return jPanel;
    }

    protected void adjustActions() {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        JaWESelectionManager jaWESelectionManager = jaWEController.getSelectionManager();
        this.newElementAction.enableDisableAction();
        this.editElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canEditProperties());
        this.duplicateElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canDuplicate());
        this.deleteElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canDelete());
        this.referencesElementAction.setEnabled(this.getSelectedElement() != null && jaWESelectionManager.canGetReferences());
        boolean bl = JaWEManager.getInstance().getJaWEController().canRepositionElement((XMLCollection)this.getOwner(), null);
        this.moveUpAction.setEnabled(this.getSelectedElement() != null && this.allParam.getSelectedIndex() > 0 && bl);
        this.moveDownAction.setEnabled(this.getSelectedElement() != null && this.allParam.getSelectedIndex() < this.allParam.getModel().getSize() - 1 && bl);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.lostFocusHandle && !this.ipc.getJaWEComponent().isUpdateInProgress()) {
            JaWESelectionManager jaWESelectionManager = JaWEManager.getInstance().getJaWEController().getSelectionManager();
            List list = jaWESelectionManager.getSelectedElements();
            XMLElement xMLElement = null;
            if (list != null && list.size() > 0) {
                xMLElement = (XMLElement)list.get(0);
            }
            if (xMLElement != null && ((XMLCollection)this.getOwner()).contains(xMLElement)) {
                this.ipc.getJaWEComponent().setUpdateInProgress(true);
                jaWESelectionManager.setSelection(this.ipc.getActiveElement(), false);
                this.ipc.getJaWEComponent().setUpdateInProgress(false);
            }
            this.allParam.clearSelection();
        }
        this.adjustActions();
    }

    public void xmlElementChanged(XMLElementChangeInfo xMLElementChangeInfo) {
        if (xMLElementChangeInfo.getAction() == 5) {
            for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                this.removeElement(xMLElement);
            }
            if (this.notifyPanel) {
                this.getPanelContainer().panelChanged(this, null);
            }
        } else if (xMLElementChangeInfo.getAction() == 3) {
            for (XMLElement xMLElement : xMLElementChangeInfo.getChangedSubElements()) {
                this.addElement(xMLElement);
            }
            if (this.notifyPanel) {
                this.getPanelContainer().panelChanged(this, null);
            }
        }
    }

    public void addElement(XMLElement xMLElement) {
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        XMLElementView xMLElementView = this.getRow(xMLElement);
        defaultListModel.addElement(xMLElementView);
    }

    public void removeElement(XMLElement xMLElement) {
        DefaultListModel defaultListModel = (DefaultListModel)this.allParam.getModel();
        XMLElementView xMLElementView = this.getRow(xMLElement);
        if (xMLElementView != null) {
            defaultListModel.removeElement(xMLElementView);
        }
    }

    @Override
    public void cleanup() {
        this.myOwner.removeListener((XMLElementChangeListener)this);
        this.allParam.removeFocusListener(this);
        this.allParam = null;
    }

    @Override
    public void selectionChanged(ChoiceButton choiceButton, Object object) {
        this.ipc.getJaWEComponent().setUpdateInProgress(false);
        this.lostFocusHandle = true;
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        JaWESelectionManager jaWESelectionManager = jaWEController.getSelectionManager();
        if (choiceButton.getChoiceType().equals(JaWEType.class)) {
            XMLElement xMLElement;
            JaWEType jaWEType = (JaWEType)object;
            String string = null;
            if (jaWEType != null) {
                string = jaWEType.getTypeId();
            }
            if (!((xMLElement = (XMLElement)jaWEController.getSelectionManager().getSelectedElements().toArray()[0]) instanceof XMLCollection)) {
                xMLElement = xMLElement.getParent();
            }
            if (xMLElement instanceof XMLCollection) {
                Serializable serializable;
                int n;
                XMLCollection xMLCollection = (XMLCollection)xMLElement;
                XMLElement xMLElement2 = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(xMLCollection, string, false);
                boolean bl = PanelUtilities.isForModalDialog(xMLElement2);
                if (!bl && this.ipc.isModified() && ((n = this.ipc.showModifiedWarning()) == 2 || n == 0 && this.ipc.isModified())) {
                    this.ipc.getJaWEComponent().setUpdateInProgress(true);
                    jaWESelectionManager.setSelection(this.ipc.getActiveElement(), true);
                    this.ipc.getJaWEComponent().setUpdateInProgress(false);
                    return;
                }
                n = 0;
                if (bl) {
                    this.lostFocusHandle = false;
                    this.ipc.getJaWEComponent().setUpdateInProgress(true);
                    serializable = new StandardXPDLElementEditor();
                    ((StandardXPDLElementEditor)serializable).editXPDLElement(xMLElement2);
                    this.ipc.getJaWEComponent().setUpdateInProgress(false);
                    this.lostFocusHandle = true;
                    boolean bl2 = ((StandardXPDLElementEditor)serializable).getStatus() == 0;
                    boolean bl3 = true;
                    if (bl2) {
                        bl3 = jaWEController.canInsertElement(xMLCollection, xMLElement2);
                    }
                    if (!bl2 || !bl3) {
                        if (!bl3) {
                            jaWEController.message(((StandardXPDLElementEditor)serializable).getLanguageDependentString("WarningCannotInsertElement"), 2);
                        }
                        this.ipc.getJaWEComponent().setUpdateInProgress(true);
                        jaWESelectionManager.setSelection(this.ipc.getActiveElement(), true);
                        this.ipc.getJaWEComponent().setUpdateInProgress(false);
                        return;
                    }
                    n = 1;
                }
                if (n != 0) {
                    this.ipc.getJaWEComponent().setUpdateInProgress(true);
                }
                jaWEController.startUndouableChange();
                xMLCollection.add(xMLElement2);
                serializable = new ArrayList();
                serializable.add(xMLElement2);
                jaWEController.endUndouableChange((List)((Object)serializable));
                if (n != 0) {
                    this.setSelectedElement(xMLElement2);
                    this.adjustActions();
                    this.ipc.getJaWEComponent().setUpdateInProgress(false);
                }
            }
        }
    }

    @Override
    public Object getSelectedObject(ChoiceButton choiceButton) {
        return null;
    }

    @Override
    public List getChoices(ChoiceButton choiceButton) {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        ArrayList arrayList = new ArrayList();
        if (choiceButton.getChoiceType().equals(JaWEType.class)) {
            XMLElement xMLElement = (XMLElement)jaWEController.getSelectionManager().getSelectedElements().toArray()[0];
            arrayList.addAll(jaWEController.getJaWETypes().getTypes(xMLElement));
        }
        return arrayList;
    }

    @Override
    public boolean isEmpty() {
        return this.allParam.getModel().getSize() == 0;
    }

    @Override
    public boolean validateEntry() {
        if (this.isEmpty() && this.getOwner().isRequired() && !this.getOwner().isReadOnly()) {
            XMLBasicPanel.defaultErrorMessage(this.getWindow(), this.getTitle() + ": ");
            this.allParam.requestFocus();
            return false;
        }
        return true;
    }
}

