/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.panel.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.enhydra.jawe.base.panel.PanelContainer;
import org.enhydra.jawe.base.panel.PanelSettings;
import org.enhydra.jawe.base.panel.panels.XMLBasicPanel;
import org.enhydra.jawe.base.panel.panels.XMLElementView;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;

public class XMLSimpleTablePanel
extends XMLBasicPanel {
    protected static Dimension miniTableDimension = new Dimension(450, 125);
    protected static Dimension smallTableDimension = new Dimension(450, 200);
    protected static Dimension mediumTableDimension = new Dimension(550, 200);
    protected static Dimension largeTableDimension = new Dimension(650, 200);
    protected JTable allItems;
    protected Vector columnNames;
    protected List columnsToShow;

    public XMLSimpleTablePanel(PanelContainer panelContainer, XMLCollection xMLCollection, List list, List list2, String string, boolean bl, boolean bl2, boolean bl3) {
        super(panelContainer, (XMLElement)xMLCollection, string, true, bl, bl2);
        this.columnNames = this.getColumnNames(list);
        this.columnsToShow = list;
        this.allItems = new JTable(new Vector(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }
        };
        Color color = new Color(245, 245, 245);
        if (panelContainer.getSettings() instanceof PanelSettings) {
            color = ((PanelSettings)panelContainer.getSettings()).getBackgroundColor();
        }
        this.allItems.setBackground(color);
        this.setupTable(bl3);
        this.fillTableContent(list2);
        this.add(this.createScrollPane());
    }

    public JTable getTable() {
        return this.allItems;
    }

    public XMLElement getSelectedElement() {
        int n = this.allItems.getSelectedRow();
        if (n >= 0) {
            return (XMLElement)this.allItems.getValueAt(n, 0);
        }
        return null;
    }

    public void addRow(XMLElement xMLElement) {
        int n = this.allItems.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        Vector vector = this.getRow(xMLElement);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(XMLElement xMLElement) {
        int n = this.getElementRow(xMLElement);
        if (n >= 0) {
            DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
            defaultTableModel.removeRow(n);
        }
    }

    public List getElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            arrayList.add(this.allItems.getValueAt(i, 0));
        }
        return arrayList;
    }

    protected Vector getColumnNames(List list) {
        Vector<String> vector = new Vector<String>();
        vector.add("Object");
        XMLElement xMLElement = ((XMLCollection)this.getOwner()).generateNewElement();
        if (xMLElement instanceof XMLComplexElement) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XMLElement xMLElement2 = ((XMLComplexElement)xMLElement).get(string);
                if (xMLElement2 != null) {
                    vector.add(this.pc.getLabelGenerator().getLabel(xMLElement2));
                    continue;
                }
                iterator.remove();
            }
        } else {
            vector.add(this.pc.getLabelGenerator().getLabel(xMLElement));
        }
        return vector;
    }

    protected void setupTable(boolean bl) {
        TableColumn tableColumn = this.allItems.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(0);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        int n = this.columnNames.size() - 1;
        Dimension dimension = n <= 3 ? new Dimension(smallTableDimension) : (n <= 5 ? new Dimension(mediumTableDimension) : new Dimension(largeTableDimension));
        if (bl) {
            dimension.width = this.allItems.getPreferredScrollableViewportSize().width;
        }
        this.allItems.setPreferredScrollableViewportSize(new Dimension(dimension));
    }

    protected void fillTableContent(List list) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (XMLElement xMLElement : list) {
            Vector vector = this.getRow(xMLElement);
            defaultTableModel.addRow(vector);
        }
    }

    protected Vector getRow(XMLElement xMLElement) {
        Vector<XMLElementView> vector = new Vector<XMLElementView>();
        if (xMLElement instanceof XMLComplexElement) {
            Iterator iterator = this.columnsToShow.iterator();
            vector = new Vector();
            XMLComplexElement xMLComplexElement = (XMLComplexElement)xMLElement;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                XMLElement xMLElement2 = xMLComplexElement.get(string);
                if (xMLElement2 == null) continue;
                vector.add(new XMLElementView(this.pc, xMLElement2, 2));
            }
        } else {
            vector.add(new XMLElementView(this.pc, xMLElement, 2));
        }
        vector.add(0, (XMLElementView)xMLElement);
        return vector;
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this.allItems);
        return jScrollPane;
    }

    protected int getElementRow(XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            XMLElement xMLElement2 = (XMLElement)this.allItems.getValueAt(i, 0);
            if (xMLElement != xMLElement2) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    public void cleanup() {
    }
}

