/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.base.tooltip;

import java.lang.reflect.Method;
import java.util.Map;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.ResourceManager;
import org.enhydra.jawe.Settings;
import org.enhydra.jawe.base.display.DisplayNameGenerator;
import org.enhydra.jawe.base.label.LabelGenerator;
import org.enhydra.jawe.base.tooltip.TooltipGenerator;
import org.enhydra.jawe.base.tooltip.TooltipGeneratorSettings;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLComplexChoice;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLEmptyChoiceElement;
import org.enhydra.jxpdl.XMLSimpleElement;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ArrayType;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.BasicType;
import org.enhydra.jxpdl.elements.DeclaredType;
import org.enhydra.jxpdl.elements.Join;
import org.enhydra.jxpdl.elements.ListType;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Split;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.utilities.SequencedHashMap;

public class StandardTooltipGenerator
implements TooltipGenerator {
    public static final String EMPTY_STRING = "";
    public static final String HTML_OPEN = "<html>";
    public static final String HTML_CLOSE = "</html>";
    public static final String STRONG_OPEN = "<strong>";
    public static final String STRONG_CLOSE = "</strong>";
    public static final String LINE_BREAK = "<br>";
    public static final String COLON_SPACE = ": ";
    protected TooltipGeneratorSettings settings;

    public StandardTooltipGenerator() {
        this.settings = new TooltipGeneratorSettings();
        this.settings.init(null);
    }

    public StandardTooltipGenerator(TooltipGeneratorSettings tooltipGeneratorSettings) {
        this.settings = tooltipGeneratorSettings;
        this.settings.init(null);
    }

    public String getTooltip(Activity activity) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, activity.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, activity.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, activity.get("Description"));
        if (activity.getFirstPerformerObj() != null) {
            this.putKeyValue((Map)sequencedHashMap, (XMLElement)activity.getFirstPerformerObj());
        }
        this.putKeyValue((Map)sequencedHashMap, activity.get("StartMode"));
        this.putKeyValue((Map)sequencedHashMap, activity.get("FinishMode"));
        this.putKeyValue((Map)sequencedHashMap, activity.get("Priority"));
        this.putKeyValue((Map)sequencedHashMap, activity.get("Limit"));
        this.fillTypePartOfTooltip(activity, (Map)sequencedHashMap);
        return this.makeTooltip((XMLElement)activity, (Map)sequencedHashMap);
    }

    protected void fillTypePartOfTooltip(Activity activity, Map map) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        String string = labelGenerator.getLabel((XMLElement)activity.getActivityTypes());
        String string2 = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)activity).getTypeId();
        String string3 = this.settings.getLanguageDependentString(string2);
        if (string3 == null || string3.equals(EMPTY_STRING)) {
            string3 = string2;
        }
        map.put(string, string3);
        if (string2.equals("ACTIVITY_TASK_APPLICATION")) {
            string = this.settings.getLanguageDependentString("ApplicationKey");
            string3 = String.valueOf(activity.getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().getTaskApplication().getId());
            map.put(string, string3);
        }
        if (string2.equals("ACTIVITY_TASK_SCRIPT")) {
            string = this.settings.getLanguageDependentString("ScriptTypeKey");
            string3 = String.valueOf(activity.getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().getTaskScript().getScript().getScriptType());
            map.put(string, string3);
            string = this.settings.getLanguageDependentString("ScriptKey");
            string3 = String.valueOf(activity.getActivityTypes().getImplementation().getImplementationTypes().getTask().getTaskTypes().getTaskScript().getScript().toValue());
            map.put(string, string3);
        }
        if (string2.equals("ACTIVITY_SUBFLOW")) {
            string = this.settings.getLanguageDependentString("ReferencedProcessKey");
            string3 = activity.getActivityTypes().getImplementation().getImplementationTypes().getSubFlow().getId();
            if (string3.equals(EMPTY_STRING)) {
                string3 = this.settings.getLanguageDependentString("NoneKey");
            }
            map.put(string, string3);
        }
        if (string2.equals("ACTIVITY_ROUTE")) {
            // empty if block
        }
        if (string2.equals("ACTIVITY_BLOCK")) {
            string = this.settings.getLanguageDependentString("ReferencedActivitySetKey");
            string3 = activity.getActivityTypes().getBlockActivity().getActivitySetId();
            if (string3.equals(EMPTY_STRING)) {
                string3 = this.settings.getLanguageDependentString("NoneKey");
            }
            map.put(string, string3);
        }
    }

    public String getTooltip(ArrayType arrayType) {
        return ResourceManager.getLanguageDependentString("SubTypeKey");
    }

    public String getTooltip(Artifact artifact) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, artifact.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, artifact.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, artifact.get("ArtifactType"));
        this.putKeyValue((Map)sequencedHashMap, artifact.get("TextAnnotation"));
        return this.makeTooltip((XMLElement)artifact, (Map)sequencedHashMap);
    }

    public String getTooltip(Association association) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, association.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, association.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, association.get("AssociationDirection"));
        this.putKeyValue((Map)sequencedHashMap, association.get("Source"));
        this.putKeyValue((Map)sequencedHashMap, association.get("Target"));
        return this.makeTooltip((XMLElement)association, (Map)sequencedHashMap);
    }

    public String getTooltip(BasicType basicType) {
        return ResourceManager.getLanguageDependentString("SubTypeKey");
    }

    public String getTooltip(DeclaredType declaredType) {
        return ResourceManager.getLanguageDependentString("SubTypeKey");
    }

    public String getTooltip(Join join) {
        return ResourceManager.getLanguageDependentString("JoinTypeKey");
    }

    public String getTooltip(ListType listType) {
        return ResourceManager.getLanguageDependentString("SubTypeKey");
    }

    public String getTooltip(Package package_) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, package_.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, package_.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, package_.getPackageHeader().get("Description"));
        return this.makeTooltip((XMLElement)package_, (Map)sequencedHashMap);
    }

    public String getTooltip(Participant participant) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, participant.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, participant.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, (XMLElement)participant.getParticipantType());
        this.putKeyValue((Map)sequencedHashMap, participant.get("Description"));
        return this.makeTooltip((XMLElement)participant, (Map)sequencedHashMap);
    }

    public String getTooltip(Split split) {
        return ResourceManager.getLanguageDependentString("SplitTypeKey");
    }

    public String getTooltip(Transition transition) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, transition.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, transition.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, transition.get("Description"));
        this.putKeyValue((Map)sequencedHashMap, transition.get("From"));
        this.putKeyValue((Map)sequencedHashMap, transition.get("To"));
        this.putKeyValue((Map)sequencedHashMap, (XMLElement)transition.getCondition().getTypeAttribute());
        sequencedHashMap.put(labelGenerator.getLabel((XMLElement)transition.getCondition()), transition.getCondition().toValue());
        return this.makeTooltip((XMLElement)transition, (Map)sequencedHashMap);
    }

    public String getTooltip(WorkflowProcess workflowProcess) {
        SequencedHashMap sequencedHashMap = new SequencedHashMap();
        this.putKeyValue((Map)sequencedHashMap, workflowProcess.get("Id"));
        this.putKeyValue((Map)sequencedHashMap, workflowProcess.get("Name"));
        this.putKeyValue((Map)sequencedHashMap, workflowProcess.get("AccessLevel"));
        this.putKeyValue((Map)sequencedHashMap, workflowProcess.getProcessHeader().get("Description"));
        return this.makeTooltip((XMLElement)workflowProcess, (Map)sequencedHashMap);
    }

    public String getTooltip(XMLEmptyChoiceElement xMLEmptyChoiceElement) {
        return this.generateStandardTooltip((XMLElement)xMLEmptyChoiceElement);
    }

    public String getTooltip(XMLComplexChoice xMLComplexChoice) {
        return this.generateStandardTooltip((XMLElement)xMLComplexChoice);
    }

    public String getTooltip(XMLCollection xMLCollection) {
        return this.generateStandardTooltip((XMLElement)xMLCollection);
    }

    public String getTooltip(XMLCollectionElement xMLCollectionElement) {
        return this.generateStandardTooltip((XMLElement)xMLCollectionElement);
    }

    public String getTooltip(XMLComplexElement xMLComplexElement) {
        return this.generateStandardTooltip((XMLElement)xMLComplexElement);
    }

    public String getTooltip(XMLSimpleElement xMLSimpleElement) {
        return this.generateStandardTooltip((XMLElement)xMLSimpleElement);
    }

    public String getTooltip(XMLAttribute xMLAttribute) {
        return this.generateStandardTooltip((XMLElement)xMLAttribute);
    }

    @Override
    public String getTooltip(XMLElement xMLElement) {
        try {
            Method method;
            Class<Object> clazz;
            block8: {
                clazz = xMLElement.getClass();
                method = null;
                try {
                    method = this.getClass().getMethod("getTooltip", clazz);
                }
                catch (Exception exception) {
                    if (clazz == XMLSimpleElement.class || clazz == XMLAttribute.class || clazz == XMLComplexChoice.class || clazz == XMLComplexElement.class || clazz == XMLCollectionElement.class || clazz == XMLCollection.class) break block8;
                    if (XMLComplexChoice.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexChoice.class;
                    }
                    if (XMLAttribute.class.isAssignableFrom(clazz)) {
                        clazz = XMLAttribute.class;
                    }
                    if (XMLSimpleElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLSimpleElement.class;
                    }
                    if (XMLComplexElement.class.isAssignableFrom(clazz)) {
                        clazz = XMLComplexElement.class;
                    }
                    if (!XMLCollection.class.isAssignableFrom(clazz)) break block8;
                    clazz = XMLCollection.class;
                }
            }
            method = this.getClass().getMethod("getTooltip", clazz);
            return (String)method.invoke((Object)this, xMLElement);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return this.generateStandardTooltip(xMLElement);
        }
    }

    public String generateStandardTooltip(XMLElement xMLElement) {
        return ResourceManager.getLanguageDependentString(xMLElement.toName() + "Key");
    }

    protected String makeTooltip(XMLElement xMLElement, Map map) {
        if (map == null) {
            return EMPTY_STRING;
        }
        String string = HTML_OPEN;
        for (Map.Entry entry : map.entrySet()) {
            string = string + this.makeAnotherHtmlLine((String)entry.getKey(), (String)entry.getValue());
        }
        string = string.substring(0, string.length() - LINE_BREAK.length());
        string = string + HTML_CLOSE;
        return string;
    }

    protected String makeAnotherHtmlLine(String string, String string2) {
        int n = 100;
        int n2 = 15;
        String string3 = EMPTY_STRING;
        string3 = string3 + STRONG_OPEN;
        string3 = string3 + string + COLON_SPACE;
        string3 = string3 + STRONG_CLOSE;
        String string4 = string2;
        string4 = string4.replaceAll("<", "&lt;");
        int n3 = (string4 = string4.replaceAll(">", "&gt;")).length();
        if (n3 > n) {
            String string5 = EMPTY_STRING;
            int n4 = n3 / n;
            for (int i = 0; i <= n4; ++i) {
                int n5 = i * n;
                int n6 = (i + 1) * n;
                if (n6 > n3) {
                    n6 = n3;
                }
                string5 = string5 + string4.substring(n5, n6);
                if (i == n2) {
                    string5 = string5 + " ...";
                    break;
                }
                if (i >= n4) continue;
                string5 = string5 + LINE_BREAK;
                string5 = string5 + this.makeEmptyHTMLText((string + COLON_SPACE).length());
            }
            string4 = string5;
        }
        string3 = string3 + string4;
        string3 = string3 + LINE_BREAK;
        return string3;
    }

    protected String makeEmptyHTMLText(int n) {
        if (n < 0) {
            return null;
        }
        String string = EMPTY_STRING;
        for (int i = 0; i < n; ++i) {
            string = string + "&nbsp;";
        }
        return string;
    }

    protected void putKeyValue(Map map, XMLElement xMLElement) {
        LabelGenerator labelGenerator = JaWEManager.getInstance().getLabelGenerator();
        DisplayNameGenerator displayNameGenerator = JaWEManager.getInstance().getDisplayNameGenerator();
        map.put(labelGenerator.getLabel(xMLElement), displayNameGenerator.getDisplayName(xMLElement));
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }
}

