/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneRendererInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneViewInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.VertexView;

public class DefaultGraphSwimlaneView
extends VertexView
implements GraphSwimlaneViewInterface {
    protected static Map renderers = new HashMap();

    public DefaultGraphSwimlaneView(Object object) {
        super(object);
    }

    public CellViewRenderer getRenderer() {
        String string = ((GraphSwimlaneInterface)super.getCell()).getType();
        GraphSwimlaneRendererInterface graphSwimlaneRendererInterface = (GraphSwimlaneRendererInterface)renderers.get(string);
        if (graphSwimlaneRendererInterface == null) {
            graphSwimlaneRendererInterface = this.createRenderer(((GraphSwimlaneInterface)super.getCell()).getUserObject());
            renderers.put(string, graphSwimlaneRendererInterface);
        }
        return graphSwimlaneRendererInterface;
    }

    public boolean intersects(JGraph jGraph, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = this.getBounds();
        boolean bl = GraphUtilities.getGraphOrientation(((Graph)jGraph).getXPDLObject()).equals("VERTICAL");
        if (rectangle2D2 != null) {
            Rectangle rectangle = bl ? new Rectangle((int)rectangle2D2.getX(), (int)rectangle2D2.getY(), (int)rectangle2D2.getWidth(), GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth()) : new Rectangle((int)rectangle2D2.getX(), (int)rectangle2D2.getY(), GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth(), (int)rectangle2D2.getHeight());
            return rectangle.intersects(rectangle2D);
        }
        return false;
    }

    @Override
    public void refreshChildViews(GraphLayoutCache graphLayoutCache, CellMapper cellMapper) {
        this.childViews.clear();
        this.refresh(graphLayoutCache, cellMapper, false);
    }

    public Rectangle2D getBounds() {
        return this.bounds;
    }

    public void addChildView(CellView cellView) {
        if (cellView != null) {
            this.childViews.add(cellView);
        }
    }

    protected GraphSwimlaneRendererInterface createRenderer(Object object) {
        return GraphUtilities.getGraphController().getGraphObjectRendererFactory().createParticipantRenderer(object);
    }
}

