/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.plaf.FontUIResource;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.components.graph.DefaultGraphActivity;
import org.enhydra.jawe.components.graph.DefaultGraphArtifact;
import org.enhydra.jawe.components.graph.DefaultGraphPort;
import org.enhydra.jawe.components.graph.DefaultGraphSwimlane;
import org.enhydra.jawe.components.graph.DefaultGraphTransition;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphPortInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphTransitionInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.enhydra.jxpdl.elements.Pool;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphConstants;

public class GraphObjectFactory {
    protected Properties properties;

    public void configure(Properties properties) throws Exception {
        this.properties = properties;
    }

    public GraphActivityInterface createActivity(Map map, Activity activity, Point point) {
        String string = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)activity).getTypeId();
        Point point2 = GraphUtilities.getOffsetPoint(activity);
        GraphActivityInterface graphActivityInterface = this.createActivityCell(activity, string);
        Map map2 = this.initActivityProperties(point, point2, activity, string);
        map.put(graphActivityInterface, map2);
        return graphActivityInterface;
    }

    protected GraphActivityInterface createActivityCell(Activity activity, String string) {
        return new DefaultGraphActivity(activity);
    }

    protected Map initActivityProperties(Point point, Point point2, Activity activity, String string) {
        AttributeMap attributeMap = new AttributeMap();
        Rectangle rectangle = null;
        int n = GraphUtilities.getGraphController().getGraphSettings().getActivityWidth();
        int n2 = GraphUtilities.getGraphController().getGraphSettings().getActivityHeight();
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity);
        if (nodeGraphicsInfo != null) {
            if (nodeGraphicsInfo.getWidth() != 0) {
                n = nodeGraphicsInfo.getWidth();
            }
            if (nodeGraphicsInfo.getHeight() != 0) {
                n2 = nodeGraphicsInfo.getHeight();
            }
        }
        if (activity.getActivityType() == 6 || activity.getActivityType() == 7) {
            if (nodeGraphicsInfo == null || nodeGraphicsInfo.getWidth() == 0) {
                n = activity.getActivityType() == 0 ? GraphUtilities.getGraphController().getGraphSettings().getGatewayWidth() : GraphUtilities.getGraphController().getGraphSettings().getEventRadius() * 2 + 1;
            }
            if (nodeGraphicsInfo == null || nodeGraphicsInfo.getHeight() == 0) {
                n2 = activity.getActivityType() == 0 ? GraphUtilities.getGraphController().getGraphSettings().getGatewayWidth() : GraphUtilities.getGraphController().getGraphSettings().getEventRadius() * 2 + 1;
            }
            rectangle = new Rectangle(point.x + point2.x, point.y + point2.y, n, n2);
        } else {
            rectangle = new Rectangle(point.x + point2.x, point.y + point2.y, n, n2);
        }
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle);
        GraphConstants.setOpaque((Map)attributeMap, (boolean)true);
        GraphConstants.setBorderColor((Map)attributeMap, (Color)Color.darkGray);
        String string2 = JaWEManager.getFontName();
        int n3 = GraphUtilities.getGraphController().getGraphSettings().getGraphFontSize();
        try {
            FontUIResource fontUIResource;
            try {
                fontUIResource = new FontUIResource(string2, 0, n3);
            }
            catch (Exception exception) {
                fontUIResource = new FontUIResource("Label.font", 0, n3);
            }
            GraphConstants.setFont((Map)attributeMap, (Font)fontUIResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributeMap;
    }

    public GraphArtifactInterface createArtifact(Map map, Artifact artifact, Point point) {
        String string = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)artifact).getTypeId();
        Point point2 = GraphUtilities.getOffsetPoint((XMLCollectionElement)artifact);
        GraphArtifactInterface graphArtifactInterface = this.createArtifactCell(artifact, string);
        Map map2 = this.initArtifactProperties(point, point2, artifact, string);
        map.put(graphArtifactInterface, map2);
        return graphArtifactInterface;
    }

    protected GraphArtifactInterface createArtifactCell(Artifact artifact, String string) {
        return new DefaultGraphArtifact(artifact);
    }

    protected Map initArtifactProperties(Point point, Point point2, Artifact artifact, String string) {
        NodeGraphicsInfo nodeGraphicsInfo;
        AttributeMap attributeMap = new AttributeMap();
        Rectangle rectangle = null;
        int n = GraphUtilities.getGraphController().getGraphSettings().getDataObjectWidth();
        int n2 = GraphUtilities.getGraphController().getGraphSettings().getDataObjectHeight();
        if (artifact.getArtifactType().equals("Annotation")) {
            n = GraphUtilities.getGraphController().getGraphSettings().getAnnotationWidth();
            n2 = GraphUtilities.getGraphController().getGraphSettings().getAnnotationHeight();
        }
        if ((nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)artifact)) != null) {
            if (nodeGraphicsInfo.getWidth() != 0) {
                n = nodeGraphicsInfo.getWidth();
            }
            if (nodeGraphicsInfo.getHeight() != 0) {
                n2 = nodeGraphicsInfo.getHeight();
            }
        }
        rectangle = new Rectangle(point.x + point2.x, point.y + point2.y, n, n2);
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle);
        GraphConstants.setOpaque((Map)attributeMap, (boolean)true);
        GraphConstants.setBorderColor((Map)attributeMap, (Color)Color.darkGray);
        String string2 = JaWEManager.getFontName();
        int n3 = GraphUtilities.getGraphController().getGraphSettings().getGraphFontSize();
        try {
            FontUIResource fontUIResource;
            try {
                fontUIResource = new FontUIResource(string2, 0, n3);
            }
            catch (Exception exception) {
                fontUIResource = new FontUIResource("Label.font", 0, n3);
            }
            GraphConstants.setFont((Map)attributeMap, (Font)fontUIResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributeMap;
    }

    public GraphSwimlaneInterface createParticipant(Rectangle rectangle, Map map, Object object) {
        GraphSwimlaneInterface graphSwimlaneInterface = this.createParticipantCell(object);
        Map map2 = this.initParticipantProperties(rectangle, object);
        map.put(graphSwimlaneInterface, map2);
        return graphSwimlaneInterface;
    }

    protected GraphSwimlaneInterface createParticipantCell(Object object) {
        if (object instanceof Pool) {
            return new DefaultGraphSwimlane((Pool)object);
        }
        if (object instanceof Lane) {
            return new DefaultGraphSwimlane((Lane)object);
        }
        return null;
    }

    protected Map initParticipantProperties(Rectangle rectangle, Object object) {
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)rectangle);
        GraphConstants.setOpaque((Map)attributeMap, (boolean)false);
        GraphConstants.setBorderColor((Map)attributeMap, (Color)Color.black);
        GraphConstants.setMoveable((Map)attributeMap, (boolean)false);
        GraphConstants.setSizeable((Map)attributeMap, (boolean)false);
        String string = JaWEManager.getFontName();
        int n = GraphUtilities.getGraphController().getGraphSettings().getGraphFontSize();
        try {
            FontUIResource fontUIResource;
            try {
                fontUIResource = new FontUIResource(string, 0, n);
            }
            catch (Exception exception) {
                fontUIResource = new FontUIResource("Label.font", 0, n);
            }
            GraphConstants.setFont((Map)attributeMap, (Font)fontUIResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributeMap;
    }

    public GraphTransitionInterface createTransition(List list, Map map, XMLCollectionElement xMLCollectionElement) {
        GraphTransitionInterface graphTransitionInterface = this.createTransitionCell(xMLCollectionElement);
        Map map2 = this.initTransitionProperties(list, xMLCollectionElement);
        map.put(graphTransitionInterface, map2);
        return graphTransitionInterface;
    }

    protected GraphTransitionInterface createTransitionCell(XMLCollectionElement xMLCollectionElement) {
        return new DefaultGraphTransition(xMLCollectionElement);
    }

    protected Map initTransitionProperties(List list, XMLCollectionElement xMLCollectionElement) {
        AttributeMap attributeMap = new AttributeMap();
        GraphConstants.setPoints((Map)attributeMap, (List)list);
        this.setTransitionStyle(GraphUtilities.getStyle(xMLCollectionElement), attributeMap);
        GraphConstants.setLineEnd((Map)attributeMap, (int)2);
        GraphConstants.setEndFill((Map)attributeMap, (boolean)true);
        GraphConstants.setEndSize((Map)attributeMap, (int)7);
        GraphConstants.setBeginFill((Map)attributeMap, (boolean)true);
        GraphConstants.setBeginSize((Map)attributeMap, (int)7);
        String string = JaWEManager.getFontName();
        int n = GraphUtilities.getGraphController().getGraphSettings().getGraphFontSize();
        try {
            FontUIResource fontUIResource;
            try {
                fontUIResource = new FontUIResource(string, 0, n);
            }
            catch (Exception exception) {
                fontUIResource = new FontUIResource("Label.font", 0, n);
            }
            GraphConstants.setFont((Map)attributeMap, (Font)fontUIResource);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return attributeMap;
    }

    protected void setTransitionStyle(String string, AttributeMap attributeMap) {
        if (string.equals("NO_ROUTING_BEZIER")) {
            GraphConstants.setLineStyle((Map)attributeMap, (int)12);
        } else if (string.equals("NO_ROUTING_SPLINE")) {
            GraphConstants.setLineStyle((Map)attributeMap, (int)13);
        } else if (string.equals("SIMPLE_ROUTING_BEZIER")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            GraphConstants.setLineStyle((Map)attributeMap, (int)12);
        } else if (string.equals("SIMPLE_ROUTING_ORTHOGONAL")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            GraphConstants.setLineStyle((Map)attributeMap, (int)11);
        } else if (string.equals("SIMPLE_ROUTING_SPLINE")) {
            GraphConstants.setRouting((Map)attributeMap, (Edge.Routing)GraphConstants.ROUTING_SIMPLE);
            GraphConstants.setLineStyle((Map)attributeMap, (int)13);
        } else {
            GraphConstants.setLineStyle((Map)attributeMap, (int)11);
        }
    }

    public GraphPortInterface createPort(String string, String string2) {
        GraphPortInterface graphPortInterface = this.createPortCell(string, string2);
        return graphPortInterface;
    }

    protected GraphPortInterface createPortCell(String string, String string2) {
        return new DefaultGraphPort(string, string2);
    }

    protected Map initPortProperties(String string) {
        AttributeMap attributeMap = new AttributeMap();
        return attributeMap;
    }
}

