/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.graph.CommonExpressionParticipant;
import org.enhydra.jawe.components.graph.CommonExpressionParticipants;
import org.enhydra.jawe.components.graph.CopiedActivityOrArtifactInfo;
import org.enhydra.jawe.components.graph.CopyOrCutInfo;
import org.enhydra.jawe.components.graph.FreeTextExpressionParticipant;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphActivityViewInterface;
import org.enhydra.jawe.components.graph.GraphArtifactViewInterface;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphEAConstants;
import org.enhydra.jawe.components.graph.GraphManager;
import org.enhydra.jawe.components.graph.GraphParticipantComparator;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.JaWEGraphModel;
import org.enhydra.jawe.components.graph.JaWEParentMap;
import org.enhydra.jawe.components.graph.LaneInfo;
import org.enhydra.jawe.components.graph.ParticipantInfo;
import org.enhydra.jawe.components.graph.StartEndDescription;
import org.enhydra.jawe.components.graph.WorkflowElement;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySet;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.Artifact;
import org.enhydra.jxpdl.elements.Artifacts;
import org.enhydra.jxpdl.elements.Association;
import org.enhydra.jxpdl.elements.Associations;
import org.enhydra.jxpdl.elements.ConnectorGraphicsInfo;
import org.enhydra.jxpdl.elements.ConnectorGraphicsInfos;
import org.enhydra.jxpdl.elements.Coordinates;
import org.enhydra.jxpdl.elements.Coordinatess;
import org.enhydra.jxpdl.elements.ExtendedAttribute;
import org.enhydra.jxpdl.elements.ExtendedAttributes;
import org.enhydra.jxpdl.elements.Lane;
import org.enhydra.jxpdl.elements.Lanes;
import org.enhydra.jxpdl.elements.NestedLane;
import org.enhydra.jxpdl.elements.NestedLanes;
import org.enhydra.jxpdl.elements.NodeGraphicsInfo;
import org.enhydra.jxpdl.elements.NodeGraphicsInfos;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.Participant;
import org.enhydra.jxpdl.elements.Performer;
import org.enhydra.jxpdl.elements.Performers;
import org.enhydra.jxpdl.elements.Pool;
import org.enhydra.jxpdl.elements.Pools;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;
import org.enhydra.jxpdl.elements.WorkflowProcess;
import org.enhydra.jxpdl.elements.WorkflowProcesses;
import org.enhydra.jxpdl.utilities.SequencedHashMap;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;

public class GraphUtilities {
    public static GraphController getGraphController() {
        GraphController graphController = null;
        List list = JaWEManager.getInstance().getComponentManager().getComponents();
        for (JaWEComponent jaWEComponent : list) {
            if (!(jaWEComponent instanceof GraphController)) continue;
            graphController = (GraphController)jaWEComponent;
            break;
        }
        return graphController;
    }

    public static List getParticipantVisualOrder(XMLCollectionElement xMLCollectionElement) {
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        String string = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId();
        }
        return GraphUtilities.getParticipantVisualOrder(workflowProcess, string);
    }

    public static List getParticipantVisualOrder(WorkflowProcess workflowProcess, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ExtendedAttribute extendedAttribute = GraphUtilities.getParticipantVisualOrderEA(workflowProcess, string);
        if (extendedAttribute != null) {
            String string2 = extendedAttribute.getVValue();
            String string3 = null;
            while (true) {
                int n = string2.indexOf(";");
                String string4 = null;
                boolean bl = false;
                if (n < 0) {
                    if (string2.length() == 0) break;
                    string4 = string2;
                } else {
                    string4 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                }
                int n2 = string4.indexOf("### CEP -> ");
                int n3 = string4.indexOf(" <- CEP ###");
                if (n2 >= 0 && n3 < 0) {
                    if (string3 == null) {
                        string3 = string4 + ";";
                        continue;
                    }
                    string3 = string3 + string4 + ";";
                    continue;
                }
                if (n2 < 0 && n3 >= 0) {
                    string3 = string3 + string4;
                    bl = true;
                } else if (n2 < 0 && n3 < 0) {
                    if (string3 != null) {
                        string3 = string3 + string4 + ";";
                        continue;
                    }
                    string3 = string4;
                    bl = true;
                } else {
                    string3 = string4;
                    bl = true;
                }
                arrayList.add(string3);
                if (bl) {
                    string3 = null;
                }
                if (string4.equals(string2)) break;
            }
            if (string != null) {
                arrayList.remove(0);
            }
        }
        return arrayList;
    }

    public static List getLaneVisualOrder(XMLCollectionElement xMLCollectionElement) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = GraphUtilities.getLanesInVisualOrder(xMLCollectionElement);
        for (int i = 0; i < list.size(); ++i) {
            Lane lane = (Lane)list.get(i);
            arrayList.add(lane.getId());
        }
        return arrayList;
    }

    public static List getLanesInVisualOrder(XMLCollectionElement xMLCollectionElement) {
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        List list = GraphUtilities.getLaneHierarchy(pool);
        return list;
    }

    protected static ExtendedAttribute getParticipantVisualOrderEA(XMLCollectionElement xMLCollectionElement) {
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        String string = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId();
        }
        return GraphUtilities.getParticipantVisualOrderEA(workflowProcess, string);
    }

    protected static ExtendedAttribute getParticipantVisualOrderEA(WorkflowProcess workflowProcess, String string) {
        ExtendedAttributes extendedAttributes = workflowProcess.getExtendedAttributes();
        ExtendedAttribute extendedAttribute = null;
        String string2 = "JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER";
        if (string == null) {
            extendedAttribute = extendedAttributes.getFirstExtendedAttributeForName(string2);
        } else {
            string2 = "JaWE_GRAPH_BLOCK_PARTICIPANT_ORDER";
            ArrayList arrayList = extendedAttributes.getElementsForName(string2);
            for (ExtendedAttribute extendedAttribute2 : arrayList) {
                String string3 = GraphUtilities.getActivitySetIdForBlockParticipantVisualOrderOrOrientationEA(extendedAttribute2);
                if (!string3.equals(string)) continue;
                extendedAttribute = extendedAttribute2;
                break;
            }
        }
        return extendedAttribute;
    }

    protected static String getActivitySetIdForBlockParticipantVisualOrderOrOrientationEA(ExtendedAttribute extendedAttribute) {
        return GraphUtilities.getActivitySetIdForBlockParticipantVisualOrderOrOrientationEA(extendedAttribute.getVValue());
    }

    protected static String getActivitySetIdForBlockParticipantVisualOrderOrOrientationEA(String string) {
        String[] stringArray = XMLUtil.tokenize((String)string, (String)";");
        if (stringArray.length > 0) {
            return stringArray[0];
        }
        return "";
    }

    protected static ExtendedAttribute createParticipantVisualOrderEA(XMLCollectionElement xMLCollectionElement, String string, boolean bl) {
        ExtendedAttributes extendedAttributes = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement).getExtendedAttributes();
        String string2 = "JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER";
        if (xMLCollectionElement instanceof ActivitySet) {
            string2 = "JaWE_GRAPH_BLOCK_PARTICIPANT_ORDER";
        }
        ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributes.generateNewElement();
        extendedAttribute.setName(string2);
        extendedAttribute.setVValue(string);
        if (bl) {
            extendedAttributes.add(0, (XMLElement)extendedAttribute);
        }
        return extendedAttribute;
    }

    protected static String createParticipantVisualOrderEAVal(XMLCollectionElement xMLCollectionElement, List list) {
        String string = "";
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId() + ";";
        }
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                string = string + (String)list.get(i);
                if (i == list.size() - 1) continue;
                string = string + ";";
            }
        }
        return string;
    }

    public static String getGraphOrientation(XMLCollectionElement xMLCollectionElement) {
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        return pool != null ? pool.getOrientation() : "HORIZONTAL";
    }

    public static void setGraphOrientation(XMLCollectionElement xMLCollectionElement, String string) {
        JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement).setOrientation(string);
    }

    public static String getGraphParticipantOrientation(WorkflowProcess workflowProcess, XMLCollectionElement xMLCollectionElement) {
        String string = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId();
        }
        return GraphUtilities.getGraphParticipantOrientation(workflowProcess, string);
    }

    public static String getGraphParticipantOrientation(WorkflowProcess workflowProcess, String string) {
        String string2 = "HORIZONTAL";
        ExtendedAttribute extendedAttribute = GraphUtilities.getGraphParticipantOrientationEA(workflowProcess, string);
        if (extendedAttribute != null) {
            string2 = extendedAttribute.getVValue();
            if (string != null) {
                String[] stringArray = XMLUtil.tokenize((String)string2, (String)";");
                string2 = stringArray[1];
            }
        }
        return string2;
    }

    protected static ExtendedAttribute getGraphParticipantOrientationEA(WorkflowProcess workflowProcess, String string) {
        String string2 = "JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORIENTATION";
        if (string != null) {
            string2 = "JaWE_GRAPH_BLOCK_PARTICIPANT_ORIENTATION";
        }
        ExtendedAttributes extendedAttributes = workflowProcess.getExtendedAttributes();
        ExtendedAttribute extendedAttribute = null;
        if (string == null) {
            extendedAttribute = extendedAttributes.getFirstExtendedAttributeForName(string2);
        } else {
            for (ExtendedAttribute extendedAttribute2 : extendedAttributes.getElementsForName(string2)) {
                String string3 = GraphUtilities.getActivitySetIdForBlockParticipantVisualOrderOrOrientationEA(extendedAttribute2);
                if (!string3.equals(string)) continue;
                extendedAttribute = extendedAttribute2;
                break;
            }
        }
        return extendedAttribute;
    }

    public static List getStartOrEndDescriptions(XMLCollectionElement xMLCollectionElement, boolean bl) {
        ArrayList<StartEndDescription> arrayList = new ArrayList<StartEndDescription>();
        List list = GraphUtilities.getStartOrEndExtendedAttributes(xMLCollectionElement, bl);
        for (ExtendedAttribute extendedAttribute : list) {
            StartEndDescription startEndDescription = new StartEndDescription(extendedAttribute);
            arrayList.add(startEndDescription);
        }
        return arrayList;
    }

    public static List getStartOrEndExtendedAttributes(XMLCollectionElement xMLCollectionElement, boolean bl) {
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        String string = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId();
        }
        return GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string, bl);
    }

    public static List getStartOrEndExtendedAttributes(WorkflowProcess workflowProcess, String string, boolean bl) {
        ArrayList<ExtendedAttribute> arrayList = new ArrayList<ExtendedAttribute>();
        ExtendedAttributes extendedAttributes = workflowProcess.getExtendedAttributes();
        String string2 = null;
        string2 = bl ? (string == null ? "JaWE_GRAPH_START_OF_WORKFLOW" : "JaWE_GRAPH_START_OF_BLOCK") : (string == null ? "JaWE_GRAPH_END_OF_WORKFLOW" : "JaWE_GRAPH_END_OF_BLOCK");
        ArrayList arrayList2 = extendedAttributes.getElementsForName(string2);
        if (string == null) {
            arrayList.addAll(arrayList2);
        } else {
            for (ExtendedAttribute extendedAttribute : arrayList2) {
                int n;
                String string3 = extendedAttribute.getVValue();
                String[] stringArray = XMLUtil.tokenize((String)string3, (String)",");
                String string4 = stringArray[0].substring((n = stringArray[0].indexOf("ACTIVITY_SET_ID=")) + "ACTIVITY_SET_ID=".length());
                if (!string4.equals(string)) continue;
                arrayList.add(0, extendedAttribute);
            }
        }
        return arrayList;
    }

    public static List getStartOrEndExtendedAttributes(XMLCollectionElement xMLCollectionElement, String string, String string2) {
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        String string3 = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string3 = xMLCollectionElement.getId();
        }
        return GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string3, string, string2);
    }

    public static List getStartOrEndExtendedAttributes(WorkflowProcess workflowProcess, String string, String string2, String string3) {
        List list = GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string, true);
        list.addAll(GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string, false));
        ArrayList<ExtendedAttribute> arrayList = new ArrayList<ExtendedAttribute>();
        for (ExtendedAttribute extendedAttribute : list) {
            StartEndDescription startEndDescription = new StartEndDescription(extendedAttribute);
            if (!(string3.equals("JaWE_GRAPH_PARTICIPANT_ID") && string2.equals(startEndDescription.getParticipantId()) || string3.equals("ACTIVITY_SET_ID") && string2.equals(startEndDescription.getActSetId())) && (!string3.equals("CONNECTING_ACTIVITY_ID") || !string2.equals(startEndDescription.getActId()))) continue;
            arrayList.add(extendedAttribute);
        }
        return arrayList;
    }

    public static String getParticipantId(Activity activity) {
        String string = FreeTextExpressionParticipant.getInstance().getId();
        ExtendedAttribute extendedAttribute = GraphUtilities.getParticipantIdEA(activity);
        if (extendedAttribute != null) {
            string = extendedAttribute.getVValue();
        }
        return string;
    }

    protected static ExtendedAttribute getParticipantIdEA(Activity activity) {
        return activity.getExtendedAttributes().getFirstExtendedAttributeForName("JaWE_GRAPH_PARTICIPANT_ID");
    }

    protected static ExtendedAttribute createParticipantIdEA(Activity activity, String string, boolean bl) {
        ExtendedAttributes extendedAttributes = activity.getExtendedAttributes();
        ExtendedAttribute extendedAttribute = (ExtendedAttribute)extendedAttributes.generateNewElement();
        extendedAttribute.setName("JaWE_GRAPH_PARTICIPANT_ID");
        extendedAttribute.setVValue(string);
        if (bl) {
            extendedAttributes.add(0, (XMLElement)extendedAttribute);
        }
        return extendedAttribute;
    }

    public static Point getOffsetPoint(Activity activity) {
        Point point = new Point(0, 0);
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity);
        if (nodeGraphicsInfo != null) {
            try {
                point.x = (int)Double.parseDouble(nodeGraphicsInfo.getCoordinates().getXCoordinate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                point.y = (int)Double.parseDouble(nodeGraphicsInfo.getCoordinates().getYCoordinate());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return point;
    }

    public static Point getOffsetPoint(XMLCollectionElement xMLCollectionElement) {
        Point point = new Point(0, 0);
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo(xMLCollectionElement);
        if (nodeGraphicsInfo != null) {
            try {
                point.x = (int)Double.parseDouble(nodeGraphicsInfo.getCoordinates().getXCoordinate());
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                point.y = (int)Double.parseDouble(nodeGraphicsInfo.getCoordinates().getYCoordinate());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return point;
    }

    public static void setOffsetPoint(XMLCollectionElement xMLCollectionElement, Point point, String string) {
        NodeGraphicsInfo nodeGraphicsInfo;
        if (point == null) {
            point = new Point(0, 0);
        }
        if ((nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo(xMLCollectionElement)) == null) {
            nodeGraphicsInfo = GraphUtilities.createNodeGraphicsInfo(xMLCollectionElement, point, string, true);
        } else {
            if (string != null) {
                nodeGraphicsInfo.setLaneId(string);
            }
            nodeGraphicsInfo.getCoordinates().setXCoordinate(String.valueOf(point.x));
            nodeGraphicsInfo.getCoordinates().setYCoordinate(String.valueOf(point.y));
        }
    }

    protected static NodeGraphicsInfo createNodeGraphicsInfo(XMLCollectionElement xMLCollectionElement, Point point, String string, boolean bl) {
        Object object;
        NodeGraphicsInfos nodeGraphicsInfos = (NodeGraphicsInfos)xMLCollectionElement.get("NodeGraphicsInfos");
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(nodeGraphicsInfos, "", false);
        if (string != null) {
            nodeGraphicsInfo.setLaneId(string);
        }
        if (point != null) {
            nodeGraphicsInfo.getCoordinates().setXCoordinate(String.valueOf(point.x));
            nodeGraphicsInfo.getCoordinates().setYCoordinate(String.valueOf(point.y));
        }
        int n = GraphUtilities.getGraphController().getGraphSettings().getActivityWidth();
        int n2 = GraphUtilities.getGraphController().getGraphSettings().getActivityHeight();
        if (xMLCollectionElement instanceof Activity) {
            object = (Activity)xMLCollectionElement;
            if (object.getActivityType() == 6 || object.getActivityType() == 7) {
                n = GraphUtilities.getGraphController().getGraphSettings().getEventRadius() * 2 + 1;
                n2 = GraphUtilities.getGraphController().getGraphSettings().getEventRadius() * 2 + 1;
            } else if (object.getActivityType() == 0) {
                n = GraphUtilities.getGraphController().getGraphSettings().getGatewayWidth();
                n2 = GraphUtilities.getGraphController().getGraphSettings().getGatewayHeight();
            }
        } else if (xMLCollectionElement instanceof Artifact) {
            object = (Artifact)xMLCollectionElement;
            if (object.getArtifactType().equals("Annotation")) {
                n = GraphUtilities.getGraphController().getGraphSettings().getAnnotationWidth();
                n2 = GraphUtilities.getGraphController().getGraphSettings().getAnnotationHeight();
            } else {
                n = GraphUtilities.getGraphController().getGraphSettings().getDataObjectWidth();
                n2 = GraphUtilities.getGraphController().getGraphSettings().getDataObjectHeight();
            }
        }
        object = null;
        Color color = GraphUtilities.getGraphController().getGraphSettings().getLaneBorderColor();
        if (xMLCollectionElement instanceof Pool || xMLCollectionElement instanceof Lane) {
            Lane lane;
            FreeTextExpressionParticipant freeTextExpressionParticipant = null;
            if (xMLCollectionElement instanceof Lane && (freeTextExpressionParticipant = GraphUtilities.getParticipantForLane(lane = (Lane)xMLCollectionElement, null)) == null && lane.getPerformers().size() > 0) {
                freeTextExpressionParticipant = lane;
            }
            if (freeTextExpressionParticipant == null) {
                freeTextExpressionParticipant = FreeTextExpressionParticipant.getInstance();
            }
            object = freeTextExpressionParticipant instanceof FreeTextExpressionParticipant ? GraphUtilities.getGraphController().getGraphSettings().getLaneFreeTextExpressionColor() : (freeTextExpressionParticipant instanceof Lane ? GraphUtilities.getGraphController().getGraphSettings().getLaneCommonExpressionColor() : JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)freeTextExpressionParticipant).getColor());
        } else {
            nodeGraphicsInfo.setWidth(n);
            nodeGraphicsInfo.setHeight(n2);
            object = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)xMLCollectionElement).getColor();
        }
        nodeGraphicsInfo.setFillColor(Utils.getColorString((Color)object));
        nodeGraphicsInfo.setBorderColor(Utils.getColorString(color));
        nodeGraphicsInfo.setToolId("JaWE");
        if (bl) {
            nodeGraphicsInfos.add((XMLElement)nodeGraphicsInfo);
        }
        return nodeGraphicsInfo;
    }

    protected static NodeGraphicsInfo createNodeGraphicsInfo(XMLCollectionElement xMLCollectionElement, XMLCollectionElement xMLCollectionElement2, NodeGraphicsInfo nodeGraphicsInfo) {
        Object object;
        NodeGraphicsInfos nodeGraphicsInfos = (NodeGraphicsInfos)xMLCollectionElement2.get("NodeGraphicsInfos");
        NodeGraphicsInfo nodeGraphicsInfo2 = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(nodeGraphicsInfos, "", false);
        nodeGraphicsInfo2.setLaneId(nodeGraphicsInfo.getLaneId());
        int n = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
        double d = n + 1;
        double d2 = n + 1;
        try {
            d = Double.parseDouble(nodeGraphicsInfo.getCoordinates().getXCoordinate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            d2 = Double.parseDouble(nodeGraphicsInfo.getCoordinates().getYCoordinate());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xMLCollectionElement != null) {
            object = GraphUtilities.getGraphOrientation(xMLCollectionElement);
            if (((String)object).equals("HORIZONTAL")) {
                if (d < (double)(n + 1)) {
                    d = n + 1;
                }
            } else if (d2 < (double)(n + 1)) {
                d2 = n + 1;
            }
        }
        if (d < 1.0) {
            d = 1.0;
        }
        if (d2 < 1.0) {
            d2 = 1.0;
        }
        nodeGraphicsInfo2.getCoordinates().setXCoordinate(String.valueOf(d));
        nodeGraphicsInfo2.getCoordinates().setYCoordinate(String.valueOf(d2));
        try {
            nodeGraphicsInfo2.setWidth(nodeGraphicsInfo.getWidth());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            nodeGraphicsInfo2.setHeight(nodeGraphicsInfo.getHeight());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nodeGraphicsInfo2.getWidth() == 0 || nodeGraphicsInfo2.getHeight() == 0) {
            if (xMLCollectionElement2 instanceof Activity) {
                object = (Activity)xMLCollectionElement2;
                if (object.getActivityType() == 6 || object.getActivityType() == 7) {
                    if (nodeGraphicsInfo2.getWidth() == 0) {
                        nodeGraphicsInfo2.setWidth(GraphUtilities.getGraphController().getGraphSettings().getEventRadius() * 2 + 1);
                    }
                    if (nodeGraphicsInfo2.getHeight() == 0) {
                        nodeGraphicsInfo2.setHeight(GraphUtilities.getGraphController().getGraphSettings().getEventRadius() * 2 + 1);
                    }
                } else if (object.getActivityType() == 0) {
                    if (nodeGraphicsInfo2.getWidth() == 0) {
                        nodeGraphicsInfo2.setWidth(GraphUtilities.getGraphController().getGraphSettings().getGatewayWidth());
                    }
                    if (nodeGraphicsInfo2.getHeight() == 0) {
                        nodeGraphicsInfo2.setHeight(GraphUtilities.getGraphController().getGraphSettings().getGatewayHeight());
                    }
                } else {
                    if (nodeGraphicsInfo2.getWidth() == 0) {
                        nodeGraphicsInfo2.setWidth(GraphUtilities.getGraphController().getGraphSettings().getActivityWidth());
                    }
                    if (nodeGraphicsInfo2.getHeight() == 0) {
                        nodeGraphicsInfo2.setHeight(GraphUtilities.getGraphController().getGraphSettings().getActivityHeight());
                    }
                }
            } else if (xMLCollectionElement2 instanceof Artifact && (object = (Artifact)xMLCollectionElement2).getArtifactType().equals("Annotation")) {
                if (nodeGraphicsInfo2.getWidth() == 0) {
                    nodeGraphicsInfo2.setWidth(GraphUtilities.getGraphController().getGraphSettings().getAnnotationWidth());
                }
                if (nodeGraphicsInfo2.getHeight() == 0) {
                    nodeGraphicsInfo2.setHeight(GraphUtilities.getGraphController().getGraphSettings().getAnnotationHeight());
                } else {
                    if (nodeGraphicsInfo2.getWidth() == 0) {
                        nodeGraphicsInfo2.setWidth(GraphUtilities.getGraphController().getGraphSettings().getDataObjectWidth());
                    }
                    if (nodeGraphicsInfo2.getHeight() == 0) {
                        nodeGraphicsInfo2.setHeight(GraphUtilities.getGraphController().getGraphSettings().getDataObjectHeight());
                    }
                }
            }
        }
        if (!nodeGraphicsInfo.getFillColor().equals("")) {
            object = Utils.getColor(nodeGraphicsInfo.getFillColor());
            nodeGraphicsInfo2.setFillColor(Utils.getColorString((Color)object));
        }
        if (!nodeGraphicsInfo.getBorderColor().equals("")) {
            object = Utils.getColor(nodeGraphicsInfo.getBorderColor());
            nodeGraphicsInfo2.setBorderColor(Utils.getColorString((Color)object));
        }
        nodeGraphicsInfo2.setToolId("JaWE");
        nodeGraphicsInfos.add((XMLElement)nodeGraphicsInfo2);
        return nodeGraphicsInfo2;
    }

    public static Point getOffsetPointOld(Activity activity) {
        Point point = new Point(0, 0);
        ExtendedAttribute extendedAttribute = activity.getExtendedAttributes().getFirstExtendedAttributeForName("JaWE_GRAPH_OFFSET");
        if (extendedAttribute != null) {
            String string = extendedAttribute.getVValue();
            String[] stringArray = XMLUtil.tokenize((String)string, (String)",");
            try {
                point.x = Integer.parseInt(stringArray[0]);
                point.y = Integer.parseInt(stringArray[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((ExtendedAttributes)extendedAttribute.getParent()).remove((XMLElement)extendedAttribute);
        }
        return point;
    }

    protected static NodeGraphicsInfo updateNodeGraphicsInfoFromAnyOtherVendor(XMLCollectionElement xMLCollectionElement, XMLCollectionElement xMLCollectionElement2) {
        Iterator iterator = ((NodeGraphicsInfos)xMLCollectionElement.get("NodeGraphicsInfos")).toElements().iterator();
        NodeGraphicsInfo nodeGraphicsInfo = null;
        if (iterator.hasNext()) {
            nodeGraphicsInfo = (NodeGraphicsInfo)iterator.next();
        }
        if (nodeGraphicsInfo != null) {
            return GraphUtilities.createNodeGraphicsInfo(xMLCollectionElement2, xMLCollectionElement, nodeGraphicsInfo);
        }
        return null;
    }

    public static String getStyle(XMLCollectionElement xMLCollectionElement) {
        String string = "NO_ROUTING_SPLINE";
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement);
        if (connectorGraphicsInfo != null) {
            string = connectorGraphicsInfo.getStyle();
        }
        return string;
    }

    public static void setStyle(XMLCollectionElement xMLCollectionElement, String string) {
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement);
        if (connectorGraphicsInfo == null) {
            connectorGraphicsInfo = GraphUtilities.createConnectorGraphicsInfo(xMLCollectionElement, string, true);
        } else {
            connectorGraphicsInfo.setStyle(string);
        }
    }

    protected static ConnectorGraphicsInfo createConnectorGraphicsInfo(XMLCollectionElement xMLCollectionElement, String string, boolean bl) {
        ConnectorGraphicsInfos connectorGraphicsInfos = (ConnectorGraphicsInfos)xMLCollectionElement.get("ConnectorGraphicsInfos");
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(connectorGraphicsInfos, "", false);
        connectorGraphicsInfo.setStyle(string);
        Color color = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)xMLCollectionElement).getColor();
        connectorGraphicsInfo.setFillColor(Utils.getColorString(color));
        connectorGraphicsInfo.setToolId("JaWE");
        if (bl) {
            connectorGraphicsInfos.add((XMLElement)connectorGraphicsInfo);
        }
        return connectorGraphicsInfo;
    }

    protected static String getStyleOld(Transition transition) {
        String string = "";
        ExtendedAttribute extendedAttribute = GraphUtilities.getStyleEAOld(transition);
        if (extendedAttribute != null) {
            string = extendedAttribute.getVValue();
            ((ExtendedAttributes)extendedAttribute.getParent()).remove((XMLElement)extendedAttribute);
        }
        return string;
    }

    protected static ExtendedAttribute getStyleEAOld(Transition transition) {
        return transition.getExtendedAttributes().getFirstExtendedAttributeForName("JaWE_GRAPH_TRANSITION_STYLE");
    }

    public static List getBreakpoints(XMLCollectionElement xMLCollectionElement) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement);
        if (connectorGraphicsInfo != null) {
            ArrayList arrayList2 = connectorGraphicsInfo.getCoordinatess().toElements();
            for (int i = 0; i < arrayList2.size(); ++i) {
                Coordinates coordinates = (Coordinates)arrayList2.get(i);
                try {
                    Point point = new Point((int)Double.parseDouble(coordinates.getXCoordinate()), (int)Double.parseDouble(coordinates.getYCoordinate()));
                    arrayList.add(point);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return arrayList;
    }

    public static void setBreakpoints(XMLCollectionElement xMLCollectionElement, List list) {
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement);
        if (connectorGraphicsInfo == null) {
            connectorGraphicsInfo = GraphUtilities.createConnectorGraphicsInfo(xMLCollectionElement, list, true);
        } else {
            GraphUtilities.setBreakPointCoordinates(connectorGraphicsInfo, list);
        }
    }

    public static ConnectorGraphicsInfo createConnectorGraphicsInfo(XMLCollectionElement xMLCollectionElement, List list, boolean bl) {
        ConnectorGraphicsInfos connectorGraphicsInfos = (ConnectorGraphicsInfos)xMLCollectionElement.get("ConnectorGraphicsInfos");
        ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(connectorGraphicsInfos, "", false);
        GraphUtilities.setBreakPointCoordinates(connectorGraphicsInfo, list);
        connectorGraphicsInfo.setStyle("NO_ROUTING_SPLINE");
        Color color = JaWEManager.getInstance().getJaWEController().getTypeResolver().getJaWEType((XMLElement)xMLCollectionElement).getColor();
        connectorGraphicsInfo.setFillColor(Utils.getColorString(color));
        connectorGraphicsInfo.setToolId("JaWE");
        if (bl) {
            connectorGraphicsInfos.add((XMLElement)connectorGraphicsInfo);
        }
        return connectorGraphicsInfo;
    }

    protected static void setBreakPointCoordinates(ConnectorGraphicsInfo connectorGraphicsInfo, List list) {
        Coordinatess coordinatess = connectorGraphicsInfo.getCoordinatess();
        coordinatess.clear();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Point point = (Point)list.get(i);
                Coordinates coordinates = (Coordinates)coordinatess.generateNewElement();
                coordinates.setXCoordinate(String.valueOf(point.x));
                coordinates.setYCoordinate(String.valueOf(point.y));
                coordinatess.add((XMLElement)coordinates);
            }
        }
    }

    protected static List getBreakpointsOld(Transition transition) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        ExtendedAttribute extendedAttribute = transition.getExtendedAttributes().getFirstExtendedAttributeForName("JaWE_GRAPH_BREAK_POINTS");
        if (extendedAttribute != null) {
            String[] stringArray = XMLUtil.tokenize((String)extendedAttribute.getVValue(), (String)"-");
            int n = 0;
            int n2 = 0;
            if ("HORIZONTAL".equals(GraphUtilities.getGraphParticipantOrientation(XMLUtil.getWorkflowProcess((XMLElement)transition), (XMLCollectionElement)XMLUtil.getActivitySet((XMLElement)transition)))) {
                n = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
            } else {
                n2 = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                String[] stringArray2 = XMLUtil.tokenize((String)string, (String)",");
                try {
                    Point point = new Point(n + Integer.parseInt(stringArray2[0]), n2 + Integer.parseInt(stringArray2[1]));
                    arrayList.add(point);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ((ExtendedAttributes)extendedAttribute.getParent()).remove((XMLElement)extendedAttribute);
        }
        return arrayList;
    }

    protected static ConnectorGraphicsInfo updateConnectorGraphicsInfoFromAnyOtherVendor(XMLCollectionElement xMLCollectionElement) {
        Iterator iterator = ((ConnectorGraphicsInfos)xMLCollectionElement.get("ConnectorGraphicsInfos")).toElements().iterator();
        ConnectorGraphicsInfo connectorGraphicsInfo = null;
        if (iterator.hasNext()) {
            connectorGraphicsInfo = (ConnectorGraphicsInfo)iterator.next();
        }
        ConnectorGraphicsInfo connectorGraphicsInfo2 = null;
        if (connectorGraphicsInfo != null) {
            connectorGraphicsInfo2 = GraphUtilities.createConnectorGraphicsInfo(xMLCollectionElement, new ArrayList(), true);
            Coordinatess coordinatess = connectorGraphicsInfo2.getCoordinatess();
            ArrayList arrayList = connectorGraphicsInfo.getCoordinatess().toElements();
            if (arrayList.size() >= 3) {
                for (int i = 1; i < arrayList.size() - 1; ++i) {
                    Coordinates coordinates = (Coordinates)arrayList.get(i);
                    String string = coordinates.getXCoordinate();
                    String string2 = coordinates.getYCoordinate();
                    if (string.equals("0") && string2.equals("0") || string.equals("0.0") && string2.equals("0.0")) continue;
                    Coordinates coordinates2 = (Coordinates)coordinatess.generateNewElement();
                    coordinates2.setXCoordinate(coordinates.getXCoordinate());
                    coordinates2.setYCoordinate(coordinates.getYCoordinate());
                    coordinatess.add((XMLElement)coordinates2);
                }
            }
            if (!connectorGraphicsInfo.getFillColor().equals("")) {
                Color color = Utils.getColor(connectorGraphicsInfo.getFillColor());
                connectorGraphicsInfo2.setFillColor(Utils.getColorString(color));
            }
        }
        return connectorGraphicsInfo2;
    }

    public static List gatherParticipants(XMLCollectionElement xMLCollectionElement) {
        ArrayList arrayList = ((Activities)xMLCollectionElement.get("Activities")).toElements();
        ArrayList<ParticipantInfo> arrayList2 = new ArrayList<ParticipantInfo>();
        List list = GraphUtilities.getParticipantVisualOrder(xMLCollectionElement);
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        if (list.size() > 0) {
            ParticipantInfo participantInfo = null;
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                Participant participant = XMLUtil.findParticipant((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (WorkflowProcess)workflowProcess, (String)string);
                if (participant == null && CommonExpressionParticipants.getInstance().isCommonExpressionParticipantId(string)) {
                    string = CommonExpressionParticipants.getInstance().getIdFromVisualOrderEA(string);
                    participant = CommonExpressionParticipants.getInstance().getCommonExpressionParticipant(xMLCollectionElement, string);
                }
                if (participant != null) {
                    ParticipantInfo participantInfo2 = new ParticipantInfo(participant);
                    List list2 = GraphUtilities.getAllActivitiesForParticipantId(arrayList, string);
                    participantInfo2.setActivities(list2);
                    arrayList.removeAll(list2);
                    arrayList2.add(participantInfo2);
                    continue;
                }
                if (participantInfo != null) continue;
                participantInfo = new ParticipantInfo(FreeTextExpressionParticipant.getInstance());
                arrayList2.add(participantInfo);
            }
            if (participantInfo != null) {
                participantInfo.setActivities(arrayList);
            }
        }
        return arrayList2;
    }

    public static List getAllActivitiesForParticipantId(Collection collection, String string) {
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        for (Activity activity : collection) {
            String string2 = GraphUtilities.getParticipantId(activity);
            if (!string.equals(string2)) continue;
            arrayList.add(activity);
        }
        return arrayList;
    }

    public static List gatherLanes(XMLCollectionElement xMLCollectionElement) {
        ArrayList arrayList = new ArrayList(((Activities)xMLCollectionElement.get("Activities")).toElements());
        arrayList.addAll(XMLUtil.getPackage((XMLElement)xMLCollectionElement).getArtifacts().toElements());
        ArrayList<LaneInfo> arrayList2 = new ArrayList<LaneInfo>();
        List list = GraphUtilities.getLaneVisualOrder(xMLCollectionElement);
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                Lane lane = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement).getLanes().getLane(string);
                LaneInfo laneInfo = new LaneInfo(lane);
                List list2 = GraphUtilities.getAllActivitiesAndArtifactsForLaneId(arrayList, string);
                laneInfo.setActivitiesAndArtifacts(list2);
                arrayList.removeAll(list2);
                arrayList2.add(laneInfo);
            }
        }
        return arrayList2;
    }

    public static List getAllActivitiesAndArtifactsForLaneId(Collection collection, String string) {
        ArrayList<XMLCollectionElement> arrayList = new ArrayList<XMLCollectionElement>();
        for (XMLCollectionElement xMLCollectionElement : collection) {
            String string2 = JaWEManager.getInstance().getXPDLUtils().getLaneId(xMLCollectionElement);
            if (!string.equals(string2)) continue;
            arrayList.add(xMLCollectionElement);
        }
        return arrayList;
    }

    public static boolean scanExtendedAttributes(Package package_) {
        Iterator iterator = package_.getWorkflowProcesses().toElements().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            WorkflowProcess workflowProcess = (WorkflowProcess)iterator.next();
            bl = GraphUtilities.scanExtendedAttributes(workflowProcess) || bl;
        }
        return bl;
    }

    protected static boolean scanExtendedAttributes(WorkflowProcess workflowProcess) {
        boolean bl = false;
        boolean bl2 = false;
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcess(workflowProcess);
        if (pool == null) {
            pool = JaWEManager.getInstance().getXPDLUtils().createPoolForProcess(workflowProcess);
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)pool, null, null, true);
            pool.setOrientation(GraphUtilities.getGraphParticipantOrientation(workflowProcess, (String)null));
            bl = true;
            bl2 = true;
        }
        bl = GraphUtilities.scanExtendedAttributesForWPOrAs((XMLCollectionElement)workflowProcess, bl2) || bl;
        for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
            bl = GraphUtilities.scanExtendedAttributes(activitySet, bl2) || bl;
        }
        return bl;
    }

    protected static boolean scanExtendedAttributes(ActivitySet activitySet, boolean bl) {
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForActivitySet(activitySet);
        if (pool == null) {
            pool = JaWEManager.getInstance().getXPDLUtils().createPoolForActivitySet(activitySet);
            pool.setOrientation(GraphUtilities.getGraphParticipantOrientation(XMLUtil.getWorkflowProcess((XMLElement)activitySet), activitySet.getId()));
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)pool, null, null, true);
            bl = true;
        }
        return GraphUtilities.scanExtendedAttributesForWPOrAs((XMLCollectionElement)activitySet, bl);
    }

    protected static String getNewStyle(Transition transition, String string) {
        if (string.equals("SIMPLEROUTING")) {
            return "SIMPLE_ROUTING_ORTHOGONAL";
        }
        if (string.equals("NOROUTING") || string.equals("")) {
            if (transition != null && transition.getFrom().equals(transition.getTo())) {
                return "NO_ROUTING_BEZIER";
            }
            return "NO_ROUTING_ORTHOGONAL";
        }
        return "NO_ROUTING_ORTHOGONAL";
    }

    public static boolean scanExtendedAttributesForWPOrAs(XMLCollectionElement xMLCollectionElement, boolean bl) {
        boolean bl2 = false;
        FreeTextExpressionParticipant freeTextExpressionParticipant = FreeTextExpressionParticipant.getInstance();
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        ExtendedAttributes extendedAttributes = workflowProcess.getExtendedAttributes();
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        Transitions transitions = (Transitions)xMLCollectionElement.get("Transitions");
        ArrayList arrayList = activities.toElements();
        if (bl) {
            Object object;
            String string;
            Object object2;
            Object object3;
            String string2;
            ExtendedAttribute extendedAttribute;
            Object object4;
            Object object5;
            Object object6;
            Object object72;
            Object object82;
            Object object9;
            int n;
            int n2 = GraphUtilities.getGraphController().getGraphSettings().getActivityWidth();
            int n3 = GraphUtilities.getGraphController().getGraphSettings().getActivityHeight();
            List list = GraphUtilities.getParticipants(activities);
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (n = 0; n < list.size(); ++n) {
                object9 = (Participant)list.get(n);
                hashMap.put(object9.getId(), object9);
            }
            n = 1;
            object9 = new ArrayList();
            ExtendedAttribute extendedAttribute2 = GraphUtilities.getParticipantVisualOrderEA(xMLCollectionElement);
            if (extendedAttribute2 == null) {
                n = 0;
            } else {
                object9 = GraphUtilities.getParticipantVisualOrder(xMLCollectionElement);
            }
            ArrayList arrayList2 = new ArrayList(object9);
            arrayList2.removeAll(hashMap.keySet());
            for (int i = 0; i < arrayList2.size(); ++i) {
                String string3 = (String)arrayList2.get(i);
                Participant participant = XMLUtil.findParticipant((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (WorkflowProcess)workflowProcess, (String)string3);
                if (participant != null && !list.contains(participant)) {
                    list.add(participant);
                    hashMap.put(string3, participant);
                    continue;
                }
                if (CommonExpressionParticipants.getInstance().isCommonExpressionParticipantId(string3)) {
                    object82 = CommonExpressionParticipants.getInstance().getIdFromVisualOrderEA(string3);
                    object72 = CommonExpressionParticipants.getInstance().getCommonExpressionParticipant(xMLCollectionElement, (String)object82);
                    if (object72 == null) {
                        object72 = CommonExpressionParticipants.getInstance().generateCommonExpressionParticipant(xMLCollectionElement);
                        object72.setId((String)object82);
                    }
                    list.add(object72);
                    hashMap.put(object82, object72);
                    continue;
                }
                if (!freeTextExpressionParticipant.getId().equals(string3) || list.contains((Object)freeTextExpressionParticipant)) continue;
                list.add(freeTextExpressionParticipant);
                hashMap.put(string3, (Object)freeTextExpressionParticipant);
            }
            SequencedHashMap sequencedHashMap = new SequencedHashMap();
            boolean bl3 = false;
            for (int i = 0; i < list.size(); ++i) {
                object82 = (Participant)list.get(i);
                if (object82 == freeTextExpressionParticipant) {
                    bl3 = true;
                    continue;
                }
                object72 = GraphUtilities.getActivitiesWithPerformer(arrayList, object82.getId());
                arrayList.removeAll((Collection<?>)object72);
                object6 = new ParticipantInfo((Participant)object82);
                object5 = object72.iterator();
                while (object5.hasNext()) {
                    object4 = (Activity)object5.next();
                    extendedAttribute = GraphUtilities.getParticipantIdEA(object4);
                    if (extendedAttribute != null) {
                        string2 = extendedAttribute.getVValue();
                        if (string2.equals(object3 = object4.getFirstPerformer())) continue;
                        if (!hashMap.containsKey(object3)) {
                            extendedAttribute.setVValue(freeTextExpressionParticipant.getId());
                        } else {
                            extendedAttribute.setVValue((String)object3);
                        }
                        bl2 = true;
                        continue;
                    }
                    extendedAttribute = GraphUtilities.createParticipantIdEA(object4, object4.getFirstPerformer(), false);
                    ((ExtendedAttributes)extendedAttribute.getParent()).add(0, (XMLElement)extendedAttribute);
                    bl2 = true;
                }
                object6.setActivities((List)object72);
                sequencedHashMap.put((Object)object82.getId(), object6);
            }
            if (!bl3 && arrayList.size() > 0) {
                bl3 = true;
            }
            if (bl3) {
                ParticipantInfo participantInfo = new ParticipantInfo(freeTextExpressionParticipant);
                participantInfo.setActivities(new ArrayList(arrayList));
                sequencedHashMap.put((Object)freeTextExpressionParticipant.getId(), (Object)participantInfo);
                object82 = CommonExpressionParticipants.getInstance().getCommonExpressionParticipants(xMLCollectionElement);
                object72 = object82.iterator();
                while (object72.hasNext()) {
                    object6 = (CommonExpressionParticipant)((Object)object72.next());
                    if (sequencedHashMap.containsKey((Object)object6.getId())) continue;
                    sequencedHashMap.put((Object)object6.getId(), (Object)new ParticipantInfo((Participant)object6));
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    object5 = (Activity)arrayList.get(i);
                    object4 = object5.getExtendedAttributes();
                    extendedAttribute = GraphUtilities.getParticipantIdEA((Activity)object5);
                    if (extendedAttribute != null) {
                        string2 = GraphUtilities.getParticipantId((Activity)object5);
                        object3 = (ParticipantInfo)sequencedHashMap.get((Object)string2);
                        if (object3 == null) {
                            extendedAttribute.setVValue(freeTextExpressionParticipant.getId());
                            bl2 = true;
                        } else if (object3 != participantInfo) {
                            participantInfo.removeActivity((Activity)object5);
                            ((ParticipantInfo)object3).addActivity((Activity)object5);
                        }
                    }
                    if (extendedAttribute != null) continue;
                    extendedAttribute = GraphUtilities.createParticipantIdEA((Activity)object5, freeTextExpressionParticipant.getId(), false);
                    object4.add(0, (XMLElement)extendedAttribute);
                    bl2 = true;
                }
                if (participantInfo.getActivities().size() == 0 && !object9.contains(freeTextExpressionParticipant.getId())) {
                    sequencedHashMap.remove((Object)freeTextExpressionParticipant.getId());
                }
            }
            if (extendedAttribute2 != null) {
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (Object object72 : sequencedHashMap.sequence()) {
                    Participant participant = (Participant)hashMap.get(object72);
                    if (participant instanceof CommonExpressionParticipant) {
                        object72 = CommonExpressionParticipants.getInstance().getIdForVisualOrderEA((String)object72);
                    }
                    arrayList3.add(object72);
                }
                object72 = new ArrayList(arrayList3);
                object72.removeAll((Collection<?>)object9);
                ArrayList arrayList4 = new ArrayList(object9);
                arrayList4.removeAll(arrayList3);
                object82 = arrayList4.iterator();
                while (object82.hasNext()) {
                    object5 = (String)object82.next();
                    object4 = XMLUtil.findParticipant((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (WorkflowProcess)workflowProcess, (String)object5);
                    if (object4 == null) {
                        object4 = CommonExpressionParticipants.getInstance().getCommonExpressionParticipant(xMLCollectionElement, (String)object5);
                    }
                    if (object4 == null && !((String)object5).equals(freeTextExpressionParticipant.getId())) continue;
                    object82.remove();
                }
                object9.removeAll(arrayList4);
                object9.addAll(object72);
                GraphUtilities.checkLanes(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement), (List)object9);
                if (n == 0) {
                    if (object9.size() > 0) {
                        extendedAttribute2 = GraphUtilities.createParticipantVisualOrderEA(xMLCollectionElement, GraphUtilities.createParticipantVisualOrderEAVal(xMLCollectionElement, (List)object9), false);
                        extendedAttributes.add(0, (XMLElement)extendedAttribute2);
                        bl2 = true;
                    }
                } else if (arrayList4.size() != 0 || object72.size() != 0) {
                    object5 = GraphUtilities.createParticipantVisualOrderEAVal(xMLCollectionElement, (List)object9);
                    extendedAttribute2.setVValue((String)object5);
                    bl2 = true;
                }
            } else {
                extendedAttribute2 = GraphUtilities.createParticipantVisualOrderEA(xMLCollectionElement, GraphUtilities.createParticipantVisualOrderEAVal(xMLCollectionElement, sequencedHashMap.sequence()), false);
                ((ExtendedAttributes)extendedAttribute2.getParent()).add(0, (XMLElement)extendedAttribute2);
                GraphUtilities.checkLanes(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement), sequencedHashMap.sequence());
                bl2 = true;
            }
            if (extendedAttribute2 != null) {
                ((ExtendedAttributes)extendedAttribute2.getParent()).remove((XMLElement)extendedAttribute2);
                bl2 = true;
            }
            for (Object object82 : sequencedHashMap.values()) {
                object72 = ((ParticipantInfo)object82).getActivities();
                int n4 = 2 * n2;
                int n5 = n3;
                int n6 = 10;
                int n7 = 10;
                double d = (int)Math.sqrt(object72.size());
                int n8 = 0;
                for (int i = 0; i < object72.size(); ++i) {
                    Point point;
                    object2 = (Activity)object72.get(i);
                    string = GraphUtilities.getLaneIdForMigration(object2);
                    object = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)object2);
                    if (object == null && (object = GraphUtilities.updateNodeGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)object2, xMLCollectionElement)) != null) {
                        object.setLaneId(string);
                        bl2 = true;
                    }
                    if (object == null) {
                        point = GraphUtilities.getOffsetPointOld(object2);
                        if (point == null) {
                            if ((double)(++n8) / d == (double)((int)((double)n8 / d))) {
                                n4 = -n4;
                                n7 += n5;
                            } else {
                                n6 += n4;
                            }
                            point = new Point(n6, n7);
                        }
                        object = GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)object2, point, string, false);
                        ((NodeGraphicsInfos)object.getParent()).add((XMLElement)object);
                        bl2 = true;
                    }
                    if ((point = GraphUtilities.getParticipantIdEA(object2)) == null) continue;
                    ((ExtendedAttributes)point.getParent()).remove((XMLElement)point);
                    bl2 = true;
                }
            }
            object82 = GraphUtilities.getStartOrEndDescriptions(xMLCollectionElement, true);
            object72 = GraphUtilities.getStartOrEndDescriptions(xMLCollectionElement, false);
            String string4 = null;
            if (xMLCollectionElement instanceof ActivitySet) {
                string4 = xMLCollectionElement.getId();
            }
            ArrayList arrayList5 = new ArrayList(object82);
            arrayList5.addAll(object72);
            Iterator iterator = arrayList5.iterator();
            HashSet hashSet = new HashSet();
            while (iterator.hasNext()) {
                StartEndDescription startEndDescription = (StartEndDescription)iterator.next();
                if (!sequencedHashMap.containsKey((Object)startEndDescription.getParticipantId())) {
                    hashSet.addAll(GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string4, startEndDescription.getParticipantId(), "JaWE_GRAPH_PARTICIPANT_ID"));
                }
                if (startEndDescription.getActId() != null && workflowProcess.getActivity(startEndDescription.getActId()) == null) {
                    hashSet.addAll(GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string4, startEndDescription.getActId(), "CONNECTING_ACTIVITY_ID"));
                }
                if (startEndDescription.getActSetId() != null && workflowProcess.getActivitySet(startEndDescription.getActSetId()) == null) {
                    hashSet.addAll(GraphUtilities.getStartOrEndExtendedAttributes(workflowProcess, string4, startEndDescription.getActSetId(), "ACTIVITY_SET_ID"));
                }
                String string5 = "ACTIVITY_START";
                if (!startEndDescription.isStart()) {
                    string5 = "ACTIVITY_END";
                }
                object3 = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(activities, string5, true);
                GraphUtilities.createParticipantIdEA(object3, startEndDescription.getParticipantId(), true);
                GraphUtilities.createNodeGraphicsInfo(object3, startEndDescription.getOffset(), GraphUtilities.getLaneIdForMigration(object3), true);
                ExtendedAttribute extendedAttribute3 = GraphUtilities.getParticipantIdEA(object3);
                if (extendedAttribute3 != null) {
                    ((ExtendedAttributes)extendedAttribute3.getParent()).remove((XMLElement)extendedAttribute3);
                    bl2 = true;
                }
                Transition transition = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(transitions, "", false);
                object2 = null;
                if (startEndDescription.isStart()) {
                    transition.setFrom(object3.getId());
                    string = startEndDescription.getActId();
                    if (!"".equals(string) && (object2 = workflowProcess.getActivity(string)) != null) {
                        string = GraphUtilities.getProperActIdForStart(workflowProcess, object2, object2.getId(), 1);
                    }
                    transition.setTo(string);
                } else {
                    transition.setTo(object3.getId());
                    string = startEndDescription.getActId();
                    if (!"".equals(string) && (object2 = workflowProcess.getActivity(string)) != null) {
                        string = GraphUtilities.getProperActIdForEnd(workflowProcess, object2, object2.getId(), 1);
                    }
                    transition.setFrom(string);
                }
                transitions.add((XMLElement)transition);
                GraphUtilities.createConnectorGraphicsInfo((XMLCollectionElement)transition, startEndDescription.getTransitionStyle(), true);
                hashSet.addAll(GraphUtilities.getStartOrEndExtendedAttributes(xMLCollectionElement, true));
                hashSet.addAll(GraphUtilities.getStartOrEndExtendedAttributes(xMLCollectionElement, false));
                if (object2 == null) continue;
                XMLUtil.correctSplitAndJoin((Activity)object2);
            }
            if (hashSet.size() > 0) {
                extendedAttributes.removeAll(new ArrayList(hashSet));
                bl2 = true;
            }
            for (Transition transition : transitions.toElements()) {
                ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo((XMLCollectionElement)transition);
                if (connectorGraphicsInfo == null) {
                    connectorGraphicsInfo = GraphUtilities.updateConnectorGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)transition);
                    bl2 = true;
                }
                if (connectorGraphicsInfo == null) {
                    object3 = GraphUtilities.getStyleOld(transition);
                    connectorGraphicsInfo = GraphUtilities.createConnectorGraphicsInfo((XMLCollectionElement)transition, object3, false);
                    List list2 = GraphUtilities.getBreakpointsOld(transition);
                    if (list2.size() > 0) {
                        GraphUtilities.setBreakPointCoordinates(connectorGraphicsInfo, list2);
                    }
                    ((ConnectorGraphicsInfos)connectorGraphicsInfo.getParent()).add((XMLElement)connectorGraphicsInfo);
                    bl2 = true;
                    continue;
                }
                object3 = GraphUtilities.getStyle((XMLCollectionElement)transition);
                if (GraphEAConstants.transitionStyles.contains(object3)) continue;
                connectorGraphicsInfo.setStyle("NO_ROUTING_SPLINE");
                bl2 = true;
            }
            for (ParticipantInfo participantInfo : sequencedHashMap.values()) {
                List list3 = participantInfo.getActivities();
                object3 = new HashMap();
                for (int i = 0; i < list3.size(); ++i) {
                    Activity activity = (Activity)list3.get(i);
                    object2 = GraphUtilities.getOffsetPoint(activity);
                    if (object3.containsKey(object2)) {
                        string = (Activity)object3.get(object2);
                        object = GraphUtilities.getOffsetPoint((Activity)string);
                        object.x += n2 + 30;
                        object.y += n3 + 15;
                        GraphUtilities.setOffsetPoint((XMLCollectionElement)activity, (Point)object, JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)activity));
                        bl2 = true;
                    }
                    object3.put(object2, activity);
                }
            }
        } else {
            String string;
            Object object;
            NodeGraphicsInfo nodeGraphicsInfo2;
            Activity activity2;
            Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
            for (Activity activity2 : activities.toElements()) {
                nodeGraphicsInfo2 = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity2);
                if (nodeGraphicsInfo2 != null) continue;
                nodeGraphicsInfo2 = GraphUtilities.updateNodeGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)activity2, xMLCollectionElement);
                if (nodeGraphicsInfo2 == null || nodeGraphicsInfo2.getLaneId().equals("")) {
                    object = null;
                    if (activity2.getActivityType() == 1 || activity2.getActivityType() == 2) {
                        string = activity2.getFirstPerformer();
                        Lane lane = GraphUtilities.getLaneForPerformer(pool, string);
                        if (lane == null && (lane = GraphUtilities.getDefaultLane(pool)) == null) {
                            lane = GraphUtilities.createDefaultLane(pool);
                        }
                        object = lane.getId();
                    } else if (pool.getLanes().size() > 0) {
                        object = ((Lane)pool.getLanes().get(0)).getId();
                    } else {
                        string = GraphUtilities.createDefaultLane(pool);
                        object = string.getId();
                    }
                    if (nodeGraphicsInfo2 == null) {
                        nodeGraphicsInfo2 = GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)activity2, new Point(10 + (int)(300.0 * Math.random()), (int)(10.0 + 200.0 * Math.random())), (String)object, true);
                    } else {
                        nodeGraphicsInfo2.setLaneId((String)object);
                    }
                }
                bl2 = true;
            }
            for (Activity activity2 : transitions.toElements()) {
                nodeGraphicsInfo2 = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo((XMLCollectionElement)activity2);
                if (nodeGraphicsInfo2 != null) continue;
                nodeGraphicsInfo2 = GraphUtilities.updateConnectorGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)activity2);
                if (nodeGraphicsInfo2 == null) {
                    nodeGraphicsInfo2 = GraphUtilities.createConnectorGraphicsInfo((XMLCollectionElement)activity2, "NO_ROUTING_SPLINE", true);
                }
                bl2 = true;
            }
            for (Activity activity2 : XMLUtil.getPackage((XMLElement)xMLCollectionElement).getArtifacts().toElements()) {
                nodeGraphicsInfo2 = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity2);
                if (nodeGraphicsInfo2 != null) continue;
                nodeGraphicsInfo2 = GraphUtilities.updateNodeGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)activity2, xMLCollectionElement);
                if (nodeGraphicsInfo2 == null || nodeGraphicsInfo2.getLaneId().equals("")) {
                    object = XMLUtil.getArtifactReferences((Package)XMLUtil.getPackage((XMLElement)pool), (String)activity2.getId());
                    string = null;
                    if (object.size() > 0) {
                        for (int i = 0; i < object.size(); ++i) {
                            Association association = XMLUtil.getAssociation((XMLElement)((XMLElement)object.get(i)));
                            String string6 = association.getSource().equals(activity2.getId()) ? association.getTarget() : association.getSource();
                            Activity activity3 = ((Activities)xMLCollectionElement.get("Activities")).getActivity(string6);
                            if (activity3 == null) continue;
                            string = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)activity3).getLaneId();
                            break;
                        }
                    }
                    if (string == null) continue;
                    if (nodeGraphicsInfo2 == null) {
                        nodeGraphicsInfo2 = GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)activity2, new Point(10 + (int)(300.0 * Math.random()), (int)(10.0 + 200.0 * Math.random())), string, true);
                    } else {
                        nodeGraphicsInfo2.setLaneId(string);
                    }
                    bl2 = true;
                    continue;
                }
                bl2 = true;
            }
            for (Activity activity2 : XMLUtil.getPackage((XMLElement)xMLCollectionElement).getAssociations().toElements()) {
                nodeGraphicsInfo2 = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo((XMLCollectionElement)activity2);
                if (nodeGraphicsInfo2 != null) continue;
                nodeGraphicsInfo2 = GraphUtilities.updateConnectorGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)activity2);
                if (nodeGraphicsInfo2 == null) {
                    nodeGraphicsInfo2 = GraphUtilities.createConnectorGraphicsInfo((XMLCollectionElement)activity2, "NO_ROUTING_SPLINE", true);
                }
                bl2 = true;
            }
            activity2 = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)pool);
            if (activity2 == null) {
                activity2 = GraphUtilities.updateNodeGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)pool, null);
                if (activity2 == null) {
                    activity2 = GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)pool, null, null, true);
                }
                bl2 = true;
            }
            for (NodeGraphicsInfo nodeGraphicsInfo2 : pool.getLanes().toElements()) {
                activity2 = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)nodeGraphicsInfo2);
                if (activity2 != null) continue;
                activity2 = GraphUtilities.updateNodeGraphicsInfoFromAnyOtherVendor((XMLCollectionElement)nodeGraphicsInfo2, null);
                if (activity2 == null) {
                    activity2 = GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)nodeGraphicsInfo2, null, null, true);
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    protected static String getProperActIdForEnd(WorkflowProcess workflowProcess, Activity activity, String string, int n) {
        String string2;
        Activity activity2;
        if (n > 1 && activity.getId().equals(string)) {
            return string;
        }
        Set set = XMLUtil.getNonExceptionalOutgoingTransitions((Activity)activity);
        if (set.size() == 1 && (activity2 = workflowProcess.getActivity(string2 = ((Transition)set.toArray()[0]).getTo())) != null && !activity2.getId().equals(activity.getId())) {
            return GraphUtilities.getProperActIdForEnd(workflowProcess, activity2, string, ++n);
        }
        return activity.getId();
    }

    protected static String getProperActIdForStart(WorkflowProcess workflowProcess, Activity activity, String string, int n) {
        String string2;
        Activity activity2;
        if (n > 1 && activity.getId().equals(string)) {
            return string;
        }
        Set set = XMLUtil.getIncomingTransitions((Activity)activity);
        if (set.size() == 1 && (activity2 = workflowProcess.getActivity(string2 = ((Transition)set.toArray()[0]).getFrom())) != null && !activity2.getId().equals(activity.getId())) {
            return GraphUtilities.getProperActIdForStart(workflowProcess, activity2, string, ++n);
        }
        return activity.getId();
    }

    protected static String getLaneIdForMigration(Activity activity) {
        String string = activity.getFirstPerformer();
        if (string.equals("")) {
            string = GraphUtilities.getParticipantId(activity);
        }
        XMLCollectionElement xMLCollectionElement = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)activity);
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        Lane lane = GraphUtilities.getLaneForPerformer(pool, string);
        if (lane == null && (lane = GraphUtilities.getDefaultLane(pool)) == null) {
            lane = GraphUtilities.createDefaultLane(pool);
        }
        return lane.getId();
    }

    protected static List getParticipants(Activities activities) {
        ArrayList<Participant> arrayList = new ArrayList<Participant>();
        List list = GraphUtilities.getAllPossiblePerformers(activities);
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)activities);
        FreeTextExpressionParticipant freeTextExpressionParticipant = FreeTextExpressionParticipant.getInstance();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            Participant participant = XMLUtil.findParticipant((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (WorkflowProcess)workflowProcess, (String)string);
            if (participant == null) {
                participant = freeTextExpressionParticipant;
            }
            if (arrayList.contains(participant)) continue;
            arrayList.add(participant);
        }
        return arrayList;
    }

    protected static List getAllPossiblePerformers(Activities activities) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        arrayList2.add(new Integer(1));
        arrayList2.add(new Integer(2));
        Iterator iterator = JaWEManager.getInstance().getXPDLUtils().getActivities(activities, arrayList2).iterator();
        while (iterator.hasNext()) {
            String string = ((Activity)iterator.next()).getFirstPerformer();
            if (string.equals("") || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public static boolean isMyKindOfExtendedAttribute(ExtendedAttribute extendedAttribute) {
        boolean bl = false;
        ExtendedAttributes extendedAttributes = (ExtendedAttributes)extendedAttribute.getParent();
        String string = extendedAttribute.getName();
        if (extendedAttributes.getParent() instanceof WorkflowProcess && (string.equals("JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORIENTATION") || string.equals("JaWE_GRAPH_BLOCK_PARTICIPANT_ORIENTATION") || string.equals("JaWE_GRAPH_WORKFLOW_PARTICIPANT_ORDER") || string.equals("JaWE_GRAPH_BLOCK_PARTICIPANT_ORDER") || string.equals("JaWE_GRAPH_END_OF_WORKFLOW") || string.equals("JaWE_GRAPH_START_OF_WORKFLOW") || string.equals("JaWE_GRAPH_END_OF_BLOCK") || string.equals("JaWE_GRAPH_START_OF_BLOCK"))) {
            bl = true;
        } else if (extendedAttributes.getParent() instanceof Activity && (string.equals("JaWE_GRAPH_PARTICIPANT_ID") || string.equals("JaWE_GRAPH_OFFSET"))) {
            bl = true;
        } else if (extendedAttributes.getParent() instanceof Transition && (string.equals("JaWE_GRAPH_BREAK_POINTS") || string.equals("JaWE_GRAPH_TRANSITION_STYLE"))) {
            bl = true;
        }
        return bl;
    }

    public static void adjustPackageOnUndoOrRedoEvent(List list, boolean bl) {
        Set set;
        Package package_ = JaWEManager.getInstance().getJaWEController().getMainPackage();
        GraphController graphController = GraphUtilities.getGraphController();
        Pool pool = GraphUtilities.getRotatedGraphObject(list);
        if (pool != null) {
            set = JaWEManager.getInstance().getXPDLUtils().getProcessForPool(pool);
            if (set == null) {
                set = JaWEManager.getInstance().getXPDLUtils().getActivitySetForPool(pool);
            }
            if (set != null) {
                Graph graph = graphController.getGraph((XMLCollectionElement)set);
                Object[] objectArray = JaWEGraphModel.getAll((GraphModel)graph.getModel());
                graph.getModel().remove(objectArray);
                graph.getGraphManager().createWorkflowGraph(graph.getXPDLObject());
                return;
            }
        }
        set = GraphUtilities.getInsertedOrRemovedWorkflowProcesses(list, true);
        Set set2 = GraphUtilities.getInsertedOrRemovedActivitySets(list, true);
        Set set3 = GraphUtilities.getInsertedOrRemovedWorkflowProcesses(list, false);
        Set set4 = GraphUtilities.getInsertedOrRemovedActivitySets(list, false);
        for (WorkflowProcess workflowProcess : set3) {
            graphController.removeGraph((XMLCollectionElement)workflowProcess);
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                graphController.removeGraph((XMLCollectionElement)activitySet);
            }
        }
        for (WorkflowProcess workflowProcess : set4) {
            graphController.removeGraph((XMLCollectionElement)workflowProcess);
        }
        for (WorkflowProcess workflowProcess : set) {
            graphController.createGraph(workflowProcess);
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                graphController.createGraph(activitySet);
            }
        }
        for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
            if (set.contains(workflowProcess)) continue;
            GraphUtilities.adjustWorkflowProcessOrActivitySetOnUndoOrRedoEvent(list, (XMLCollectionElement)workflowProcess, bl);
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                if (set2.contains(activitySet)) continue;
                GraphUtilities.adjustWorkflowProcessOrActivitySetOnUndoOrRedoEvent(list, (XMLCollectionElement)activitySet, bl);
            }
        }
        for (WorkflowProcess workflowProcess : set2) {
            graphController.createGraph((ActivitySet)workflowProcess);
        }
    }

    public static void adjustWorkflowProcessOrActivitySetOnUndoOrRedoEvent(List list, XMLCollectionElement xMLCollectionElement, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Object object722;
        Graph graph = GraphUtilities.getGraphController().getGraph(xMLCollectionElement);
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        GraphManager graphManager = graph.getGraphManager();
        List list2 = GraphUtilities.getLanesInVisualOrder(xMLCollectionElement);
        HashSet hashSet = new HashSet();
        Set set = GraphUtilities.getInsertedOrRemovedActivitiesAndArtifacts(list, xMLCollectionElement, true, !bl);
        Set set2 = GraphUtilities.getInsertedOrRemovedActivitiesAndArtifacts(list, xMLCollectionElement, false, !bl);
        GraphUtilities.updateJGraphForActivityAndArtifactBounds(graph, list, xMLCollectionElement);
        Set set3 = GraphUtilities.getActivitiesAndArtifactsWithChangedOffset(list, xMLCollectionElement);
        set3.addAll(GraphUtilities.getActivitiesAndArtifactsWithChangedLaneId(list, xMLCollectionElement));
        set3.removeAll(set2);
        Set set4 = GraphUtilities.getInsertedOrRemovedTransitionsAndAssociations(list, xMLCollectionElement, true);
        Set set5 = GraphUtilities.getInsertedOrRemovedTransitionsAndAssociations(list, xMLCollectionElement, false);
        Set set6 = GraphUtilities.getUpdatedTransitionsAndAssociations(list, xMLCollectionElement);
        set6.addAll(GraphUtilities.getTransitionsWithChangedBreakpointsOrStyle(list, xMLCollectionElement));
        set6.removeAll(set5);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list3 = JaWEGraphModel.getAllParticipantsInModel(graph.getModel());
        if (list3 != null) {
            for (Object object722 : list3) {
                if (!(object722.getUserObject() instanceof Lane)) continue;
                arrayList.add(object722.getUserObject());
            }
        }
        HashSet hashSet2 = new HashSet(list2);
        hashSet2.removeAll(arrayList);
        hashSet.addAll(arrayList);
        hashSet.removeAll(list2);
        object722 = new HashMap();
        for (Object object8 : hashSet) {
            GraphSwimlaneInterface object62 = graphManager.getGraphParticipant(object8);
            object5 = object62.getChildActivitiesAndArtifacts();
            if (object5 == null || object5.size() <= 0) continue;
            object42 = object5.iterator();
            while (object42.hasNext()) {
                object3 = (WorkflowElement)object42.next();
                if (set2.contains(object3.getPropertyObject()) || set3.contains(object3.getPropertyObject()) || (object2 = GraphUtilities.getLane(xMLCollectionElement, (String)(object = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)object3.getPropertyObject())))) == null) continue;
                object722.put(object8, object2);
            }
        }
        for (Map.Entry entry : object722.entrySet()) {
            object5 = (Lane)entry.getKey();
            object42 = (Lane)entry.getValue();
            object3 = graphManager.getGraphParticipant(object5);
            object3.setUserObject(object42);
            hashSet2.remove(object42);
            hashSet.remove(object5);
        }
        ArrayList arrayList2 = new ArrayList(list2);
        arrayList2.retainAll(hashSet2);
        for (Object object42 : arrayList2) {
            graphManager.insertParticipantAndArrangeParticipants(object42, null);
        }
        for (Object object42 : set5) {
            graphManager.removeTransitionOrAssociation((XMLCollectionElement)object42);
        }
        for (Object object42 : set2) {
            graphManager.removeActivityOrArtifact((XMLCollectionElement)object42);
        }
        for (Object object42 : set) {
            graphManager.insertActivityOrArtifact((XMLCollectionElement)object42);
        }
        for (Object object42 : set4) {
            graphManager.insertTransitionOrAssociation((XMLCollectionElement)object42);
        }
        for (Object object42 : set3) {
            graphManager.arrangeActivityOrArtifactPosition((XMLCollectionElement)object42);
        }
        for (Object object42 : set6) {
            graphManager.updateTransitionOrAssociation((XMLCollectionElement)object42);
        }
        if (hashSet.size() > 0) {
            object42 = new ArrayList();
            object5 = hashSet.iterator();
            while (object5.hasNext()) {
                object3 = graphManager.getGraphParticipant((Lane)object5.next());
                object42.add(object3);
            }
            graphManager.removeCellsAndArrangeParticipants(object42.toArray());
        }
        object42 = new JaWEParentMap();
        object3 = new HashMap();
        list3 = JaWEGraphModel.getAllParticipantsInModel(graph.getModel());
        if (list3 != null) {
            int n;
            int n2;
            int n3;
            GraphSwimlaneInterface graphSwimlaneInterface;
            int n4;
            GraphSwimlaneInterface graphSwimlaneInterface2;
            list3.remove(graph.getGraphManager().getGraphParticipant(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement)));
            object = new GraphParticipantComparator(graphManager);
            Collections.sort(list3, object);
            object2 = GraphUtilities.getLanesWithChangedOrder(list);
            Set set7 = GraphUtilities.getNestedLanesWithChangedOrder(list);
            ArrayList<GraphSwimlaneInterface> arrayList3 = new ArrayList<GraphSwimlaneInterface>();
            ArrayList<GraphSwimlaneInterface> arrayList4 = new ArrayList<GraphSwimlaneInterface>();
            object5 = object2.iterator();
            while (object5.hasNext()) {
                Lane lane = (Lane)object5.next();
                graphSwimlaneInterface2 = graph.getGraphManager().getGraphParticipant(lane);
                if (graphSwimlaneInterface2 != null) {
                    if (!(graphSwimlaneInterface2.getParent() instanceof GraphSwimlaneInterface) || !(((GraphSwimlaneInterface)((Object)graphSwimlaneInterface2.getParent())).getPropertyObject() instanceof Pool)) continue;
                    arrayList3.add(graphSwimlaneInterface2);
                    continue;
                }
                System.out.println("Can't find GPI for lane " + lane);
            }
            for (Lane lane : set7) {
                graphSwimlaneInterface2 = graph.getGraphManager().getGraphParticipant(lane);
                if (graphSwimlaneInterface2 != null) {
                    arrayList4.add(graphSwimlaneInterface2);
                    continue;
                }
                System.out.println("Can't find GPI for lane " + lane);
            }
            boolean bl2 = false;
            System.out.println("CPARS=" + list2);
            for (n4 = 0; n4 < list2.size(); ++n4) {
                System.out.println("GPARS=" + list3);
                graphSwimlaneInterface = graphManager.getGraphParticipant(list2.get(n4));
                if (!arrayList3.contains(graphSwimlaneInterface)) continue;
                n3 = n4;
                n2 = list3.indexOf(graphSwimlaneInterface);
                if (n3 != n2) {
                    n = n3 - n2;
                    System.out.println("Repositioning participant " + graphSwimlaneInterface + " for " + n + ",oi=" + n2 + ", ni=" + n3);
                    for (int i = 0; i < Math.abs(n); ++i) {
                        bl2 = graphManager.moveParticipant(graphSwimlaneInterface, n < 0, (Map)object3, (ParentMap)object42) || bl2;
                    }
                    list3.remove(n2);
                    list3.add(n3, graphSwimlaneInterface);
                    continue;
                }
                System.out.println("participant " + graphSwimlaneInterface + ",oi=" + n2 + ", ni=" + n3 + ", needs no repositioning");
            }
            for (n4 = 0; n4 < list2.size(); ++n4) {
                System.out.println("GPARS=" + list3);
                graphSwimlaneInterface = graphManager.getGraphParticipant(list2.get(n4));
                if (!arrayList4.contains(graphSwimlaneInterface) || (n3 = n4) == (n2 = list3.indexOf(graphSwimlaneInterface))) continue;
                n = n3 - n2;
                System.out.println("Repositioning nested participant " + graphSwimlaneInterface + " for " + n + ",oi=" + n2 + ", ni=" + n3);
                bl2 = graphManager.moveParticipant(graphSwimlaneInterface, n < 0, (Map)object3, (ParentMap)object42) || bl2;
                list3.remove(n2);
                list3.add(n3, graphSwimlaneInterface);
            }
            if (bl2) {
                graphManager.graphModel().insertAndEdit(null, (Map)object3, null, (ParentMap)object42, null);
            }
        }
        graph.repaint();
    }

    public static void adjustPackageOnUndoableChangeEvent(List list) {
        Object object;
        Package package_ = JaWEManager.getInstance().getJaWEController().getMainPackage();
        GraphController graphController = GraphUtilities.getGraphController();
        Set set = GraphUtilities.getInsertedOrRemovedWorkflowProcesses(list, true);
        Set set2 = GraphUtilities.getInsertedOrRemovedActivitySets(list, true);
        Set set3 = GraphUtilities.getInsertedOrRemovedWorkflowProcesses(list, false);
        Set set4 = GraphUtilities.getInsertedOrRemovedActivitySets(list, false);
        Map map = GraphUtilities.getActivitySetsWithChangedId(list);
        for (WorkflowProcess workflowProcess : set3) {
            graphController.removeGraph((XMLCollectionElement)workflowProcess);
            object = JaWEManager.getInstance().getXPDLUtils().getPoolForProcess(workflowProcess);
            if (object != null) {
                ((Pools)object.getParent()).remove((XMLElement)object);
            }
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                graphController.removeGraph((XMLCollectionElement)activitySet);
                object = JaWEManager.getInstance().getXPDLUtils().getPoolForActivitySet(activitySet);
                if (object == null) continue;
                ((Pools)object.getParent()).remove((XMLElement)object);
            }
        }
        for (WorkflowProcess workflowProcess : set4) {
            graphController.removeGraph((XMLCollectionElement)workflowProcess);
        }
        for (WorkflowProcess workflowProcess : set) {
            object = JaWEManager.getInstance().getXPDLUtils().getPoolForProcess(workflowProcess);
            if (JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)object) == null) {
                GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)object, null, null, true);
            }
            graphController.createGraph(workflowProcess);
            for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                object = JaWEManager.getInstance().getXPDLUtils().getPoolForActivitySet(activitySet);
                if (JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo((XMLCollectionElement)object) == null) {
                    GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)object, null, null, true);
                }
                graphController.createGraph(activitySet);
            }
        }
        if (set.size() == 0) {
            for (WorkflowProcess workflowProcess : package_.getWorkflowProcesses().toElements()) {
                GraphUtilities.adjustWorkflowProcessOrActivitySetOnUndoableChangeEvent(list, (XMLCollectionElement)workflowProcess, null, false);
                if (set2.size() != 0) continue;
                for (ActivitySet activitySet : workflowProcess.getActivitySets().toElements()) {
                    GraphUtilities.adjustWorkflowProcessOrActivitySetOnUndoableChangeEvent(list, (XMLCollectionElement)activitySet, null, false);
                }
            }
        }
        for (WorkflowProcess workflowProcess : set2) {
            object = JaWEManager.getInstance().getXPDLUtils().getPoolForActivitySet((ActivitySet)workflowProcess);
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)object, null, null, true);
            graphController.createGraph((ActivitySet)workflowProcess);
        }
    }

    public static void adjustWorkflowProcessOrActivitySetOnUndoableChangeEvent(List list, XMLCollectionElement xMLCollectionElement, Map map, boolean bl) {
        GraphActivityInterface graphActivityInterface;
        Object object4;
        Object object22;
        boolean bl2;
        Object object32;
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLCollectionElement);
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        GraphController graphController = GraphUtilities.getGraphController();
        Graph graph = graphController.getGraph(xMLCollectionElement);
        if (graph == null) {
            System.err.println("can't find graph for wporas " + xMLCollectionElement.getId());
        }
        GraphManager graphManager = graph.getGraphManager();
        boolean bl3 = GraphUtilities.reloadGraphIfNeccessary(graph);
        if (bl3) {
            return;
        }
        if (GraphUtilities.hasPoolOrientationChanged(list, xMLCollectionElement)) {
            GraphUtilities.rotateProcess(graph);
            return;
        }
        String string = null;
        if (xMLCollectionElement instanceof ActivitySet) {
            string = xMLCollectionElement.getId();
        }
        List list2 = GraphUtilities.getLanesInVisualOrder(xMLCollectionElement);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        List list3 = JaWEGraphModel.getAllParticipantsInModel(graph.getModel());
        if (list3 != null) {
            for (Object object32 : list3) {
                if (!(object32.getUserObject() instanceof Lane)) continue;
                arrayList.add(object32.getUserObject());
            }
        }
        HashSet hashSet = new HashSet(list2);
        object32 = new HashSet(arrayList);
        hashSet.removeAll(arrayList);
        object32.removeAll(list2);
        Set set = GraphUtilities.getInsertedOrRemovedActivitiesAndArtifacts(list, xMLCollectionElement, true, false);
        Set set2 = GraphUtilities.getInsertedOrRemovedActivitiesAndArtifacts(list, xMLCollectionElement, false, false);
        Map map2 = GraphUtilities.updateJGraphForActivityAndArtifactBounds(graph, list, xMLCollectionElement);
        Set set3 = GraphUtilities.getActivitiesWithChangedPerformer(list, xMLCollectionElement);
        set3.removeAll(set2);
        Set set4 = GraphUtilities.getActivitiesAndArtifactsWithChangedOffset(list, xMLCollectionElement);
        set4.removeAll(set2);
        Set set5 = GraphUtilities.getInsertedOrRemovedTransitionsAndAssociations(list, xMLCollectionElement, true);
        Set set6 = GraphUtilities.getInsertedOrRemovedTransitionsAndAssociations(list, xMLCollectionElement, false);
        Set set7 = GraphUtilities.getUpdatedTransitionsAndAssociations(list, xMLCollectionElement);
        set7.removeAll(set6);
        List list4 = GraphUtilities.getLaneVisualOrder(xMLCollectionElement);
        boolean bl4 = JaWEManager.getInstance().getJaWEController().getEdit().isPasteInProgress();
        CopyOrCutInfo copyOrCutInfo = graphController.getCopyOrCutInfo();
        boolean bl5 = bl2 = bl4 && copyOrCutInfo != null && (set.size() > 0 || set5.size() > 0);
        if (bl2 && GraphUtilities.getGraphController().getSelectedGraph().getXPDLObject() != xMLCollectionElement) {
            return;
        }
        ArrayList arrayList2 = ((Activities)xMLCollectionElement.get("Activities")).toElements();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Lane lane;
            boolean bl6;
            object22 = (Activity)arrayList2.get(i);
            object4 = null;
            if (set3.contains(object22)) {
                object4 = GraphUtilities.getLaneForPerformer(pool, object22.getFirstPerformer());
            } else {
                String string2 = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)object22);
                object4 = GraphUtilities.getLane(xMLCollectionElement, string2);
            }
            if (object4 == null) {
                if (bl2) continue;
                arrayList3.add(object22);
                object4 = GraphUtilities.getDefaultLane(pool);
                if (object4 == null) {
                    object4 = GraphUtilities.createDefaultLane(pool);
                }
                if (!list4.contains(object4.getId())) {
                    hashSet.add(object4);
                    list4.add(object4.getId());
                }
                GraphUtilities.setLaneId((XMLCollectionElement)object22, object4.getId());
                continue;
            }
            GraphUtilities.setLaneId((XMLCollectionElement)object22, object4.getId());
            boolean bl7 = bl6 = graph.getGraphManager().getGraphParticipant(object4) != null;
            if (!bl6) {
                hashSet.add(object4);
                arrayList3.add(object22);
                continue;
            }
            graphActivityInterface = graph.getGraphManager().getGraphActivity((Activity)object22);
            if (graphActivityInterface == null || (lane = (Lane)((GraphSwimlaneInterface)((Object)graphActivityInterface.getParent())).getUserObject()) == object4) continue;
            arrayList3.add(object22);
        }
        set3.addAll(arrayList3);
        arrayList3.removeAll(set);
        for (Object object22 : set) {
            if (bl2) {
                GraphUtilities.adjustPastedActivityOrArtifact((XMLCollectionElement)object22, list4, hashSet, copyOrCutInfo, graphManager);
                continue;
            }
            GraphUtilities.adjustInsertedOrUpdatedActivityOrArtifact(xMLCollectionElement, (XMLCollectionElement)object22, list4, hashSet);
        }
        for (Object object22 : set3) {
            GraphUtilities.adjustInsertedOrUpdatedActivityOrArtifact(xMLCollectionElement, (XMLCollectionElement)object22, list4, hashSet);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            int n;
            object22 = (Lane)iterator.next();
            GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)object22, null, null, true);
            graphManager.insertParticipantAndArrangeParticipants(object22, null);
            object4 = GraphUtilities.getAllActivitiesAndArtifactsForLaneId(set, object22.getId());
            for (n = 0; n < object4.size(); ++n) {
                graphActivityInterface = (XMLCollectionElement)object4.get(n);
                graphManager.insertActivityOrArtifact((XMLCollectionElement)graphActivityInterface);
            }
            set.removeAll((Collection<?>)object4);
            object4 = GraphUtilities.getAllActivitiesAndArtifactsForLaneId(set3, object22.getId());
            for (n = 0; n < object4.size(); ++n) {
                graphActivityInterface = (XMLCollectionElement)object4.get(n);
                graphManager.arrangeActivityOrArtifactPosition((XMLCollectionElement)graphActivityInterface);
            }
            set3.removeAll((Collection<?>)object4);
        }
        for (Object object22 : set) {
            graphManager.insertActivityOrArtifact((XMLCollectionElement)object22);
        }
        for (Object object22 : set3) {
            graphManager.arrangeActivityOrArtifactPosition((XMLCollectionElement)object22);
        }
        object22 = new ArrayList(set7);
        object22.addAll(set5);
        if (bl2) {
            GraphUtilities.adjustPastedTransitionsOrAssociations((List)object22, copyOrCutInfo, graphManager);
        } else {
            GraphUtilities.adjustInsertedOrUpdatedTransitionsOrAssociations((List)object22, graphManager);
        }
        for (Object object4 : set6) {
            graphManager.removeTransitionOrAssociation((XMLCollectionElement)object4);
        }
        for (Object object4 : set7) {
            graphManager.updateTransitionOrAssociation((XMLCollectionElement)object4);
        }
        for (Object object4 : set5) {
            graphManager.insertTransitionOrAssociation((XMLCollectionElement)object4);
        }
        for (Object object4 : set2) {
            graphManager.removeActivityOrArtifact((XMLCollectionElement)object4);
        }
        if (object32.size() > 0) {
            object4 = new HashSet();
            iterator = object32.iterator();
            while (iterator.hasNext()) {
                Lane lane = (Lane)iterator.next();
                object4.add(graphManager.getGraphParticipant(lane));
            }
            graphManager.removeCellsAndArrangeParticipants(object4.toArray());
        }
        if (bl2) {
            copyOrCutInfo.incrementOffsetPoint(graph);
        }
        if (map2.size() > 0) {
            graphManager.updateModelAndArrangeParticipants(null, map2, new JaWEParentMap(), null, "", null, true);
        }
        graph.repaint();
        System.out.println("AGP2=" + JaWEGraphModel.getAllParticipantsInModel(graph.getModel()));
    }

    public static void adjustInsertedOrUpdatedActivityOrArtifact(XMLCollectionElement xMLCollectionElement, XMLCollectionElement xMLCollectionElement2, List list, Set set) {
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo(xMLCollectionElement2);
        Lane lane = null;
        if (nodeGraphicsInfo == null) {
            int n = GraphUtilities.getGraphController().getGraphSettings().getLaneNameWidth();
            if (xMLCollectionElement2 instanceof Activity) {
                String string = ((Activity)xMLCollectionElement2).getFirstPerformer();
                if (string.equals("")) {
                    lane = GraphUtilities.getDefaultLane(pool);
                    if (lane == null) {
                        lane = GraphUtilities.createDefaultLane(pool);
                    }
                } else {
                    lane = GraphUtilities.getLaneForPerformer(pool, ((Activity)xMLCollectionElement2).getFirstPerformer());
                    if (lane == null) {
                        lane = GraphUtilities.createLaneForPerformer(pool, ((Activity)xMLCollectionElement2).getFirstPerformer());
                    }
                }
            } else {
                lane = GraphUtilities.getDefaultLane(pool);
                if (lane == null) {
                    lane = GraphUtilities.createDefaultLane(pool);
                }
            }
            nodeGraphicsInfo = GraphUtilities.createNodeGraphicsInfo(xMLCollectionElement2, new Point(n, n), lane.getId(), true);
        } else {
            lane = pool.getLanes().getLane(nodeGraphicsInfo.getLaneId());
            if (lane == null) {
                lane = GraphUtilities.getDefaultLane(pool);
                if (lane == null) {
                    lane = GraphUtilities.createDefaultLane(pool);
                }
                nodeGraphicsInfo.setLaneId(lane.getId());
            }
        }
        if (!list.contains(lane.getId())) {
            set.add(lane);
        }
    }

    public static void adjustPastedActivityOrArtifact(XMLCollectionElement xMLCollectionElement, List list, Set set, CopyOrCutInfo copyOrCutInfo, GraphManager graphManager) {
        Point point = copyOrCutInfo.getPastePoint();
        Point point2 = copyOrCutInfo.getOffsetPoint(graphManager.getGraph());
        Point point3 = copyOrCutInfo.getReferencePoint();
        if (point != null) {
            Activity activity;
            int n;
            String string = JaWEManager.getInstance().getXPDLUtils().getLaneId(xMLCollectionElement);
            Point point4 = GraphUtilities.getOffsetPoint(xMLCollectionElement);
            CopiedActivityOrArtifactInfo copiedActivityOrArtifactInfo = new CopiedActivityOrArtifactInfo(string, point4);
            Rectangle rectangle = copyOrCutInfo.getActivityBounds(copiedActivityOrArtifactInfo);
            Point point5 = point3;
            if (rectangle != null) {
                point5 = rectangle.getLocation();
            }
            Point point6 = new Point(point5.x + point.x - point3.x, point5.y + point.y - point3.y);
            GraphSwimlaneInterface graphSwimlaneInterface = graphManager.findParentParticipantForLocation(point6, null, null);
            String string2 = ((Lane)graphSwimlaneInterface.getPropertyObject()).getId();
            GraphUtilities.setOffsetPoint(xMLCollectionElement, graphManager.getOffset(point6), string2);
            if (xMLCollectionElement instanceof Activity && ((n = (activity = (Activity)xMLCollectionElement).getActivityType()) == 1 || n == 2)) {
                Lane lane = GraphUtilities.getDefaultLane(JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(graphManager.getGraph().getXPDLObject()));
                if (lane == null || !string2.equals(lane.getId())) {
                    String string3 = GraphUtilities.getLanesFirstPerformer((Lane)graphSwimlaneInterface.getPropertyObject());
                    if (string3 == null) {
                        string3 = "";
                    }
                    activity.setFirstPerformer(string3);
                } else {
                    activity.setFirstPerformer("");
                }
            }
        } else {
            Point point7 = GraphUtilities.getOffsetPoint(xMLCollectionElement);
            Point point8 = new Point(point2.x + point7.x, point2.y + point7.y);
            Lane lane = GraphUtilities.getLaneForActivityOrArtifact(xMLCollectionElement, graphManager.getGraph().getXPDLObject());
            if (lane == null || !list.contains(lane.getId())) {
                Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(graphManager.getGraph().getXPDLObject());
                if (xMLCollectionElement instanceof Activity) {
                    lane = GraphUtilities.getLaneForPerformer(pool, ((Activity)xMLCollectionElement).getFirstPerformer());
                    if (lane != null) {
                        if (!list.contains(lane.getId())) {
                            list.add(lane.getId());
                            set.add(lane);
                        }
                    } else {
                        lane = GraphUtilities.createLaneForPerformer(pool, ((Activity)xMLCollectionElement).getFirstPerformer());
                        list.add(lane.getId());
                        set.add(lane);
                    }
                } else if (lane == null && (lane = GraphUtilities.getDefaultLane(pool)) == null) {
                    lane = GraphUtilities.createDefaultLane(pool);
                    list.add(lane.getId());
                    set.add(lane);
                }
            }
            GraphUtilities.setOffsetPoint(xMLCollectionElement, point8, lane.getId());
        }
    }

    public static void adjustPastedTransitionsOrAssociations(List list, CopyOrCutInfo copyOrCutInfo, GraphManager graphManager) {
        Iterator iterator = list.iterator();
        Point point = copyOrCutInfo.getPastePoint();
        Point point2 = copyOrCutInfo.getReferencePoint();
        while (iterator.hasNext()) {
            XMLCollectionElement xMLCollectionElement = (XMLCollectionElement)iterator.next();
            ArrayList arrayList = GraphUtilities.getBreakpoints(xMLCollectionElement);
            if (arrayList.size() <= 0) continue;
            if (point != null) {
                for (Point point3 : arrayList) {
                    point3.x += point.x - point2.x;
                    point3.y += point.y - point2.y;
                }
            } else {
                arrayList = new ArrayList();
            }
            GraphUtilities.setBreakpoints(xMLCollectionElement, arrayList);
        }
    }

    public static void adjustInsertedOrUpdatedTransitionsOrAssociations(List list, GraphManager graphManager) {
        for (XMLCollectionElement xMLCollectionElement : list) {
            int n;
            String string;
            ConnectorGraphicsInfo connectorGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement);
            String string2 = null;
            String string3 = null;
            if (xMLCollectionElement instanceof Transition) {
                string2 = ((Transition)xMLCollectionElement).getFrom();
                string3 = ((Transition)xMLCollectionElement).getTo();
            } else {
                string2 = ((Association)xMLCollectionElement).getSource();
                string3 = ((Association)xMLCollectionElement).getTarget();
            }
            if (connectorGraphicsInfo == null) {
                string = "NO_ROUTING_ORTHOGONAL";
                if (xMLCollectionElement instanceof Transition && string2.equals(string3)) {
                    string = "NO_ROUTING_BEZIER";
                }
                connectorGraphicsInfo = GraphUtilities.createConnectorGraphicsInfo(xMLCollectionElement, string, true);
            } else {
                string = GraphUtilities.getStyle(xMLCollectionElement);
                if (!GraphEAConstants.transitionStyles.contains(string)) {
                    connectorGraphicsInfo.setStyle("NO_ROUTING_ORTHOGONAL");
                }
            }
            if (!string2.equals(string3) || string2.equals("") || (string = JaWEManager.getInstance().getXPDLUtils().getConnectorGraphicsInfo(xMLCollectionElement)) != null) continue;
            GraphActivityInterface graphActivityInterface = graphManager.getGraphActivity(string2);
            Point point = new Point(50, 50);
            if (graphActivityInterface != null) {
                point = graphManager.getCenter(graphActivityInterface);
            }
            ArrayList<Point> arrayList = new ArrayList<Point>();
            int n2 = point.x - 50;
            int n3 = point.x + 50;
            if (n2 < 0) {
                n3 -= n2;
                n2 = 0;
            }
            if ((n = point.y - 50) < 0) {
                n = point.y + 50;
            }
            arrayList.add(new Point(Math.abs(n2), Math.abs(n)));
            arrayList.add(new Point(Math.abs(n3), Math.abs(n)));
            string = GraphUtilities.createConnectorGraphicsInfo(xMLCollectionElement, arrayList, true);
        }
    }

    public static Set getInsertedOrRemovedWorkflowProcesses(List list, boolean bl) {
        HashSet hashSet = new HashSet();
        List list2 = GraphUtilities.findInfoList(list, Package.class, WorkflowProcesses.class);
        for (int i = 0; i < list2.size(); ++i) {
            List list3;
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if ((!bl || xPDLElementChangeInfo.getAction() != 3) && (bl || xPDLElementChangeInfo.getAction() != 5) || (list3 = xPDLElementChangeInfo.getChangedSubElements()) == null) continue;
            hashSet.addAll(list3);
        }
        return hashSet;
    }

    public static Set getInsertedOrRemovedActivitySets(List list, boolean bl) {
        HashSet hashSet = new HashSet();
        List list2 = GraphUtilities.findInfoList(list, WorkflowProcess.class, ActivitySets.class);
        for (int i = 0; i < list2.size(); ++i) {
            List list3;
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if ((!bl || xPDLElementChangeInfo.getAction() != 3) && (bl || xPDLElementChangeInfo.getAction() != 5) || (list3 = xPDLElementChangeInfo.getChangedSubElements()) == null || list3.size() <= 0) continue;
            hashSet.addAll(list3);
        }
        return hashSet;
    }

    public static boolean hasPoolOrientationChanged(List list, XMLCollectionElement xMLCollectionElement) {
        HashMap hashMap = new HashMap();
        List list2 = GraphUtilities.findInfoList(list, Pool.class, XMLAttribute.class);
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if (!xPDLElementChangeInfo.getChangedElement().toName().equals("Orientation") || XMLUtil.getPool((XMLElement)xPDLElementChangeInfo.getChangedElement()) != pool) continue;
            return true;
        }
        return false;
    }

    public static Map getActivitySetsWithChangedId(List list) {
        HashMap<Object, ActivitySet> hashMap = new HashMap<Object, ActivitySet>();
        List list2 = GraphUtilities.findInfoList(list, ActivitySet.class, XMLAttribute.class);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            ActivitySet activitySet = XMLUtil.getActivitySet((XMLElement)xPDLElementChangeInfo.getChangedElement());
            hashMap.put(xPDLElementChangeInfo.getOldValue(), activitySet);
        }
        return hashMap;
    }

    public static Set getInsertedOrRemovedActivitiesAndArtifacts(List list, XMLCollectionElement xMLCollectionElement, boolean bl, boolean bl2) {
        XPDLElementChangeInfo xPDLElementChangeInfo;
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        List list2 = GraphUtilities.findInfoList(list, xMLCollectionElement.getClass(), Activities.class);
        for (int i = 0; i < list2.size(); ++i) {
            List list3;
            xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if ((!bl || xPDLElementChangeInfo.getAction() != 3) && (bl || xPDLElementChangeInfo.getAction() != 5) || xPDLElementChangeInfo.getChangedElement().getParent() != xMLCollectionElement || (list3 = xPDLElementChangeInfo.getChangedSubElements()) == null || list3.size() <= 0) continue;
            hashSet.addAll(list3);
        }
        list2 = GraphUtilities.findInfoList(list, Package.class, Artifacts.class);
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        if (pool != null) {
            xPDLElementChangeInfo = XMLUtil.getPackage((XMLElement)xMLCollectionElement);
            for (int i = 0; i < list2.size(); ++i) {
                List list4;
                XPDLElementChangeInfo xPDLElementChangeInfo2 = (XPDLElementChangeInfo)((Object)list2.get(i));
                if ((!bl || xPDLElementChangeInfo2.getAction() != 3) && (bl || xPDLElementChangeInfo2.getAction() != 5) || xPDLElementChangeInfo2.getChangedElement().getParent() != xPDLElementChangeInfo || (list4 = xPDLElementChangeInfo2.getChangedSubElements()) == null || list4.size() <= 0) continue;
                if (bl2) {
                    for (int j = 0; j < list4.size(); ++j) {
                        Artifact artifact = (Artifact)list4.get(j);
                        String string = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)artifact);
                        if (pool.getLanes().getLane(string) == null) continue;
                        hashSet.add(artifact);
                    }
                    continue;
                }
                hashSet.addAll(list4);
            }
        }
        return hashSet;
    }

    public static Set getActivitiesWithChangedPerformer(List list, XMLCollectionElement xMLCollectionElement) {
        HashSet<Activity> hashSet = new HashSet<Activity>();
        List list2 = GraphUtilities.findInfoList(list, Performers.class, Performer.class);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            Activity activity = XMLUtil.getActivity((XMLElement)xPDLElementChangeInfo.getChangedElement());
            if (activity == null || activity.getParent().getParent() != xMLCollectionElement) continue;
            hashSet.add(activity);
        }
        return hashSet;
    }

    public static Set getActivitiesWithChangedPerformer(List list, XMLCollectionElement xMLCollectionElement, String string) {
        HashSet<Activity> hashSet = new HashSet<Activity>();
        List list2 = GraphUtilities.findInfoList(list, Performers.class, Performer.class);
        for (int i = 0; i < list2.size(); ++i) {
            Activity activity;
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if (!xPDLElementChangeInfo.getOldValue().equals(string) || (activity = XMLUtil.getActivity((XMLElement)xPDLElementChangeInfo.getChangedElement())) == null || activity.getParent().getParent() != xMLCollectionElement) continue;
            hashSet.add(activity);
        }
        return hashSet;
    }

    public static Set getInsertedOrRemovedTransitionsAndAssociations(List list, XMLCollectionElement xMLCollectionElement, boolean bl) {
        XPDLElementChangeInfo xPDLElementChangeInfo;
        HashSet<Association> hashSet = new HashSet<Association>();
        List list2 = GraphUtilities.findInfoList(list, xMLCollectionElement.getClass(), Transitions.class);
        for (int i = 0; i < list2.size(); ++i) {
            List list3;
            xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if ((!bl || xPDLElementChangeInfo.getAction() != 3) && (bl || xPDLElementChangeInfo.getAction() != 5) || xPDLElementChangeInfo.getChangedElement().getParent() != xMLCollectionElement || (list3 = xPDLElementChangeInfo.getChangedSubElements()) == null || list3.size() <= 0) continue;
            hashSet.addAll(list3);
        }
        list2 = GraphUtilities.findInfoList(list, Package.class, Associations.class);
        Package package_ = XMLUtil.getPackage((XMLElement)xMLCollectionElement);
        xPDLElementChangeInfo = (Activities)xMLCollectionElement.get("Activities");
        for (int i = 0; i < list2.size(); ++i) {
            List list4;
            XPDLElementChangeInfo xPDLElementChangeInfo2 = (XPDLElementChangeInfo)((Object)list2.get(i));
            if ((!bl || xPDLElementChangeInfo2.getAction() != 3) && (bl || xPDLElementChangeInfo2.getAction() != 5) || xPDLElementChangeInfo2.getChangedElement().getParent() != package_ || (list4 = xPDLElementChangeInfo2.getChangedSubElements()) == null || list4.size() <= 0) continue;
            for (int j = 0; j < list4.size(); ++j) {
                Association association = (Association)list4.get(j);
                if (xPDLElementChangeInfo.getActivity(association.getSource()) == null && xPDLElementChangeInfo.getActivity(association.getTarget()) == null) continue;
                hashSet.add(association);
            }
        }
        return hashSet;
    }

    public static Set getUpdatedTransitionsAndAssociations(List list, XMLCollectionElement xMLCollectionElement) {
        String string;
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        List list2 = GraphUtilities.findInfoList(list, Transition.class, XMLAttribute.class);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            object = (XMLAttribute)xPDLElementChangeInfo.getChangedElement();
            if (object.getParent().getParent().getParent() != xMLCollectionElement || !(string = object.toName()).equals("From") && !string.equals("To")) continue;
            hashSet.add(object.getParent());
        }
        list2 = GraphUtilities.findInfoList(list, Association.class, XMLAttribute.class);
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        for (int i = 0; i < list2.size(); ++i) {
            Association association;
            object = (XPDLElementChangeInfo)((Object)list2.get(i));
            string = (XMLAttribute)object.getChangedElement();
            String string2 = string.toName();
            if (!string2.equals("Source") && !string2.equals("Target") || activities.getActivity((association = (Association)string.getParent()).getSource()) == null && activities.getActivity(association.getTarget()) == null) continue;
            hashSet.add(association);
        }
        return hashSet;
    }

    public static Set getLanesWithChangedOrder(List list) {
        HashSet<XMLElement> hashSet = new HashSet<XMLElement>();
        List list2 = GraphUtilities.findInfoList(list, Pool.class, Lanes.class);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            List list3 = xPDLElementChangeInfo.getChangedSubElements();
            for (int j = 0; j < list3.size(); ++j) {
                XMLElement xMLElement = (XMLElement)list3.get(j);
                if (!(xMLElement instanceof Lane)) continue;
                hashSet.add(xMLElement);
            }
        }
        return hashSet;
    }

    public static Set getNestedLanesWithChangedOrder(List list) {
        HashSet<Lane> hashSet = new HashSet<Lane>();
        List list2 = GraphUtilities.findInfoList(list, Lane.class, NestedLanes.class);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            List list3 = xPDLElementChangeInfo.getChangedSubElements();
            for (int j = 0; j < list3.size(); ++j) {
                Lane lane;
                XMLElement xMLElement = (XMLElement)list3.get(j);
                if (!(xMLElement instanceof NestedLane) || (lane = XMLUtil.getPool((XMLElement)xMLElement).getLanes().getLane(((NestedLane)xMLElement).getLaneId())) == null) continue;
                hashSet.add(lane);
            }
        }
        return hashSet;
    }

    public static Set getActivitiesAndArtifactsWithChangedOffset(List list, XMLCollectionElement xMLCollectionElement) {
        HashSet<Object> hashSet = new HashSet<Object>();
        List list2 = GraphUtilities.findInfoList(list, Coordinates.class, XMLAttribute.class);
        for (int i = 0; i < list2.size(); ++i) {
            Pool pool;
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
            Coordinates coordinates = (Coordinates)xMLElement.getParent();
            if (!(coordinates.getParent() instanceof NodeGraphicsInfo)) continue;
            Activity activity = XMLUtil.getActivity((XMLElement)xMLElement);
            if (activity != null && activity.getParent().getParent() == xMLCollectionElement) {
                hashSet.add(activity);
                continue;
            }
            Artifact artifact = XMLUtil.getArtifact((XMLElement)xMLElement);
            if (artifact == null || (pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement)) == null) continue;
            String string = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)artifact);
            if (pool.getLanes().getLane(string) == null) continue;
            hashSet.add(artifact);
        }
        return hashSet;
    }

    public static Map updateJGraphForActivityAndArtifactBounds(Graph graph, List list, XMLCollectionElement xMLCollectionElement) {
        Pool pool;
        Object object;
        Activity activity;
        Object object2;
        HashMap<XMLElement, AttributeMap> hashMap = new HashMap<XMLElement, AttributeMap>();
        GraphLayoutCache graphLayoutCache = graph.getGraphLayoutCache();
        HashSet<Object> hashSet = new HashSet<Object>();
        List list2 = GraphUtilities.findInfoList(list, Coordinates.class, XMLAttribute.class);
        list2.addAll(GraphUtilities.findInfoList(list, NodeGraphicsInfo.class, XMLAttribute.class));
        HashMap<Activity, Object> hashMap2 = new HashMap<Activity, Object>();
        HashMap<Activity, Object> hashMap3 = new HashMap<Activity, Object>();
        HashMap<Activity, Object> hashMap4 = new HashMap<Activity, Object>();
        HashMap<Activity, Object> hashMap5 = new HashMap<Activity, Object>();
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            object2 = xPDLElementChangeInfo.getChangedElement();
            if (!object2.toName().equals("XCoordinate") && !object2.toName().equals("YCoordinate") && !object2.toName().equals("Width") && !object2.toName().equals("Height") || !(object2.getParent() instanceof NodeGraphicsInfo) && !(object2.getParent().getParent() instanceof NodeGraphicsInfo)) continue;
            activity = XMLUtil.getActivity((XMLElement)object2);
            if (activity != null && activity.getParent().getParent() == xMLCollectionElement) {
                hashSet.add(activity);
                if (object2.toName().equals("XCoordinate")) {
                    hashMap2.put(activity, xPDLElementChangeInfo.getOldValue());
                    continue;
                }
                if (object2.toName().equals("YCoordinate")) {
                    hashMap3.put(activity, xPDLElementChangeInfo.getOldValue());
                    continue;
                }
                if (object2.toName().equals("Width")) {
                    hashMap4.put(activity, xPDLElementChangeInfo.getOldValue());
                    continue;
                }
                hashMap5.put(activity, xPDLElementChangeInfo.getOldValue());
                continue;
            }
            object = XMLUtil.getArtifact((XMLElement)object2);
            if (object == null || (pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement)) == null) continue;
            String string = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)object);
            if (pool.getLanes().getLane(string) == null) continue;
            hashSet.add(object);
            if (object2.toName().equals("XCoordinate")) {
                hashMap2.put(activity, xPDLElementChangeInfo.getOldValue());
                continue;
            }
            if (object2.toName().equals("YCoordinate")) {
                hashMap3.put(activity, xPDLElementChangeInfo.getOldValue());
                continue;
            }
            if (object2.toName().equals("Width")) {
                hashMap4.put(activity, xPDLElementChangeInfo.getOldValue());
                continue;
            }
            hashMap5.put(activity, xPDLElementChangeInfo.getOldValue());
        }
        for (XMLCollectionElement xMLCollectionElement2 : hashSet) {
            object2 = null;
            object2 = xMLCollectionElement2 instanceof Activity ? graph.getGraphManager().getGraphActivity((Activity)xMLCollectionElement2) : graph.getGraphManager().getGraphArtifact((Artifact)xMLCollectionElement2);
            activity = (AbstractCellView)graphLayoutCache.getMapping(object2, false);
            if (activity == null) continue;
            object = null;
            object = activity instanceof GraphActivityViewInterface ? ((GraphActivityViewInterface)activity).getOriginalBounds() : ((GraphArtifactViewInterface)activity).getOriginalBounds();
            pool = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo(xMLCollectionElement2);
            int n = pool.getWidth();
            int n2 = pool.getHeight();
            int n3 = (int)Double.parseDouble(pool.getCoordinates().getXCoordinate());
            int n4 = (int)Double.parseDouble(pool.getCoordinates().getYCoordinate());
            String string = (String)hashMap4.get(xMLCollectionElement2);
            int n5 = string == null ? n : (int)Double.parseDouble(string);
            String string2 = (String)hashMap5.get(xMLCollectionElement2);
            int n6 = string2 == null ? n2 : (int)Double.parseDouble(string2);
            String string3 = (String)hashMap2.get(xMLCollectionElement2);
            int n7 = string3 == null ? n3 : (int)Double.parseDouble(string3);
            String string4 = (String)hashMap3.get(xMLCollectionElement2);
            int n8 = string4 == null ? n4 : (int)Double.parseDouble(string4);
            double d = n7 - n3;
            double d2 = n8 - n4;
            Rectangle rectangle = new Rectangle((int)(((Rectangle)object).getX() - d), (int)(((Rectangle)object).getY() - d2), n, n2);
            HashMap<String, Rectangle> hashMap6 = new HashMap<String, Rectangle>();
            hashMap6.put("bounds", rectangle);
            graphLayoutCache.editCell(object2, hashMap6);
            AttributeMap attributeMap = new AttributeMap((Map)object2.getAttributes());
            hashMap.put((XMLElement)object2, attributeMap);
        }
        return hashMap;
    }

    public static Set getActivitiesAndArtifactsWithChangedLaneId(List list, XMLCollectionElement xMLCollectionElement) {
        HashSet<Object> hashSet = new HashSet<Object>();
        List list2 = GraphUtilities.findInfoList(list, NodeGraphicsInfo.class, XMLAttribute.class);
        for (int i = 0; i < list2.size(); ++i) {
            Pool pool;
            Artifact artifact;
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
            if (!xMLElement.toName().equals("LaneId")) continue;
            Activity activity = XMLUtil.getActivity((XMLElement)xMLElement);
            if (activity != null && activity.getParent().getParent() == xMLCollectionElement) {
                hashSet.add(activity);
            }
            if ((artifact = XMLUtil.getArtifact((XMLElement)xMLElement)) == null || (pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement)) == null) continue;
            String string = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)artifact);
            if (pool.getLanes().getLane(string) == null) continue;
            hashSet.add(artifact);
        }
        return hashSet;
    }

    public static Set getTransitionsWithChangedBreakpointsOrStyle(List list, XMLCollectionElement xMLCollectionElement) {
        Association association;
        Transition transition;
        XMLElement xMLElement;
        XPDLElementChangeInfo xPDLElementChangeInfo;
        int n;
        HashSet<Object> hashSet = new HashSet<Object>();
        List list2 = GraphUtilities.findInfoList(list, ConnectorGraphicsInfo.class, XMLAttribute.class);
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        for (n = 0; n < list2.size(); ++n) {
            xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(n));
            xMLElement = xPDLElementChangeInfo.getChangedElement();
            if (!xMLElement.toName().equals("Style")) continue;
            transition = XMLUtil.getTransition((XMLElement)xMLElement);
            if (transition != null && transition.getParent().getParent() == xMLCollectionElement) {
                hashSet.add(transition);
            }
            if ((association = XMLUtil.getAssociation((XMLElement)xMLElement)) == null || activities.getActivity(association.getSource()) == null && activities.getActivity(association.getTarget()) == null) continue;
            hashSet.add(association);
        }
        list2 = GraphUtilities.findInfoList(list, Coordinates.class, XMLAttribute.class);
        list2.addAll(GraphUtilities.findInfoList(list, ConnectorGraphicsInfo.class, Coordinatess.class));
        for (n = 0; n < list2.size(); ++n) {
            xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(n));
            xMLElement = xPDLElementChangeInfo.getChangedElement();
            if (!(xMLElement instanceof Coordinatess) && !(xMLElement.getParent().getParent().getParent() instanceof ConnectorGraphicsInfo)) continue;
            transition = XMLUtil.getTransition((XMLElement)xMLElement);
            if (transition != null && transition.getParent().getParent() == xMLCollectionElement) {
                hashSet.add(transition);
            }
            if ((association = XMLUtil.getAssociation((XMLElement)xMLElement)) == null || activities.getActivity(association.getSource()) == null && activities.getActivity(association.getTarget()) == null) continue;
            hashSet.add(association);
        }
        return hashSet;
    }

    public static Pool getRotatedGraphObject(List list) {
        List list2 = GraphUtilities.findInfoList(list, Pool.class, XMLAttribute.class);
        for (int i = 0; i < list2.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list2.get(i));
            if (!xPDLElementChangeInfo.getChangedElement().toName().equals("Orientation")) continue;
            return XMLUtil.getPool((XMLElement)xPDLElementChangeInfo.getChangedElement());
        }
        return null;
    }

    public static List findInfoList(List list, Class clazz, Class clazz2) {
        ArrayList<XPDLElementChangeInfo> arrayList = new ArrayList<XPDLElementChangeInfo>();
        for (int i = 0; i < list.size(); ++i) {
            XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)((Object)list.get(i));
            XMLElement xMLElement = xPDLElementChangeInfo.getChangedElement();
            if (xMLElement.getClass() != clazz2 || xMLElement.getParent().getClass() != clazz) continue;
            arrayList.add(xPDLElementChangeInfo);
        }
        return arrayList;
    }

    protected static boolean reloadGraphIfNeccessary(Graph graph) {
        List list = JaWEGraphModel.getAllParticipantsInModel(graph.getModel());
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        if (bl) {
            GraphUtilities.reloadGraph(graph);
        }
        return bl;
    }

    protected static void reloadGraph(Graph graph) {
        Object[] objectArray = JaWEGraphModel.getAll((GraphModel)graph.getModel());
        graph.getModel().remove(objectArray);
        GraphUtilities.scanExtendedAttributesForWPOrAs(graph.getXPDLObject(), false);
        graph.getGraphManager().createWorkflowGraph(graph.getXPDLObject());
    }

    protected static List getActivitiesWithPerformer(List list, String string) {
        ArrayList<Activity> arrayList = new ArrayList<Activity>();
        for (Activity activity : list) {
            if (!activity.getFirstPerformer().equals(string)) continue;
            arrayList.add(activity);
        }
        return arrayList;
    }

    protected static Lane getLaneForActivityOrArtifact(XMLCollectionElement xMLCollectionElement, XMLCollectionElement xMLCollectionElement2) {
        NodeGraphicsInfo nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo(xMLCollectionElement);
        if (nodeGraphicsInfo != null) {
            String string = nodeGraphicsInfo.getLaneId();
            if (xMLCollectionElement2 == null) {
                xMLCollectionElement2 = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)xMLCollectionElement);
            }
            Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement2);
            return pool.getLanes().getLane(string);
        }
        return null;
    }

    protected static Lane getLaneForPerformer(Pool pool, String string) {
        for (Lane lane : pool.getLanes().toElements()) {
            if (!GraphUtilities.hasPerformer(lane, string)) continue;
            return lane;
        }
        return null;
    }

    protected static Lane createLaneForActivity(Activity activity, boolean bl) {
        String string = activity.getFirstPerformer();
        XMLCollectionElement xMLCollectionElement = XMLUtil.getActivitySetOrWorkflowProcess((XMLElement)activity);
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        Lanes lanes = pool.getLanes();
        Lane lane = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(lanes, "", false);
        Performer performer = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(lane.getPerformers(), "", true);
        performer.setValue(string);
        Participant participant = GraphUtilities.getParticipantForLane(lane, FreeTextExpressionParticipant.getInstance());
        lane.setName(participant.getName().equals("") ? participant.getId() : participant.getName());
        GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)lane, null, null, true);
        if (bl) {
            lanes.add((XMLElement)lane);
        }
        return lane;
    }

    protected static Lane createLaneForPerformer(Pool pool, String string) {
        System.out.println("CREATING LANE for perf " + string);
        Lanes lanes = pool.getLanes();
        Lane lane = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(lanes, "", false);
        String string2 = "";
        if (string.equals("") || string.equals(FreeTextExpressionParticipant.getInstance().getId())) {
            string2 = FreeTextExpressionParticipant.getInstance().getName();
        } else {
            Performer performer = JaWEManager.getInstance().getXPDLObjectFactory().createXPDLObject(lane.getPerformers(), "", true);
            if (CommonExpressionParticipants.getInstance().isCommonExpressionParticipantId(string)) {
                string2 = CommonExpressionParticipants.getInstance().getIdFromVisualOrderEA(string);
                performer.setValue(string2);
            } else {
                performer.setValue(string);
                Participant participant = GraphUtilities.getParticipantForLane(lane, null);
                string2 = string;
                if (participant != null) {
                    string2 = participant.getName().equals("") ? participant.getId() : participant.getName();
                }
            }
        }
        GraphUtilities.createNodeGraphicsInfo((XMLCollectionElement)lane, null, null, true);
        lane.setName(string2);
        lanes.add((XMLElement)lane);
        return lane;
    }

    public static void setLanesFirstPerformer(Lane lane, String string) {
        ArrayList arrayList = lane.getPerformers().toElements();
        if (arrayList.size() > 0) {
            Performer performer = (Performer)arrayList.get(0);
            performer.setValue(string);
        }
    }

    protected static String getLanesFirstPerformer(Lane lane) {
        Iterator iterator = lane.getPerformers().toElements().iterator();
        if (iterator.hasNext()) {
            Performer performer = (Performer)iterator.next();
            return performer.toValue();
        }
        return null;
    }

    protected static boolean hasPerformer(Lane lane, String string) {
        for (Performer performer : lane.getPerformers().toElements()) {
            if (!performer.toValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected static Lane getDefaultLane(Pool pool) {
        if (pool == null) {
            return null;
        }
        for (Lane lane : pool.getLanes().toElements()) {
            if (lane.getPerformers().size() != 0) continue;
            return lane;
        }
        return null;
    }

    protected static Lane createDefaultLane(Pool pool) {
        return GraphUtilities.createLaneForPerformer(pool, FreeTextExpressionParticipant.getInstance().getId());
    }

    protected static void checkLanes(Pool pool, List list) {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (GraphUtilities.getLaneForPerformer(pool, string) != null) continue;
            GraphUtilities.createLaneForPerformer(pool, string);
        }
    }

    public static void setNewLaneId(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Activity activity = (Activity)list.get(i);
            GraphUtilities.setLaneId((XMLCollectionElement)activity, string);
        }
    }

    public static void setNewPerformer(List list, String string) {
        for (int i = 0; i < list.size(); ++i) {
            Activity activity = (Activity)list.get(i);
            activity.setFirstPerformer(string);
        }
    }

    public static void setLaneId(XMLCollectionElement xMLCollectionElement, String string) {
        NodeGraphicsInfo nodeGraphicsInfo;
        if (string == null || string.equals("")) {
            string = FreeTextExpressionParticipant.getInstance().getId();
        }
        if ((nodeGraphicsInfo = JaWEManager.getInstance().getXPDLUtils().getNodeGraphicsInfo(xMLCollectionElement)) != null) {
            nodeGraphicsInfo.setLaneId(string);
        }
    }

    public static Lane getParentLane(Lane lane) {
        Lanes lanes = (Lanes)lane.getParent();
        for (Lane lane2 : lanes.toElements()) {
            if (lane2.equals((Object)lane)) continue;
            for (NestedLane nestedLane : lane2.getNestedLanes().toElements()) {
                if (!nestedLane.getLaneId().equals(lane.getId())) continue;
                return lane2;
            }
        }
        return null;
    }

    protected static List getLaneHierarchy(Pool pool) {
        ArrayList arrayList = new ArrayList();
        List list = GraphUtilities.getRootLanes(pool);
        for (int i = 0; i < list.size(); ++i) {
            Lane lane = (Lane)list.get(i);
            arrayList.addAll(GraphUtilities.getLaneHierarchy(lane));
        }
        return arrayList;
    }

    protected static List getLaneHierarchy(Lane lane) {
        ArrayList<Lane> arrayList = new ArrayList<Lane>();
        arrayList.add(lane);
        List list = GraphUtilities.getNestedLanes(lane);
        for (int i = 0; i < list.size(); ++i) {
            arrayList.addAll(GraphUtilities.getLaneHierarchy((Lane)list.get(i)));
        }
        return arrayList;
    }

    protected static List getRootLanes(Pool pool) {
        ArrayList<Lane> arrayList = new ArrayList<Lane>();
        ArrayList arrayList2 = pool.getLanes().toElements();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Lane lane = (Lane)arrayList2.get(i);
            if (GraphUtilities.getParentLane(lane) != null) continue;
            arrayList.add(lane);
        }
        return arrayList;
    }

    protected static List getNestedLanes(Lane lane) {
        ArrayList<Lane> arrayList = new ArrayList<Lane>();
        Lanes lanes = (Lanes)lane.getParent();
        for (NestedLane nestedLane : lane.getNestedLanes().toElements()) {
            Lane lane2 = lanes.getLane(nestedLane.getLaneId());
            arrayList.add(lane2);
        }
        return arrayList;
    }

    protected static void fillParentLanes(Lane lane, List list) {
        Lane lane2 = GraphUtilities.getParentLane(lane);
        if (lane2 != null) {
            list.add(lane2);
            GraphUtilities.fillParentLanes(lane2, list);
        }
    }

    public static Participant getParticipantForLane(Lane lane, Participant participant) {
        ActivitySet activitySet;
        Participant participant2 = null;
        String string = "";
        Iterator iterator = lane.getPerformers().toElements().iterator();
        if (iterator.hasNext()) {
            string = ((Performer)iterator.next()).toValue();
        }
        Pool pool = XMLUtil.getPool((XMLElement)lane);
        WorkflowProcess workflowProcess = JaWEManager.getInstance().getXPDLUtils().getProcessForPool(pool);
        if (workflowProcess == null && (activitySet = JaWEManager.getInstance().getXPDLUtils().getActivitySetForPool(pool)) != null) {
            workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)activitySet);
        }
        if (workflowProcess != null) {
            participant2 = XMLUtil.findParticipant((XMLInterface)JaWEManager.getInstance().getXPDLHandler(), (WorkflowProcess)workflowProcess, (String)string);
        }
        if (participant2 == null) {
            participant2 = participant;
        }
        return participant2;
    }

    public static boolean isCommonExpressionLane(Lane lane) {
        return GraphUtilities.getParticipantForLane(lane, null) == null && lane.getPerformers().size() > 0;
    }

    public static Lane getLane(XMLCollectionElement xMLCollectionElement, String string) {
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        return pool.getLanes().getLane(string);
    }

    public static Set getArtifacts(XMLCollectionElement xMLCollectionElement) {
        Package package_;
        ArrayList arrayList;
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        Pool pool = JaWEManager.getInstance().getXPDLUtils().getPoolForProcessOrActivitySet(xMLCollectionElement);
        if (pool != null && (arrayList = (package_ = XMLUtil.getPackage((XMLElement)xMLCollectionElement)).getArtifacts().toElements()) != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Artifact artifact = (Artifact)arrayList.get(i);
                String string = JaWEManager.getInstance().getXPDLUtils().getLaneId((XMLCollectionElement)artifact);
                if (pool.getLanes().getLane(string) == null) continue;
                hashSet.add(artifact);
            }
        }
        return hashSet;
    }

    public static Set getAssociations(XMLCollectionElement xMLCollectionElement) {
        HashSet<Association> hashSet = new HashSet<Association>();
        Package package_ = XMLUtil.getPackage((XMLElement)xMLCollectionElement);
        Activities activities = (Activities)xMLCollectionElement.get("Activities");
        ArrayList arrayList = package_.getAssociations().toElements();
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Association association = (Association)arrayList.get(i);
                if (activities.getActivity(association.getSource()) == null && activities.getActivity(association.getTarget()) == null) continue;
                hashSet.add(association);
            }
        }
        return hashSet;
    }

    public static void rotateProcess(Graph graph) {
        Object[] objectArray = JaWEGraphModel.getAll((GraphModel)graph.getModel());
        graph.getModel().remove(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            XMLCollectionElement xMLCollectionElement;
            if (!(objectArray[i] instanceof DefaultGraphCell)) continue;
            Object object2 = ((DefaultGraphCell)objectArray[i]).getUserObject();
            if (object2 instanceof Activity || object2 instanceof Artifact) {
                xMLCollectionElement = (XMLCollectionElement)object2;
                object = GraphUtilities.getOffsetPoint(xMLCollectionElement);
                Utils.flipCoordinates((Point)object);
                GraphUtilities.setOffsetPoint(xMLCollectionElement, (Point)object, null);
                continue;
            }
            if (!(object2 instanceof Transition) && !(object2 instanceof Association)) continue;
            xMLCollectionElement = (XMLCollectionElement)object2;
            object = GraphUtilities.getBreakpoints(xMLCollectionElement);
            for (int j = 0; j < object.size(); ++j) {
                Point point = (Point)object.get(j);
                Utils.flipCoordinates(point);
            }
            GraphUtilities.setBreakpoints(xMLCollectionElement, (List)object);
        }
        graph.getGraphManager().createWorkflowGraph(graph.getXPDLObject());
    }
}

