/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.enhydra.jawe.components.graph.DefaultCellPanel;
import org.enhydra.jawe.components.graph.GraphActivityInterface;
import org.enhydra.jawe.components.graph.GraphArtifactInterface;
import org.enhydra.jawe.components.graph.GraphSwimlaneInterface;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.elements.Activity;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.VertexView;

public class MultiLinedRenderer
extends DefaultCellPanel
implements CellViewRenderer {
    public static boolean loaded = false;
    protected static float borderWidth = 1.0f;
    protected BasicStroke borderStroke = new BasicStroke(borderWidth, 0, 1);
    protected transient JGraph graph;
    protected transient VertexView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = UIManager.getColor("Tree.textForeground");
    protected transient Color defaultBackground = UIManager.getColor("Tree.textBackground");
    protected transient Color bordercolor;
    transient boolean isDoubleBuffered = false;

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        this.graph = jGraph;
        this.wrapName(GraphUtilities.getGraphController().getGraphSettings().isNameWrappingEnabled());
        this.wrapStyle(GraphUtilities.getGraphController().getGraphSettings().isWordWrappingEnabled());
        this.isDoubleBuffered = this.graph.isDoubleBuffered();
        if (cellView instanceof VertexView) {
            Object object;
            this.view = (VertexView)cellView;
            int n = 2;
            Object object2 = this.view.getCell();
            if (object2 instanceof GraphActivityInterface) {
                object = (GraphActivityInterface)object2;
                Activity activity = (Activity)object.getUserObject();
                int n2 = activity.getActivityType();
                if (n2 == 1 && activity.getIcon().equals("")) {
                    n = 0;
                }
            } else if (object2 instanceof GraphSwimlaneInterface) {
                n = 4;
            } else if (object2 instanceof GraphArtifactInterface) {
                n = 0;
            }
            this.setMainIcon(this.getIcon());
            this.setTextPosition(n);
            this.showIcon(GraphUtilities.getGraphController().getGraphSettings().shouldShowIcons());
            this.setDisplayName(this.view.getCell().toString());
            if (this.graph.getEditingCell() != this.view.getCell()) {
                object = this.graph.convertValueToString((Object)this.view);
                if (object != null) {
                    this.setDisplayName(object.toString());
                } else {
                    this.setDisplayName(null);
                }
            } else {
                this.setDisplayName(null);
            }
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            object = this.view.getAllAttributes();
            this.installAttributes(this.graph, (Map)object);
            return this;
        }
        return null;
    }

    protected void installAttributes(JGraph jGraph, Map map) {
        this.setOpaque(GraphConstants.isOpaque((Map)map));
        Color color = GraphConstants.getForeground((Map)map);
        this.setForeground(color != null ? color : jGraph.getForeground());
        Color color2 = GraphConstants.getBackground((Map)map);
        this.setBackground(color2 != null ? color2 : jGraph.getBackground());
        Font font = GraphConstants.getFont((Map)map);
        this.setFont(font != null ? font : jGraph.getFont());
        Border border = GraphConstants.getBorder((Map)map);
        this.bordercolor = GraphConstants.getBorderColor((Map)map);
        if (border != null) {
            this.setBorder(border);
        } else if (this.bordercolor != null) {
            borderWidth = Math.max(1, Math.round(GraphConstants.getLineWidth((Map)map)));
        }
    }

    public ImageIcon getIcon() {
        return GraphUtilities.getGraphController().getGraphSettings().getDefaultActivityIcon();
    }

    public Point2D getPerimeterPoint(VertexView vertexView, Point2D point2D) {
        Rectangle2D rectangle2D = vertexView.getBounds();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = d + d3 / 2.0;
        double d6 = d2 + d4 / 2.0;
        double d7 = point2D.getX() - d5;
        double d8 = point2D.getY() - d6;
        double d9 = Math.atan2(d8, d7);
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = Math.PI;
        double d13 = 1.5707963267948966;
        double d14 = d13 - d9;
        double d15 = Math.atan2(d4, d3);
        if (d9 < -d12 + d15 || d9 > d12 - d15) {
            d10 = d;
            d11 = d6 - d3 * Math.tan(d9) / 2.0;
        } else if (d9 < -d15) {
            d11 = d2;
            d10 = d5 - d4 * Math.tan(d14) / 2.0;
        } else if (d9 < d15) {
            d10 = d + d3;
            d11 = d6 + d3 * Math.tan(d9) / 2.0;
        } else {
            d11 = d2 + d4;
            d10 = d5 + d4 * Math.tan(d14) / 2.0;
        }
        return new Point2D.Double(d10, d11);
    }
}

