/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.graph.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.base.controller.JaWEController;
import org.enhydra.jawe.components.graph.Graph;
import org.enhydra.jawe.components.graph.GraphController;
import org.enhydra.jawe.components.graph.GraphUtilities;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;

public class RotateProcess
extends ActionBase {
    public RotateProcess(JaWEComponent jaWEComponent) {
        super(jaWEComponent);
    }

    @Override
    public void enableDisableAction() {
        JaWEController jaWEController = JaWEManager.getInstance().getJaWEController();
        GraphController graphController = (GraphController)this.jawecomponent;
        if (graphController.getSelectedGraph() != null && XMLUtil.getPackage((XMLElement)graphController.getSelectedGraph().getXPDLObject()) == jaWEController.getMainPackage()) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        GraphController graphController = (GraphController)this.jawecomponent;
        Graph graph = graphController.getSelectedGraph();
        if (graph == null) {
            return;
        }
        graphController.setUpdateInProgress(true);
        JaWEManager.getInstance().getJaWEController().startUndouableChange();
        if (GraphUtilities.getGraphOrientation(graph.getXPDLObject()).equals("HORIZONTAL")) {
            GraphUtilities.setGraphOrientation(graph.getXPDLObject(), "VERTICAL");
        } else {
            GraphUtilities.setGraphOrientation(graph.getXPDLObject(), "HORIZONTAL");
        }
        GraphUtilities.rotateProcess(graph);
        ArrayList<XMLCollectionElement> arrayList = new ArrayList<XMLCollectionElement>();
        arrayList.add(graph.getXPDLObject());
        JaWEManager.getInstance().getJaWEController().endUndouableChange(arrayList);
        graph.clearSelection();
        graphController.setUpdateInProgress(false);
    }
}

