/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.searchnavigator;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.enhydra.jawe.JaWEComponent;
import org.enhydra.jawe.JaWEComponentSettings;
import org.enhydra.jawe.JaWEComponentView;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.XPDLElementChangeInfo;
import org.enhydra.jawe.components.XPDLTreeNode;
import org.enhydra.jawe.components.searchnavigator.SearchNavigatorPanel;
import org.enhydra.jawe.components.searchnavigator.SearchNavigatorSettings;
import org.enhydra.jxpdl.XMLCollection;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.elements.Package;

public class SearchNavigator
implements Observer,
TreeSelectionListener,
JaWEComponent {
    protected String type = "OTHER";
    protected SearchNavigatorPanel panel;
    protected boolean updateInProgress = false;
    protected SearchNavigatorSettings settings;

    public SearchNavigator(JaWEComponentSettings jaWEComponentSettings) throws Exception {
        this.settings = (SearchNavigatorSettings)jaWEComponentSettings;
        this.settings.init(this);
        this.init();
        JaWEManager.getInstance().getJaWEController().addObserver((Observer)this);
        JaWEManager.getInstance().getValidationOrSearchResultEditor().setSearchDisplayEnabled(false);
    }

    public JaWEComponentSettings getSettings() {
        return this.settings;
    }

    public SearchNavigatorSettings getNavigatorSettings() {
        return this.settings;
    }

    @Override
    public void update(Observable observable, Object object) {
        if (!(object instanceof XPDLElementChangeInfo)) {
            return;
        }
        XPDLElementChangeInfo xPDLElementChangeInfo = (XPDLElementChangeInfo)object;
        int n = xPDLElementChangeInfo.getAction();
        if (n != 9 && n != 20 && n != 10 && n != 5 && n != 15 && n != 16 && n != 17) {
            return;
        }
        long l = System.currentTimeMillis();
        JaWEManager.getInstance().getLoggingManager().info("SearchNavigator -> update for event " + xPDLElementChangeInfo + " started ...");
        this.update(xPDLElementChangeInfo);
        JaWEManager.getInstance().getLoggingManager().info("SearchNavigator -> update ended...");
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        JaWEManager.getInstance().getLoggingManager().debug("THE UPDATE OF SEARCH NAVIG COMPONENT LASTED FOR " + d + " SECONDS!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(XPDLElementChangeInfo xPDLElementChangeInfo) {
        if (this.updateInProgress) {
            return;
        }
        if (xPDLElementChangeInfo.getSource() == this) {
            return;
        }
        this.updateInProgress = true;
        try {
            int n = xPDLElementChangeInfo.getAction();
            if (n == 9 || n == 20) {
                this.panel.refreshSearchPanel(xPDLElementChangeInfo.getChangedElement(), xPDLElementChangeInfo.getChangedSubElements(), n);
                this.settings.adjustActions();
            } else if (n == 10) {
                this.panel.refreshDisplay(xPDLElementChangeInfo.getChangedSubElements());
            } else if (n == 15 || n == 16 || n == 17) {
                for (int i = 0; i < xPDLElementChangeInfo.getChangedSubElements().size(); ++i) {
                    this.panel.removeLostReferences((XPDLElementChangeInfo)xPDLElementChangeInfo.getChangedSubElements().get(i));
                }
            } else {
                this.panel.removeLostReferences(xPDLElementChangeInfo);
            }
        }
        finally {
            this.updateInProgress = false;
        }
    }

    public void cleanMatches() {
        this.panel.reinitialize();
        this.settings.adjustActions();
    }

    public boolean hasMatches() {
        return this.panel.hasMatches();
    }

    protected void init() {
        this.panel = new SearchNavigatorPanel(this);
        this.panel.configure();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        XPDLTreeNode xPDLTreeNode;
        int n;
        if (this.updateInProgress) {
            return;
        }
        JaWEManager.getInstance().getLoggingManager().info("SearchNavigator -> selection changed ...");
        TreePath treePath = treeSelectionEvent.getOldLeadSelectionPath();
        TreePath[] treePathArray = treeSelectionEvent.getPaths();
        ArrayList<XMLElement> arrayList = new ArrayList<XMLElement>();
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < treePathArray.length; ++i) {
            if (treePathArray[i] != treeSelectionEvent.getNewLeadSelectionPath()) continue;
            n2 = i;
            break;
        }
        TreePath treePath2 = treePathArray[n2];
        treePathArray[n2] = treePathArray[treePathArray.length - 1];
        treePathArray[treePathArray.length - 1] = treePath2;
        for (n = 0; n < treePathArray.length; ++n) {
            if (treeSelectionEvent.isAddedPath(treePathArray[n])) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        if (treePath == null) {
            bl = false;
            bl2 = false;
        }
        for (n = 0; n < treePathArray.length; ++n) {
            if (!treeSelectionEvent.isAddedPath(treePathArray[n])) continue;
            xPDLTreeNode = (XPDLTreeNode)treePathArray[n].getLastPathComponent();
            if (xPDLTreeNode == null || xPDLTreeNode.getXPDLElement() == null) {
                return;
            }
            arrayList.add(xPDLTreeNode.getXPDLElement());
        }
        if (bl && bl2) {
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(arrayList, true);
        } else if (bl && !bl2) {
            JaWEManager.getInstance().getJaWEController().getSelectionManager().addToSelection(arrayList);
        } else {
            arrayList.clear();
            if (this.panel.tree.isSelectionEmpty()) {
                arrayList.add(((XPDLTreeNode)treePathArray[0].getLastPathComponent()).getXPDLElement());
            } else {
                treePathArray = this.panel.tree.getSelectionPaths();
                for (n = 0; n < treePathArray.length; ++n) {
                    xPDLTreeNode = (XPDLTreeNode)treePathArray[n].getLastPathComponent();
                    if (xPDLTreeNode == null || xPDLTreeNode.getXPDLElement() == null) {
                        return;
                    }
                    arrayList.add(xPDLTreeNode.getXPDLElement());
                }
            }
            JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(arrayList, true);
        }
        JaWEManager.getInstance().getLoggingManager().info("SearchNavigator -> oabservers notified about selection change!");
    }

    public JaWEComponentView getView() {
        return this.panel;
    }

    public JComponent getDisplay() {
        return this.panel.getDisplay();
    }

    public String getComponentType() {
        return this.type;
    }

    public void setComponentType(String string) {
        this.type = string;
    }

    public String getName() {
        return "SearchNavigator";
    }

    public boolean adjustXPDL(Package package_) {
        return false;
    }

    public List checkValidity(XMLElement xMLElement, boolean bl) {
        return null;
    }

    public boolean canCreateElement(XMLCollection xMLCollection) {
        return true;
    }

    public boolean canInsertElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canModifyElement(XMLElement xMLElement) {
        return true;
    }

    public boolean canRemoveElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canDuplicateElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public boolean canRepositionElement(XMLCollection xMLCollection, XMLElement xMLElement) {
        return true;
    }

    public void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }
}

