/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.util.ArrayList;
import org.enhydra.jxpdl.XMLBaseForCollectionAndComplex;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLEmptyChoiceElement;
import org.enhydra.jxpdl.XMLInterface;

public abstract class XMLComplexChoice
extends XMLElement {
    protected ArrayList choices;
    protected XMLElement choosen;
    protected transient boolean cachesInitialized = false;

    public XMLComplexChoice(XMLComplexElement xMLComplexElement, String string, boolean bl) {
        super((XMLElement)xMLComplexElement, string, bl);
        this.fillChoices();
    }

    @Override
    public void setValue(String string) {
    }

    @Override
    public void removeXPDL1Support() {
        super.removeXPDL1Support();
        for (int i = 0; i < this.choices.size(); ++i) {
            ((XMLElement)this.choices.get(i)).removeXPDL1Support();
        }
    }

    @Override
    public void makeAs(XMLElement xMLElement) {
        super.makeAs(xMLElement);
        XMLComplexChoice xMLComplexChoice = (XMLComplexChoice)xMLElement;
        int n = xMLComplexChoice.choices.indexOf(xMLComplexChoice.getChoosen());
        XMLElement xMLElement2 = (XMLElement)this.choices.get(n);
        xMLElement2.makeAs(xMLComplexChoice.getChoosen());
        this.setChoosen(xMLElement2);
    }

    @Override
    public void setReadOnly(boolean bl) {
        super.setReadOnly(bl);
        for (int i = 0; i < this.choices.size(); ++i) {
            ((XMLElement)this.choices.get(i)).setReadOnly(bl);
        }
    }

    @Override
    public void setNotifyListeners(boolean bl) {
        super.setNotifyListeners(bl);
        for (int i = 0; i < this.choices.size(); ++i) {
            ((XMLElement)this.choices.get(i)).setNotifyListeners(bl);
        }
    }

    @Override
    public void setNotifyMainListeners(boolean bl) {
        super.setNotifyMainListeners(bl);
        for (int i = 0; i < this.choices.size(); ++i) {
            ((XMLElement)this.choices.get(i)).setNotifyMainListeners(bl);
        }
    }

    public void initCaches(XMLInterface xMLInterface) {
        if (!this.isReadOnly) {
            throw new RuntimeException("Caches can be initialized only in read-only mode!");
        }
        this.clearCaches();
        for (XMLElement xMLElement : this.choices) {
            if (xMLElement instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)xMLElement).initCaches(xMLInterface);
                continue;
            }
            if (!(xMLElement instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)xMLElement).initCaches(xMLInterface);
        }
        this.cachesInitialized = true;
    }

    public void clearCaches() {
        for (XMLElement xMLElement : this.choices) {
            if (xMLElement instanceof XMLBaseForCollectionAndComplex) {
                ((XMLBaseForCollectionAndComplex)xMLElement).clearCaches();
                continue;
            }
            if (!(xMLElement instanceof XMLComplexChoice)) continue;
            ((XMLComplexChoice)xMLElement).clearCaches();
        }
        this.cachesInitialized = false;
    }

    @Override
    public boolean isEmpty() {
        return this.choosen instanceof XMLEmptyChoiceElement;
    }

    public ArrayList getChoices() {
        return this.choices;
    }

    public XMLElement getChoosen() {
        return this.choosen;
    }

    public void setChoosen(XMLElement xMLElement) {
        if (this.isReadOnly) {
            throw new RuntimeException("Can't set the value of read only element!");
        }
        if (!this.choices.contains(xMLElement)) {
            throw new RuntimeException("Incorrect value! The possible values are: " + this.choices);
        }
        boolean bl = false;
        XMLElement xMLElement2 = this.choosen;
        if (this.choosen == null || !this.choosen.equals(xMLElement)) {
            bl = true;
        }
        this.choosen = xMLElement;
        if (bl && (this.notifyMainListeners || this.notifyListeners)) {
            XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(xMLElement2, this.choosen, null, 1);
            if (this.notifyListeners) {
                this.notifyListeners(xMLElementChangeInfo);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners(xMLElementChangeInfo);
            }
        }
    }

    protected abstract void fillChoices();

    @Override
    public Object clone() {
        XMLComplexChoice xMLComplexChoice = (XMLComplexChoice)super.clone();
        xMLComplexChoice.choices = new ArrayList();
        xMLComplexChoice.choosen = null;
        xMLComplexChoice.cachesInitialized = false;
        for (XMLElement xMLElement : this.choices) {
            XMLElement xMLElement2 = (XMLElement)xMLElement.clone();
            xMLComplexChoice.choices.add(xMLElement2);
            xMLElement2.setParent(xMLComplexChoice);
            if (xMLComplexChoice.choosen != null || this.choosen == null || !this.choosen.equals(xMLElement)) continue;
            xMLComplexChoice.choosen = xMLElement2;
        }
        return xMLComplexChoice;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (bl) {
            XMLComplexChoice xMLComplexChoice = (XMLComplexChoice)object;
            bl = this.choices.equals(xMLComplexChoice.choices);
            bl = !(!bl || this.choices == null && xMLComplexChoice.choices != null || this.choices != null && xMLComplexChoice.choices == null);
        }
        return bl;
    }
}

