/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.enhydra.jxpdl.XMLElementChangeInfo;
import org.enhydra.jxpdl.XMLElementChangeListener;
import org.enhydra.jxpdl.XMLUtil;

public abstract class XMLElement
implements Serializable,
Cloneable {
    protected transient List listeners = new ArrayList();
    protected transient boolean notifyMainListeners = false;
    protected transient boolean notifyListeners = false;
    protected Integer originalElementHashCode;
    private String name;
    private boolean isRequired = false;
    protected String value;
    protected boolean isReadOnly = false;
    protected XMLElement parent;
    protected boolean xpdl1support = false;

    public XMLElement(XMLElement xMLElement, boolean bl) {
        this.parent = xMLElement;
        this.isRequired = bl;
        this.name = this.getClass().getName();
        this.name = XMLUtil.getShortClassName(this.name);
        this.value = new String();
        this.originalElementHashCode = new Integer(this.hashCode());
    }

    public XMLElement(XMLElement xMLElement, boolean bl, boolean bl2) {
        this(xMLElement, bl);
        this.xpdl1support = bl2;
    }

    public XMLElement(XMLElement xMLElement, String string, boolean bl) {
        this.parent = xMLElement;
        this.name = string;
        this.isRequired = bl;
        this.value = new String();
        this.originalElementHashCode = new Integer(this.hashCode());
    }

    public boolean isXPDL1Support() {
        return this.xpdl1support;
    }

    public void removeXPDL1Support() {
        this.xpdl1support = false;
    }

    public void makeAs(XMLElement xMLElement) {
        if (xMLElement == null || !xMLElement.getClass().equals(this.getClass()) || !xMLElement.name.equals(this.name)) {
            throw new RuntimeException("Can't perform makeAs! Element[" + xMLElement + "," + xMLElement.getClass() + "|" + this.getClass() + "," + xMLElement.name + "|" + this.name + "]");
        }
        this.setValue(xMLElement.value);
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isEmpty() {
        return this.value == null || this.value.trim().length() <= 0;
    }

    public void setValue(String string) {
        if (this.isReadOnly) {
            String string2 = "Name=" + this.toName() + ", Val=" + this.toValue();
            if (this.parent != null) {
                string2 = string2 + ", Parent name=" + this.parent.toName();
            }
            throw new RuntimeException("Can't set the value of read only element: " + string2 + "!");
        }
        boolean bl = false;
        String string3 = this.value;
        if (!this.value.equals(string)) {
            bl = true;
        }
        this.value = string;
        if (bl && (this.notifyMainListeners || this.notifyListeners)) {
            XMLElementChangeInfo xMLElementChangeInfo = this.createInfo(string3, this.value, null, 1);
            if (this.notifyListeners) {
                this.notifyListeners(xMLElementChangeInfo);
            }
            if (this.notifyMainListeners) {
                this.notifyMainListeners(xMLElementChangeInfo);
            }
        }
    }

    public String toValue() {
        return this.value;
    }

    public String toName() {
        return this.name;
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public void setParent(XMLElement xMLElement) {
        this.parent = xMLElement;
    }

    public Object clone() {
        XMLElement xMLElement = null;
        try {
            xMLElement = (XMLElement)super.clone();
            xMLElement.parent = this.parent;
            xMLElement.name = new String(this.name);
            xMLElement.value = new String(this.value);
            xMLElement.isRequired = this.isRequired;
            xMLElement.isReadOnly = this.isReadOnly;
            xMLElement.listeners = new ArrayList();
            xMLElement.notifyListeners = false;
            xMLElement.notifyMainListeners = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error(cloneNotSupportedException.toString());
        }
        return xMLElement;
    }

    public Integer getOriginalElementHashCode() {
        return this.originalElementHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        boolean bl = false;
        if (object != null && object instanceof XMLElement && object.getClass().equals(this.getClass())) {
            XMLElement xMLElement = (XMLElement)object;
            bl = this.name.equals(xMLElement.name);
            bl = bl && this.value.equals(xMLElement.value);
            bl = bl && this.isRequired == xMLElement.isRequired;
        }
        return bl;
    }

    public List getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return new ArrayList(this.listeners);
    }

    public void addListener(XMLElementChangeListener xMLElementChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(xMLElementChangeListener);
    }

    public boolean removeListener(XMLElementChangeListener xMLElementChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners.remove(xMLElementChangeListener);
    }

    protected void notifyListeners(XMLElementChangeInfo xMLElementChangeInfo) {
        for (XMLElementChangeListener xMLElementChangeListener : this.getListeners()) {
            xMLElementChangeListener.xmlElementChanged(xMLElementChangeInfo);
        }
    }

    protected void notifyMainListeners(XMLElementChangeInfo xMLElementChangeInfo) {
        XMLElement xMLElement = this.getMainElement();
        if (xMLElement != null) {
            for (XMLElementChangeListener xMLElementChangeListener : xMLElement.getListeners()) {
                xMLElementChangeListener.xmlElementChanged(xMLElementChangeInfo);
            }
        }
    }

    protected XMLElement getMainElement() {
        XMLElement xMLElement = this;
        while (!xMLElement.isMainElement() && (xMLElement = xMLElement.getParent()) != null) {
        }
        return xMLElement;
    }

    protected boolean isMainElement() {
        return false;
    }

    public void setNotifyMainListeners(boolean bl) {
        this.notifyMainListeners = bl;
    }

    public void setNotifyListeners(boolean bl) {
        this.notifyListeners = bl;
    }

    protected XMLElementChangeInfo createInfo(Object object, Object object2, List list, int n) {
        XMLElementChangeInfo xMLElementChangeInfo = new XMLElementChangeInfo();
        xMLElementChangeInfo.setChangedElement(this);
        xMLElementChangeInfo.setOldValue(object);
        xMLElementChangeInfo.setNewValue(object2);
        xMLElementChangeInfo.setChangedSubElements(list);
        xMLElementChangeInfo.setAction(n);
        return xMLElementChangeInfo;
    }
}

