/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jxpdl.elements;

import java.util.ArrayList;
import org.enhydra.jxpdl.XMLAttribute;
import org.enhydra.jxpdl.XMLCollectionElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLInterface;
import org.enhydra.jxpdl.elements.Activities;
import org.enhydra.jxpdl.elements.Activity;
import org.enhydra.jxpdl.elements.ActivitySets;
import org.enhydra.jxpdl.elements.Transition;
import org.enhydra.jxpdl.elements.Transitions;

public class ActivitySet
extends XMLCollectionElement {
    protected transient ArrayList startingActivities;
    protected transient ArrayList endingActivities;

    public ActivitySet(ActivitySets activitySets) {
        super(activitySets, true);
    }

    @Override
    protected void fillStructure() {
        XMLAttribute xMLAttribute = new XMLAttribute((XMLElement)this, "Name", false);
        Activities activities = new Activities(this);
        Transitions transitions = new Transitions(this);
        super.fillStructure();
        this.add(xMLAttribute);
        this.add(activities);
        this.add(transitions);
    }

    @Override
    public void initCaches(XMLInterface xMLInterface) {
        super.initCaches(xMLInterface);
        for (Activity activity : this.getActivities().toElements()) {
            Transition transition;
            ArrayList arrayList = activity.getIncomingTransitions();
            ArrayList arrayList2 = activity.getNonExceptionalOutgoingTransitions();
            if (arrayList.size() == 0) {
                this.startingActivities.add(activity);
            } else if (arrayList.size() == 1 && (transition = (Transition)arrayList.get(0)).getFrom().equals(transition.getTo())) {
                this.startingActivities.add(activity);
            }
            if (arrayList2.size() == 0) {
                this.endingActivities.add(activity);
                continue;
            }
            if (arrayList2.size() != 1 || !(transition = (Transition)arrayList2.get(0)).getFrom().equals(transition.getTo())) continue;
            this.endingActivities.add(activity);
        }
    }

    @Override
    public void clearCaches() {
        this.startingActivities = new ArrayList();
        this.endingActivities = new ArrayList();
        super.clearCaches();
    }

    public ArrayList getStartingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.startingActivities;
    }

    public ArrayList getEndingActivities() {
        if (!this.isReadOnly) {
            throw new RuntimeException("This method can be used only in read-only mode!");
        }
        return this.endingActivities;
    }

    public Activity getActivity(String string) {
        return this.getActivities().getActivity(string);
    }

    public Transition getTransition(String string) {
        return this.getTransitions().getTransition(string);
    }

    public String getName() {
        return this.get("Name").toValue();
    }

    public void setName(String string) {
        this.set("Name", string);
    }

    public Activities getActivities() {
        return (Activities)this.get("Activities");
    }

    public Transitions getTransitions() {
        return (Transitions)this.get("Transitions");
    }
}

