/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.jawe.components.problemsnavigator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.enhydra.jawe.ActionBase;
import org.enhydra.jawe.JaWEManager;
import org.enhydra.jawe.Utils;
import org.enhydra.jawe.base.xpdlvalidator.ValidationError;
import org.enhydra.jawe.components.problemsnavigator.ProblemsNavigator;
import org.enhydra.jawe.components.problemsnavigator.ProblemsNavigatorSettings;
import org.enhydra.jawe.components.problemsnavigator.ProblemsTableCellRenderer;
import org.enhydra.jxpdl.ParsingErrors;
import org.enhydra.jxpdl.XMLComplexElement;
import org.enhydra.jxpdl.XMLElement;
import org.enhydra.jxpdl.XMLUtil;
import org.enhydra.jxpdl.elements.Package;
import org.enhydra.jxpdl.elements.WorkflowProcess;

public class ProblemsTablePanel
extends JPanel {
    protected JTable allItems;
    protected ProblemsNavigator controller;
    protected Vector columnNames;
    protected int sortingColumn = -1;
    protected ValidationErrorComparator vec = new ValidationErrorComparator();
    protected String veId = "-1";
    protected boolean scInProgress = false;

    public ProblemsTablePanel(ProblemsNavigator problemsNavigator) {
        this.controller = problemsNavigator;
        this.setLayout(new BorderLayout());
        this.columnNames = this.getColumnNames(problemsNavigator);
        this.allItems = this.createTable();
        this.setupTable();
        this.add(this.createScrollPane());
    }

    public JTable getTable() {
        return this.allItems;
    }

    public String getSelectedErrId() {
        return this.veId;
    }

    public ValidationError getSelectedElement() {
        int n = this.allItems.getSelectedRow();
        if (n >= 0) {
            return (ValidationError)this.allItems.getValueAt(n, 0);
        }
        return null;
    }

    public boolean setSelectedElement(String string) {
        try {
            int n = this.allItems.getRowCount();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (!string.equals(this.allItems.getValueAt(i, 7))) continue;
                    this.scInProgress = true;
                    this.allItems.setRowSelectionInterval(i, i);
                    JViewport jViewport = (JViewport)this.allItems.getParent();
                    Rectangle rectangle = this.allItems.getCellRect(i, 0, true);
                    Point point = jViewport.getViewPosition();
                    rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
                    jViewport.scrollRectToVisible(rectangle);
                    this.scrollRectToVisible(rectangle);
                    this.veId = string;
                    this.scInProgress = false;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scInProgress = true;
        this.allItems.clearSelection();
        this.scInProgress = false;
        return false;
    }

    public void addRow(ValidationError validationError) {
        int n = this.allItems.getRowCount();
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        Vector vector = this.getRow(validationError);
        defaultTableModel.insertRow(n, vector);
    }

    public void removeRow(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        defaultTableModel.removeRow(n);
    }

    protected JTable createTable() {
        JTable jTable = new JTable(new Vector(), this.columnNames){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                int n3 = this.convertColumnIndexToModel(n2);
                DefaultTableModel defaultTableModel = (DefaultTableModel)this.getModel();
                String string = null;
                if (n3 > 1 && n3 < 6) {
                    try {
                        string = defaultTableModel.getValueAt(n, n3).toString();
                    }
                    catch (Exception exception) {
                        string = super.getToolTipText(mouseEvent);
                    }
                } else {
                    string = super.getToolTipText(mouseEvent);
                }
                return string;
            }
        };
        Color color = new Color(245, 245, 245);
        if (this.controller.getSettings() instanceof ProblemsNavigatorSettings) {
            color = ((ProblemsNavigatorSettings)this.controller.getSettings()).getBackgroundColor();
        }
        jTable.setBackground(color);
        return jTable;
    }

    protected void setupTable() {
        TableColumn tableColumn = this.allItems.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        tableColumn = this.allItems.getColumnModel().getColumn(1);
        tableColumn.setCellRenderer(new ProblemsTableCellRenderer());
        tableColumn.setMinWidth(20);
        tableColumn.setMaxWidth(20);
        tableColumn.setPreferredWidth(20);
        tableColumn.setResizable(false);
        tableColumn = this.allItems.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(100);
        tableColumn.setResizable(true);
        tableColumn = this.allItems.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(450);
        tableColumn.setResizable(true);
        tableColumn = this.allItems.getColumnModel().getColumn(4);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(150);
        tableColumn.setResizable(true);
        tableColumn = this.allItems.getColumnModel().getColumn(5);
        tableColumn.setMinWidth(0);
        tableColumn.setPreferredWidth(300);
        tableColumn.setResizable(true);
        tableColumn = this.allItems.getColumnModel().getColumn(6);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        tableColumn = this.allItems.getColumnModel().getColumn(7);
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        tableColumn.setPreferredWidth(0);
        tableColumn.setResizable(false);
        this.allItems.setAutoResizeMode(0);
        this.allItems.setColumnSelectionAllowed(false);
        this.allItems.setRowSelectionAllowed(true);
        this.allItems.setSelectionMode(0);
        this.allItems.getTableHeader().setReorderingAllowed(false);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (listSelectionModel.isSelectionEmpty()) {
                    ProblemsTablePanel.this.veId = "-1";
                } else {
                    int n = listSelectionModel.getMinSelectionIndex();
                    int n2 = ProblemsTablePanel.this.allItems.getSelectedColumn();
                    XMLElement xMLElement = null;
                    ValidationError validationError = (ValidationError)ProblemsTablePanel.this.allItems.getValueAt(n, 0);
                    xMLElement = n2 == 4 ? validationError.getElement() : (XMLElement)ProblemsTablePanel.this.allItems.getValueAt(n, 6);
                    ProblemsTablePanel.this.veId = ProblemsTablePanel.this.getErrorCode(validationError);
                    if (!ProblemsTablePanel.this.scInProgress) {
                        JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
                    }
                }
            }
        };
        this.allItems.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.allItems.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent changeEvent) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                ProblemsTablePanel.this.changeSelection();
            }
        });
        this.allItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ActionBase actionBase;
                ProblemsTablePanel.this.changeSelection();
                if (mouseEvent.getClickCount() > 1 && (actionBase = JaWEManager.getInstance().getJaWEController().getJaWEActions().getAction("EditProperties")).isEnabled()) {
                    actionBase.actionPerformed(null);
                }
            }
        });
        JTableHeader jTableHeader = this.allItems.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = ProblemsTablePanel.this.allItems.getColumnModel();
                int n = ProblemsTablePanel.this.vec.getIndex();
                if (mouseEvent != null) {
                    n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                }
                ProblemsTablePanel.this.performSorting(n);
            }
        });
    }

    protected void changeSelection() {
        int n = this.allItems.getSelectedRow();
        int n2 = this.allItems.getSelectedColumn();
        XMLElement xMLElement = null;
        try {
            xMLElement = n2 == 4 ? ((ValidationError)this.allItems.getValueAt(n, 0)).getElement() : (XMLElement)this.allItems.getValueAt(n, 6);
            if (!this.scInProgress) {
                JaWEManager.getInstance().getJaWEController().getSelectionManager().setSelection(xMLElement, true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Vector getColumnNames(ProblemsNavigator problemsNavigator) {
        Vector<String> vector = new Vector<String>();
        vector.add("Object");
        vector.add("");
        vector.add(problemsNavigator.getSettings().getLanguageDependentString("TypeKey"));
        vector.add(problemsNavigator.getSettings().getLanguageDependentString("DescriptionKey"));
        vector.add(problemsNavigator.getSettings().getLanguageDependentString("ElementKey"));
        vector.add(problemsNavigator.getSettings().getLanguageDependentString("locationKey"));
        vector.add("Location");
        vector.add("ErrId");
        return vector;
    }

    public void fillTableContent(List list) {
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        for (ValidationError validationError : list) {
            Vector vector = this.getRow(validationError);
            arrayList.add(vector);
        }
        this.sortTableContent(arrayList);
    }

    public void sortTableContent(List list) {
        if (this.vec.getIndex() != -1) {
            Collections.sort(list, this.vec);
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (Vector vector : list) {
            defaultTableModel.addRow(vector);
        }
    }

    protected Vector getRow(ValidationError validationError) {
        Object object;
        String string;
        Vector<Object> vector = new Vector<Object>();
        XMLElement xMLElement = validationError.getElement();
        vector.add(validationError);
        if (validationError.getType().equals("ERROR")) {
            vector.add(((ProblemsNavigatorSettings)this.controller.getSettings()).getErrorIcon());
        } else {
            vector.add(((ProblemsNavigatorSettings)this.controller.getSettings()).getWarningIcon());
        }
        vector.add(this.controller.getSettings().getLanguageDependentString(validationError.getSubType() + "TypeKey"));
        String string2 = validationError.getId();
        if (string2 == null) {
            string2 = "";
        }
        if (string2.length() > 0 && (string = this.controller.getSettings().getLanguageDependentString(string2)) != null) {
            string2 = string;
        }
        if (validationError.getDescription().length() > 0) {
            string = validationError.getDescription();
            if (validationError.getSubType().equals("SCHEMA")) {
                if (string.indexOf(ParsingErrors.ERROR) == 0) {
                    object = this.controller.getSettings().getLanguageDependentString(ParsingErrors.ERROR + "Key") + " " + this.controller.getSettings().getLanguageDependentString("AtLineNumberKey") + " ";
                    string = (String)object + string.substring(ParsingErrors.ERROR.length() + ParsingErrors.AT_LINE_NO_STRING.length());
                } else if (string.indexOf(ParsingErrors.WARNING) == 0) {
                    object = this.controller.getSettings().getLanguageDependentString(ParsingErrors.WARNING + "Key") + " " + this.controller.getSettings().getLanguageDependentString("AtLineNumberKey") + " ";
                    string = (String)object + string.substring(ParsingErrors.WARNING.length() + ParsingErrors.AT_LINE_NO_STRING.length());
                } else if (string.indexOf(ParsingErrors.FATAL_ERROR) == 0) {
                    object = this.controller.getSettings().getLanguageDependentString(ParsingErrors.FATAL_ERROR + "Key") + " " + this.controller.getSettings().getLanguageDependentString("AtLineNumberKey") + " ";
                    string = (String)object + string.substring(ParsingErrors.FATAL_ERROR.length() + ParsingErrors.AT_LINE_NO_STRING.length());
                }
            } else {
                string2 = string2 + ": ";
            }
            string2 = string2 + string;
        }
        vector.add(string2);
        vector.add(JaWEManager.getInstance().getLabelGenerator().getLabel(xMLElement) + " - " + JaWEManager.getInstance().getDisplayNameGenerator().getDisplayName(xMLElement));
        string = Utils.getLocation((XMLElement)xMLElement);
        object = XMLUtil.getActivitySet((XMLElement)xMLElement);
        WorkflowProcess workflowProcess = XMLUtil.getWorkflowProcess((XMLElement)xMLElement);
        Package package_ = XMLUtil.getPackage((XMLElement)xMLElement);
        String string3 = this.controller.getSettings().getLanguageDependentString("PackageKey") + " '" + package_.getId() + "'";
        if (workflowProcess != null) {
            string3 = string3 + ", " + this.controller.getSettings().getLanguageDependentString("WorkflowProcessKey") + " '" + workflowProcess.getId() + "'";
        }
        if (object != null) {
            string3 = string3 + ", " + this.controller.getSettings().getLanguageDependentString("ActivitySetKey") + " '" + object.getId() + "'";
        }
        if (string != object && string != workflowProcess && string != package_) {
            string3 = string3 + ", " + this.controller.getSettings().getLanguageDependentString(string.toName() + "Key") + " '" + ((XMLComplexElement)string).get("Id").toValue() + "'";
        }
        if (xMLElement != string && xMLElement != object && xMLElement != workflowProcess && xMLElement != package_) {
            string3 = string3 + " -> " + this.controller.getSettings().getLanguageDependentString(xMLElement.toName() + "Key");
        }
        vector.add(string3);
        vector.add(string);
        vector.add(this.getErrorCode(validationError));
        return vector;
    }

    protected String getErrorCode(ValidationError validationError) {
        return String.valueOf(validationError.getElement().hashCode()) + "-" + validationError.getType() + "-" + validationError.getSubType() + "-" + validationError.getId();
    }

    protected JScrollPane createScrollPane() {
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setViewportView(this.allItems);
        return jScrollPane;
    }

    protected int getElementRow(XMLElement xMLElement) {
        int n = -1;
        for (int i = 0; i < this.allItems.getRowCount(); ++i) {
            XMLElement xMLElement2 = ((ValidationError)this.allItems.getValueAt(i, 0)).getElement();
            if (xMLElement != xMLElement2) continue;
            n = i;
            break;
        }
        return n;
    }

    public void cleanup() {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        for (int i = defaultTableModel.getRowCount() - 1; i >= 0; --i) {
            defaultTableModel.removeRow(i);
        }
        this.veId = "-1";
    }

    protected void performSorting(int n) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.allItems.getModel();
        ArrayList<Vector> arrayList = new ArrayList<Vector>(defaultTableModel.getDataVector());
        String string = this.veId;
        this.cleanup();
        this.vec.setIndex(n);
        this.sortTableContent(arrayList);
        if (!string.equals("-1")) {
            this.setSelectedElement(string);
        }
    }

    class ValidationErrorComparator
    implements Comparator {
        protected int index = -1;
        protected boolean ascending;

        public void setIndex(int n) {
            this.ascending = n != this.index ? false : !this.ascending;
            this.index = n;
        }

        public int getIndex() {
            return this.index;
        }

        public int compare(Object object, Object object2) {
            if (object instanceof Vector && object2 instanceof Vector) {
                try {
                    String string = ((Vector)object).elementAt(this.index).toString();
                    String string2 = ((Vector)object2).elementAt(this.index).toString();
                    if (this.ascending) {
                        return string.compareTo(string2);
                    }
                    return string2.compareTo(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return 1;
        }
    }
}

